# Bintech Robot UP - Scholarship Student Management System

## System Overview

**Bintech Robot UP** is a scholarship management system for educational institutions (specifically a university campus). It tracks scholarship students ("Alumnos Becados"), their academic programs, scholarship percentages, and automates the verification of scholarship data through portal integration.

## Business Domain

**Education / Student Financial Aid**

This system manages:
- Student scholarship records
- Scholarship types and percentages (tuition and enrollment)
- Academic program tracking
- Campus assignments
- Automated portal verification
- Exception handling for special cases

## App Files (Model Layer)

### System-Specific Files
Located in `/app/`:

- **`app_alumnos_becados.php`** - Main scholarship student model
  - Table: `alumnos_becados`
  - Primary key: `alumno_becado_id` (UUID)
  - Fields: campus, student ID, name, academic program, scholarship type, percentages, etc.
  - Features: Quick search enabled, automated status tracking

### Framework Files (Shared with ALL Systems)
These files are part of the iaCase framework and are used by ALL systems in Quantix:

- `app_iac_usr.php` - User management
- `app_iac_log.php` - Activity logging
- `app_iac_field_permission.php` - Field-level permissions
- `app_iac_table.php` - Table metadata
- `app_iac_parametros.php` - System parameters
- `app_iac_control.php` - Framework control settings
- `app_iac_limits.php` - Rate limiting/quotas
- `app_iac_seq.php` - Sequence generators
- `app_iac_tablero_aviso.php` - Dashboard notices
- `app_iac_log_hecho.php`, `app_iac_log_view.php` - Log views
- `app_iac_table_permission.php` - Table permissions

Additional shared utility files:
- `app_estilos_grid.php` - Grid styling
- `app_vitex_grid.php`, `app_vitex_grid_col.php` - Grid configurations
- `app_reportes_grid.php` - Report grids
- `app_localstorage.php` - Browser storage
- `app_user_json_data.php` - User data storage
- And more...

## Backoffice Pages (UI Layer)

Located in `/backoffice/`:

- **`alumnos_becados.php`** - Main scholarship student management page
  - Lists all scholarship students in jqGrid
  - Add/Edit/Delete/View operations
  - Quick search functionality
  - Export capabilities

## AJAX Endpoints

Located in `/backoffice/ajax/`:

- **`get_alumnos_becados.php`** - Custom AJAX endpoint
  - Action: `get_alumno_becado`
  - Returns scholarship student data as JSON
  - Supports filtering by ID and LIMIT clauses
  - Used for JavaScript-based data retrieval

## Database Tables

### Primary Tables:
- **`alumnos_becados`** - Scholarship students
  - UUID primary key
  - Student demographics (campus, student_id, name)
  - Academic data (program, period, department)
  - Scholarship details (type, tuition %, enrollment %)
  - Automation fields (status, run_id, attempt_count, last_error, evidence files)
  - Portal integration fields (URL, confirmation data, receipts)
  - Audit fields (alta_db, alta_por, ultimo_cambio, ultimo_cambio_por)

### Framework Tables (Shared):
All systems share these iaCase framework tables:
- `iac_usr` - Users
- `iac_log` - Activity logs
- `iac_table` - Table metadata
- `iac_field_permission` - Field permissions
- `iac_table_permission` - Table permissions
- `iac_parametros` - System parameters
- `iac_control` - Framework settings
- And more...

## Key Features

### 1. Scholarship Management
- Track multiple scholarship types
- Percentage-based awards (tuition and enrollment separately)
- Campus and department assignments
- Exception handling for special cases

### 2. Academic Program Tracking
- Program abbreviations (programa_siglas)
- Full program names (programa_academico)
- Academic periods (periodo_academico)
- TESUP cycles (ciclo_tesup)

### 3. Automated Portal Integration
- **Status tracking**: Run status, attempt counts
- **Error logging**: Last error code and message
- **Evidence collection**: File paths and file lists
- **Portal verification**:
  - Student search confirmation
  - ID matching
  - Program/period verification
  - Receipt generation and storage
- **Lock mechanism**: Prevents concurrent processing
- **Skip reasons**: Documents why records are skipped

### 4. Search & Export
- Quick search (busqueda_rapida_automatica)
- jqGrid with filters
- Export capabilities
- Column sorting and filtering

### 5. Audit Trail
- Creation timestamp and user (alta_db, alta_por)
- Last modification timestamp and user (ultimo_cambio, ultimo_cambio_por)
- Full activity logging through iaCase framework

## Technical Architecture

### Framework Integration
This system is built on the **iaCase framework**, which means:

- **Auto-generated UI**: Forms and grids are automatically created from database schema
- **CRUD operations**: Insert/Update/Delete handled by framework
- **Validation**: Type checking, required fields, length limits all automatic
- **Permissions**: User-based, table-based, and field-based permissions
- **Logging**: All actions automatically logged
- **jqGrid integration**: Data tables with sorting, filtering, paging

### Display Mode
- Uses `cardex_window` mode (forms open in new window)
- Permissions: Full edit, delete, export, insert, list, read, update
- Search enabled with automatic quick search

### JavaScript Integration
The system includes a JavaScript function `obteniendoAlumnosBecados()` that:
- Fetches scholarship student data via AJAX
- Supports single record or batch retrieval
- Returns JSON data structure
- Handles errors gracefully

## File Organization

```
/lamp/www/quantix/
├── app/
│   ├── app_alumnos_becados.php       ← BINTECH ROBOT UP MODEL
│   ├── app_iac_*.php                  ← SHARED FRAMEWORK FILES
│   └── [other shared utility files]
├── backoffice/
│   ├── alumnos_becados.php            ← BINTECH ROBOT UP UI
│   └── ajax/
│       └── get_alumnos_becados.php    ← BINTECH ROBOT UP AJAX
├── inc/                                ← SHARED FRAMEWORK CORE
│   ├── iacase.php                     ← Core CRUD engine
│   ├── config.php                     ← Entry point
│   ├── ia_utilerias.php               ← Database utilities
│   └── [other framework files]
└── [database]
    └── alumnos_becados                ← BINTECH ROBOT UP TABLE
```

## How It Works

### User Flow:
1. User navigates to `/backoffice/alumnos_becados.php`
2. Page loads `app_alumnos_becados` class
3. Class calls `process_action()` to handle URL parameter `?iah=`
   - `iah=l` or empty = List (jqGrid)
   - `iah=a` = Add form
   - `iah=e` = Edit form
   - `iah=r` = Read-only view
   - `iah=s` = Save (insert or update)
   - `iah=d` = Delete
4. Framework auto-generates HTML forms and jqGrid from database schema
5. JavaScript provides additional interactivity (AJAX calls, validations)

### Automation Flow:
1. Background process identifies students needing verification
2. Sets `status` and locks record with `locked_by`
3. Attempts portal verification (increments `attempt_count`)
4. On success: Records confirmation data, saves receipt, sets `portal_saved_at`
5. On failure: Logs error code/message in `last_error_code`, `last_error_message`
6. Stores evidence files in `evidence_path` with list in `evidence_files`
7. Updates `last_attempt_at` timestamp
8. Releases lock

## Common Operations

### Adding a New Scholarship Student:
1. Navigate to Alumnos Becados page
2. Click "Add" button
3. Fill in required fields:
   - Campus
   - Student ID
   - Name
   - Academic program
   - Period
   - Scholarship type
   - Percentages (tuition and enrollment)
4. Save
5. System generates UUID and records audit data

### Viewing Automation Status:
1. Open record in Edit or Read mode
2. Check fields:
   - `status` - Current processing status
   - `attempt_count` - How many times attempted
   - `last_error_message` - What went wrong (if anything)
   - `portal_confirmed_*` - Verification results
   - `evidence_files` - List of collected evidence

### Exporting Data:
1. Click Export button in grid
2. Choose format (Excel, CSV, PDF)
3. System generates file with all visible columns

## Integration Points

### With Framework:
- Uses `iacase_base` parent class for all CRUD
- Leverages `appRelate` for schema metadata
- Respects `iac_field_permission` for field visibility
- Logs to `iac_log` automatically

### With External Systems:
- Portal integration via `portal_url` field
- Evidence storage on filesystem
- Receipt tracking for institutional records

## Maintenance Notes

### Do NOT Edit:
- `campos_default()` method - Auto-generated from database schema
- Framework files (`app_iac_*.php`, `/inc/*`)

### Safe to Customize:
- `campos_final()` method - Field ordering, display groups, custom validation
- Permission settings in constructor
- Hook methods (insert_*, update_*, delete_* overrides)
- `listme_postRender()` for custom JavaScript

### Database Changes:
1. Alter table in database
2. Regenerate `appRelateBase.php` from schema
3. Update `campos_final()` if field order changes
4. Clear opcache if in production

## Security

- **Permissions**: Controlled by `$this->permiso_*` properties
- **User type checks**: Can restrict by Rony/Power/Normal user types
- **Field-level security**: Via `iac_field_permission` table
- **SQL injection prevention**: Framework uses parameterized queries
- **Session management**: Automatic timeout and regeneration
- **Audit logging**: All changes tracked with user and timestamp

---

**System Type:** Educational Institution - Financial Aid
**Framework:** iaCase (custom PHP CRUD framework)
**Database:** MySQL
**UI:** jqGrid + jQuery UI
**Architecture:** Model-driven auto-CRUD with declarative customization

**Related Systems in Quantix:**
- MrW - Reporte Propietarios (property management)
- Ari Ben (CFDI invoicing)

All systems share the same framework core (`/inc/`) and framework tables (`iac_*`)!
