<?php
function mostrandoReglas($ruta) : array{
    if (!$ruta){
        $ruta=$_SERVER['REQUEST_URI'];
        $ruta = parse_url($_SERVER['REQUEST_URI']);
        $ruta=$ruta['path'];
    }
    $ruta= str_replace('/vitex/','',$ruta);
    $ruta= str_replace('.php','',$ruta);

    $ultima_carpeta= explode('/',$ruta);

    $ultima_carpeta= end($ultima_carpeta);

    /* verificando si la ruta es nota_bodega*/
    $array_bodega=['edita_movimiento','alta_movimiento','nota_bodega'];


    if(in_array($ultima_carpeta,$array_bodega)) {
        $ruta = "backoffice/nota_bodega";
        $ruta_emplode=explode('/',$ruta);
        $ultima_carpeta= end($ruta_emplode);
    };
    /* verificando si la ruta es nota_bodega*/

    $ruta_reglas= __DIR__.'/lib/'.$ruta;


    $nombre_archivo=$ultima_carpeta.'.php';

    if (file_exists($ruta_reglas.'/'.$nombre_archivo)) {
        $contenido = file_get_contents($ruta_reglas.'/'.$nombre_archivo);
        $patron = '/##(.*?)##/s'; // Expresión regular que encuentra el texto entre "##"
        $coincidencias= [];
        preg_match_all($patron, $contenido, $coincidencias);

        $titulo= end($coincidencias);

        foreach ($coincidencias as $coincidencia){
            $contenido= str_replace($coincidencia,'', $contenido);
        }
        return [
            "titulo"=>implode("", $titulo),
            "contenido"=>$contenido
        ];
    }
    return [
        "titulo"=>'Reglas del site',
        "contenido"=>''
    ];
}
function obteniendoArchivosReglas($ruta=null){
    if (!$ruta){
        $ruta=$_SERVER['REQUEST_URI'];
        $ruta = parse_url($_SERVER['REQUEST_URI']);
        $ruta=$ruta['path'];
    }

    $ruta= str_replace('/vitex/','',$ruta);
    $ruta= str_replace('.php','',$ruta);

    /* verificando si la ruta es nota_bodega*/
    $array_bodega=['bodega/edita_movimiento','bodega/alta_movimiento','backoffice/nota_bodega'];
    if(in_array($ruta,$array_bodega)) $ruta="backoffice/nota_bodega";
    /* verificando si la ruta es nota_bodega*/

    $ruta_reglas= __DIR__.'/lib/'.$ruta.'/';
    if (is_dir($ruta_reglas)){
        $archivos = scandir($ruta_reglas);

        $archivos_php = array_filter($archivos, function ($archivo) {
            return pathinfo($archivo, PATHINFO_EXTENSION) === 'php';
        });
        return $archivos_php;
    }
    return [];

}
?>