<?php
// Ultra-Simple PMS Matcher - Direct MySQL

$link = mysql_connect('localhost', 'root', 'M@chiavell1');
mysql_select_db('quantix', $link);

echo "═══════════════════════════════════════════════════════════════\n";
echo "  PMS MATCHER CLI - BASELINE\n";
echo "═══════════════════════════════════════════════════════════════\n\n";

function norm($t) { 
    if (!$t) return ''; 
    $a = 'ÁÉÍÓÚáéíóúÑñÜü';
    $b = 'AEIOUaeiouNnuu';
    $r = strtr($t, $a, $b);
    return strtolower(trim(preg_replace('/\s+/', ' ', $r))); 
}

function street($t) { 
    $n = norm($t); 
    $m = ['slp37'=>'san luis potosi 37','vs146'=>'vicente suarez 146','ver 2'=>'veracruz 26'];
    foreach ($m as $a => $f) {
        if (strpos($n, $a . '-') !== false) { $n = str_replace($a . '-', $f . ' | ', $n); break; }
        if (strpos($n, $a) !== false) { $n = str_replace($a, $f, $n); break; }
    }
    if (preg_match('/\d/', $n, $m, PREG_OFFSET_CAPTURE)) return trim(substr($n, 0, $m[0][1]));
    return $n; 
}

function unit($t) { 
    $n = norm($t); 
    if (preg_match('/\b(\d{2,4})\b/', $n, $m)) return $m[1];
    if (preg_match('/ph\s*(\w+)/i', $n, $m)) return 'ph' . norm($m[1]);
    if (preg_match('/\b([A-Z])\b/', $t, $m)) return strtolower($m[1]);
    return ''; 
}

function mcb($p, $cp, $cr) { 
    $ps = street($p['nombre_propiedad']); 
    if (strlen($ps) < 3) $ps = street($p['direccion']); 
    $cs = street($cp); 
    $np = norm($p['nombre_propiedad']); 
    $nd = norm($p['direccion']); 
    $nc = norm($cp); 
    
    $bs = 0; 
    if (strlen($nc) >= 5) {
        if (strpos($np, $nc) !== false || strpos($nd, $nc) !== false) $bs = 100;
        elseif (strlen($ps) >= 5 && strlen($cs) >= 5) { similar_text($ps, $cs, $pct); $bs = $pct; }
    }
    
    $us = 0; 
    $pu = unit($p['nombre_propiedad']); 
    $cu = unit($cr); 
    if (!empty($pu) && !empty($cu)) { 
        if ($pu === $cu) $us = 100; 
        else { similar_text($pu, $cu, $pct); $us = $pct; } 
    } elseif (empty($cu) || $cr === 'N/A') { 
        $us = $bs; 
    }
    
    $conf = round($bs * 0.6 + $us * 0.4); 
    $tier = ($conf >= 95) ? 1 : (($conf >= 80) ? 2 : (($conf >= 65) ? 3 : (($conf >= 40) ? 4 : 0))); 
    return ($tier > 0) ? ['m' => true, 'c' => $conf, 't' => $tier] : ['m' => false]; 
}

function mhf($p, $a) { 
    $np = norm($p['nombre_propiedad']); 
    $nd = norm($p['direccion']); 
    $na = norm($a); 
    
    if ($np === $na) return ['m' => true, 'c' => 100, 't' => 1]; 
    
    foreach (preg_split('/[\|,]/', $na) as $s) {
        $s = trim($s); 
        if (strlen($s) >= 5 && strlen($np) >= 5) {
            if (strpos($s, $np) !== false || strpos($np, $s) !== false) return ['m' => true, 'c' => 90, 't' => 2]; 
            if (strlen($nd) >= 5 && (strpos($s, $nd) !== false || strpos($nd, $s) !== false)) return ['m' => true, 'c' => 90, 't' => 2]; 
        }
    }
    
    similar_text($np, $na, $pct); 
    if ($pct >= 85) return ['m' => true, 'c' => 70, 't' => 3]; 
    similar_text($nd, $na, $pct); 
    if ($pct >= 85) return ['m' => true, 'c' => 70, 't' => 3]; 
    
    $ps = street($p['nombre_propiedad']); 
    if (strlen($ps) < 3) $ps = street($p['direccion']); 
    $as = street($a); 
    
    if (strlen($ps) >= 5 && strlen($as) >= 5) {
        if (strpos($as, $ps) !== false || strpos($ps, $as) !== false) {
            $pu = unit($p['nombre_propiedad']); 
            $au = unit($a); 
            $c = (!empty($pu) && !empty($au) && $pu === $au) ? 65 : 50; 
            return ['m' => true, 'c' => $c, 't' => 4]; 
        }
    } 
    return ['m' => false]; 
}

// Load properties
$res = mysql_query("SELECT * FROM propiedad ORDER BY nombre_propiedad");
$props = []; 
while ($row = mysql_fetch_assoc($res)) $props[$row['propiedad_id']] = $row;
echo "[1/5] Properties: " . count($props) . "\n\n";

// Cloudbeds
$res = mysql_query("SELECT * FROM cloudbeds_reserva WHERE check_in_date >= '2025-01-01' AND propiedad_id IS NULL");
$cbres = []; 
while ($row = mysql_fetch_assoc($res)) $cbres[] = $row;
echo "[2/5] Cloudbeds: " . count($cbres) . " unmatched\n";
$cb_match = 0; 
$cbtier = [];
foreach ($cbres as $cb) {
    $best = null; $bc = 0; 
    foreach ($props as $p) {
        $r = mcb($p, $cb['property'], $cb['room_number']); 
        if ($r['m'] && $r['c'] > $bc) { $bc = $r['c']; $best = ['p' => $p, 'r' => $cb, 'm' => $r]; } 
    }
    if ($best && $bc >= 80) { 
        $cb_match++; 
        $t = $best['m']['t'];
        $cbtier[$t] = isset($cbtier[$t]) ? $cbtier[$t] + 1 : 1; 
    } 
}
echo "  Matched (≥80%): $cb_match\n\n";

// Hostify
$res = mysql_query("SELECT * FROM hostify_reserva WHERE check_in >= '2025-01-01' AND propiedad_id IS NULL");
$hfres = []; 
while ($row = mysql_fetch_assoc($res)) $hfres[] = $row;
echo "[3/5] Hostify: " . count($hfres) . " unmatched\n";
$hf_match = 0; 
$hftier = [];
foreach ($hfres as $hf) {
    $best = null; $bc = 0; 
    foreach ($props as $p) {
        $r = mhf($p, $hf['anuncio']); 
        if ($r['m'] && $r['c'] > $bc) { $bc = $r['c']; $best = ['p' => $p, 'r' => $hf, 'm' => $r]; } 
    }
    if ($best && $bc >= 80) { 
        $hf_match++; 
        $t = $best['m']['t'];
        $hftier[$t] = isset($hftier[$t]) ? $hftier[$t] + 1 : 1; 
    } 
}
echo "  Matched (≥80%): $hf_match\n\n";

// Stats
echo "[4/5] Statistics\n───────────────────────────────────────────────────────────────\n";
$cb_rate = count($cbres) ? round(100 * $cb_match / count($cbres), 2) : 0;
$hf_rate = count($hfres) ? round(100 * $hf_match / count($hfres), 2) : 0;
$total = count($cbres) + count($hfres);
$matched = $cb_match + $hf_match;
$rate = $total ? round(100 * $matched / $total, 2) : 0;

echo "CLOUDBEDS: $cb_match/" . count($cbres) . " ($cb_rate%)\n";
foreach ($cbtier as $t => $c) echo "  Tier $t: $c\n";

echo "\nHOSTIFY: $hf_match/" . count($hfres) . " ($hf_rate%)\n";
foreach ($hftier as $t => $c) echo "  Tier $t: $c\n";

echo "\nCOMBINED: $matched/$total ($rate%)\n";
echo "═══════════════════════════════════════════════════════════════\n";
