<?php

/**
 *
 * @version 2021-09-29
 *
 * @covers \ParamsHelper
 * @uses ::strim
 *
 */

use PHPUnit\Framework\TestCase;

class ParamsHelperTest extends TestCase
{

    /**
     * @covers ParamsHelper::getInventDefault
     */
    public function testGetInventDefault() {
        $this->assertEquals(
            ['quantity'=>'0', 'numero'=>'0', 'palabra'=>''],
            ParamsHelper::getInventDefault(
                ['quantity', 'numero', 'palabra', 'oper', 'ignorame'],
                ['numero'],
                ['ignorame']
            )
        );
    }



    /**
     * @covers ParamsHelper::get
     * @dataProvider providerGet
     */
    public function testGet($keyDefault, array $numberKeys, $request, $noTrimKeys, $ignoreKeys, $expected) {

        $this->assertEquals($expected,
            ParamsHelper::get($keyDefault, $numberKeys, $noTrimKeys, $ignoreKeys,  $request));
    }

    public function providerGet()
    {
        return [
            "Known numbers parametros" => [
                ['quantity'=>7, 'price'=>1, 'min_price'=>2, 'min_por_rollo'=>3, 'max_por_rollo'=>4, 'weight_per_m'=>5,
                    'rollos'=>6], // keyDefault
                ['quantity', 'price', 'min_price', 'min_por_rollo', 'max_por_rollo', 'weight_per_m',
                    'rollos'], // number keys
                ['quantity'=>'-1,234,567.12', 'price'=>'$1,234,567.12',
                    'min_price'=>'1,234,567.12', 'min_por_rollo'=>'1,234,567.12',
                    'max_por_rollo'=>'1,234,567.12', 'weight_per_m'=>'1,234,567.12',
                    'rollos'=>'1,234,567.12%'], // $request
                [], // noTrimKeys
                [], // ignorKeys
                ['quantity'=>'-1234567.12', 'price'=>'1234567.12',
                    'min_price'=>'1234567.12', 'min_por_rollo'=>'1234567.12',
                    'max_por_rollo'=>'1234567.12', 'weight_per_m'=>'1234567.12',
                    'rollos'=>'1234567.12'], // $expected
            ],

            "Known numbers no se eliminen" => [
                ['quantity'=>7, 'price'=>1, 'min_price'=>2, 'min_por_rollo'=>3, 'max_por_rollo'=>4, 'weight_per_m'=>5,
                    'rollos'=>6], // keyDefault
                [], // number keys
                ['quantity'=>'-1,234,567.12', 'price'=>'1,234,567.12',
                    'min_price'=>'1,234,567.12', 'min_por_rollo'=>'1,234,567.12',
                    'max_por_rollo'=>'1,234,567.12', 'weight_per_m'=>'1,234,567.12',
                    'rollos'=>'1,234,567.12'], // $request
                [], // noTrimKeys
                [], // ignorKeys
                ['quantity'=>'-1234567.12', 'price'=>'1234567.12',
                    'min_price'=>'1234567.12', 'min_por_rollo'=>'1234567.12',
                    'max_por_rollo'=>'1234567.12', 'weight_per_m'=>'1234567.12',
                    'rollos'=>'1234567.12'], // $expected
            ],

            "Numeros especiales" => [
                ['numero'=>'1,234.56', 'numEspacio'=>' 1,234.56 ', 'uno'=>'1.12', 'cero'=>'0.00'], // key default
                ['numero', 'uno', 'cero', 'numEspacio'], // number keys
                ['numero'=>'1,234.56', 'numEspacio'=>' 1,234.56 ', 'uno'=>'1.12', 'cero'=>'0.00'], // request
                [], // noTrimKeys
                [], // ignorKeys
                ['numero'=>'1234.56', 'numEspacio'=>'1234.56', 'uno'=>'1.12', 'cero'=>'0.00'], // expected
            ],

            "Elimina espacios de entrada" => [
                ['palabra'=>''],
                [],
                ['palabra'=>'   palab,ra          larga      '],
                [], // noTrimKeys
                [], // ignorKeys
                ['palabra'=>'palab,ra larga'],
            ],

            "No trim" => [
                ['palabra'=>''],
                [],
                ['palabra'=>'   palab,ra          larga      '],
                ['palabra'], // noTrimKeys
                [], // ignorKeys
                ['palabra'=>'   palab,ra          larga      '], // expected
            ],
            "Ignore keys" => [
                ['Ignorame'=>"soy ignorame", 'r'=>'param llamado r: me ignoran', 'f'=>'param llamado f: me ignoran',
                    'oper'=>'param llamado oper: me ignoran'],
                [],
                ['Ignorame'=>"soy ignorame", 'r'=>'param llamado r: me ignoran', 'f'=>'param llamado f: me ignoran',
                    'oper'=>'param llamado oper: me ignoran'],
                [],
                ['Ignorame'],
                []
            ],
            "Defaults" => [
                ['No vengo en request'=>'valor default', 'vengo en request' => 'vengo default' ],
                [], //number Keys
                ['vengo en request' => 'valor del request', 'solo vengo en request'=>'no salgo' ], // request
                [], // noTrimKeys
                [], // ignorKeys
                ['No vengo en request'=>'valor default', 'vengo en request' => 'valor del request' ] // expected
            ],
            "Array Param" => [
                ['noTrim'=>'noTrim default value', 'numero'=>'default numero', 'palabra'=>'p', 'ignoreme'=>1],
                ['numero'],
                [ 'noTrim'=>['   palab,ra          larga      '],
                  'numero'=>['1,234.56','1,234.56'],
                  'palabra' => ['nombre uno', 'nombre dos'],
                    'ignoreme'=>1
                ],
                ['noTrim'], // noTrimKeys
                ['ignoreme'], // ignorKeys
                [ 'noTrim'=>['   palab,ra          larga      '],
                    'numero'=>['1234.56','1234.56'],
                    'palabra' => ['nombre uno', 'nombre dos']
                ],
            ],
        ];
    }
}
