<?php
/** @noinspection PhpArrayShapeAttributeCanBeAddedInspection */
declare(strict_types=1);
/**
 * Prueba permisos bodega
 *
 * 1.- Da de alta bodegas para sus pruebas
 * 2.- Pide usuarios de pruebas estandard de bootstrap.php nombrando los adicionales que necesita
 * 3.- Pone los permisos a los usuarios
 * 4.- Corre pruebas
 * 5.- Borra permisos y bodegas, Pues los usuarios usa usuarios registrados.
 *
 * @covers \PermisosBodegaTest
 *
 * @covers PermisosBodega::__construct
 * @covers PermisosBodega::getBodegasActivas
 * @covers PermisosBodega::getPermisosPorUsuariosBodegas
 * @covers \PermisosBodega::puedeEntrarABodegas
 * @covers PermisosBodega::bodegasConROoRW
 * @covers PermisosBodega::bodegasConRW
 * @covers PermisosBodega::bodegasPuedeConsultarMovimientos
 * @covers PermisosBodega::bodegasPuedeConsultarVerificarMovimientos
 * @covers PermisosBodega::bodegasPuedeHacerMovimientos
 * @covers PermisosBodega::bodegasPuedeHacerVerificarMovimientos
 * @covers PermisosBodega::traeUsuarioBodegas
 * @covers Iac\inc\sql\IacMysqli
 * @covers sqlMysqli
 * @uses ::assoc_mysql2mysqli()
 * @covers ::ia_sqlArray()
 * @covers ::ia_singleread()
 * @uses ::ia_singleton()
 * @covers ::ia_query()
 * @covers ::ia_sqlSelectMultiKey()
 *
 * @covers ::ia_errores_a_dime()
 * @covers ::usuarioTipoRony()
 * @covers ::strim()
 * @covers ::strit()
 * @covers ::usuarioSupervisaBodega()
 * @uses ::usuarioTipoRony()
 *
 */


global $usuarios;
$usuarios = getForTestsUserIdTypes([
    // 'Puede bodega: No',
    'Puede bodega: Si pero sin permiso_bodega entry',

    'Usuario Nada',
    'Usuario R/O',
    'Usuario R/W',

]);


use Iac\inc\sql\IacSqlBuilder;
use PHPUnit\Framework\TestCase;

class PermisosBodegaTest extends TestCase
{
    protected static permisosBodega $permisosBodegaRony;
    protected static permisosBodega $permisosBodegaTipoRony;
    protected static array $bodegasActivas;
    protected static array $bodegasTodas;

    protected static array $bodegas = [
        "bodegaNoExiste",
        "bodegaNoExisteConPermisos",
        "bodegaSinPermisos",

        "bodegaInactive",
        "bodegaTodosPermisos",
        "bodegaMovimientos",

        "bodegaVerificar",
        "bodegaConteo",


    ];




    /**
     * Corre antes de todas las pruebas de esta clase
     * Pone bodegas y usuarios de prueba
     */
    public static function setUpBeforeClass(): void {
        self::limpiaPruebasDeDb();
        self::preparaPruebasDb();

        self::$permisosBodegaRony = new permisosBodega("1");
        global $usuarios;
        self::$permisosBodegaTipoRony = new PermisosBodega($usuarios['Usuario Tipo Rony']);

        $method = __METHOD__;
        self::$bodegasActivas = ia_sqlArray(
            "SELECT /*$method*/ bodega_id, bodega, label, color, empresa_id, grupo, activo 
                FROM bodega WHERE activo = 'Si' ORDER BY bodega", 'bodega_id');
        self::$bodegasTodas = ia_sqlArray(
            "SELECT /*$method*/ bodega_id, bodega, label, color, empresa_id, grupo, activo 
                FROM bodega ORDER BY bodega", 'bodega_id');
    }

    /**
     * Corre al terminarse todas las pruebas de esta clase
     * Elimina bodegas y usuarios de prueba
     */
    public static function tearDownAfterClass(): void {
        self::limpiaPruebasDeDb();
    }

    protected static function preparaPruebasDb() {
        $builder = new IacSqlBuilder();
        // alta bodegas
            foreach(self::$bodegas as $bodega_id) {
                if($bodega_id === "bodegaNoExiste" || $bodega_id === "bodegaNoExisteConPermisos") {
                    ia_query("delete from bodega where bodega_id = " . strit($bodega_id));
                    continue;
                }

                $bodega = [
                    'bodega_id' => $bodega_id,
                    'bodega' => $bodega_id,
                    'label' => $bodega_id,
                    'grupo' => 'grupoTest',
                    'empresa_id' => 1,
                    'descripcion' => '',
                    'color' => '#FF0000',
                    'activo' => 'Si',
                    'alta_db' => 'NOW()',
                    'alta_por' => 'tester',
                    'ultimo_cambio' => 'NOW()',
                    'ultimo_cambio_por' => 'tester',
                ];
                if($bodega_id === "bodegaInactive")
                    $bodega['activo'] = 'No';
                ia_query($builder->insert('bodega', $bodega, true));
            }


        // alta permisos de usuarios en bodegas
            // puede hacer movimientos, puede consultar movimientos
            $bodegas = [
                "bodegaNoExisteConPermisos",
                "bodegaInactive",
                "bodegaTodosPermisos",
                "bodegaMovimientos",
                ];
            $users = [
                'Usuario Nada' => 'Nada',
                'Usuario R/O' => 'R/O',
                'Usuario R/W' => 'R/W',
            ];
            global $usuarios;
            foreach($users as $rol => $permiso) {
                $iac_usr_id = $usuarios[$rol];
                ia_query("DELETE FROM permiso_bodega WHERE iac_usr_id=$iac_usr_id");
                foreach ($bodegas as $bodegaId) {
                    $sql = "INSERT INTO permiso_bodega(bodega_id, iac_usr_id, puede_movimientos)
                        VALUES('$bodegaId', $iac_usr_id, '$permiso') 
                        ON DUPLICATE KEY UPDATE puede_movimientos = '$permiso'";
                    ia_query($sql);
                }
            }
            // puede verificar movimientos
            $bodegas = [
                "bodegaNoExisteConPermisos",
                "bodegaInactive",
                "bodegaTodosPermisos",
                "bodegaVerificar",
            ];
            $users = [
                'Usuario Nada' => 'Nada',
                'Usuario R/O' => 'R/O',
                'Usuario R/W' => 'R/W',
            ];
            global $usuarios;
            foreach($users as $rol => $permiso)
                foreach($bodegas as $bodegaId) {
                    $iac_usr_id = $usuarios[$rol];
                    $sql = "INSERT INTO permiso_bodega(bodega_id, iac_usr_id, puede_verificar_movimientos)
                            VALUES('$bodegaId', $iac_usr_id, '$permiso') 
                            ON DUPLICATE KEY UPDATE puede_verificar_movimientos = '$permiso'";
                    ia_query($sql);
                }
        // puede verificar movimientos
        $bodegas = [
            "bodegaNoExisteConPermisos",
            "bodegaInactive",
            "bodegaTodosPermisos",
            "bodegaConteo",
        ];
        $users = [
            'Usuario Nada' => 'Nada',
            'Usuario R/O' => 'R/O',
            'Usuario R/W' => 'R/W',
        ];
        global $usuarios;
        foreach($users as $rol => $permiso)
            foreach($bodegas as $bodegaId) {
                $iac_usr_id = $usuarios[$rol];
                $sql = "INSERT INTO permiso_bodega(bodega_id, iac_usr_id, puede_conteo_fisico)
                            VALUES('$bodegaId', $iac_usr_id, '$permiso') 
                            ON DUPLICATE KEY UPDATE puede_conteo_fisico = '$permiso'";
                ia_query($sql);
            }

    }

    protected static function limpiaPruebasDeDb() {
        $bProtected = [];
        foreach(static::$bodegas as $b)
            $bProtected[] = strit($b);
        // quitamos las bodegas adicionales
        ia_query("DELETE FROM permiso_bodega WHERE bodega_id IN (" .  implode(',', $bProtected). ")");
        ia_query("DELETE FROM bodega WHERE bodega_id IN (" .  implode(',', $bProtected). ")");

    }

///
////////PERMISOS true/false /////////////////////////////////////////////////////////////
///


    /**
     * Puede en bodegas
     *
     * @covers \PermisosBodega::puedeEntrarABodegas
     *
     * @dataProvider providerPuedeEntrarABodegas
     * @param $user_id
     * @param $expected
     */
    public function testpuedeEntrarABodegas($user_id, $expected) {
        $bodegas = new PermisosBodega($user_id);
        $this->assertEquals($expected, $bodegas->puedeEntrarABodegas());
    }

    public function providerPuedeEntrarABodegas():array
    {
        global $usuarios;
       // $sin = $usuarios['Puede bodega: Si pero sin permiso_bodega entry'];
        return [
            // testName =>[ userid, expected]
            "Rony" => [1, true],
            "Usuario Tipo Rony" => [$usuarios['Usuario Tipo Rony'] , true],

            'Usuario no existe' => [$usuarios['Usuario no existe'], false],
            'Usuario Inactive' => [$usuarios['Usuario Inactive'], false],
          //  'Puede bodega: No'=> [$usuarios['Puede bodega: No'], false],
          //  "Puede bodega: Si pero sin permiso_bodega entry $sin"=> [$usuarios['Puede bodega: Si pero sin permiso_bodega entry'], false],
            // "usuario ale que si puede" => ["69", true],
            //"usuario solo tiene Nada en permiso_bodega" => [1, false]
        ];
    }

    /**
     * @covers PermisosBodega::puedeEditarCatalogosBodega
     */
    public function testpuedeEditarCatalogosBodega() {
        $this->assertTrue(self::$permisosBodegaRony->puedeEditarCatalogosBodega());
        global $usuarios;
        $permisoBodega = new permisosBodega($usuarios['Usuario R/W']);
        $this->assertFalse($permisoBodega->puedeEditarCatalogosBodega());
    }

    /**
     * @covers PermisosBodega::puedeConsultarCatalogosBodega
     */
    public function testpuedeConsultarCatalogosBodega() {
        $this->assertTrue(self::$permisosBodegaRony->puedeConsultarCatalogosBodega());
        global $usuarios;
        $permisoBodega = new permisosBodega($usuarios['Usuario R/W']);
        $this->assertFalse($permisoBodega->puedeConsultarCatalogosBodega());
    }


    /**
     * Rony, tipo Rony puede CONSULTAR movimientos
     *
     * @covers       \PermisosBodega::puedeConsultarMovimientos
     * @covers       \PermisosBodega::permisoConsultar
     *
     * @dataProvider providerTipoRonypuedeConsultarMovimientos
     * @param $bodega_id
     * @param $expected
     */
    public function testTipoRonyPuedeConsultarMovimientos($bodega_id, $expected) {
        $this->assertEquals($expected, self::$permisosBodegaRony->puedeConsultarMovimientos($bodega_id));
    }

    /**
     * Rony, tipo Rony puede CONSULTAR Verificar movimientos
     *
     * @covers       \PermisosBodega::puedeConsultarVerificarMovimientos
     * @covers       \PermisosBodega::permisoConsultar
     * @covers       \PermisosBodega::getBodegasActivasEInactivas
     *
     * @dataProvider providerTipoRonypuedeConsultarMovimientos
     * @param $bodega_id
     * @param $expected
     */
    public function testTipoRonyPuedeConsultarVerificarMovimientos($bodega_id, $expected) {
        $this->assertEquals($expected,
            self::$permisosBodegaRony->puedeConsultarVerificarMovimientos($bodega_id));
    }

    public function providerTipoRonypuedeConsultarMovimientos(): array
    {
        return [
            "Bodega no existe" => ["bodegaNoExiste", false],
            "Bodega no existe con permisos" => ["bodegaNoExisteConPermisos", false],
            "Empty bodega_id" => ["", false],
            "Bodega inactiva" => ["bodegaInactive", true],
            "Bodega totalmente sin permisos" => ["bodegaSinPermisos", true],
            "Bodega con permisos" => ["bodegaTodosPermisos", true],

        ];
    }

    /**
     * Rony, tipo Rony puede CONSULTAR movimientos
     *
     * @covers       \PermisosBodega::puedeHacerMovimientos
     * @covers       PermisosBodega::permisoRW
     *
     * @dataProvider providerTipoRonypuedeHacerMovimientos
     * @param string $bodega_id
     * @param bool $expected
     */
    public function testTipoRonyPuedeHacerMovimientos(string $bodega_id, bool $expected) {
        $this->assertEquals($expected, self::$permisosBodegaRony->puedeHacerMovimientos($bodega_id));
    }

    /**
     * Rony, tipo Rony puede CONSULTAR Verificar movimientos
     *
     * @covers       \PermisosBodega::puedeHacerVerificarMovimientos
     * @covers       PermisosBodega::permisoRW
     *
     * @dataProvider providerTipoRonypuedeHacerMovimientos
     * @param string $bodega_id
     * @param bool $expected
     * @throws Exception
     */
    public function testTipoRonyPuedeHacerVerificarMovimientos(string $bodega_id, bool $expected) {
        $this->assertEquals($expected,
            self::$permisosBodegaRony->puedeHacerVerificarMovimientos($bodega_id));
    }

    public function providerTipoRonypuedeHacerMovimientos(): array
    {
        return [
            "Bodega no existe" => ["bodegaNoExiste", false],
            "Bodega no existe con permisos" => ["bodegaNoExisteConPermisos", false],
            "Empty bodega_id" => ["", false],
            "Bodega inactiva" => ["bodegaInactive", false],
            "Bodega totalmente sin permisos" => ["bodegaSinPermisos", true],
            "Bodega con permisos" => ["bodegaTodosPermisos", true],

        ];
    }

    /**
     * Usuario puede CONSULTAR movimientos.
     *
     * @covers       PermisosBodega::puedeConsultarMovimientos
     * @covers       PermisosBodega::permisoConsultar
     *
     * @dataProvider providerUsuarioPuedeConsultarMovimientos
     * @param string $bodega_id
     * @param int|string $user_id
     * @param bool $expected
     */
    public function testUsuarioPuedeConsultarMovimientos(string $bodega_id, int|string $user_id, bool $expected) {
        $permisoBodega = new permisosBodega($user_id);
        $this->assertEquals($expected, $permisoBodega->puedeConsultarMovimientos($bodega_id));
    }

    public function providerUsuarioPuedeConsultarMovimientos(): array
    {
        global $usuarios;
        $usrRW = $usuarios['Usuario R/W'];
       // $sin = $usuarios['Puede bodega: Si pero sin permiso_bodega entry'];
        return [
            "bodegaNoExisteConPermisos" => ["bodegaNoExisteConPermisos", $usuarios['Usuario R/W'], false],
            "bodegaInactive  $usrRW" => ["bodegaInactive", $usuarios['Usuario R/W'], false],
            "Empty bodega_id" => ["", $usuarios['Usuario R/W'], false],

            'bodegaMovimientos Usuario no existe' => ["bodegaMovimientos", $usuarios['Usuario no existe'], false],
            'bodegaMovimientos Usuario Inactive' => ["bodegaMovimientos", $usuarios['Usuario Inactive'], false],
        //    "bodegaMovimientos Usuario Puede bodega: No" => ["bodegaMovimientos", $usuarios['Puede bodega: No'], false],
        //    "bodegaMovimientos Usuario Sin permiso_bodega entry $sin" => ["bodegaMovimientos", $sin, false],
            "bodegaMovimientos Usuario Nada" => ["bodegaMovimientos", $usuarios['Usuario Nada'], false],
            "bodegaMovimientos Usuario R/O" => ["bodegaMovimientos", $usuarios['Usuario R/O'], true],
            "bodegaMovimientos Usuario R/W" => ["bodegaMovimientos", $usuarios['Usuario R/W'], true],

            "bodegaSinPermisos Usuario Nada" => ["bodegaSinPermisos", $usuarios['Usuario Nada'], false],
            "bodegaSinPermisos Usuario R/O" => ["bodegaSinPermisos", $usuarios['Usuario R/O'], false],
            "bodegaSinPermisos Usuario R/W" => ["bodegaSinPermisos", $usuarios['Usuario R/W'], false],



        ];
    }

    /**
     * Usuario puede HACER movimientos.
     *
     * @covers       PermisosBodega::puedeHacerMovimientos
     * @covers       PermisosBodega::permisoRW
     *
     * @dataProvider providerUsuarioPuedeHacerMovimientos
     * @param string $bodega_id
     * @param int|string $user_id
     * @param bool $expected
     */
    public function testUsuarioPuedeHacerMovimientos(string $bodega_id, int|string $user_id, bool $expected) {
        $permisoBodega = new permisosBodega($user_id);
        $this->assertEquals($expected, $permisoBodega->puedeHacerMovimientos($bodega_id));
    }

    public function providerUsuarioPuedeHacerMovimientos(): array
    {
        global $usuarios;
        $usrRW = $usuarios['Usuario R/W'];
        // $sin = $usuarios['Puede bodega: Si pero sin permiso_bodega entry'];
        return [
            "bodegaNoExisteConPermisos" => ["bodegaNoExisteConPermisos", $usuarios['Usuario R/W'], false],
            "bodegaInactive  $usrRW" => ["bodegaInactive", $usuarios['Usuario R/W'], false],
            "Empty bodega_id" => ["", $usuarios['Usuario R/W'], false],

            'bodegaMovimientos Usuario no existe' => ["bodegaMovimientos", $usuarios['Usuario no existe'], false],
            'bodegaMovimientos Usuario Inactive' => ["bodegaMovimientos", $usuarios['Usuario Inactive'], false],

          //  "bodegaMovimientos Usuario Puede bodega: No" => ["bodegaMovimientos", $usuarios['Puede bodega: No'], false],
          //  "bodegaMovimientos Usuario Sin permiso_bodega entry $sin" => ["bodegaMovimientos", $sin, false],
            "bodegaMovimientos Usuario Nada" => ["bodegaMovimientos", $usuarios['Usuario Nada'], false],
            "bodegaMovimientos Usuario R/O" => ["bodegaMovimientos", $usuarios['Usuario R/O'], false],
            "bodegaMovimientos Usuario R/W" => ["bodegaMovimientos", $usuarios['Usuario R/W'], true],

            "bodegaSinPermisos Usuario Nada" => ["bodegaSinPermisos", $usuarios['Usuario Nada'], false],
            "bodegaSinPermisos Usuario R/O" => ["bodegaSinPermisos", $usuarios['Usuario R/O'], false],
            "bodegaSinPermisos Usuario R/W" => ["bodegaSinPermisos", $usuarios['Usuario R/W'], false],
            "bodegaSinPermisos Usuario Rony" => ["bodegaSinPermisos", 1, true],
            "bodegaSinPermisos Usuario Tipo Rony" => ["bodegaSinPermisos", $usuarios['Usuario Tipo Rony'], true],




        ];
    }

    /**
     * @covers PermisosBodega::puedeVerValorProductos
     * @uses PermisosBodega::getBodegasActivasEInactivas
     * @uses PermisosBodega::getPermisosDeBodega
     * @uses PermisosBodega::traeUsuarioBodegas
     */
    public function testPuedeVerValorProductos() {
        $this->assertTrue(self::$permisosBodegaRony->puedeVerValorProductos('bodegaMovimientos'),
            "Rony");
        global $usuarios;
        $permisos_bodega = new PermisosBodega($usuarios['Usuario R/W']);
        $this->assertFalse($permisos_bodega->puedeVerValorProductos('bodegaMovimientos'),
            "Usuario no puede");
    }

    /**
     * @covers PermisosBodega::puedeReportesEspeciales
     * @uses PermisosBodega::getBodegasActivasEInactivas
     * @uses PermisosBodega::getPermisosDeBodega
     * @uses PermisosBodega::traeUsuarioBodegas
     */
    public function testPuedeReportesEspeciales() {
        $this->assertTrue(self::$permisosBodegaRony->puedeReportesEspeciales('bodegaMovimientos'),
            "Rony");
        global $usuarios;
        $permisos_bodega = new PermisosBodega($usuarios['Usuario R/W']);
        $this->assertFalse($permisos_bodega->puedeReportesEspeciales('bodegaMovimientos'),
            "Usuario no puede");
    }

///
////////PERMISOS regresan array  /////////////////////////////////////////////////////////////
///
    /**
     * @covers PermisosBodega::getBodegasActivas
     */
    public function testgetBodegasActivas() {
        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaRony->getBodegasActivas()
        );
    }

    /**
     * @covers PermisosBodega::getBodegasActivasEInactivas
     */
    public function testGetBodegasActivasEInactivas() {
        $this->assertEquals(
            self::$bodegasTodas,
            self::$permisosBodegaRony->getBodegasActivasEInactivas()
        );
    }


    /**
     * Rony y usuario tipo rony en que bodegas puede hacer movimientos
     *
     * @covers PermisosBodega::bodegasPuedeHacerMovimientos
     * @covers PermisosBodega::bodegasConRW
     * @covers PermisosBodega::permisosBodegaRonyModificar
     * @covers PermisosBodega::getBodegasActivasEInactivas
     */
    public function testRonyBodegasPuedeHacerMovimientos() {
        $this->assertEquals(
    self::$bodegasActivas,
    self::$permisosBodegaRony->bodegasPuedeHacerMovimientos(),
            "Rony puede en todas las bodegas activas"
        );
        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaTipoRony->bodegasPuedeHacerMovimientos(),
            "Usuario tipo Rony puede en todas las bodegas activas"
        );
        $this->assertEquals(
            ["bodegaTodosPermisos" => self::$bodegasActivas["bodegaTodosPermisos"]],
            self::$permisosBodegaRony->bodegasPuedeHacerMovimientos("bodegaTodosPermisos"),
            "Rony en bodega con permisos"
        );
        $this->assertEquals(
            ["bodegaTodosPermisos" => self::$bodegasActivas["bodegaTodosPermisos"]],
            self::$permisosBodegaTipoRony->bodegasPuedeHacerMovimientos("bodegaTodosPermisos"),
            "Tipo rony en bodega con permisos"
        );

        $this->assertEquals(
            [],
            self::$permisosBodegaRony->bodegasPuedeHacerMovimientos("bodegaNoExiste"),
            "En bodega no existe"
        );
        $this->assertEquals(
            [],
            self::$permisosBodegaRony->bodegasPuedeHacerMovimientos("bodegaInactive"),
            "En bodega Inactive"
        );
    }

    /**
     * Rony y usuario tipo rony en que bodegas puede hacer verificar movimientos
     *
     * @covers PermisosBodega::bodegasPuedeHacerVerificarMovimientos
     * @covers PermisosBodega::bodegasConRW
     * @covers PermisosBodega::permisosBodegaRonyModificar
     */
    public function testRonyBodegasPuedeHacerVerificarMovimientos() {
        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaRony->bodegasPuedeHacerVerificarMovimientos(),
            "Rony puede en todas las bodegas activas"
        );
        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaTipoRony->bodegasPuedeHacerVerificarMovimientos(),
            "Usuario tipo Rony puede en todas las bodegas activas"
        );

        $this->assertEquals(
             ["bodegaTodosPermisos" => self::$bodegasActivas["bodegaTodosPermisos"]],
            self::$permisosBodegaRony->bodegasPuedeHacerVerificarMovimientos("bodegaTodosPermisos"),
            "Rony en bodega con permisos"
        );
        $this->assertEquals(
            ["bodegaTodosPermisos" => self::$bodegasActivas["bodegaTodosPermisos"]],
            self::$permisosBodegaTipoRony->bodegasPuedeHacerVerificarMovimientos("bodegaTodosPermisos"),
            "Tipo rony en bodega con permisos"
        );

        $this->assertEquals(
            [],
            self::$permisosBodegaRony->bodegasPuedeHacerVerificarMovimientos("bodegaNoExiste"),
            "En bodega no existe"
        );
        $this->assertEquals(
            [],
            self::$permisosBodegaRony->bodegasPuedeHacerVerificarMovimientos("bodegaInactive"),
            "En bodega inactive"
        );

    }

    /**
     * Rony y usuario tipo rony en que bodegas puede hacer movimientos
     *
     * @covers PermisosBodega::bodegasPuedeConsultarMovimientos
     * @covers  PermisosBodega::bodegasConROoRW
     * @covers PermisosBodega::permisosBodegaRonyConsulta
     * @covers PermisosBodega::getBodegasActivasEInactivas
     */
    public function testRonyBodegasPuedeConsultarMovimientos() {

        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaRony->bodegasPuedeConsultarMovimientos()
        );
        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaTipoRony->bodegasPuedeConsultarMovimientos()
        );

        $this->assertEquals(
            ["bodegaTodosPermisos" => self::$bodegasTodas["bodegaTodosPermisos"]],
            self::$permisosBodegaRony->bodegasPuedeConsultarMovimientos("bodegaTodosPermisos"),
            "bodegaTodosPermisos, Rony"
        );
        $this->assertEquals(
             ["bodegaTodosPermisos" => self::$bodegasTodas["bodegaTodosPermisos"]],
            self::$permisosBodegaTipoRony->bodegasPuedeConsultarMovimientos("bodegaTodosPermisos"),
            "bodegaTodosPermisos, tipo rony"
        );
        $this->assertEquals(
             ["bodegaInactive" => self::$bodegasTodas["bodegaInactive"] ],
            self::$permisosBodegaRony->bodegasPuedeConsultarMovimientos("bodegaInactive"),
            "bodegaInactive, puede consultar una bodega inactive"
        );
        $this->assertEquals(
            [],
            self::$permisosBodegaRony->bodegasPuedeConsultarMovimientos("bodegaNoExiste"),
            "bodegaNoExiste"
        );


    }

    /**
     * Rony y usuario tipo rony en que bodegas puede hacer movimientos
     *
     * @covers PermisosBodega::bodegasPuedeConsultarVerificarMovimientos
     * @covers PermisosBodega::bodegasConROoRW
     * @covers PermisosBodega::permisosBodegaRonyConsulta
     * @covers PermisosBodega::getBodegasActivasEInactivas
     */
    public function testRonyBodegasPuedeConsultarVerificarMovimientos() {

        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaRony->bodegasPuedeConsultarVerificarMovimientos()
        );
        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaTipoRony->bodegasPuedeConsultarVerificarMovimientos()
        );

        $this->assertEquals(
            ["bodegaTodosPermisos" => self::$bodegasTodas["bodegaTodosPermisos"]],
            self::$permisosBodegaRony->bodegasPuedeConsultarVerificarMovimientos("bodegaTodosPermisos"),
            "bodegaTodosPermisos, Rony"
        );
        $this->assertEquals(
            ["bodegaTodosPermisos" => self::$bodegasTodas["bodegaTodosPermisos"]],
            self::$permisosBodegaTipoRony->bodegasPuedeConsultarVerificarMovimientos("bodegaTodosPermisos"),
            "bodegaTodosPermisos, tipo rony"
        );
        $this->assertEquals(
            ["bodegaInactive" => self::$bodegasTodas["bodegaInactive"] ],
            self::$permisosBodegaRony->bodegasPuedeConsultarVerificarMovimientos("bodegaInactive"),
            "bodegaInactive, puede consultar una bodega inactive"
        );
        $this->assertEquals(
            [],
            self::$permisosBodegaRony->bodegasPuedeConsultarVerificarMovimientos("bodegaNoExiste"),
            "bodegaNoExiste"
        );


    }

    /**
     * Usuarios No pueden hacer movimientos.
     *
     * @covers PermisosBodega::bodegasPuedeHacerMovimientos
     * @covers PermisosBodega::bodegasConRW
     * @covers PermisosBodega::traeUsuarioBodegas
     *
     * @dataProvider providerUsuarioNoBodegasPuedeHacerMovimientos
     */
    public function testUsuarioNoBodegasPuedeHacerMovimientos(int|string $uId, string $bodegaId, array $expected) {
        $permisosBodega = new PermisosBodega($uId);
        $this->assertEquals($expected, $permisosBodega->bodegasPuedeHacerMovimientos($bodegaId));
    }

    public function providerUsuarioNoBodegasPuedeHacerMovimientos():array {
        global $usuarios;
        $usuarioPuede = $usuarios['Usuario R/W'];
        return [
            "bodegaNoExiste, usuario puede" => [$usuarioPuede, "bodegaNoExiste", []],
            "bodegaNoExisteConPermisos, usuario puede" => [$usuarioPuede, "bodegaNoExisteConPermisos", []],
            "bodegaSinPermisos, usuario puede" => [$usuarioPuede, "bodegaSinPermisos", []],
            "bodegaInactive, usuario puede" => [$usuarioPuede, "bodegaInactive", []],
            "Usuario RW en bodega sin permisos" => [$usuarioPuede, "bodegaVerificar", []],


            "Usuario no existe con bodegaTodosPermisos" => [$usuarios['Usuario no existe'], "bodegaTodosPermisos", []],
            "Usuario inactive con bodegaTodosPermisos" => [$usuarios['Usuario Inactive'], "bodegaTodosPermisos", []],
            "Usuario no existe en que bodegas" => [$usuarios['Usuario no existe'], "", []],
            "Usuario inactive en que bodegas" => [$usuarios['Usuario Inactive'], "", []],
            "Usuario con permiso Nada en que bodegas" => [$usuarios['Usuario Nada'], "", []],
            "Usuario con permiso R/O en que bodegas" => [$usuarios['Usuario R/O'], "", []],

            "Usuario Nada en bodegaMovimientos" => [$usuarios['Usuario Nada'], "bodegaMovimientos", []],
            "Usuario R/O en bodegaMovimientos" => [$usuarios['Usuario R/O'], "bodegaMovimientos", []],
            "Usuario R/W en otra bodega no en esta" => [$usuarios['Usuario R/W'], "bodegaVerificar", []],

        ];

    }

    /**
     * Usuarios NO puede consultar movimientos.
     *
     * @covers PermisosBodega::bodegasPuedeConsultarMovimientos
     * @covers PermisosBodega::bodegasConROoRW
     * @covers PermisosBodega::traeUsuarioBodegas
     *
     * @dataProvider providerUsuarioNoPuedeConsultarBodegas
     */
    public function testUsuarioNoPuedeConsultarBodegas(int|string $uId, string $bodegaId, array $expected) {
        $permisosBodega = new PermisosBodega($uId);
        $this->assertEquals($expected, $permisosBodega->bodegasPuedeConsultarMovimientos($bodegaId));
    }

    public function providerUsuarioNoPuedeConsultarBodegas():array {
        global $usuarios;
        $usuarioPuedeRO = $usuarios['Usuario R/O'];
        $usuarioPuedeRW = $usuarios['Usuario R/W'];
        return [
            "bodegaNoExisteUsuarioRO" => [$usuarioPuedeRO, "bodegaNoExiste", []],
            "bodegaNoExisteUsuarioRW" => [$usuarioPuedeRW, "bodegaNoExiste", []],
            "bodegaSinPermisosRO" => [$usuarioPuedeRO, "bodegaSinPermisos", []],
            "bodegaSinPermisos" => [$usuarioPuedeRW, "bodegaSinPermisos", []],
            "bodegaInactiveRO" => [$usuarioPuedeRO, "bodegaInactive", []],
            "bodegaInactiveRW" => [$usuarioPuedeRW, "bodegaInactive", []],

            "Usuario RO en bodega sin permiso" => [$usuarioPuedeRO, "bodegaVerificar", []],
            "Usuario RW en bodega sin permiso" => [$usuarioPuedeRW, "bodegaVerificar", []],

            "bodegaNoExisteConPermisosRO" => [$usuarioPuedeRO, "bodegaNoExisteConPermisos", []],
            "Usuario no existe con bodegaTodosPermisos" => [$usuarios['Usuario no existe'], "bodegaTodosPermisos", []],
            "Usuario inactive con bodegaTodosPermisos" => [$usuarios['Usuario Inactive'], "bodegaTodosPermisos", []],
            "Usuario no existe en que bodegas" => [$usuarios['Usuario no existe'], "", []],
            "Usuario inactive en que bodegas" => [$usuarios['Usuario Inactive'], "", []],
            "Usuario Nada en " => [$usuarios['Usuario Nada'], "bodegaMovimientos", []],
        ];

    }

    /**
     * Usuario SI puede hacer movimientos en que bodegas o en bodega especifica
     *
     * @covers PermisosBodega::bodegasPuedeHacerMovimientos
     * @covers PermisosBodega::bodegasConRW
     * @covers PermisosBodega::traeUsuarioBodegas
     *
     */
    public function testUsuarioBodegasPuedeHacerMovimientos() {
        global $usuarios;

        $permisoBodega = new PermisosBodega($usuarios['Usuario R/W']);
        $this->assertArrayHasKey("bodegaMovimientos", $permisoBodega->bodegasPuedeHacerMovimientos(),
            "Usuario R/W puede hacer movimientos en que bodegas");
        $this->assertArrayHasKey("bodegaTodosPermisos", $permisoBodega->bodegasPuedeHacerMovimientos(),
            "Usuario R/W puede hacer movimientos en que bodegas");

        $this->assertArrayHasKey("bodegaMovimientos", $permisoBodega->bodegasPuedeHacerMovimientos("bodegaMovimientos"),
            "Usuario R/W puede hacer movimientos en bodegaMovimientos");
        $this->assertArrayNotHasKey("bodegaTodosPermisos", $permisoBodega->bodegasPuedeHacerMovimientos("bodegaMovimientos"),
            "Usuario R/W puede hacer movimientos en bodegaMovimientos");
    }

    /**
     * @covers PermisosBodega::bodegasPuedeRegistarConteoFisico
     * @covers PermisosBodega::bodegasConRW
     * @covers PermisosBodega::permisosBodegaRonyModificar
     */
    public function testRonyPuedeRegistrarConteoFisico() {
        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaRony->bodegasPuedeRegistarConteoFisico()
        );
        $this->assertEquals(
            self::$bodegasActivas,
            self::$permisosBodegaTipoRony->bodegasPuedeRegistarConteoFisico()
        );
    }

    /**
     * @covers PermisosBodega::bodegasPuedeConsultarConteoFisico
     * @covers PermisosBodega::bodegasConROoRW
     * @covers PermisosBodega::permisosBodegaRonyConsulta
     * @covers PermisosBodega::getBodegasActivasEInactivas
     */
    public function testRonyPuedeConsultarConteoFisico() {
        $this->assertSame(
            self::$bodegasActivas,
            self::$permisosBodegaTipoRony->bodegasPuedeConsultarConteoFisico()
        );
    }

    /**
     * @covers PermisosBodega::bodegasPuedeRegistarConteoFisico
     * @covers PermisosBodega::bodegasConRW
     * @covers PermisosBodega::traeUsuarioBodegas
     *
     * @dataProvider providerBodegasPuedeRegistarConteoFisico
     */
    public function testUsuarioBodegasPuedeRegistarConteoFisico($usuario_id, $bodega_id, $expected) {
        $permiso_bodega = new PermisosBodega($usuario_id);
        if(is_array($expected)) {
            $this->assertEquals($expected,
                $permiso_bodega->bodegasPuedeRegistarConteoFisico($bodega_id)
            );
        }   else {
                $this->assertEquals($expected,
                    array_key_exists($bodega_id,
                    $permiso_bodega->bodegasPuedeRegistarConteoFisico($bodega_id)
                    )
                );
        }
    }

    public function providerBodegasPuedeRegistarConteoFisico():array {
        global $usuarios;
        return [
            'Usuario No existe'=>[ $usuarios['Usuario no existe'], '', [] ],
            'Usuario Nada'=>[ $usuarios['Usuario Nada'], '', [] ],
            'Usuario R/O'=>[ $usuarios['Usuario R/O'], '', [] ],
            'Usuario R/O bodega conteo'=>[ $usuarios['Usuario R/O'], 'bodegaConteo', [] ],
            'Usuario R/W bodega conteo'=>[ $usuarios['Usuario R/W'], 'bodegaConteo', true ],
            'Usuario R/W bodegaTodosPermisos'=>[ $usuarios['Usuario R/W'], 'bodegaConteo', true ],
        ];
    }


///
//////// Regresan un sql in clause para bodegas ids en que puede ...  para bodega_id IN('b1',... ) ////
///

    /**
     * @covers PermisosBodega::inBodegasIdConsultarVerificarMovimientos
     * @covers PermisosBodega::inClause
     * @covers   PermisosBodega::bodegasPuedeConsultarVerificarMovimientos
     * @covers   PermisosBodega::permisosBodegaRonyConsulta
     * @covers   PermisosBodega::getBodegasActivas
     * @covers   PermisosBodega::bodegasConROoRW
     * @covers   PermisosBodega::traeUsuarioBodegas
     *
     */
    public function testInBodegasIdConsultarVerificarMovimientos() {
        global $usuarios;
        $permiso_bodega = new PermisosBodega($usuarios['Usuario Nada']);
        $this->assertEquals( "('\r\t\n')", $permiso_bodega->inBodegasIdConsultarVerificarMovimientos(),
            "Usuario Sin permiso");
        $permiso_bodega = new PermisosBodega("1");
        $inClause = '';
        foreach($permiso_bodega->getBodegasActivas() as $bodega_id => $_)
            $inClause .= ($inClause === '' ? '' : ',') . strit($bodega_id);
        $inClause = "($inClause)";
        $this->assertEquals( $inClause, $permiso_bodega->inBodegasIdConsultarVerificarMovimientos(),
            "Usuario Rony");

        $permiso_bodega = new PermisosBodega($usuarios['Usuario R/O']);
        $this->assertStringContainsString( 'bodegaVerificar', $permiso_bodega->inBodegasIdConsultarVerificarMovimientos(),
            "Usuario R/O");
    }


    /**
     * @covers PermisosBodega::inBodegasIdConsultarMovimientos
     * @covers PermisosBodega::inClause
     * @uses   PermisosBodega::bodegasPuedeConsultarMovimientos
     * @uses   PermisosBodega::permisosBodegaRonyConsulta
     * @uses   PermisosBodega::getBodegasActivasEInactivas
     * @uses   PermisosBodega::bodegasConROoRW
     * @uses   PermisosBodega::traeUsuarioBodegas
     *
     */
    public function testInBodegasIdConsultarMovimientos() {
        global $usuarios;
        $permiso_bodega = new PermisosBodega($usuarios['Usuario Nada']);
        $this->assertEquals( "('\r\t\n')", $permiso_bodega->inBodegasIdConsultarMovimientos(),
            "Sin permiso");
        $permiso_bodega = new PermisosBodega("1");
        $inClause = '';
        foreach($permiso_bodega->getBodegasActivas() as $bodega_id => $_)
            $inClause .= ($inClause === '' ? '' : ',') . strit($bodega_id);
        $inClause = "($inClause)";
        $this->assertEquals( $inClause, $permiso_bodega->inBodegasIdConsultarMovimientos(),
            "Rony");

        $permiso_bodega = new PermisosBodega($usuarios['Usuario R/O']);
        $this->assertStringContainsString( 'bodegaMovimientos', $permiso_bodega->inBodegasIdConsultarMovimientos(),
            "Usuario R/O");
    }

///
//////// Todos los permisos de un usuario ////
///

    /**
     * @covers PermisosBodega::getPermisosDeBodega
     * @uses PermisosBodega::permisosBodegaRonyModificar()
     * @uses PermisosBodega::getBodegasActivas()
     * @uses PermisosBodega::traeUsuarioBodegas()
     *
     */
    public function testGetPermisosDeBodega() {
        $permiso_bodega = new PermisosBodega("1");
        $this->assertEquals($permiso_bodega->getBodegasActivas(),
            $permiso_bodega->getPermisosDeBodega(),
            'Rony Todas las bodegas'
        );
        global $usuarios;
        $permiso_bodega = new PermisosBodega($usuarios['Usuario R/O']);
        $this->assertArrayHasKey('bodegaTodosPermisos', $permiso_bodega->getPermisosDeBodega(),
            'Usuario tiene permiso en bodega'
        );
    }


}
