<?php 

use PHPUnit\Framework\TestCase;

include_once "bodega/listas/LiHelpers.php";

class Permisador {
    public static function puede($permiso) {
        return true;
    }
}

class ListPreciosTest extends TestCase
{
    protected $listPrecios;

    public function setUp() : void {

        parent::setUp();
        $this->listPrecios = new LiHelpers(null, true);
    }

    public function testIsPositive() {


        $permisos= $this->listPrecios->permisos;

        $this->assertTrue($permisos);
    }

    public function testIsArray() {

        $listas= $this->listPrecios->listas;

        $this->assertIsArray($listas);

        $this->assertNotEmpty($listas);

        $this->assertGreaterThan(0, count($listas));
        
    }

    public function testProducts() {
        $productos= $this->listPrecios->productos;
        $this->assertNotNull($productos);

        $this->assertNotEmpty($productos);

        //buscando que sea un array
        $this->assertIsArray($productos);

        //buscando que tenga al menos un producto
        $this->assertGreaterThan(0, count($productos));
    }

    public function testTotalListas() {
        $totalListas= $this->listPrecios->total_listas;

        $this->assertNotNull($totalListas);

        $this->assertNotEmpty($totalListas);

        $this->assertGreaterThan(0, $totalListas);
    }

    public function testTotalActuales() {
        $totalActuales= $this->listPrecios->total_actuales;

        $this->assertNotNull($totalActuales);

        $this->assertNotEmpty($totalActuales);

        $this->assertGreaterThan(0, $totalActuales);
    }

    public function testTotalFuturas() {
        $totalFuturas= $this->listPrecios->total_futuras;
        $totalFuturas= intval($totalFuturas);

        $this->assertNotNull($totalFuturas);

        $this->assertIsInt($totalFuturas);
        
    }

    public function testTotal_draft() {
        $totalDraft= $this->listPrecios->total_trabajo;
        $totalDraft= intval($totalDraft);

        $this->assertNotNull($totalDraft);

        $this->assertIsInt($totalDraft);        
    }

    public function testListaCaducada() {

        $fehcaCaducada= date("Y-m-d", strtotime("-1 day"));
        $fecha_inicio= date("Y-m-d", strtotime("-2 day"));

        $totalListasInit= $this->listPrecios->total_listas();

        $sql= 
        "INSERT INTO 
        lista_precios
        (lista_precios_id, nombre, activo, fecha_inicio, fecha_fin, archivada, es_trabajo, locked, fecha_lista)
        VALUES
        (8000, 'Lista Caducada', 'Si', '$fecha_inicio', '$fehcaCaducada', 0, 0, 0, '8000_$fecha_inicio')";

        $result= ia_query($sql);

        $this->assertFalse($result);


        $this->listPrecios->jubilandoListas();

        $totalListas= $this->listPrecios->total_listas();


        $sql= "DELETE FROM lista_precios WHERE nombre='Lista Caducada'";
        $delete=ia_query($sql);

        assert($delete);

        $this->assertEquals($totalListasInit, $totalListas);

    }

    
    
}

?>