<?php
declare(strict_types=1);
include "bodega/componentes/nota_history/Historial.php";
/**
 * Tests para Historian
 *
 * @covers the_error_handler
 * @covers Iac\inc\sql\IacMysqli::runSql
 */

use PHPUnit\Framework\TestCase;

// global $usuarios; $usuarios = getForTestsUserIdTypes([]);

class HistorialTest extends TestCase
{
// https://docs.phpunit.de/en/10.0/fixtures.html Ojo este link es de phpunit 10.0 y tenemos instalado 9.5

    const NOTA_BODEGA_ID = 'cc483a12801aa75111ee210e199212ed';

    /**
     * Se ejecuta antes de la clase de pruebas o de todos sus metodos de test*
     * @return void
     */
    public static function setUpBeforeClass(): void {
        $items = [
            0 => [
                'history_id' => '205305',
                'date' => '2023-07-18 18:03:04',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            1 => [
                'history_id' => '205304',
                'date' => '2023-07-18 18:03:04',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            2 => [
                'history_id' => '205303',
                'date' => '2023-07-18 18:03:04',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "FALTAN VERIFICACIONES", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "0", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ]
        ];
        $nota_bodega_id = self::NOTA_BODEGA_ID;
        $action = "test_nota_hist";
        $motive = '';
        $table = 'nota_bodega_hist';

        $insertValues = [
            'action' => $action,
            'motive' => $motive,
            'pk' => $nota_bodega_id,
            'user_nick' => empty($user_nick) ? $_SESSION['usuario'] : $user_nick,
            'date' => 'NOW()'
        ];

        $select_item = ia_singleton("SELECT * FROM nota_bodega_hist WHERE pk=".strit($nota_bodega_id));
        if(!empty($select_item)) {
            $sql = "DELETE FROM nota_bodega_hist WHERE pk = ".strit($nota_bodega_id);
            $ok = ia_query($sql,true,false);
        }

        foreach($items as $item){
            $insertValues['record'] = $item["record"];
            $_sql[] = ia_insert($table,$insertValues);
            ia_transaction($_sql);
        }
    }

    /**
     * Se ejecuta al terminar todas las pruebas (metodos test*) de la clase
     * @return void
     */
    public static function tearDownAfterClass():void {

    }

    /**
     * Se corre antes de correr cada test* Method.
     * @return void
     */
    protected function setUp(): void {
    }

    /**
     * Se corre después de correr cada test* Method.
     * @return void
     */
    protected function tearDown(): void {
    }

    /**
     * @covers ::getAllHistory
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers assoc_mysql2mysqli
     * @covers ia_sqlArrayIndx
     * @covers sqlMysqli::log_trace
     * @covers strit
     */
    public function testGetAllHistory()
    {

        $nota_bodega_id = self::NOTA_BODEGA_ID;
        $result = getAllHistory($nota_bodega_id);

        $this->assertIsArray($result);

        foreach( $result as  $res ){
            $this->assertArrayHasKey('record', $res);
            $this->assertNotEmpty($res["record"]);
        }


        $this->assertEquals(
            [], getAllHistory([]), "Test empty array param"
        );

        $this->assertEquals(
            [], getAllHistory(null), "Test null param"
        );

        $this->assertEquals(
            [], getAllHistory(''), "Test empty param"
        );
    }


    /**
     * @covers ::getArrayDifferences
     * @covers getArrayDifferences
     * @covers getItemsDiff
     * @covers getNotaDiff
     * @covers indexItem
     * @covers getAllNotaDiff
     * @covers assoc_mysql2mysqli
     * @covers ia_sqlArray
     * @covers sqlMysqli::log_trace
     * @covers strit
     * @covers Iac\inc\sql\IacMysqli::selectArrayKey
     */
    public function testGetArrayDifferences(){
        $hist = [
            0 => [
                'history_id' => '205464',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "FALTAN VERIFICACIONES", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "0", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            1 => [
                'history_id' => '205463',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            2 => [
                'history_id' => '205462',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            3 => [
                'history_id' => '205461',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            4 => [
                'history_id' => '205460',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            5 => [
                'history_id' => '205459',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
        ];
        $espera = [
            0 => [
                'history_id' => '205464',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "FALTAN VERIFICACIONES", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "0", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            1 => [
                'history_id' => '205462',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
            2 => [
                'history_id' => '205461',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}] - []',
                        'numero_compra_actual' => '3068 - ',
                    ],
                    'cambios_items' => '',
                ],
            ],
            3 => [
                'history_id' => '205460',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
        ];

        $result = getArrayDifferences($hist, false);
        $this->assertEquals(
            $espera, $result, "Test correct param important = false. getArrayDifferences"
        );

        foreach( $result as  $res ){
            $this->assertNotEmpty($res);
        }

        $espera = [
            0 => [
                'history_id' => '205464',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "FALTAN VERIFICACIONES", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "0", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
        ];
        $result = getArrayDifferences($hist, true);
        $this->assertEquals(
            $espera, $result, "Test correct param important = true. getArrayDifferences"
        );

        foreach( $result as  $res ){
            $this->assertNotEmpty($res);
        }

        $entrada = [
            0 => [
                'history_id' => '205464',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "FALTAN VERIFICACIONES", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "0", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            1 => [
                'history_id' => '205463',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Correccion", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            2 => [
                'history_id' => '205462',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Correccion", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            3 => [
                'history_id' => '205461',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            4 => [
                'history_id' => '205460',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            5 => [
                'history_id' => '205459',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
        ];
        $espera = [
            0 => [
                'history_id' => '205464',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "FALTAN VERIFICACIONES", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "0", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            1 => [
                'history_id' => '205463',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Correccion", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'tipo' => 'Movimiento - Correccion',
                    ],
                    'cambios_items' => '',
                ],
            ],
            2 => [
                'history_id' => '205462',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Correccion", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
            3 => [
                'history_id' => '205461',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'tipo' => 'Correccion - Movimiento',
                        'numero_compra' => '[{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}] - []',
                        'numero_compra_actual' => '3068 - ',
                    ],
                    'cambios_items' => '',
                ],
            ],
            4 => [
                'history_id' => '205460',
                'date' => '2023-07-18 18:47:18',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
        ];
        $result = getArrayDifferences($entrada, false);
        $this->assertEquals(
            $espera, $result, "Test cerreccion getArrayDifferences"
        );

    }

    /**
     * @covers ::listChanges
     */
    public function testListChanges(){
        $entra = [
            0 => [
                'date' => '2023-07-18 19:40:29',
                'action' => 'test_nota_hist',
                'user_nick' => 'tester como Rony',
                'id' => 'cc483a12801aa75111ee210e199212ed',
                'hits_id' => '205554',
                'index' => 0,
                'cambios_items' => '',
                'cambios' => '',
            ],
            1 => [
                'date' => '2023-07-18 19:40:29',
                'action' => 'test_nota_hist',
                'user_nick' => 'tester como Rony',
                'id' => 'cc483a12801aa75111ee210e199212ed',
                'hits_id' => '205552',
                'index' => 1,
                'cambios_items' => '',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
            2 => [
                'date' => '2023-07-18 19:40:29',
                'action' => 'test_nota_hist',
                'user_nick' => 'tester como Rony',
                'id' => 'cc483a12801aa75111ee210e199212ed',
                'hits_id' => '205551',
                'index' => 2,
                'cambios_items' => '',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}] - []',
                        'numero_compra_actual' => '3068 - ',
                    ],
                    'cambios_items' => '',
                ],
            ],
            3 => [
                'date' => '2023-07-18 19:40:29',
                'action' => 'test_nota_hist',
                'user_nick' => 'tester como Rony',
                'id' => 'cc483a12801aa75111ee210e199212ed',
                'hits_id' => '205550',
                'index' => 3,
                'cambios_items' => '',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
        ];
        $espera = [
            'numero_compra' => [
                0 => [
                    'cambio' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                    'index' => 1,
                    'date' => '2023-07-18 19:40:29',
                ],
                1 => [
                    'cambio' => '[{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}] - []',
                    'index' => 2,
                    'date' => '2023-07-18 19:40:29',
                ],
                2 => [
                    'cambio' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                    'index' => 3,
                    'date' => '2023-07-18 19:40:29',
                ],
            ],
            'numero_compra_actual' => [
                0 => [
                    'cambio' => ' - 3068',
                    'index' => 1,
                    'date' => '2023-07-18 19:40:29',
                ],
                1 => [
                    'cambio' => '3068 - ',
                    'index' => 2,
                    'date' => '2023-07-18 19:40:29',
                ],
                2 => [
                    'cambio' => ' - 3068',
                    'index' => 3,
                    'date' => '2023-07-18 19:40:29',
                ],
            ],
        ];
        $result = listChanges($entra);
        $this->assertEquals(
            $espera, $result, "Test correct param listChanges"
        );

        $this->assertEquals(
            [],  listChanges([]), "Test empty param listChanges"
        );

    }

    /**
     * @covers ::formatImpHistory
     */
    public function testformatImpHistory(){
        $entra = [
            0 => [
                'history_id' => '205506',
                'date' => '2023-07-18 19:19:46',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "FALTAN VERIFICACIONES", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "0", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
            ],
            1 => [
                'history_id' => '205504',
                'date' => '2023-07-18 19:19:46',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
            2 => [
                'history_id' => '205503',
                'date' => '2023-07-18 19:19:46',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "0", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:44:53", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "analaura", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": "\r\nFALTO CAPTURAR EL número de compra", "numero_compra_actual": "", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "info", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}] - []',
                        'numero_compra_actual' => '3068 - ',
                    ],
                    'cambios_items' => '',
                ],
            ],
            3 => [
                'history_id' => '205502',
                'date' => '2023-07-18 19:19:46',
                'user_nick' => 'tester como Rony',
                'action' => 'test_nota_hist',
                'record' => '{"lock": "0", "paid": "0", "tipo": "Movimiento", "fecha": "2023-07-12", "grupo": "", "items": [{"lento": "No", "rollos": "1.00", "alta_db": "2023-07-12 17:44:53", "alta_por": "analaura", "color_id": "54bf6469e2cc850b11ec1c9577f53466", "es_saldo": "No", "quantity": "25.80", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "en_remate": "No", "averageMal": "0", "super_lento": "No", "nuevoProducto": "0", "ultimo_cambio": "2023-07-12 17:44:53", "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "rollosNegativo": "0", "quantityNegativo": "0", "ultimo_cambio_por": "analaura", "producto_bodega_id": "f8bc123029a8941811ed8c4b5bf7b502_74867af2fe60b6fd11ec699a9e251758_54bf6469e2cc850b11ec1c9577f53466", "nota_bodega_item_id": "cc483a12801aa75111ee210e1997f743", "producto_color_calidad": "", "producto_color_calidad_comentario": ""}], "label": "", "activo": "1", "estado": "0", "numero": "3460", "pedido": "[]", "alta_db": "2023-07-12 17:44:53", "cliente": "[{\"nombre\": \"OSVALDO DE LA ROSA\", \"alta_db\": \"2023-07-12 17:44:03\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"cliente_id\": \"f8bc123029a8b39a11ed9115e930c442\", \"alta_por_id\": \"132\"}]", "colores": "JASPE CLARO", "lock_el": null, "remarks": "", "alta_por": "analaura", "recibido": "No", "ayudantes": "ALAN ALBERTO HERNANDEZ ROLDAN", "bodega_id": "f8bc123029a8941811ed8c4b5bf7b502", "documento": "nada", "iac_edits": "1", "numero_pi": "", "origen_id": "11ec6cb303b99f07ad6b74867af2fe60", "pagare_id": "", "tipo_nota": "CASH", "autorizado": "No", "cliente_cp": "", "cliente_id": "f8bc123029a8b39a11ed9115e930c442", "fabrica_id": "", "para_quien": "", "pedido_por": "[{\"id\": \"74867af2fe60972811ed28748470c6a3\", \"lbl\": \"WILLEBALDO VARGAS GAYTÁN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:12\", \"display\": \"WILLEBALDO VARGAS GAYTÁN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "reset_lock": "0", "super_lock": "0", "verificada": "No", "es_apartado": "No", "num_colores": "1", "numero_real": "3460", "por_sistema": "0", "recibido_el": null, "system_lock": "0", "total_rolls": "1.00", "recibido_por": null, "remarks_paid": "", "unlock_hasta": null, "autorizado_el": null, "cp_cliente_id": "", "numero_as_num": "3460", "numero_compra": "[{\"index\": 1, \"alta_db\": \"2023-07-12 05:50:33\", \"alta_por\": \"socorro\", \"compra_id\": \"\", \"fue_error\": \"No\", \"alta_por_id\": \"103\", \"numero_compra\": \"3068\"}]", "numero_pagare": "", "own_reference": "", "reset_lock_el": null, "super_lock_el": null, "ultimo_cambio": "2023-07-12 17:50:33", "verificada_el": null, "autorizado_por": null, "ayudantes_json": "[{\"id\": \"11ed2021f8f021caa2c174867af2fe60\", \"lbl\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"index\": \"1\", \"alta_db\": \"2023-07-12 17:44:10\", \"display\": \"ALAN ALBERTO HERNANDEZ ROLDAN\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\"}]", "cliente_actual": "[\"OSVALDO DE LA ROSA\"][\"f8bc123029a8b39a11ed9115e930c442\"]", "entrada_salida": "Salida", "motivo_de_lock": null, "nota_bodega_id": "cc483a12801aa75111ee210e199212ed", "reset_lock_por": "", "system_lock_el": null, "tipo_nota_json": "[{\"lbl\": \"CASH\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"tipo_nota\": \"CASH\", \"alta_por_id\": \"132\"}]", "total_quantity": "25.80", "verificada_por": "", "system_lock_por": "", "forma_etiquetado": "", "numero_solicitud": null, "numero_tipo_nota": "5196", "remarks_internos": null, "remarks_recibido": null, "destino_fuerza_el": null, "destino_fuerza_ok": "No", "numero_contenedor": "", "numero_order_text": "00000000000000000000000000003460", "traslado_forza_ok": "No", "ultimo_cambio_por": "socorro", "ultimo_movimiento": null, "chofer_responsable": "[]", "quantity_tipo_nota": "2193.00", "traslado_fuerza_el": null, "unsuper_lock_hasta": null, "estado_verificacion": "VERIFICADA", "producto_general_id": "74867af2fe60b6fd11ec699a9e251758", "cp_autotransporte_id": "", "existencia_snap_shot": "[]", "inconsistencias_text": null, "numero_compra_actual": "3068", "chofer_responsable_id": "", "contra_nota_bodega_id": "", "empresa_id_etiquetado": "", "inconsistencias_nivel": "", "json_file_attachments": null, "numero_tipo_nota_json": "[{\"lbl\": \"5196\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"numero_tipo_nota\": \"5196\"}]", "cp_figuratransporte_id": "", "responsable_etiquetado": "", "verificaciones_propias": "0", "confirmacion_etiquetado": "No", "modificacion_importante": "No", "quantity_tipo_nota_json": "[{\"lbl\": \"2193.00\", \"index\": 1, \"alta_db\": \"2023-07-12 05:44:53\", \"alta_por\": \"analaura\", \"fue_error\": \"No\", \"alta_por_id\": \"132\", \"quantity_tipo_nota\": \"2193.00\"}]", "motivo_cambio_importante": "", "producto_general_calidad": "", "solicitud_carta_porte_id": null, "existencia_snap_shot_html": null, "modificacion_importante_el": null, "modificacion_importante_por": "", "modificacion_importante_json": "{}", "modificacion_importante_text": null, "verificaciones_otras_bodegas": "1", "autorizacion_ultimo_movimiento": "No", "json_file_attachments_nota_foto": null, "modificacion_importante_cuantas": "0", "autorizacion_ultimo_movimiento_el": null, "autorizacion_ultimo_movimiento_por": null, "modificacion_importante_autorizada": "No", "autorizacion_ultimo_movimiento_rony": "No", "producto_general_calidad_comentario": "", "modificacion_importante_autorizada_el": null, "autorizacion_ultimo_movimiento_cuantos": "0", "autorizacion_ultimo_movimiento_el_rony": null, "modificacion_importante_autorizada_por": "", "autorizacion_ultimo_movimiento_por_rony": null, "modificacion_importante_autorizada_text": null, "modificacion_importante_autorizada_cuantas": "0", "modificacion_importante_autorizada_requeridas": "2"}',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
        ];
        $espera = [
            0 => [
                'date' => '2023-07-18 19:19:46',
                'action' => 'test_nota_hist',
                'user_nick' => 'tester como Rony',
                'id' => 'cc483a12801aa75111ee210e199212ed',
                'hits_id' => '205506',
                'index' => 0,
                'cambios_items' => '',
                'cambios' => '',
            ],
            1 => [
                'date' => '2023-07-18 19:19:46',
                'action' => 'test_nota_hist',
                'user_nick' => 'tester como Rony',
                'id' => 'cc483a12801aa75111ee210e199212ed',
                'hits_id' => '205504',
                'index' => 1,
                'cambios_items' => '',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
            2 => [
                'date' => '2023-07-18 19:19:46',
                'action' => 'test_nota_hist',
                'user_nick' => 'tester como Rony',
                'id' => 'cc483a12801aa75111ee210e199212ed',
                'hits_id' => '205503',
                'index' => 2,
                'cambios_items' => '',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}] - []',
                        'numero_compra_actual' => '3068 - ',
                    ],
                    'cambios_items' => '',
                ],
            ],
            3 => [
                'date' => '2023-07-18 19:19:46',
                'action' => 'test_nota_hist',
                'user_nick' => 'tester como Rony',
                'id' => 'cc483a12801aa75111ee210e199212ed',
                'hits_id' => '205502',
                'index' => 3,
                'cambios_items' => '',
                'cambios' => [
                    'general' => [
                        'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-12 05:50:33", "alta_por": "socorro", "compra_id": "", "fue_error": "No", "alta_por_id": "103", "numero_compra": "3068"}]',
                        'numero_compra_actual' => ' - 3068',
                    ],
                    'cambios_items' => '',
                ],
            ],
        ];
        $result = formatImpHistory($entra);

        $this->assertEquals(
            $espera,
            $result,
            'test valid input formatImpHistory'
        );

        foreach( $result as  $res ){
            $this->assertIsArray($res);
            $this->assertArrayHasKey('cambios', $res);
        }

        $this->assertEquals(
            [],
            formatImpHistory([]),
            'test empty input formatImpHistory'
        );


    }


    /**
     * @covers ::getRecord
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers assoc_mysql2mysqli
     * @covers ia_sqlArrayIndx
     * @covers sqlMysqli::log_trace
     * @covers strit
     * @covers ia_singleton
     * @covers Iac\inc\sql\IacMysqli::singleton
     */
    public function testGetRecord()
    {
        $item = [
            'date' => '2023-07-06 16:11:54',
            'action' => 'insert',
            'user_nick' => 'marcos',
            'id' => 'cc483a12801aa81111ee1c4a1d6bc69a',
            'hits_id' => '201460',
            'index' => 0,
            'cambios_items' => '',
            'cambios' => '',
        ];
        $_item = getRecord( $item );
        $this->assertIsArray($_item);

        $result = getRecord([]);
        $this->assertEquals(
            [],
            $result
        );
    }

    /**
     * @covers ::getNotaDiff
     *
     */
    public function testGetNotaDiff()
    {

        $espera = [
            'tipo' => 'Traslado - Movimiento',
            'fecha' => '2023-07-08 - 2023-07-09',
            'entrada_salida' => 'Salida - Entrada',
            'numero' => '2082 - 20821',
            'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11 - 54bf6469e2cc850b11ec1caa42beef111',
            'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3 - 11ec6cb303b9c80dad6b74867af2fe60',
        ];
        $nota_old = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Traslado',
            'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 14:07:02',
                    'alta_por' => 'sistema',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.20',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 14:07:02',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1dcb00e72479',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => '',
        'activo' => '1',
			'estado' => '0',
			'numero' => '2082',
			'pedido' => '[]',
			'alta_db' => '2023-07-08 11:23:56',
			'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
			'colores' => 'NARANJA NEON',
			'lock_el' => NULL,
			'remarks' => '',
			'alta_por' => 'marcos',
			'recibido' => 'No',
			'ayudantes' => 'SIN AYUDANTES',
			'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
			'documento' => 'nada',
			'iac_edits' => '1',
			'numero_pi' => '',
			'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
			'pagare_id' => '',
			'tipo_nota' => '',
			'autorizado' => 'No',
			'cliente_cp' => '',
			'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
			'fabrica_id' => '',
			'para_quien' => '',
			'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'reset_lock' => '0',
			'super_lock' => '0',
			'verificada' => 'No',
			'es_apartado' => 'No',
			'num_colores' => '1',
			'numero_real' => '2082',
			'por_sistema' => '0',
			'recibido_el' => NULL,
			'system_lock' => '0',
			'total_rolls' => '2.00',
			'recibido_por' => NULL,
			'remarks_paid' => '',
			'unlock_hasta' => NULL,
			'autorizado_el' => NULL,
			'cp_cliente_id' => '',
			'numero_as_num' => '2082',
			'numero_compra' => '[{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
			'numero_pagare' => '',
			'own_reference' => '',
			'reset_lock_el' => NULL,
			'super_lock_el' => NULL,
			'ultimo_cambio' => '2023-07-08 14:07:02',
			'verificada_el' => NULL,
			'autorizado_por' => NULL,
			'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
			'entrada_salida' => 'Salida',
			'motivo_de_lock' => NULL,
			'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
			'reset_lock_por' => '',
			'system_lock_el' => NULL,
			'tipo_nota_json' => '[]',
			'total_quantity' => '50.20',
			'verificada_por' => '',
			'system_lock_por' => '',
			'forma_etiquetado' => '',
			'numero_solicitud' => NULL,
			'numero_tipo_nota' => '',
			'remarks_internos' => NULL,
			'remarks_recibido' => NULL,
			'destino_fuerza_el' => NULL,
			'destino_fuerza_ok' => 'No',
			'numero_contenedor' => '',
			'numero_order_text' => '00000000000000000000000000002082',
			'traslado_forza_ok' => 'No',
			'ultimo_cambio_por' => 'marcos',
			'ultimo_movimiento' => NULL,
			'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
			'quantity_tipo_nota' => '0.00',
			'traslado_fuerza_el' => NULL,
			'unsuper_lock_hasta' => NULL,
			'estado_verificacion' => 'VERIFICADA',
			'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
			'cp_autotransporte_id' => '',
			'existencia_snap_shot' => '[]',
			'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
			'numero_compra_actual' => '',
			'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
			'contra_nota_bodega_id' => '',
			'empresa_id_etiquetado' => '',
			'inconsistencias_nivel' => 'danger',
			'json_file_attachments' => NULL,
			'numero_tipo_nota_json' => '[]',
			'cp_figuratransporte_id' => '',
			'responsable_etiquetado' => '',
			'verificaciones_propias' => '0',
			'confirmacion_etiquetado' => 'No',
			'modificacion_importante' => 'Si',
			'quantity_tipo_nota_json' => '[]',
			'motivo_cambio_importante' => '',
			'producto_general_calidad' => '',
			'solicitud_carta_porte_id' => NULL,
			'existencia_snap_shot_html' => NULL,
			'modificacion_importante_el' => '2023-07-08 14:07:02',
			'modificacion_importante_por' => 'marcos',
			'modificacion_importante_json' => '{"items": "El quantity del color NARANJA NEON cambió de 50.70 a 50.20", "total_quantity": "El quantity total cambió de 50.70 a 50.20"}',
			'modificacion_importante_text' => '
El quantity total cambió de 50.70 a 50.20
El quantity del color NARANJA NEON cambió de 50.70 a 50.20',
			'verificaciones_otras_bodegas' => '2',
			'autorizacion_ultimo_movimiento' => 'No',
			'json_file_attachments_nota_foto' => NULL,
			'modificacion_importante_cuantas' => '1',
			'autorizacion_ultimo_movimiento_el' => NULL,
			'autorizacion_ultimo_movimiento_por' => NULL,
			'modificacion_importante_autorizada' => 'No',
			'autorizacion_ultimo_movimiento_rony' => 'No',
			'producto_general_calidad_comentario' => '',
			'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
			'autorizacion_ultimo_movimiento_cuantos' => '0',
			'autorizacion_ultimo_movimiento_el_rony' => NULL,
			'modificacion_importante_autorizada_por' => '',
			'autorizacion_ultimo_movimiento_por_rony' => NULL,
			'modificacion_importante_autorizada_text' => '',
			'modificacion_importante_autorizada_cuantas' => '0',
			'modificacion_importante_autorizada_requeridas' => '2',
		];
		$nota_nueva = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Movimiento',
            'fecha' => '2023-07-09',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-10 16:38:38',
                    'alta_por' => 'sistema',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.20',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-10 16:38:38',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'rony',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => '54bf6469e2ccbf5c11ee1f6a21ab36bd',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => '',
			'activo' => '1',
			'estado' => '0',
			'numero' => '20821',
			'pedido' => '[]',
			'alta_db' => '2023-07-08 11:23:56',
			'cliente' => '[]',
			'colores' => 'NARANJA NEON',
			'lock_el' => NULL,
			'remarks' => '',
			'alta_por' => 'marcos',
			'recibido' => 'No',
			'ayudantes' => 'SIN AYUDANTES',
			'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
			'documento' => 'nada',
			'iac_edits' => '3',
			'numero_pi' => '',
			'origen_id' => '11ec6cb303b9c80dad6b74867af2fe60',
			'pagare_id' => '',
			'tipo_nota' => '',
			'autorizado' => 'No',
			'cliente_cp' => '',
			'cliente_id' => '',
			'fabrica_id' => '',
			'para_quien' => '',
			'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'reset_lock' => '0',
			'super_lock' => '0',
			'verificada' => 'No',
			'es_apartado' => 'No',
			'num_colores' => '1',
			'numero_real' => '2082',
			'por_sistema' => '0',
			'recibido_el' => NULL,
			'system_lock' => '0',
			'total_rolls' => '2.00',
			'recibido_por' => NULL,
			'remarks_paid' => '',
			'unlock_hasta' => NULL,
			'autorizado_el' => NULL,
			'cp_cliente_id' => '',
			'numero_as_num' => '2082',
			'numero_compra' => '[{"index": "2", "alta_db": "2023-07-08 14:21:38", "alta_por": "analaura", "compra_id": "cc483a12801ab3f611ee1db437adae4d", "fue_error": "No", "alta_por_id": "132", "numero_compra": "3373"}, {"index": "1", "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "alta_por_id": "118", "numero_compra": ""}]',
			'numero_pagare' => '',
			'own_reference' => '',
			'reset_lock_el' => NULL,
			'super_lock_el' => NULL,
			'ultimo_cambio' => '2023-07-10 16:38:38',
			'verificada_el' => NULL,
			'autorizado_por' => NULL,
			'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'cliente_actual' => NULL,
			'entrada_salida' => 'Entrada',
			'motivo_de_lock' => NULL,
			'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
			'reset_lock_por' => '',
			'system_lock_el' => NULL,
			'tipo_nota_json' => '[]',
			'total_quantity' => '50.20',
			'verificada_por' => '',
			'system_lock_por' => '',
			'forma_etiquetado' => '',
			'numero_solicitud' => NULL,
			'numero_tipo_nota' => '',
			'remarks_internos' => NULL,
			'remarks_recibido' => NULL,
			'destino_fuerza_el' => NULL,
			'destino_fuerza_ok' => 'No',
			'numero_contenedor' => '',
			'numero_order_text' => '00000000000000000000000000002082',
			'traslado_forza_ok' => 'No',
			'ultimo_cambio_por' => 'rony',
			'ultimo_movimiento' => NULL,
			'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
			'quantity_tipo_nota' => '0.00',
			'traslado_fuerza_el' => NULL,
			'unsuper_lock_hasta' => NULL,
			'estado_verificacion' => 'NO VERIFICADA',
			'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef111',
			'cp_autotransporte_id' => '',
			'existencia_snap_shot' => '[]',
			'inconsistencias_text' => "
NO PIDEN DE LV: ANA LAURA GONZALEZ
Cliente NO CAPTURADO
El TIPO DE VENTA esta vacío
El NÚMERO de TIPO DE VENTA esta vacío
El QUANTITY de TIPO DE VENTA esta vacío",
			'numero_compra_actual' => '',
			'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
			'contra_nota_bodega_id' => '3373',
			'empresa_id_etiquetado' => '',
			'inconsistencias_nivel' => 'warning',
			'json_file_attachments' => NULL,
			'numero_tipo_nota_json' => '[]',
			'cp_figuratransporte_id' => '',
			'responsable_etiquetado' => '',
			'verificaciones_propias' => '0',
			'confirmacion_etiquetado' => 'No',
			'modificacion_importante' => 'Si',
			'quantity_tipo_nota_json' => '[]',
			'motivo_cambio_importante' => '',
			'producto_general_calidad' => '',
			'solicitud_carta_porte_id' => NULL,
			'existencia_snap_shot_html' => NULL,
			'modificacion_importante_el' => '2023-07-10 16:38:38',
			'modificacion_importante_por' => 'rony',
			'modificacion_importante_json' => '{"origen_id": "El origen/destino cambió de TEXCOCO a LV"}',
			'modificacion_importante_text' => '
El origen/destino cambió de TEXCOCO a LV',
			'verificaciones_otras_bodegas' => '2',
			'autorizacion_ultimo_movimiento' => 'No',
			'json_file_attachments_nota_foto' => NULL,
			'modificacion_importante_cuantas' => '2',
			'autorizacion_ultimo_movimiento_el' => NULL,
			'autorizacion_ultimo_movimiento_por' => NULL,
			'modificacion_importante_autorizada' => 'No',
			'autorizacion_ultimo_movimiento_rony' => 'No',
			'producto_general_calidad_comentario' => '',
			'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
			'autorizacion_ultimo_movimiento_cuantos' => '0',
			'autorizacion_ultimo_movimiento_el_rony' => NULL,
			'modificacion_importante_autorizada_por' => '',
			'autorizacion_ultimo_movimiento_por_rony' => NULL,
			'modificacion_importante_autorizada_text' => '',
			'modificacion_importante_autorizada_cuantas' => '0',
			'modificacion_importante_autorizada_requeridas' => '2',
		];

        $response = getNotaDiff($nota_old, $nota_nueva);

        $this->assertEquals(
            $espera,
            $response,
            "campos importantes getNotaDiff"
        );

        $nota_old_test = [];
        $response = getNotaDiff($nota_old_test, $nota_nueva);
        $this->assertEquals(
            [],
            $response,
            "Array vacio de entrada Ok"
        );

        $nota_nueva_test = [];
        $response = getNotaDiff($nota_old, $nota_nueva_test);
        $this->assertEquals(
            [],
            $response,
            "Array vacio de entrada Ok"
        );
    }

    /**
     * @covers ::getAllNotaDiff
     * @covers strim
     */
    public function testGetAllNotaDiff()
    {

        $nota_old = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Traslado',
            'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 11:23:56',
                    'alta_por' => 'marcos',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.70',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 11:23:56',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1db437b46352',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
        'activo' => '1',
			'estado' => '0',
			'numero' => '2082',
			'pedido' => '[]',
			'alta_db' => '2023-07-08 11:23:56',
			'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
			'colores' => 'NARANJA NEON',
			'lock_el' => NULL,
			'remarks' => '',
			'alta_por' => 'marcos',
			'recibido' => 'No',
			'ayudantes' => 'SIN AYUDANTES',
			'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
			'documento' => 'nada',
			'iac_edits' => '0',
			'numero_pi' => '',
			'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
			'pagare_id' => '',
			'tipo_nota' => '',
			'autorizado' => 'No',
			'cliente_cp' => '',
			'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
			'fabrica_id' => '',
			'para_quien' => '',
			'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'reset_lock' => '0',
			'super_lock' => '0',
			'verificada' => 'No',
			'es_apartado' => 'No',
			'num_colores' => '1',
			'numero_real' => '2082',
			'por_sistema' => '0',
			'recibido_el' => NULL,
			'system_lock' => '0',
			'total_rolls' => '2.00',
			'recibido_por' => NULL,
			'remarks_paid' => '',
			'unlock_hasta' => NULL,
			'autorizado_el' => NULL,
			'cp_cliente_id' => '',
			'numero_as_num' => '2082',
			'numero_compra' => '[]',
			'numero_pagare' => '',
			'own_reference' => '',
			'reset_lock_el' => NULL,
			'super_lock_el' => NULL,
			'ultimo_cambio' => '2023-07-08 11:23:56',
			'verificada_el' => NULL,
			'autorizado_por' => NULL,
			'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
			'entrada_salida' => 'Salida',
			'motivo_de_lock' => NULL,
			'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
			'reset_lock_por' => '',
			'system_lock_el' => NULL,
			'tipo_nota_json' => '[]',
			'total_quantity' => '50.70',
			'verificada_por' => '',
			'system_lock_por' => '',
			'forma_etiquetado' => '',
			'numero_solicitud' => NULL,
			'numero_tipo_nota' => '',
			'remarks_internos' => NULL,
			'remarks_recibido' => NULL,
			'destino_fuerza_el' => NULL,
			'destino_fuerza_ok' => 'No',
			'numero_contenedor' => '',
			'numero_order_text' => '00000000000000000000000000002082',
			'traslado_forza_ok' => 'No',
			'ultimo_cambio_por' => 'marcos',
			'ultimo_movimiento' => NULL,
			'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
			'quantity_tipo_nota' => '0.00',
			'traslado_fuerza_el' => NULL,
			'unsuper_lock_hasta' => NULL,
			'estado_verificacion' => 'VERIFICADA',
			'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
			'cp_autotransporte_id' => '',
			'existencia_snap_shot' => '[]',
			'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
			'numero_compra_actual' => '',
			'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
			'contra_nota_bodega_id' => '',
			'empresa_id_etiquetado' => '',
			'inconsistencias_nivel' => 'danger',
			'json_file_attachments' => NULL,
			'numero_tipo_nota_json' => '[]',
			'cp_figuratransporte_id' => '',
			'responsable_etiquetado' => '',
			'verificaciones_propias' => '0',
			'confirmacion_etiquetado' => 'No',
			'modificacion_importante' => 'No',
			'quantity_tipo_nota_json' => '[]',
			'motivo_cambio_importante' => '',
			'producto_general_calidad' => '',
			'solicitud_carta_porte_id' => NULL,
			'existencia_snap_shot_html' => NULL,
			'modificacion_importante_el' => NULL,
			'modificacion_importante_por' => '',
			'modificacion_importante_json' => json_encode(strim(<<< JSON
[]
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
			'modificacion_importante_text' => NULL,
			'verificaciones_otras_bodegas' => '2',
			'autorizacion_ultimo_movimiento' => 'No',
			'json_file_attachments_nota_foto' => NULL,
			'modificacion_importante_cuantas' => '0',
			'autorizacion_ultimo_movimiento_el' => NULL,
			'autorizacion_ultimo_movimiento_por' => NULL,
			'modificacion_importante_autorizada' => 'No',
			'autorizacion_ultimo_movimiento_rony' => 'No',
			'producto_general_calidad_comentario' => '',
			'modificacion_importante_autorizada_el' => NULL,
			'autorizacion_ultimo_movimiento_cuantos' => '0',
			'autorizacion_ultimo_movimiento_el_rony' => NULL,
			'modificacion_importante_autorizada_por' => '',
			'autorizacion_ultimo_movimiento_por_rony' => NULL,
			'modificacion_importante_autorizada_text' => NULL,
			'modificacion_importante_autorizada_cuantas' => '0',
			'modificacion_importante_autorizada_requeridas' => '2',
		];
		$nota_nueva = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Traslado',
            'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 14:07:02',
                    'alta_por' => 'sistema',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.20',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 14:07:02',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1dcb00e72479',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
			'activo' => '1',
			'estado' => '0',
			'numero' => '2082',
			'pedido' => '[]',
			'alta_db' => '2023-07-08 11:23:56',
			'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
			'colores' => 'NARANJA NEON',
			'lock_el' => NULL,
			'remarks' => '',
			'alta_por' => 'marcos',
			'recibido' => 'No',
			'ayudantes' => 'SIN AYUDANTES',
			'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
			'documento' => 'nada',
			'iac_edits' => '1',
			'numero_pi' => '',
			'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
			'pagare_id' => '',
			'tipo_nota' => '',
			'autorizado' => 'No',
			'cliente_cp' => '',
			'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
			'fabrica_id' => '',
			'para_quien' => '',
			'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'reset_lock' => '0',
			'super_lock' => '0',
			'verificada' => 'No',
			'es_apartado' => 'No',
			'num_colores' => '1',
			'numero_real' => '2082',
			'por_sistema' => '0',
			'recibido_el' => NULL,
			'system_lock' => '0',
			'total_rolls' => '2.00',
			'recibido_por' => NULL,
			'remarks_paid' => '',
			'unlock_hasta' => NULL,
			'autorizado_el' => NULL,
			'cp_cliente_id' => '',
			'numero_as_num' => '2082',
			'numero_compra' => '[{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
			'numero_pagare' => '',
			'own_reference' => '',
			'reset_lock_el' => NULL,
			'super_lock_el' => NULL,
			'ultimo_cambio' => '2023-07-08 14:07:02',
			'verificada_el' => NULL,
			'autorizado_por' => NULL,
			'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
			'entrada_salida' => 'Salida',
			'motivo_de_lock' => NULL,
			'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
			'reset_lock_por' => '',
			'system_lock_el' => NULL,
			'tipo_nota_json' => '[]',
			'total_quantity' => '50.20',
			'verificada_por' => '',
			'system_lock_por' => '',
			'forma_etiquetado' => '',
			'numero_solicitud' => NULL,
			'numero_tipo_nota' => '',
			'remarks_internos' => NULL,
			'remarks_recibido' => NULL,
			'destino_fuerza_el' => NULL,
			'destino_fuerza_ok' => 'No',
			'numero_contenedor' => '',
			'numero_order_text' => '00000000000000000000000000002082',
			'traslado_forza_ok' => 'No',
			'ultimo_cambio_por' => 'marcos',
			'ultimo_movimiento' => NULL,
			'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
			'quantity_tipo_nota' => '0.00',
			'traslado_fuerza_el' => NULL,
			'unsuper_lock_hasta' => NULL,
			'estado_verificacion' => 'NO VERIFICADA',
			'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
			'cp_autotransporte_id' => '',
			'existencia_snap_shot' => '[]',
			'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
			'numero_compra_actual' => '',
			'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
			'contra_nota_bodega_id' => '',
			'empresa_id_etiquetado' => '',
			'inconsistencias_nivel' => 'danger',
			'json_file_attachments' => NULL,
			'numero_tipo_nota_json' => '[]',
			'cp_figuratransporte_id' => '',
			'responsable_etiquetado' => '',
			'verificaciones_propias' => '0',
			'confirmacion_etiquetado' => 'No',
			'modificacion_importante' => 'Si',
			'quantity_tipo_nota_json' => '[]',
			'motivo_cambio_importante' => '',
			'producto_general_calidad' => '',
			'solicitud_carta_porte_id' => NULL,
			'existencia_snap_shot_html' => NULL,
			'modificacion_importante_el' => '2023-07-08 14:07:02',
			'modificacion_importante_por' => 'marcos',
			'modificacion_importante_json' => json_encode(strim(<<< JSON
{
    "items": "El quantity del color NARANJA NEON cambió de 50.70 a 50.20",
    "total_quantity": "El quantity total cambió de 50.70 a 50.20"
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
			'modificacion_importante_text' => '
El quantity total cambió de 50.70 a 50.20
El quantity del color NARANJA NEON cambió de 50.70 a 50.20',
			'verificaciones_otras_bodegas' => '2',
			'autorizacion_ultimo_movimiento' => 'No',
			'json_file_attachments_nota_foto' => NULL,
			'modificacion_importante_cuantas' => '1',
			'autorizacion_ultimo_movimiento_el' => NULL,
			'autorizacion_ultimo_movimiento_por' => NULL,
			'modificacion_importante_autorizada' => 'No',
			'autorizacion_ultimo_movimiento_rony' => 'No',
			'producto_general_calidad_comentario' => '',
			'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
			'autorizacion_ultimo_movimiento_cuantos' => '0',
			'autorizacion_ultimo_movimiento_el_rony' => NULL,
			'modificacion_importante_autorizada_por' => '',
			'autorizacion_ultimo_movimiento_por_rony' => NULL,
			'modificacion_importante_autorizada_text' => '',
			'modificacion_importante_autorizada_cuantas' => '0',
			'modificacion_importante_autorizada_requeridas' => '2',
		];
        $sale = [
            'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
            'total_quantity' => '50.70 - 50.20',
        ];
        $response = getAllNotaDiff($nota_old, $nota_nueva);

        $this->assertEquals(
            $sale,
            $response,
            "Compárar toda la nota testGetAllNotaDiff"
        );

        $nota_old = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Movimiento',
            'fecha' => '2023-07-17',
            'grupo' => '',
            'items' => [
                '54bf6469e2cc850b11ec1c8f6689f51d' => [
                    'lento' => 'No',
                    'rollos' => '1.00',
                    'alta_db' => '2023-07-19 15:13:24',
                    'alta_por' => 'sistema',
                    'color_id' => '54bf6469e2cc850b11ec1c8f6689f51d',
                    'es_saldo' => 'No',
                    'quantity' => '29.80',
                    'bodega_id' => '74867af2fe60845411ecaa03953dd312',
                    'en_remate' => 'No',
                    'averageMal' => '1',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-19 15:13:24',
                    'nota_bodega_id' => 'cc483a12801ab56811ee250009d8a5ba',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'rony',
                    'producto_bodega_id' => '74867af2fe60845411ecaa03953dd312_74867af2fe60b6fd11ec69a229836f0d_54bf6469e2cc850b11ec1c8f6689f51d',
                    'nota_bodega_item_id' => '54bf6469e2ccbf5c11ee2670b6c1d627',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => '',
        'activo' => '1',
			'estado' => '0',
			'numero' => '30891',
			'pedido' => '[]',
			'alta_db' => '2023-07-17 18:14:19',
			'cliente' => '[{"nombre": "PIÑA", "alta_db": "2023-07-17 18:18:24", "alta_por": "rosa", "fue_error": "No", "cliente_id": "11ecab0a89afaa8b81a354bf6469e2cc", "alta_por_id": "134"}]',
			'colores' => 'BOTELLA',
			'lock_el' => NULL,
			'remarks' => '',
			'alta_por' => 'rosa',
			'recibido' => 'No',
			'ayudantes' => 'URIEL GARCIA MARTINEZ',
			'bodega_id' => '74867af2fe60845411ecaa03953dd312',
			'documento' => 'nada',
			'iac_edits' => '2',
			'numero_pi' => '',
			'origen_id' => '11ec6cb303b9c80dad6b74867af2fe60',
			'pagare_id' => '',
			'tipo_nota' => 'PIÑA',
			'autorizado' => 'No',
			'cliente_cp' => '',
			'cliente_id' => '11ecab0a89afaa8b81a354bf6469e2cc',
			'fabrica_id' => '',
			'para_quien' => '',
			'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d27bb3430a", "lbl": "DULCE VAZQUEZ VARGAS", "index": "1", "alta_db": "2023-07-17 18:18:33", "display": "DULCE VAZQUEZ VARGAS", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134"}]',
			'reset_lock' => '0',
			'super_lock' => '0',
			'verificada' => 'No',
			'es_apartado' => 'No',
			'num_colores' => '1',
			'numero_real' => '30891',
			'por_sistema' => '0',
			'recibido_el' => NULL,
			'system_lock' => '0',
			'total_rolls' => '1.00',
			'recibido_por' => NULL,
			'remarks_paid' => '',
			'unlock_hasta' => NULL,
			'autorizado_el' => NULL,
			'cp_cliente_id' => '',
			'numero_as_num' => '30891',
			'numero_compra' => '[]',
			'numero_pagare' => '',
			'own_reference' => '',
			'reset_lock_el' => NULL,
			'super_lock_el' => NULL,
			'ultimo_cambio' => '2023-07-19 15:13:24',
			'verificada_el' => NULL,
			'autorizado_por' => NULL,
			'ayudantes_json' => '[{"id": "11ed2021f8922a3ca2c174867af2fe60", "lbl": "URIEL GARCIA MARTINEZ", "index": "1", "alta_db": "2023-07-17 18:18:30", "display": "URIEL GARCIA MARTINEZ", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134"}]',
			'cliente_actual' => '["PIÑA"]["11ecab0a89afaa8b81a354bf6469e2cc"]',
			'entrada_salida' => 'Salida',
			'motivo_de_lock' => NULL,
			'nota_bodega_id' => 'cc483a12801ab56811ee250009d8a5ba',
			'reset_lock_por' => '',
			'system_lock_el' => NULL,
			'tipo_nota_json' => '[{"lbl": "PIÑA", "index": 1, "alta_db": "2023-07-17 06:14:19", "alta_por": "rosa", "fue_error": "No", "tipo_nota": "PIÑA", "alta_por_id": "134"}]',
			'total_quantity' => '29.80',
			'verificada_por' => '',
			'system_lock_por' => '',
			'forma_etiquetado' => '',
			'numero_solicitud' => NULL,
			'numero_tipo_nota' => '',
			'remarks_internos' => NULL,
			'remarks_recibido' => NULL,
			'destino_fuerza_el' => NULL,
			'destino_fuerza_ok' => 'No',
			'numero_contenedor' => '',
			'numero_order_text' => '00000000000000000000000000030891',
			'traslado_forza_ok' => 'No',
			'ultimo_cambio_por' => 'rony',
			'ultimo_movimiento' => NULL,
			'chofer_responsable' => '[]',
			'quantity_tipo_nota' => '0.00',
			'traslado_fuerza_el' => NULL,
			'unsuper_lock_hasta' => NULL,
			'estado_verificacion' => 'FALTAN VERIFICACIONES',
			'producto_general_id' => '74867af2fe60b6fd11ec69a229836f0d',
			'cp_autotransporte_id' => '',
			'existencia_snap_shot' => '[]',
			'inconsistencias_text' => "
Los ayudantes: URIEL GARCIA MARTINEZ no pertenecen al destino  LV
NO PIDEN DE LV: DULCE VAZQUEZ VARGAS
FALTO CAPTURAR EL número de compra
Revisa el average de BOTELLA",
			'numero_compra_actual' => '',
			'chofer_responsable_id' => '',
			'contra_nota_bodega_id' => '',
			'empresa_id_etiquetado' => '',
			'inconsistencias_nivel' => 'warning',
			'json_file_attachments' => NULL,
			'numero_tipo_nota_json' => '[]',
			'cp_figuratransporte_id' => '',
			'responsable_etiquetado' => '',
			'verificaciones_propias' => '0',
			'confirmacion_etiquetado' => 'No',
			'modificacion_importante' => 'Si',
			'quantity_tipo_nota_json' => '[]',
			'motivo_cambio_importante' => '',
			'producto_general_calidad' => '',
			'solicitud_carta_porte_id' => NULL,
			'existencia_snap_shot_html' => NULL,
			'modificacion_importante_el' => '2023-07-19 15:13:24',
			'modificacion_importante_por' => 'rony',
			'modificacion_importante_json' => '{"origen_id": "El origen/destino cambió de ALAIN a LV"}',
			'modificacion_importante_text' => '
El origen/destino cambió de ALAIN a LV',
			'verificaciones_otras_bodegas' => '0',
			'autorizacion_ultimo_movimiento' => 'No',
			'json_file_attachments_nota_foto' => NULL,
			'modificacion_importante_cuantas' => '1',
			'autorizacion_ultimo_movimiento_el' => NULL,
			'autorizacion_ultimo_movimiento_por' => NULL,
			'modificacion_importante_autorizada' => 'No',
			'autorizacion_ultimo_movimiento_rony' => 'No',
			'producto_general_calidad_comentario' => '',
			'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
			'autorizacion_ultimo_movimiento_cuantos' => '0',
			'autorizacion_ultimo_movimiento_el_rony' => NULL,
			'modificacion_importante_autorizada_por' => '',
			'autorizacion_ultimo_movimiento_por_rony' => NULL,
			'modificacion_importante_autorizada_text' => '',
			'modificacion_importante_autorizada_cuantas' => '0',
			'modificacion_importante_autorizada_requeridas' => '2',
		];
		$nota_nueva = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Movimiento',
            'fecha' => '2023-07-17',
            'grupo' => '',
            'items' => [
                '54bf6469e2cc850b11ec1c8f6689f51d' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-19 18:09:15',
                    'alta_por' => 'sistema',
                    'color_id' => '54bf6469e2cc850b11ec1c8f6689f51d',
                    'es_saldo' => 'No',
                    'quantity' => '59.00',
                    'bodega_id' => '74867af2fe60845411ecaa03953dd312',
                    'en_remate' => 'No',
                    'averageMal' => '1',
                    'super_lento' => 'No',
                    'nuevoProducto' => '1',
                    'ultimo_cambio' => '2023-07-19 18:09:15',
                    'nota_bodega_id' => 'cc483a12801ab56811ee250009d8a5ba',
                    'rollosNegativo' => '1',
                    'quantityNegativo' => '1',
                    'ultimo_cambio_por' => 'rony',
                    'producto_bodega_id' => '74867af2fe60845411ecaa03953dd312_74867af2fe609cc211ed72a878063a59_54bf6469e2cc850b11ec1c8f6689f51d',
                    'nota_bodega_item_id' => '54bf6469e2ccbf5c11ee268945f05cf9',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' =>'',
			'activo' => '1',
			'estado' => '0',
			'numero' => '30891',
			'pedido' => '[]',
			'alta_db' => '2023-07-17 18:14:19',
			'cliente' => '[{"nombre": "A&D EFECTO PUBLICITARIO", "alta_db": "2023-07-19 17:09:03", "alta_por": "rony", "fue_error": "No", "cliente_id": "f8bc123029a8bad511edc29a492f642f", "alta_por_id": "1"}]',
			'colores' => 'BOTELLA',
			'lock_el' => NULL,
			'remarks' => '',
			'alta_por' => 'rosa',
			'recibido' => 'No',
			'ayudantes' => 'ADRIAN ALEJANDRO MARCIAL ABLANEDO',
			'bodega_id' => '74867af2fe60845411ecaa03953dd312',
			'documento' => 'nada',
			'iac_edits' => '4',
			'numero_pi' => '',
			'origen_id' => '11ec6cb303b9e7fdad6b74867af2fe60',
			'pagare_id' => '',
			'tipo_nota' => 'CASH',
			'autorizado' => 'No',
			'cliente_cp' => '',
			'cliente_id' => 'f8bc123029a8bad511edc29a492f642f',
			'fabrica_id' => '',
			'para_quien' => '',
			'pedido_por' => '[{"id": "74867af2fe60b1b311ed5703d24a89c4", "lbl": "FAUSTO PABLO FLORES GARCÍA", "index": "1", "alta_db": "2023-07-19 17:09:10", "display": "FAUSTO PABLO FLORES GARCÍA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
			'reset_lock' => '0',
			'super_lock' => '0',
			'verificada' => 'No',
			'es_apartado' => 'No',
			'num_colores' => '1',
			'numero_real' => '30891',
			'por_sistema' => '0',
			'recibido_el' => NULL,
			'system_lock' => '0',
			'total_rolls' => '2.00',
			'recibido_por' => NULL,
			'remarks_paid' => '',
			'unlock_hasta' => NULL,
			'autorizado_el' => NULL,
			'cp_cliente_id' => '',
			'numero_as_num' => '30891',
			'numero_compra' => '[{"index": "1", "alta_db": "2023-07-19 17:08:57", "alta_por": "rony", "compra_id": "", "fue_error": "No", "alta_por_id": "1", "numero_compra": "1"}]',
			'numero_pagare' => '',
			'own_reference' => '',
			'reset_lock_el' => NULL,
			'super_lock_el' => NULL,
			'ultimo_cambio' => '2023-07-19 18:09:15',
			'verificada_el' => NULL,
			'autorizado_por' => NULL,
			'ayudantes_json' => '[{"id": "11ed2021f904b067a2c174867af2fe60", "lbl": "ADRIAN ALEJANDRO MARCIAL ABLANEDO", "index": "1", "alta_db": "2023-07-19 17:09:07", "display": "ADRIAN ALEJANDRO MARCIAL ABLANEDO", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
			'cliente_actual' => '["A&D EFECTO PUBLICITARIO"]["f8bc123029a8bad511edc29a492f642f"]',
			'entrada_salida' => 'Salida',
			'motivo_de_lock' => NULL,
			'nota_bodega_id' => 'cc483a12801ab56811ee250009d8a5ba',
			'reset_lock_por' => '',
			'system_lock_el' => NULL,
			'tipo_nota_json' => '[{"lbl": "PIÑA", "index": 1, "alta_db": "2023-07-17 06:14:19", "alta_por": "rosa", "fue_error": "Si", "tipo_nota": "PIÑA", "alta_por_id": "134"}, {"lbl": "CASH", "index": 2, "alta_db": "2023-07-19 06:09:12", "alta_por": "rony", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": "1"}]',
			'total_quantity' => '59.00',
			'verificada_por' => '',
			'system_lock_por' => '',
			'forma_etiquetado' => '',
			'numero_solicitud' => NULL,
			'numero_tipo_nota' => '1',
			'remarks_internos' => NULL,
			'remarks_recibido' => NULL,
			'destino_fuerza_el' => NULL,
			'destino_fuerza_ok' => 'No',
			'numero_contenedor' => '',
			'numero_order_text' => '00000000000000000000000000030891',
			'traslado_forza_ok' => 'No',
			'ultimo_cambio_por' => 'rony',
			'ultimo_movimiento' => NULL,
			'chofer_responsable' => '[{"nombre": "JOSE DE JESUS FLORES MORA", "alta_db": "2023-07-19 17:08:58", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "11ec6cb30b3e43a5ad6b74867af2fe60"}]',
			'quantity_tipo_nota' => '10.00',
			'traslado_fuerza_el' => NULL,
			'unsuper_lock_hasta' => NULL,
			'estado_verificacion' => 'FALTAN VERIFICACIONES',
			'producto_general_id' => '74867af2fe609cc211ed72a878063a59',
			'cp_autotransporte_id' => '',
			'existencia_snap_shot' => '[]',
			'inconsistencias_text' => "
Los ayudantes: ADRIAN ALEJANDRO MARCIAL ABLANEDO no pertenecen al destino  UG
NO PIDEN DE UG: FAUSTO PABLO FLORES GARCÍA
A&D EFECTO PUBLICITARIO  NO LO CONFIRMASTE COMO CLIENTE DE UG es cliente de: GT
Revisa el average de BOTELLA
Negativo, No Habia Suficiente Existencia de: BOTELLA",
			'numero_compra_actual' => '1',
			'chofer_responsable_id' => '11ec6cb30b3e43a5ad6b74867af2fe60',
			'contra_nota_bodega_id' => '',
			'empresa_id_etiquetado' => '',
			'inconsistencias_nivel' => 'warning',
			'json_file_attachments' => NULL,
			'numero_tipo_nota_json' => '[{"lbl": "1", "index": 1, "alta_db": "2023-07-19 06:09:12", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "numero_tipo_nota": "1"}]',
			'cp_figuratransporte_id' => '',
			'responsable_etiquetado' => '',
			'verificaciones_propias' => '0',
			'confirmacion_etiquetado' => 'No',
			'modificacion_importante' => 'Si',
			'quantity_tipo_nota_json' => '[{"lbl": "10.00", "index": 1, "alta_db": "2023-07-19 06:09:12", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "quantity_tipo_nota": "10.00"}]',
			'motivo_cambio_importante' => '',
			'producto_general_calidad' => '',
			'solicitud_carta_porte_id' => NULL,
			'existencia_snap_shot_html' => NULL,
			'modificacion_importante_el' => '2023-07-19 18:09:15',
			'modificacion_importante_por' => 'rony',
			'modificacion_importante_json' => '{"items": "Los rollos del color BOTELLA cambió de 1.00 a 2.00
El quantity del color BOTELLA cambió de 29.80 a 59.00", "origen_id": "El origen/destino cambió de LV a UG", "total_rolls": "El total de rollos cambió de 1.00 a 2.00", "total_quantity": "El quantity total cambió de 29.80 a 59.00", "producto_general_id": "El producto cambió de SCUBA SPORT a AZUCENA PRINT"}',
			'modificacion_importante_text' => '
El producto cambió de SCUBA SPORT a AZUCENA PRINT
El origen/destino cambió de LV a UG
El total de rollos cambió de 1.00 a 2.00
El quantity total cambió de 29.80 a 59.00
Los rollos del color BOTELLA cambió de 1.00 a 2.00
El quantity del color BOTELLA cambió de 29.80 a 59.00',
			'verificaciones_otras_bodegas' => '0',
			'autorizacion_ultimo_movimiento' => 'No',
			'json_file_attachments_nota_foto' => NULL,
			'modificacion_importante_cuantas' => '2',
			'autorizacion_ultimo_movimiento_el' => NULL,
			'autorizacion_ultimo_movimiento_por' => NULL,
			'modificacion_importante_autorizada' => 'No',
			'autorizacion_ultimo_movimiento_rony' => 'No',
			'producto_general_calidad_comentario' => '',
			'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
			'autorizacion_ultimo_movimiento_cuantos' => '0',
			'autorizacion_ultimo_movimiento_el_rony' => NULL,
			'modificacion_importante_autorizada_por' => '',
			'autorizacion_ultimo_movimiento_por_rony' => NULL,
			'modificacion_importante_autorizada_text' => '',
			'modificacion_importante_autorizada_cuantas' => '0',
			'modificacion_importante_autorizada_requeridas' => '2',
		];
		$espera = [
            'cliente' => 'PIÑA - A&D EFECTO PUBLICITARIO',
            'ayudantes' => 'URIEL GARCIA MARTINEZ - ADRIAN ALEJANDRO MARCIAL ABLANEDO',
            'origen_id' => '11ec6cb303b9c80dad6b74867af2fe60 - 11ec6cb303b9e7fdad6b74867af2fe60',
            'tipo_nota' => 'PIÑA - CASH',
            'cliente_id' => '11ecab0a89afaa8b81a354bf6469e2cc - f8bc123029a8bad511edc29a492f642f',
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d27bb3430a", "lbl": "DULCE VAZQUEZ VARGAS", "index": "1", "alta_db": "2023-07-17 18:18:33", "display": "DULCE VAZQUEZ VARGAS", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134"}] - [{"id": "74867af2fe60b1b311ed5703d24a89c4", "lbl": "FAUSTO PABLO FLORES GARCÍA", "index": "1", "alta_db": "2023-07-19 17:09:10", "display": "FAUSTO PABLO FLORES GARCÍA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'total_rolls' => '1.00 - 2.00',
            'numero_compra' => '[] - [{"index": "1", "alta_db": "2023-07-19 17:08:57", "alta_por": "rony", "compra_id": "", "fue_error": "No", "alta_por_id": "1", "numero_compra": "1"}]',
            'ayudantes_json' => '[{"id": "11ed2021f8922a3ca2c174867af2fe60", "lbl": "URIEL GARCIA MARTINEZ", "index": "1", "alta_db": "2023-07-17 18:18:30", "display": "URIEL GARCIA MARTINEZ", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134"}] - [{"id": "11ed2021f904b067a2c174867af2fe60", "lbl": "ADRIAN ALEJANDRO MARCIAL ABLANEDO", "index": "1", "alta_db": "2023-07-19 17:09:07", "display": "ADRIAN ALEJANDRO MARCIAL ABLANEDO", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'total_quantity' => '29.80 - 59.00',
            'numero_tipo_nota' => ' - 1',
            'chofer_responsable' => '[] - [{"nombre": "JOSE DE JESUS FLORES MORA", "alta_db": "2023-07-19 17:08:58", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "11ec6cb30b3e43a5ad6b74867af2fe60"}]',
            'quantity_tipo_nota' => '0.00 - 10.00',
            'producto_general_id' => '74867af2fe60b6fd11ec69a229836f0d - 74867af2fe609cc211ed72a878063a59',
            'numero_compra_actual' => ' - 1',
            'chofer_responsable_id' => ' - 11ec6cb30b3e43a5ad6b74867af2fe60',
        ];
        $response = getAllNotaDiff($nota_old, $nota_nueva);

        $this->assertEquals(
            $espera,
            $response,
            "Compárar toda la nota multiples cambios GetAllNotaDiff"
        );

        $espera = [
            'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
            'total_quantity' => '50.70 - 50.20',
            'fecha' => ' - 2023-07-08',
        ];
        $nota_old = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Traslado',
            //'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 11:23:56',
                    'alta_por' => 'marcos',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.70',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 11:23:56',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1db437b46352',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
            'activo' => '1',
            'estado' => '0',
            'numero' => '2082',
            'pedido' => '[]',
            'alta_db' => '2023-07-08 11:23:56',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
            'colores' => 'NARANJA NEON',
            'lock_el' => NULL,
            'remarks' => '',
            'alta_por' => 'marcos',
            'recibido' => 'No',
            'ayudantes' => 'SIN AYUDANTES',
            'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
            'documento' => 'nada',
            'iac_edits' => '0',
            'numero_pi' => '',
            'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
            'pagare_id' => '',
            'tipo_nota' => '',
            'autorizado' => 'No',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'fabrica_id' => '',
            'para_quien' => '',
            'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'reset_lock' => '0',
            'super_lock' => '0',
            'verificada' => 'No',
            'es_apartado' => 'No',
            'num_colores' => '1',
            'numero_real' => '2082',
            'por_sistema' => '0',
            'recibido_el' => NULL,
            'system_lock' => '0',
            'total_rolls' => '2.00',
            'recibido_por' => NULL,
            'remarks_paid' => '',
            'unlock_hasta' => NULL,
            'autorizado_el' => NULL,
            'cp_cliente_id' => '',
            'numero_as_num' => '2082',
            'numero_compra' => '[]',
            'numero_pagare' => '',
            'own_reference' => '',
            'reset_lock_el' => NULL,
            'super_lock_el' => NULL,
            'ultimo_cambio' => '2023-07-08 11:23:56',
            'verificada_el' => NULL,
            'autorizado_por' => NULL,
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'entrada_salida' => 'Salida',
            'motivo_de_lock' => NULL,
            'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
            'reset_lock_por' => '',
            'system_lock_el' => NULL,
            'tipo_nota_json' => '[]',
            'total_quantity' => '50.70',
            'verificada_por' => '',
            'system_lock_por' => '',
            'forma_etiquetado' => '',
            'numero_solicitud' => NULL,
            'numero_tipo_nota' => '',
            'remarks_internos' => NULL,
            'remarks_recibido' => NULL,
            'destino_fuerza_el' => NULL,
            'destino_fuerza_ok' => 'No',
            'numero_contenedor' => '',
            'numero_order_text' => '00000000000000000000000000002082',
            'traslado_forza_ok' => 'No',
            'ultimo_cambio_por' => 'marcos',
            'ultimo_movimiento' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'quantity_tipo_nota' => '0.00',
            'traslado_fuerza_el' => NULL,
            'unsuper_lock_hasta' => NULL,
            'estado_verificacion' => 'VERIFICADA',
            'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
            'cp_autotransporte_id' => '',
            'existencia_snap_shot' => '[]',
            'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
            'numero_compra_actual' => '',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'contra_nota_bodega_id' => '',
            'empresa_id_etiquetado' => '',
            'inconsistencias_nivel' => 'danger',
            'json_file_attachments' => NULL,
            'numero_tipo_nota_json' => '[]',
            'cp_figuratransporte_id' => '',
            'responsable_etiquetado' => '',
            'verificaciones_propias' => '0',
            'confirmacion_etiquetado' => 'No',
            'modificacion_importante' => 'No',
            'quantity_tipo_nota_json' => '[]',
            'motivo_cambio_importante' => '',
            'producto_general_calidad' => '',
            'solicitud_carta_porte_id' => NULL,
            'existencia_snap_shot_html' => NULL,
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_json' => json_encode(strim(<<< JSON
[]
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            'modificacion_importante_text' => NULL,
            'verificaciones_otras_bodegas' => '2',
            'autorizacion_ultimo_movimiento' => 'No',
            'json_file_attachments_nota_foto' => NULL,
            'modificacion_importante_cuantas' => '0',
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_por' => NULL,
            'modificacion_importante_autorizada' => 'No',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'producto_general_calidad_comentario' => '',
            'modificacion_importante_autorizada_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'modificacion_importante_autorizada_text' => NULL,
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
        ];
        $nota_nueva = [
            'paid' => '0',
            'tipo' => 'Traslado',
            'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 14:07:02',
                    'alta_por' => 'sistema',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.20',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 14:07:02',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1dcb00e72479',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
            'activo' => '1',
            'estado' => '0',
            'numero' => '2082',
            'pedido' => '[]',
            'alta_db' => '2023-07-08 11:23:56',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
            'colores' => 'NARANJA NEON',
            'lock_el' => NULL,
            'remarks' => '',
            'alta_por' => 'marcos',
            'recibido' => 'No',
            'ayudantes' => 'SIN AYUDANTES',
            'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
            'documento' => 'nada',
            'iac_edits' => '1',
            'numero_pi' => '',
            'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
            'pagare_id' => '',
            'tipo_nota' => '',
            'autorizado' => 'No',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'fabrica_id' => '',
            'para_quien' => '',
            'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'reset_lock' => '0',
            'super_lock' => '0',
            'verificada' => 'No',
            'es_apartado' => 'No',
            'num_colores' => '1',
            'numero_real' => '2082',
            'por_sistema' => '0',
            'recibido_el' => NULL,
            'system_lock' => '0',
            'total_rolls' => '2.00',
            'recibido_por' => NULL,
            'remarks_paid' => '',
            'unlock_hasta' => NULL,
            'autorizado_el' => NULL,
            'cp_cliente_id' => '',
            'numero_as_num' => '2082',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
            'numero_pagare' => '',
            'own_reference' => '',
            'reset_lock_el' => NULL,
            'super_lock_el' => NULL,
            'ultimo_cambio' => '2023-07-08 14:07:02',
            'verificada_el' => NULL,
            'autorizado_por' => NULL,
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'entrada_salida' => 'Salida',
            'motivo_de_lock' => NULL,
            'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
            'reset_lock_por' => '',
            'system_lock_el' => NULL,
            'tipo_nota_json' => '[]',
            'total_quantity' => '50.20',
            'verificada_por' => '',
            'system_lock_por' => '',
            'forma_etiquetado' => '',
            'numero_solicitud' => NULL,
            'numero_tipo_nota' => '',
            'remarks_internos' => NULL,
            'remarks_recibido' => NULL,
            'destino_fuerza_el' => NULL,
            'destino_fuerza_ok' => 'No',
            'numero_contenedor' => '',
            'numero_order_text' => '00000000000000000000000000002082',
            'traslado_forza_ok' => 'No',
            'ultimo_cambio_por' => 'marcos',
            'ultimo_movimiento' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'quantity_tipo_nota' => '0.00',
            'traslado_fuerza_el' => NULL,
            'unsuper_lock_hasta' => NULL,
            'estado_verificacion' => 'NO VERIFICADA',
            'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
            'cp_autotransporte_id' => '',
            'existencia_snap_shot' => '[]',
            'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
            'numero_compra_actual' => '',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'contra_nota_bodega_id' => '',
            'empresa_id_etiquetado' => '',
            'inconsistencias_nivel' => 'danger',
            'json_file_attachments' => NULL,
            'numero_tipo_nota_json' => '[]',
            'cp_figuratransporte_id' => '',
            'responsable_etiquetado' => '',
            'verificaciones_propias' => '0',
            'confirmacion_etiquetado' => 'No',
            'modificacion_importante' => 'Si',
            'quantity_tipo_nota_json' => '[]',
            'motivo_cambio_importante' => '',
            'producto_general_calidad' => '',
            'solicitud_carta_porte_id' => NULL,
            'existencia_snap_shot_html' => NULL,
            'modificacion_importante_el' => '2023-07-08 14:07:02',
            'modificacion_importante_por' => 'marcos',
            'modificacion_importante_json' => json_encode(strim(<<< JSON
{
    "items": "El quantity del color NARANJA NEON cambió de 50.70 a 50.20",
    "total_quantity": "El quantity total cambió de 50.70 a 50.20"
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            'modificacion_importante_text' => '
El quantity total cambió de 50.70 a 50.20
El quantity del color NARANJA NEON cambió de 50.70 a 50.20',
            'verificaciones_otras_bodegas' => '2',
            'autorizacion_ultimo_movimiento' => 'No',
            'json_file_attachments_nota_foto' => NULL,
            'modificacion_importante_cuantas' => '1',
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_por' => NULL,
            'modificacion_importante_autorizada' => 'No',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'producto_general_calidad_comentario' => '',
            'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'modificacion_importante_autorizada_text' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
        ];

        $response = getAllNotaDiff($nota_old, $nota_nueva);
        $this->assertEquals(
            $espera,
            $response,
            "si un key no existe GetAllNotaDiff"
        );

        $espera = [
            'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
            'total_quantity' => '50.70 - 50.20',
            'modificacion_importante_autorizada' => 'Si - No',
            'fecha' => ' - 2023-07-08',
        ];
        $nota_old = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Traslado',
            //'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 11:23:56',
                    'alta_por' => 'marcos',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.70',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 11:23:56',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1db437b46352',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
            'activo' => '1',
            'estado' => '0',
            'numero' => '2082',
            'pedido' => '[]',
            'alta_db' => '2023-07-08 11:23:56',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
            'colores' => 'NARANJA NEON',
            'lock_el' => NULL,
            'remarks' => '',
            'alta_por' => 'marcos',
            'recibido' => 'No',
            'ayudantes' => 'SIN AYUDANTES',
            'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
            'documento' => 'nada',
            'iac_edits' => '0',
            'numero_pi' => '',
            'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
            'pagare_id' => '',
            'tipo_nota' => '',
            'autorizado' => 'No',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'fabrica_id' => '',
            'para_quien' => '',
            'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'reset_lock' => '0',
            'super_lock' => '0',
            'verificada' => 'No',
            'es_apartado' => 'No',
            'num_colores' => '1',
            'numero_real' => '2082',
            'por_sistema' => '0',
            'recibido_el' => NULL,
            'system_lock' => '0',
            'total_rolls' => '2.00',
            'recibido_por' => NULL,
            'remarks_paid' => '',
            'unlock_hasta' => NULL,
            'autorizado_el' => NULL,
            'cp_cliente_id' => '',
            'numero_as_num' => '2082',
            'numero_compra' => '[]',
            'numero_pagare' => '',
            'own_reference' => '',
            'reset_lock_el' => NULL,
            'super_lock_el' => NULL,
            'ultimo_cambio' => '2023-07-08 11:23:56',
            'verificada_el' => NULL,
            'autorizado_por' => NULL,
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'entrada_salida' => 'Salida',
            'motivo_de_lock' => NULL,
            'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
            'reset_lock_por' => '',
            'system_lock_el' => NULL,
            'tipo_nota_json' => '[]',
            'total_quantity' => '50.70',
            'verificada_por' => '',
            'system_lock_por' => '',
            'forma_etiquetado' => '',
            'numero_solicitud' => NULL,
            'numero_tipo_nota' => '',
            'remarks_internos' => NULL,
            'remarks_recibido' => NULL,
            'destino_fuerza_el' => NULL,
            'destino_fuerza_ok' => 'No',
            'numero_contenedor' => '',
            'numero_order_text' => '00000000000000000000000000002082',
            'traslado_forza_ok' => 'No',
            'ultimo_cambio_por' => 'marcos',
            'ultimo_movimiento' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'quantity_tipo_nota' => '0.00',
            'traslado_fuerza_el' => NULL,
            'unsuper_lock_hasta' => NULL,
            'estado_verificacion' => 'VERIFICADA',
            'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
            'cp_autotransporte_id' => '',
            'existencia_snap_shot' => '[]',
            'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
            'numero_compra_actual' => '',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'contra_nota_bodega_id' => '',
            'empresa_id_etiquetado' => '',
            'inconsistencias_nivel' => 'danger',
            'json_file_attachments' => NULL,
            'numero_tipo_nota_json' => '[]',
            'cp_figuratransporte_id' => '',
            'responsable_etiquetado' => '',
            'verificaciones_propias' => '0',
            'confirmacion_etiquetado' => 'No',
            'modificacion_importante' => 'No',
            'quantity_tipo_nota_json' => '[]',
            'motivo_cambio_importante' => '',
            'producto_general_calidad' => '',
            'solicitud_carta_porte_id' => NULL,
            'existencia_snap_shot_html' => NULL,
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_json' => json_encode(strim(<<< JSON
[]
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            'modificacion_importante_text' => NULL,
            'verificaciones_otras_bodegas' => '2',
            'autorizacion_ultimo_movimiento' => 'No',
            'json_file_attachments_nota_foto' => NULL,
            'modificacion_importante_cuantas' => '0',
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_por' => NULL,
            'modificacion_importante_autorizada' => 'Si',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'producto_general_calidad_comentario' => '',
            'modificacion_importante_autorizada_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'modificacion_importante_autorizada_text' => NULL,
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
        ];
        $nota_nueva = [
            'paid' => '0',
            'tipo' => 'Traslado',
            'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 14:07:02',
                    'alta_por' => 'sistema',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.20',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 14:07:02',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1dcb00e72479',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
            'activo' => '1',
            'estado' => '0',
            'numero' => '2082',
            'pedido' => '[]',
            'alta_db' => '2023-07-08 11:23:56',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
            'colores' => 'NARANJA NEON',
            'lock_el' => NULL,
            'remarks' => '',
            'alta_por' => 'marcos',
            'recibido' => 'No',
            'ayudantes' => 'SIN AYUDANTES',
            'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
            'documento' => 'nada',
            'iac_edits' => '1',
            'numero_pi' => '',
            'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
            'pagare_id' => '',
            'tipo_nota' => '',
            'autorizado' => 'No',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'fabrica_id' => '',
            'para_quien' => '',
            'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'reset_lock' => '0',
            'super_lock' => '0',
            'verificada' => 'No',
            'es_apartado' => 'No',
            'num_colores' => '1',
            'numero_real' => '2082',
            'por_sistema' => '0',
            'recibido_el' => NULL,
            'system_lock' => '0',
            'total_rolls' => '2.00',
            'recibido_por' => NULL,
            'remarks_paid' => '',
            'unlock_hasta' => NULL,
            'autorizado_el' => NULL,
            'cp_cliente_id' => '',
            'numero_as_num' => '2082',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
            'numero_pagare' => '',
            'own_reference' => '',
            'reset_lock_el' => NULL,
            'super_lock_el' => NULL,
            'ultimo_cambio' => '2023-07-08 14:07:02',
            'verificada_el' => NULL,
            'autorizado_por' => NULL,
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'entrada_salida' => 'Salida',
            'motivo_de_lock' => NULL,
            'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
            'reset_lock_por' => '',
            'system_lock_el' => NULL,
            'tipo_nota_json' => '[]',
            'total_quantity' => '50.20',
            'verificada_por' => '',
            'system_lock_por' => '',
            'forma_etiquetado' => '',
            'numero_solicitud' => NULL,
            'numero_tipo_nota' => '',
            'remarks_internos' => NULL,
            'remarks_recibido' => NULL,
            'destino_fuerza_el' => NULL,
            'destino_fuerza_ok' => 'No',
            'numero_contenedor' => '',
            'numero_order_text' => '00000000000000000000000000002082',
            'traslado_forza_ok' => 'No',
            'ultimo_cambio_por' => 'marcos',
            'ultimo_movimiento' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'quantity_tipo_nota' => '0.00',
            'traslado_fuerza_el' => NULL,
            'unsuper_lock_hasta' => NULL,
            'estado_verificacion' => 'NO VERIFICADA',
            'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
            'cp_autotransporte_id' => '',
            'existencia_snap_shot' => '[]',
            'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
            'numero_compra_actual' => '',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'contra_nota_bodega_id' => '',
            'empresa_id_etiquetado' => '',
            'inconsistencias_nivel' => 'danger',
            'json_file_attachments' => NULL,
            'numero_tipo_nota_json' => '[]',
            'cp_figuratransporte_id' => '',
            'responsable_etiquetado' => '',
            'verificaciones_propias' => '0',
            'confirmacion_etiquetado' => 'No',
            'modificacion_importante' => 'Si',
            'quantity_tipo_nota_json' => '[]',
            'motivo_cambio_importante' => '',
            'producto_general_calidad' => '',
            'solicitud_carta_porte_id' => NULL,
            'existencia_snap_shot_html' => NULL,
            'modificacion_importante_el' => '2023-07-08 14:07:02',
            'modificacion_importante_por' => 'marcos',
            'modificacion_importante_json' => json_encode(strim(<<< JSON
{
    "items": "El quantity del color NARANJA NEON cambió de 50.70 a 50.20",
    "total_quantity": "El quantity total cambió de 50.70 a 50.20"
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            'modificacion_importante_text' => '
El quantity total cambió de 50.70 a 50.20
El quantity del color NARANJA NEON cambió de 50.70 a 50.20',
            'verificaciones_otras_bodegas' => '2',
            'autorizacion_ultimo_movimiento' => 'No',
            'json_file_attachments_nota_foto' => NULL,
            'modificacion_importante_cuantas' => '1',
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_por' => NULL,
            'modificacion_importante_autorizada' => 'No',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'producto_general_calidad_comentario' => '',
            'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'modificacion_importante_autorizada_text' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
        ];

        $response = getAllNotaDiff($nota_old, $nota_nueva);
        $this->assertEquals(
            $espera,
            $response,
            "modificacion importante paso a no  GetAllNotaDiff"
        );
    }

    /**
     * @covers ::getItemsDiff
     *
     */
    public function testGetItemsDiff()
    {

        $espera = [
            '54bf6469e2cc850b11ec1c91ed404822' => [
                'productos_rollos' => '2.00 - 3.00',
                'productos_quantity' => '50.70 - 50.20',
                'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d - 74867af2fe60ad6b11ec6f2555d5d88ddd',
            ],
        ];
        $nota_old_items = [
            '54bf6469e2cc850b11ec1c91ed404822' => [
                'lento' => 'No',
                'rollos' => '2.00',
                'alta_db' => '2023-07-08 11:23:56',
                'alta_por' => 'marcos',
                'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                'es_saldo' => 'No',
                'quantity' => '50.70',
                'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                'en_remate' => 'No',
                'averageMal' => '0',
                'super_lento' => 'No',
                'nuevoProducto' => '0',
                'ultimo_cambio' => '2023-07-08 11:23:56',
                'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                'rollosNegativo' => '0',
                'quantityNegativo' => '0',
                'ultimo_cambio_por' => 'marcos',
                'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                'nota_bodega_item_id' => 'cc483a12801ab3f611ee1db437b46352',
                'producto_color_calidad' => '',
                'producto_color_calidad_comentario' => '',
            ],
        ];
        $nota_nueva_items = [
            '54bf6469e2cc850b11ec1c91ed404822' => [
                'lento' => 'No',
                'rollos' => '3.00',
                'alta_db' => '2023-07-08 14:07:02',
                'alta_por' => 'sistema',
                'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                'es_saldo' => 'No',
                'quantity' => '50.20',
                'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88ddd',
                'en_remate' => 'No',
                'averageMal' => '0',
                'super_lento' => 'No',
                'nuevoProducto' => '0',
                'ultimo_cambio' => '2023-07-08 14:07:02',
                'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                'rollosNegativo' => '0',
                'quantityNegativo' => '0',
                'ultimo_cambio_por' => 'marcos',
                'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                'nota_bodega_item_id' => 'cc483a12801ab3f611ee1dcb00e72479',
                'producto_color_calidad' => '',
                'producto_color_calidad_comentario' => '',
            ],
        ];

        $response = getItemsDiff($nota_old_items, $nota_nueva_items);
        $this->assertEquals(
            $espera,
            $response,
            "campos items getItemsDiff"
        );

        //nota old vacio
        $cambios_en_items_test = [
            'agregado' => [
                0 => '54bf6469e2cc850b11ec1c91ed404822',
            ],
        ];
        $response = getItemsDiff([], $nota_nueva_items);
        $this->assertEquals(
            $cambios_en_items_test,
            $response,
            "campos items getItemsDiff"
        );


        //nota nueva vacia
        $cambios_en_items_test_2 = [
            'eliminado' => [
                0 => '54bf6469e2cc850b11ec1c91ed404822',
            ],
        ];

        $response = getItemsDiff($nota_old_items, []);
        $this->assertEquals(
            $cambios_en_items_test_2,
            $response,
            "campos items getItemsDiff"
        );
    }

    /**
     * @covers ::indexItem
     *
     */
    public function testIndexItems()
    {
        $entra = [
            0 => [
                'lento' => 'No',
                'rollos' => '2.00',
                'alta_db' => '2023-07-08 11:23:56',
                'alta_por' => 'marcos',
                'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                'es_saldo' => 'No',
                'quantity' => '50.70',
                'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                'en_remate' => 'No',
                'averageMal' => '0',
                'super_lento' => 'No',
                'nuevoProducto' => '0',
                'ultimo_cambio' => '2023-07-08 11:23:56',
                'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                'rollosNegativo' => '0',
                'quantityNegativo' => '0',
                'ultimo_cambio_por' => 'marcos',
                'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                'nota_bodega_item_id' => 'cc483a12801ab3f611ee1db437b46352',
                'producto_color_calidad' => '',
                'producto_color_calidad_comentario' => '',
            ],
        ];
        $sale = [
            '54bf6469e2cc850b11ec1c91ed404822' => [
                'lento' => 'No',
                'rollos' => '2.00',
                'alta_db' => '2023-07-08 11:23:56',
                'alta_por' => 'marcos',
                'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                'es_saldo' => 'No',
                'quantity' => '50.70',
                'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                'en_remate' => 'No',
                'averageMal' => '0',
                'super_lento' => 'No',
                'nuevoProducto' => '0',
                'ultimo_cambio' => '2023-07-08 11:23:56',
                'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                'rollosNegativo' => '0',
                'quantityNegativo' => '0',
                'ultimo_cambio_por' => 'marcos',
                'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                'nota_bodega_item_id' => 'cc483a12801ab3f611ee1db437b46352',
                'producto_color_calidad' => '',
                'producto_color_calidad_comentario' => '',
            ],
        ];

        $response = indexItem($entra);
        $this->assertIsArray($response);
        $this->assertEquals(
            $sale,
            $response,
            "index items indexItem"
        );

        $response = indexItem([]);
        $this->assertEquals(
            [],
            $response,
            "index items indexItem"
        );
    }

    /**
     * @covers ::getAllNotaDiffList
     *
     */
    public function testGetNotaDiffList()
    {

        $nota_old = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Traslado',
            'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 11:23:56',
                    'alta_por' => 'marcos',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.70',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 11:23:56',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1db437b46352',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
        'activo' => '1',
			'estado' => '0',
			'numero' => '2082',
			'pedido' => '[]',
			'alta_db' => '2023-07-08 11:23:56',
			'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
			'colores' => 'NARANJA NEON',
			'lock_el' => NULL,
			'remarks' => '',
			'alta_por' => 'marcos',
			'recibido' => 'No',
			'ayudantes' => 'SIN AYUDANTES',
			'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
			'documento' => 'nada',
			'iac_edits' => '0',
			'numero_pi' => '',
			'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
			'pagare_id' => '',
			'tipo_nota' => '',
			'autorizado' => 'No',
			'cliente_cp' => '',
			'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
			'fabrica_id' => '',
			'para_quien' => '',
			'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'reset_lock' => '0',
			'super_lock' => '0',
			'verificada' => 'No',
			'es_apartado' => 'No',
			'num_colores' => '1',
			'numero_real' => '2082',
			'por_sistema' => '0',
			'recibido_el' => NULL,
			'system_lock' => '0',
			'total_rolls' => '2.00',
			'recibido_por' => NULL,
			'remarks_paid' => '',
			'unlock_hasta' => NULL,
			'autorizado_el' => NULL,
			'cp_cliente_id' => '',
			'numero_as_num' => '2082',
			'numero_compra' => '[]',
			'numero_pagare' => '',
			'own_reference' => '',
			'reset_lock_el' => NULL,
			'super_lock_el' => NULL,
			'ultimo_cambio' => '2023-07-08 11:23:56',
			'verificada_el' => NULL,
			'autorizado_por' => NULL,
			'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
			'entrada_salida' => 'Salida',
			'motivo_de_lock' => NULL,
			'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
			'reset_lock_por' => '',
			'system_lock_el' => NULL,
			'tipo_nota_json' => '[]',
			'total_quantity' => '50.70',
			'verificada_por' => '',
			'system_lock_por' => '',
			'forma_etiquetado' => '',
			'numero_solicitud' => NULL,
			'numero_tipo_nota' => '',
			'remarks_internos' => NULL,
			'remarks_recibido' => NULL,
			'destino_fuerza_el' => NULL,
			'destino_fuerza_ok' => 'No',
			'numero_contenedor' => '',
			'numero_order_text' => '00000000000000000000000000002082',
			'traslado_forza_ok' => 'No',
			'ultimo_cambio_por' => 'marcos',
			'ultimo_movimiento' => NULL,
			'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
			'quantity_tipo_nota' => '0.00',
			'traslado_fuerza_el' => NULL,
			'unsuper_lock_hasta' => NULL,
			'estado_verificacion' => 'VERIFICADA',
			'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
			'cp_autotransporte_id' => '',
			'existencia_snap_shot' => '[]',
			'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
			'numero_compra_actual' => '',
			'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
			'contra_nota_bodega_id' => '',
			'empresa_id_etiquetado' => '',
			'inconsistencias_nivel' => 'danger',
			'json_file_attachments' => NULL,
			'numero_tipo_nota_json' => '[]',
			'cp_figuratransporte_id' => '',
			'responsable_etiquetado' => '',
			'verificaciones_propias' => '0',
			'confirmacion_etiquetado' => 'No',
			'modificacion_importante' => 'No',
			'quantity_tipo_nota_json' => '[]',
			'motivo_cambio_importante' => '',
			'producto_general_calidad' => '',
			'solicitud_carta_porte_id' => NULL,
			'existencia_snap_shot_html' => NULL,
			'modificacion_importante_el' => NULL,
			'modificacion_importante_por' => '',
			'modificacion_importante_json' => '{}',
			'modificacion_importante_text' => NULL,
			'verificaciones_otras_bodegas' => '2',
			'autorizacion_ultimo_movimiento' => 'No',
			'json_file_attachments_nota_foto' => NULL,
			'modificacion_importante_cuantas' => '0',
			'autorizacion_ultimo_movimiento_el' => NULL,
			'autorizacion_ultimo_movimiento_por' => NULL,
			'modificacion_importante_autorizada' => 'No',
			'autorizacion_ultimo_movimiento_rony' => 'No',
			'producto_general_calidad_comentario' => '',
			'modificacion_importante_autorizada_el' => NULL,
			'autorizacion_ultimo_movimiento_cuantos' => '0',
			'autorizacion_ultimo_movimiento_el_rony' => NULL,
			'modificacion_importante_autorizada_por' => '',
			'autorizacion_ultimo_movimiento_por_rony' => NULL,
			'modificacion_importante_autorizada_text' => NULL,
			'modificacion_importante_autorizada_cuantas' => '0',
			'modificacion_importante_autorizada_requeridas' => '2',
		];
		$nota_nueva = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Traslado',
            'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 14:07:02',
                    'alta_por' => 'sistema',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.20',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 14:07:02',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1dcb00e72479',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
			'activo' => '1',
			'estado' => '0',
			'numero' => '2082',
			'pedido' => '[]',
			'alta_db' => '2023-07-08 11:23:56',
			'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
			'colores' => 'NARANJA NEON',
			'lock_el' => NULL,
			'remarks' => '',
			'alta_por' => 'marcos',
			'recibido' => 'No',
			'ayudantes' => 'SIN AYUDANTES',
			'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
			'documento' => 'nada',
			'iac_edits' => '1',
			'numero_pi' => '',
			'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
			'pagare_id' => '',
			'tipo_nota' => '',
			'autorizado' => 'No',
			'cliente_cp' => '',
			'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
			'fabrica_id' => '',
			'para_quien' => '',
			'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'reset_lock' => '0',
			'super_lock' => '0',
			'verificada' => 'No',
			'es_apartado' => 'No',
			'num_colores' => '1',
			'numero_real' => '2082',
			'por_sistema' => '0',
			'recibido_el' => NULL,
			'system_lock' => '0',
			'total_rolls' => '2.00',
			'recibido_por' => NULL,
			'remarks_paid' => '',
			'unlock_hasta' => NULL,
			'autorizado_el' => NULL,
			'cp_cliente_id' => '',
			'numero_as_num' => '2082',
			'numero_compra' => '[{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
			'numero_pagare' => '',
			'own_reference' => '',
			'reset_lock_el' => NULL,
			'super_lock_el' => NULL,
			'ultimo_cambio' => '2023-07-08 14:07:02',
			'verificada_el' => NULL,
			'autorizado_por' => NULL,
			'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
			'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
			'entrada_salida' => 'Salida',
			'motivo_de_lock' => NULL,
			'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
			'reset_lock_por' => '',
			'system_lock_el' => NULL,
			'tipo_nota_json' => '[]',
			'total_quantity' => '50.20',
			'verificada_por' => '',
			'system_lock_por' => '',
			'forma_etiquetado' => '',
			'numero_solicitud' => NULL,
			'numero_tipo_nota' => '',
			'remarks_internos' => NULL,
			'remarks_recibido' => NULL,
			'destino_fuerza_el' => NULL,
			'destino_fuerza_ok' => 'No',
			'numero_contenedor' => '',
			'numero_order_text' => '00000000000000000000000000002082',
			'traslado_forza_ok' => 'No',
			'ultimo_cambio_por' => 'marcos',
			'ultimo_movimiento' => NULL,
			'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
			'quantity_tipo_nota' => '0.00',
			'traslado_fuerza_el' => NULL,
			'unsuper_lock_hasta' => NULL,
			'estado_verificacion' => 'NO VERIFICADA',
			'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
			'cp_autotransporte_id' => '',
			'existencia_snap_shot' => '[]',
			'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
			'numero_compra_actual' => '',
			'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
			'contra_nota_bodega_id' => '',
			'empresa_id_etiquetado' => '',
			'inconsistencias_nivel' => 'danger',
			'json_file_attachments' => NULL,
			'numero_tipo_nota_json' => '[]',
			'cp_figuratransporte_id' => '',
			'responsable_etiquetado' => '',
			'verificaciones_propias' => '0',
			'confirmacion_etiquetado' => 'No',
			'modificacion_importante' => 'Si',
			'quantity_tipo_nota_json' => '[]',
			'motivo_cambio_importante' => '',
			'producto_general_calidad' => '',
			'solicitud_carta_porte_id' => NULL,
			'existencia_snap_shot_html' => NULL,
			'modificacion_importante_el' => '2023-07-08 14:07:02',
			'modificacion_importante_por' => 'marcos',
			'modificacion_importante_json' => '{"items": "El quantity del color NARANJA NEON cambió de 50.70 a 50.20", "total_quantity": "El quantity total cambió de 50.70 a 50.20"}',
			'modificacion_importante_text' => '
El quantity total cambió de 50.70 a 50.20
El quantity del color NARANJA NEON cambió de 50.70 a 50.20',
			'verificaciones_otras_bodegas' => '2',
			'autorizacion_ultimo_movimiento' => 'No',
			'json_file_attachments_nota_foto' => NULL,
			'modificacion_importante_cuantas' => '1',
			'autorizacion_ultimo_movimiento_el' => NULL,
			'autorizacion_ultimo_movimiento_por' => NULL,
			'modificacion_importante_autorizada' => 'No',
			'autorizacion_ultimo_movimiento_rony' => 'No',
			'producto_general_calidad_comentario' => '',
			'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
			'autorizacion_ultimo_movimiento_cuantos' => '0',
			'autorizacion_ultimo_movimiento_el_rony' => NULL,
			'modificacion_importante_autorizada_por' => '',
			'autorizacion_ultimo_movimiento_por_rony' => NULL,
			'modificacion_importante_autorizada_text' => '',
			'modificacion_importante_autorizada_cuantas' => '0',
			'modificacion_importante_autorizada_requeridas' => '2',
		];
        $espera = [
            'numero_compra' => '[]',
        ];

        $response = getAllNotaDiffList($nota_old, $nota_nueva);
        $this->assertEquals(
            $espera,
            $response,
            "campos importantes getAllNotaDiffList"
        );

        $espera = [
            'numero' => '',
            'producto_general_id' => '',
            'origen_id' => '',
            'quantity_tipo_nota' => '',
            'numero_compra' => '',
            'chofer_responsable' => '',
            'ayudantes' => '',
            'pedido_por' => '',
            'chofer_responsable_id' => '',
            'confirmacion_etiquetado' => '',
            'tipo' => '',
            'entrada_salida' => '',
            'verificada' => '',
            'activo' => '',
            'bodega_id' => '',
            'cliente' => '',
            'cliente_id' => '',
        ];
        $response = getAllNotaDiffList([], $nota_nueva);
        $this->assertEquals(
            $espera,
            $response,
            "campos importantes getAllNotaDiffList"
        );

        $espera = [
            'tipo' => 'Traslado',
            'activo' => '1',
            'numero' => '2082',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
            'ayudantes' => 'SIN AYUDANTES',
            'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
            'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'verificada' => 'No',
            'numero_compra' => '[]',
            'entrada_salida' => 'Salida',
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'quantity_tipo_nota' => '0.00',
            'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'confirmacion_etiquetado' => 'No',
        ];
        $response = getAllNotaDiffList($nota_old, []);
        $this->assertEquals(
            $espera,
            $response,
            "campos importantes getAllNotaDiffList"
        );


        $response = getAllNotaDiffList([], []);
        $this->assertEquals(
            [],
            $response,
            "campos importantes getAllNotaDiffList"
        );
    }

    /**
     * @covers ::compareToActual
     * @covers getAllNotaDiff
     * @covers getItemsDiff
     * @covers indexItem
     * @covers getNotaDiff
     *
     */
    public function testCompareToActual(){

        $nota_old = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Traslado',
            'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 11:23:56',
                    'alta_por' => 'marcos',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.70',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 11:23:56',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1db437b46352',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
            'activo' => '1',
            'estado' => '0',
            'numero' => '2082',
            'pedido' => '[]',
            'alta_db' => '2023-07-08 11:23:56',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
            'colores' => 'NARANJA NEON',
            'lock_el' => NULL,
            'remarks' => '',
            'alta_por' => 'marcos',
            'recibido' => 'No',
            'ayudantes' => 'SIN AYUDANTES',
            'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
            'documento' => 'nada',
            'iac_edits' => '0',
            'numero_pi' => '',
            'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
            'pagare_id' => '',
            'tipo_nota' => '',
            'autorizado' => 'No',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'fabrica_id' => '',
            'para_quien' => '',
            'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'reset_lock' => '0',
            'super_lock' => '0',
            'verificada' => 'No',
            'es_apartado' => 'No',
            'num_colores' => '1',
            'numero_real' => '2082',
            'por_sistema' => '0',
            'recibido_el' => NULL,
            'system_lock' => '0',
            'total_rolls' => '2.00',
            'recibido_por' => NULL,
            'remarks_paid' => '',
            'unlock_hasta' => NULL,
            'autorizado_el' => NULL,
            'cp_cliente_id' => '',
            'numero_as_num' => '2082',
            'numero_compra' => '[]',
            'numero_pagare' => '',
            'own_reference' => '',
            'reset_lock_el' => NULL,
            'super_lock_el' => NULL,
            'ultimo_cambio' => '2023-07-08 11:23:56',
            'verificada_el' => NULL,
            'autorizado_por' => NULL,
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'entrada_salida' => 'Salida',
            'motivo_de_lock' => NULL,
            'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
            'reset_lock_por' => '',
            'system_lock_el' => NULL,
            'tipo_nota_json' => '[]',
            'total_quantity' => '50.70',
            'verificada_por' => '',
            'system_lock_por' => '',
            'forma_etiquetado' => '',
            'numero_solicitud' => NULL,
            'numero_tipo_nota' => '',
            'remarks_internos' => NULL,
            'remarks_recibido' => NULL,
            'destino_fuerza_el' => NULL,
            'destino_fuerza_ok' => 'No',
            'numero_contenedor' => '',
            'numero_order_text' => '00000000000000000000000000002082',
            'traslado_forza_ok' => 'No',
            'ultimo_cambio_por' => 'marcos',
            'ultimo_movimiento' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'quantity_tipo_nota' => '0.00',
            'traslado_fuerza_el' => NULL,
            'unsuper_lock_hasta' => NULL,
            'estado_verificacion' => 'VERIFICADA',
            'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
            'cp_autotransporte_id' => '',
            'existencia_snap_shot' => '[]',
            'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
            'numero_compra_actual' => '',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'contra_nota_bodega_id' => '',
            'empresa_id_etiquetado' => '',
            'inconsistencias_nivel' => 'danger',
            'json_file_attachments' => NULL,
            'numero_tipo_nota_json' => '[]',
            'cp_figuratransporte_id' => '',
            'responsable_etiquetado' => '',
            'verificaciones_propias' => '0',
            'confirmacion_etiquetado' => 'No',
            'modificacion_importante' => 'No',
            'quantity_tipo_nota_json' => '[]',
            'motivo_cambio_importante' => '',
            'producto_general_calidad' => '',
            'solicitud_carta_porte_id' => NULL,
            'existencia_snap_shot_html' => NULL,
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_json' => '{}',
            'modificacion_importante_text' => NULL,
            'verificaciones_otras_bodegas' => '2',
            'autorizacion_ultimo_movimiento' => 'No',
            'json_file_attachments_nota_foto' => NULL,
            'modificacion_importante_cuantas' => '0',
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_por' => NULL,
            'modificacion_importante_autorizada' => 'No',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'producto_general_calidad_comentario' => '',
            'modificacion_importante_autorizada_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'modificacion_importante_autorizada_text' => NULL,
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
        ];
        $nota_nueva = [
            'lock' => '0',
            'paid' => '0',
            'tipo' => 'Traslado',
            'fecha' => '2023-07-08',
            'grupo' => 'CLAVEL',
            'items' => [
                '54bf6469e2cc850b11ec1c91ed404822' => [
                    'lento' => 'No',
                    'rollos' => '2.00',
                    'alta_db' => '2023-07-08 14:07:02',
                    'alta_por' => 'sistema',
                    'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                    'es_saldo' => 'No',
                    'quantity' => '50.20',
                    'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                    'en_remate' => 'No',
                    'averageMal' => '0',
                    'super_lento' => 'No',
                    'nuevoProducto' => '0',
                    'ultimo_cambio' => '2023-07-08 14:07:02',
                    'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'ultimo_cambio_por' => 'marcos',
                    'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                    'nota_bodega_item_id' => 'cc483a12801ab3f611ee1dcb00e72479',
                    'producto_color_calidad' => '',
                    'producto_color_calidad_comentario' => '',
                ],
            ],
            'label' => "",
            'activo' => '1',
            'estado' => '0',
            'numero' => '2082',
            'pedido' => '[]',
            'alta_db' => '2023-07-08 11:23:56',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-07-08 11:24:29", "alta_por": "marcos", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "118"}]',
            'colores' => 'NARANJA NEON',
            'lock_el' => NULL,
            'remarks' => '',
            'alta_por' => 'marcos',
            'recibido' => 'No',
            'ayudantes' => 'SIN AYUDANTES',
            'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
            'documento' => 'nada',
            'iac_edits' => '1',
            'numero_pi' => '',
            'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
            'pagare_id' => '',
            'tipo_nota' => '',
            'autorizado' => 'No',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'fabrica_id' => '',
            'para_quien' => '',
            'pedido_por' => '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "index": "1", "alta_db": "2023-07-08 11:24:32", "display": "ANA LAURA GONZALEZ", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'reset_lock' => '0',
            'super_lock' => '0',
            'verificada' => 'No',
            'es_apartado' => 'No',
            'num_colores' => '1',
            'numero_real' => '2082',
            'por_sistema' => '0',
            'recibido_el' => NULL,
            'system_lock' => '0',
            'total_rolls' => '2.00',
            'recibido_por' => NULL,
            'remarks_paid' => '',
            'unlock_hasta' => NULL,
            'autorizado_el' => NULL,
            'cp_cliente_id' => '',
            'numero_as_num' => '2082',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
            'numero_pagare' => '',
            'own_reference' => '',
            'reset_lock_el' => NULL,
            'super_lock_el' => NULL,
            'ultimo_cambio' => '2023-07-08 14:07:02',
            'verificada_el' => NULL,
            'autorizado_por' => NULL,
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-07-08 11:24:30", "display": "SIN AYUDANTES", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118"}]',
            'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'entrada_salida' => 'Salida',
            'motivo_de_lock' => NULL,
            'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
            'reset_lock_por' => '',
            'system_lock_el' => NULL,
            'tipo_nota_json' => '[]',
            'total_quantity' => '50.20',
            'verificada_por' => '',
            'system_lock_por' => '',
            'forma_etiquetado' => '',
            'numero_solicitud' => NULL,
            'numero_tipo_nota' => '',
            'remarks_internos' => NULL,
            'remarks_recibido' => NULL,
            'destino_fuerza_el' => NULL,
            'destino_fuerza_ok' => 'No',
            'numero_contenedor' => '',
            'numero_order_text' => '00000000000000000000000000002082',
            'traslado_forza_ok' => 'No',
            'ultimo_cambio_por' => 'marcos',
            'ultimo_movimiento' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-07-08 11:24:27", "alta_por": "marcos", "fue_error": "No", "alta_por_id": "118", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'quantity_tipo_nota' => '0.00',
            'traslado_fuerza_el' => NULL,
            'unsuper_lock_hasta' => NULL,
            'estado_verificacion' => 'NO VERIFICADA',
            'producto_general_id' => '54bf6469e2cc850b11ec1caa42beef11',
            'cp_autotransporte_id' => '',
            'existencia_snap_shot' => '[]',
            'inconsistencias_text' => "
Contra Notas:
SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
            'numero_compra_actual' => '',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'contra_nota_bodega_id' => '',
            'empresa_id_etiquetado' => '',
            'inconsistencias_nivel' => 'danger',
            'json_file_attachments' => NULL,
            'numero_tipo_nota_json' => '[]',
            'cp_figuratransporte_id' => '',
            'responsable_etiquetado' => '',
            'verificaciones_propias' => '0',
            'confirmacion_etiquetado' => 'No',
            'modificacion_importante' => 'Si',
            'quantity_tipo_nota_json' => '[]',
            'motivo_cambio_importante' => '',
            'producto_general_calidad' => '',
            'solicitud_carta_porte_id' => NULL,
            'existencia_snap_shot_html' => NULL,
            'modificacion_importante_el' => '2023-07-08 14:07:02',
            'modificacion_importante_por' => 'marcos',
            'modificacion_importante_json' => '{"items": "El quantity del color NARANJA NEON cambió de 50.70 a 50.20", "total_quantity": "El quantity total cambió de 50.70 a 50.20"}',
            'modificacion_importante_text' => '
El quantity total cambió de 50.70 a 50.20
El quantity del color NARANJA NEON cambió de 50.70 a 50.20',
            'verificaciones_otras_bodegas' => '2',
            'autorizacion_ultimo_movimiento' => 'No',
            'json_file_attachments_nota_foto' => NULL,
            'modificacion_importante_cuantas' => '1',
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_por' => NULL,
            'modificacion_importante_autorizada' => 'No',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'producto_general_calidad_comentario' => '',
            'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'modificacion_importante_autorizada_text' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
        ];

        $response = compareToActual($nota_old, $nota_nueva, false );
        $espera = [
            0 => [
                'general' => [
                    'numero_compra' => '[] - [{"index": 1, "alta_db": "2023-07-08 14:07:02", "alta_por": "marcos", "compra_id": "", "fue_error": "No", "numero_compra": ""}]',
                    'total_quantity' => '50.70 - 50.20',
                ],
                'cambios_items' => [
                    '54bf6469e2cc850b11ec1c91ed404822' => [
                        'productos_quantity' => '50.70 - 50.20',
                    ],
                ],
            ],
        ];
        $this->assertEquals(
            $espera,
            $response,
            "campos test 1 compareToActual"
        );


    }

    /**
     * @covers ::getCancelItems
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers assoc_mysql2mysqli
     * @covers ia_singleton
     * @covers sqlMysqli::log_trace
     * @covers strit
     */
    public function testGetCancelItems(){
        $espera = [
            0 => [
                'lento' => 'No',
                'rollos' => '2.00',
                'alta_db' => '2023-07-08 14:07:02',
                'alta_por' => 'sistema',
                'color_id' => '54bf6469e2cc850b11ec1c91ed404822',
                'es_saldo' => 'No',
                'quantity' => '50.20',
                'bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d',
                'en_remate' => 'No',
                'averageMal' => '0',
                'super_lento' => 'No',
                'nuevoProducto' => '0',
                'ultimo_cambio' => '2023-07-08 14:07:02',
                'nota_bodega_id' => 'cc483a12801ab3f611ee1db437adae4d',
                'rollosNegativo' => '0',
                'quantityNegativo' => '0',
                'ultimo_cambio_por' => 'marcos',
                'producto_bodega_id' => '74867af2fe60ad6b11ec6f2555d5d88d_54bf6469e2cc850b11ec1caa42beef11_54bf6469e2cc850b11ec1c91ed404822',
                'nota_bodega_item_id' => 'cc483a12801ab3f611ee1dcb00e72479',
                'producto_color_calidad' => '',
                'producto_color_calidad_comentario' => '',
            ],
        ];
        $response = getCancelItems("cc483a12801ab3f611ee1db437adae4d");

        $this->assertEquals(
            $espera,
            $response,
            "traer items getCancelItems"
        );
        $this->assertIsArray($response);

    }

    /**
     * @covers ::getTimeDiff
     */
    public function testGetTimeDiff(){
        $history_record = [
            0 => [
                'history_id' => '207939',
                'date' => '2023-07-17 18:14:19',
                'user_nick' => 'rosa',
                'action' => 'insert',
            ],
            1 => [
                'history_id' => '207978',
                'date' => '2023-07-19 15:13:24',
                'user_nick' => 'rony',
                'action' => 'update',
            ],
        ];
        $this->assertEquals(
            true,
            getTimeDiff($history_record),
            "test cambio dia getTimeDiff"
        );

        $history_record = [
            0 => [
                'history_id' => '207939',
                'date' => '2023-07-17 18:14:19',
                'user_nick' => 'rosa',
                'action' => 'insert',
            ],
            1 => [
                'history_id' => '207978',
                'date' => '2023-07-17 15:13:24',
                'user_nick' => 'rony',
                'action' => 'update',
            ],
        ];
        $this->assertEquals(
            false,
            getTimeDiff($history_record),
            "test false getTimeDiff"
        );
        
    }

}
