<?php
/**
 * Se corre al iniciar phpunit, antes de realizar cualquier prueba
 *
 * @see getUserIdTypes([])
 *
 *  v 1.0.1
 */

use JetBrains\PhpStorm\ArrayShape;
use Vitex\Tester;

session_set_cookie_params( ["lifetime"=>0,"path"=>"/wamp/www/vitex",'httponly'=>true,'samesite'=>'Strict'] );
session_start();
$_SESSION['usuario_id']='1';
$_SESSION['usuario']='tester como Rony';
$_SERVER['SERVER_NAME'] = 'localhost';
$_SERVER['REQUEST_URI'] = '/vitex/index.php';

require_once(__DIR__ . '/../inc/config.php');
$_SESSION['usuario_id']='1';
$_SESSION['usuario']='tester como Rony';
$_SERVER['SERVER_NAME'] = 'localhost';

global $gSqlClass;
require_once(__DIR__ . '/../vendor/autoload.php');
clearstatcache();
if(!file_exists( __DIR__ .'/../../showErrors.vin'))
    die("No corro en el server!, Necesito el archivo: /wamp/www/showErrors.vin para correr, si no estas en el server ponlo");

global $gIAParametros;
$gIAParametros = [];
leeParametrosVitex(true);

global $gDefaultTestUsers;
$gDefaultTestUsers = getForTestsUserIdTypes([]);
function getForTestsUserIdTypes(array $UseActiveUserAs):array {
    $method = __FUNCTION__;
    $usersIds = ["Rony" => 1];
    // usuario tipo rony
    $usersIds['Usuario Tipo Rony'] = ia_singleread("SELECT /*$method*/ iac_usr_id FROM iac_usr WHERE usuario_tipo_rony='Si' AND vale='Active'");
    if(empty($usersIds['Usuario Tipo Rony'])) {
        die("\r\nERROR: No encontre un usuario 'Tipo Rony'\r\n");
    }

    // usuario active
    $usersIds['Usuario Active'] = ia_singleread("SELECT /*$method*/ iac_usr_id FROM iac_usr WHERE iac_usr_id>1 AND  usuario_tipo_rony='No' AND vale='Active' ");
    if(empty($usersIds['Usuario Active'])) {
        die("\r\nERROR: No encontre un usuario Active\r\n");
    }


    foreach($UseActiveUserAs as $named) {
        $ya = implode(',', $usersIds);
        $usersIds[$named] = ia_singleread(
            "SELECT /*$method*/ iac_usr_id FROM iac_usr WHERE usuario_tipo_rony='No' AND vale='Active' AND iac_usr_id NOT IN($ya)");
        if(empty($usersIds[$named])) {
            die("\r\nERROR: No encontre un usuario activo para $named\r\n");
        }
    }

    // non existant user
    for($i=2; $i<=68;++$i)
        if(ia_singleread("SELECT /*$method*/ iac_usr_id FROM iac_usr WHERE iac_usr_id=$i") === '') {
            $usersIds['Usuario no existe'] = $i;
            break;
        }

    // usuario inactive
    $usersIds['Usuario Inactive'] = ia_singleread("SELECT /*$method*/ iac_usr_id FROM iac_usr WHERE vale='Inactive'");
    if(empty($usersIds['Usuario Inactive'])) {
        die("\r\nERROR: No encontre un usuario Inactive, sin permiso de login\r\n");
    }

    return $usersIds;
}

/**
 *  Para probar un método private o protected, uso:
 *  $method = getProtectedMethod('nombreDelMétodo', $classInstance);
 *  $result = $method->invokeArgs($classInstance, [$d, $updateRecord, $vaDepositado]);
 *
 * @param string $methodName
 * @param object $class
 * @return ReflectionMethod
 * @throws ReflectionException
 */
function getProtectedMethod(string $methodName,object $class): ReflectionMethod {
    $class = new ReflectionClass( get_class($class) );
    $method = $class->getMethod($methodName);
    $method->setAccessible(true);
    return $method;
}
