<?php
declare(strict_types=1);

use PHPUnit\Framework\TestCase;

/**
 * @covers Vitex_permisosTest
 *
 * @covers Iac\inc\sql\IacMysqli
 * @covers sqlMysqli
 * @uses ::assoc_mysql2mysqli()
 * @covers ::ia_sqlArray()
 * @covers ::ia_singleread()
 * @uses ::ia_singleton()
 * @covers ::ia_query()
 * @covers ::ia_sqlSelectMultiKey()
 *
 * @uses ::usuarioTipoRony()
 *
 * @covers ::ia_errores_a_dime()
 * @covers ::strim()
 * @covers ::strit()
 **/

class Vitex_permisosTest extends TestCase {

    /**
     * @covers ::deuda_puede
     * @covers ::gasto_puede
     * @covers ::puedeBancosChina
     * @covers ::puedeGastosBanco
     * @covers ::puedeGastosCuentaT
     * @covers ::puedeIngresosDirectosCuentaT
     * @covers ::puedeInversion
     * @covers ::puedePermisoUsuario
     * @covers ::puedeRevisarGastosBanco
     * @covers ::puedeRevisarGastosCuentaT
     * @covers ::tengoActivaAlertaGastos
     */
    public function test_funciones_puede_iac_usr() {
        $functionSiNo = [
            'deuda_puede' => ['tipo'=>'bool', 'campo' => 'puede_deuda'], // ret true/false del si/no
            'gasto_puede' => ['tipo'=>'bool', 'campo' =>  'puede_gasto'],// ret true/false del si/no
            'puedeGastosBanco' => ['tipo'=>'string', 'campo' => 'puede_gasto'], // reg Si/no
            'puedeGastosCuentaT' => ['tipo'=>'bool', 'campo' => 'puede_gasto_ctat'], // ret true/false del si/no
            'puedeBancosChina' => ['tipo'=>'bool', 'campo' => 'puede_banco_china'], // ret true/false del si/no
            'puedeIngresosDirectosCuentaT' => ['tipo'=>'bool', 'campo' => 'puede_ingreso_directo_a_cuentat'], // ret true/false del si/no
            'puedeInversion' => ['tipo'=>'bool', 'campo' => 'puede_inversion'], // ret true/false del si/no
            'puedeRevisarGastosCuentaT' => ['tipo'=>'bool', 'campo' => 'puede_revisar_gastos_cuentaT'], // ret true/false del si/no
            'puedeRevisarGastosBanco' => ['tipo'=>'bool', 'campo' => 'puede_revisar_movimientos_banco'], // ret true/false del si/no
            'tengoActivaAlertaGastos' => ['tipo'=>'string', 'campo' => 'activa_alerta_gastos'], // ret si/no
        ];
        $users = ia_sqlArray("SELECT * FROM iac_usr WHERE iac_usr_id>1 AND usuario_tipo_rony='No'", "iac_usr_id");
        foreach($functionSiNo as $function => $p)
            foreach($users as $uid => $u) {
                $_SESSION['usuario_id'] = $uid;
                $this->assertEquals( $p['tipo']==='bool' ?  strcasecmp('si', $u[$p['campo']]) === 0 : $u[$p['campo']],
                    $function($uid),
                    "Function $function para el permiso $p[campo] usuario $u[nick] tiene " . $u[$p['campo']]
                );
                $this->assertEquals(strcasecmp('si', $u[$p['campo']]) === 0,
                    puedePermisoUsuario($uid, $p['campo'], false),
                    "puedePermisoUsuario (true/false) para el permiso $p[campo] usuario $u[nick] tiene " . $u[$p['campo']]
                );
                $this->assertEquals($u[$p['campo']],
                    puedePermisoUsuario($uid, $p['campo'], true),
                    "puedePermisoUsuario valor Real para el permiso $p[campo] usuario $u[nick] tiene " . $u[$p['campo']]
                );
            }
    }

    /**
     * usuarioTipoRony
     * @test usuarioTipoRonyTipoRony
     * @covers ::usuarioTipoRony()
     *
     * @dataProvider providerUsuarioTipoRony
     */
    public function testUsuarioTipoRony(int|string|null $user_id,bool $expected) {
        $_SESSION['usuario_id'] = null;
        $this->assertEquals($expected ,usuarioTipoRony($user_id));
        $_SESSION['usuario_id'] = $user_id;
        $this->assertEquals($expected ,usuarioTipoRony());
    }

    public function providerUsuarioTipoRony() {
        $usuarios = getForTestsUserIdTypes([]);

        return [
            "Pasando UserId, Rony" => [$usuarios['Rony'], true],
            "Pasando UserId, No existe" => [$usuarios['Usuario no existe'], false],
            "Pasando UserId, Tipo Rony" => [$usuarios['Usuario Tipo Rony'], true],
            "Pasando UserId, Usuario Inactive" => [$usuarios['Usuario Inactive'], false],
            "UserId por default, sin sesion" => [null, false],
            "Pasando UserId, Usuario Normal Active" => [$usuarios['Usuario Active'], false],
            "Pasando UserId, Usuario Normal Active de cache" => [$usuarios['Usuario Active'], false],
        ];
    }


    public function providerRonyYTipoRonyDebenPoder() {
        $return = [];
        //$valeId = getValeId();
        $tests = [
          ['puedeCatDoc', ["79"], "1", true],

          ['puedeCuentaT', ["79", '', 'lo que sea'],  "1",true],
          ['puedeCuentaT', ["79", "1", 'lo que sea'],  "1",true],
          ['puedeCuentaT', ["", "1", 'lo que sea'],  "1",false],
          ['puedeCuentaT', ["79", "1", ''],  "1",false],

          ['puedeClientes', [],  "1",true],

          ['puedeGastosBanco', [],  "1",'Si'],
          ['puedeGastosBanco', ["1"],  "1",'Si'],

          ['tienePermisoEnVale', [], "1" , false],
          ['tienePermisoEnVale', ["1"], "1" , false],
         // ['tienePermisoEnVale', ["1", $valeId], "1" , true],
         // ['tienePermisoEnVale', ["", $valeId], "1" , true],
          ['tienePermisoEnVale', ["1", 'vale_id No Existe'], "1" , false],

          ['puedeGastosCuentaT', [], "1", true],
          ['puedeGastosCuentaT', ["1"], "1", true],

          ['puedeFiduciario', [], "1", true],
          ['puedeFiduciario', ["1"], "1", true],

          ['puedeBancosChina', [], "1", true],
          ['puedeBancosChina', ["1"], "1", true],


          ['puedePermisoUsuario', [], "1", false],
          ['puedePermisoUsuario', ["","cualquiera"], "1", true],
          ['puedePermisoUsuario', ["1","cualquiera"], "1", true],
          ['puedePermisoUsuario', ["1","cualquiera", true], "1", 'Si'],

          ['puedeIngresosDirectosCuentaT', [], "1", true],
          ['puedeIngresosDirectosCuentaT', ["1"], "1", true],

          ['puedeInversion', [], "1", true],
          ['puedeInversion', ["1"], "1", true],

        ];
        global $gDefaultTestUsers;
        foreach($tests as $t) {
            $key = $t[0].'(' . implode(', ', $t[1]) . ')';
            $return["Rony: $key"] = $t;
            $t[2] = $gDefaultTestUsers['Usuario Tipo Rony'];
            $return["Tipo Rony: $key"] = $t;
        }

        return $return;
    }

    /**
     * Revisa que siempre puedan Rony y usuario Tipo Rony
     * @dataProvider providerRonyYTipoRonyDebenPoder
     *
     */
    public function testRonyYTipoRonyDebenPoder(callable $callable, array $arguments, string $defaultUser, mixed $expected) {
        $_SESSION['usuario_id'] = $defaultUser;
        $this->assertEquals($expected, call_user_func_array($callable, $arguments));
    }


    /**
     * Pueden todos los usuairos
     *
     * @covers ::puedeConsultarProductosGenerales
     * @covers ::puedeConsultarProductosColor
     * @covers ::puedeConsultarColores
     *
     * @dataProvider providerPuedenTodosLosUsuarios
     */
    public function testPuedenTodosLosUsuarios(callable $callable,array $arguments, string $defaultUser,mixed $expected) {
        $_SESSION['usuario_id'] = $defaultUser;
        $this->assertEquals($expected, call_user_func_array($callable, $arguments));
    }

    public function providerPuedenTodosLosUsuarios() {
        global $gDefaultTestUsers;
        $usuario = $gDefaultTestUsers['Usuario Active'];
        return [
          'puedeConsultarProductosGenerales()' =>  ['puedeConsultarProductosGenerales', [], "1", true ],
          'puedeConsultarProductosGenerales($usuario)' => ['puedeConsultarProductosGenerales', [], $usuario, true ],
          'puedeConsultarProductosGenerales("sinLogin")' => ['puedeConsultarProductosGenerales', [], '', false ],

            'puedeConsultarProductosColor()' =>  ['puedeConsultarProductosColor', [], "1", true ],
            'puedeConsultarProductosColor($usuario)' => ['puedeConsultarProductosColor', [], $usuario, true ],
            'puedeConsultarProductosColor("sinLogin")' => ['puedeConsultarProductosColor', [], '', false ],

            'puedeConsultarColores()' =>  ['puedeConsultarColores', [], "1", true ],
            'puedeConsultarColores($usuario)' => ['puedeConsultarColores', [], $usuario, true ],
            'puedeConsultarColores("sinLogin")' => ['puedeConsultarColores', [], '', false ],
        ];
    }

    /**
     * @covers ::puedeAdministrarColores
     * @covers ::puedeAdministrarProductosGenerales
     * @covers ::puedeAdministrarProductosColor
     * @covers ::usuarioTipoRony()
     * @covers ::usuarioSupervisaBodega()
     */
    public function test_puedeRonyYSupervisorDeBodega() {
        $functionSiNo = [
          'puedeAdministrarColores'=>['tipo'=>'bool'],
          'puedeAdministrarProductosGenerales'=>['tipo'=>'bool'],
          'puedeAdministrarProductosColor'=>['tipo'=>'bool'],
        ];
        foreach($functionSiNo as $function => $f) {
            $this->assertTrue($function('1'), "Rony puede $function" );
        }
    }
}