<?php
declare(strict_types=1);

/**
 * @covers Vitex_utilsTest
 *
 */
use PHPUnit\Framework\TestCase;

/**
 * @uses URLify::downcode
 * @uses URLify::init
 * @uses ::strit
 * @uses ::fieldit
 * @uses ::the_error_handler
 */
class Vitex_utilsTest extends TestCase {

    /**
     * @covers ::BoldaString
     */
    public function testBoldaString() {
        $this->assertEquals("<strong>bold</strong>", BoldaString('bold'));
    }

    /**
     * @covers quitaespaciosintermedios
     * @dataProvider providerQuitaespaciosintermedios
     */
    public function test_Quitaespaciosintermedios(string $string,string $expected) {
        $this->assertEquals($expected,   quitaespaciosintermedios($string));
    }

    public function providerQuitaespaciosintermedios() {
        return [
            'Empty string' => ['', ''],
            'Espacios string' => ['   ', ''],
            'Espacios entre palabras'=>['   palab,ra          larga      ','palab,ra larga'],
            'Tabs entre palabras' => ["palabra\ttab\totro", "palabra tab otro"]
        ];
    }

    /**
     * @covers arrayMovetoTop
     * @dataProvider providerArrayMovetoTop
     */
    public function testArrayMovetoTop(array $array,string|int $key, array $expected) {
        arrayMovetoTop($array,$key);
        $this->assertEquals($expected, $array ) ;
    }

    public function providerArrayMovetoTop() {
        return [
            'un elemento' => [['baba'=>'top'], 'baba', ['baba'=>'top']],
            'dos elementos' => [ ['dos'=>'otro', 'baba'=>'top'], 'baba', ['baba'=>'top', 'dos'=>'otro']],
            'tres elementos' => [ ['tres'=>'3', 'dos'=>'otro', 'baba'=>'top'], 'baba', ['baba'=>'top', 'tres'=>'3', 'dos'=>'otro']],
            'enmedio elementos' => [ ['tres'=>'3', 'dos'=>'otro', 'baba'=>'top', 'cuatro'=>4], 'baba', ['baba'=>'top', 'tres'=>'3', 'dos'=>'otro','cuatro'=>4]],
        ];
    }

    /**
     * @covers ::arrayCopy
     */
    public function test_arrayCopy() {
        $array = [
            'int' => 3,
            'float' => 3.5,
            'bool' => true,
            'null' => null,
            'date' => new DateTime(),
            'string' =>  'String',
            'array' => [1,2,3,4,'five', 'array'=>[1,2,3]],
            'sub_array_keys' => ['a'=>1,2,3,4,'five', 'array'=>['a'=>11,2,3]],
        ];
        $this->assertEquals($array, arrayCopy($array));
    }

    /**
     * @covers ::isValueonArray
     * @dataProvider provider_isValueonArray
     */
    public function test_isValueonArray($array, $val, $expected) {
       $this->assertEquals($expected, isValueonArray($array, $val));
    }
    public function provider_isValueonArray():array {
        return [
            'not found' => [['a', 'b','c', 2], 'va', false],
            'in first level' => [['a', 'b','c', 2], 'b', 1],
            'in first stringVsNumber' => [['a', 'b','c', 2], '2', 3],
            'keys' => [['a', 'b','c', 'two'=>'2'], '2', 'two'],
            'in sub array' => [
                ['a', 'b','c', 'two'=>['dos'=>'2']], '2', 'two'
            ],
            'in sub sub array' => [
                ['a', 'b','c', 'two'=>['dos'=>['1','2']]], '2', 'two'
            ],
            'in sub array not found' => [
                ['a', 'b','c', 'two'=>['dos'=>'2']], 'dos', false
            ],
        ];
    }

    /**
     * @covers ::generaArraydeunaColumna
     * @dataProvider provider_generaArraydeunaColumna
     */
    public function test_generaArraydeunaColumna($arr, $col, $startingpos = 0, $stoppingpos = -1) {
        if($stoppingpos === -1)
            $stoppingpos = count($arr);
        $offset = $stoppingpos - $startingpos;
        $sliced = array_slice($arr, $startingpos, $offset, false);
        foreach($sliced as &$d) {
            if(is_array($d) )
                if(count($d) > $col)
                    $d =  array_values($d)[$col];
                else
                    $d = reset($d);
        }
        $this->assertEquals(
            $sliced,
            generaArraydeunaColumna($arr, $col, $startingpos, $stoppingpos));
    }

    public function provider_generaArraydeunaColumna():array {
        $numberKeys = [
            ['a1', 'b1', 'c1', 'd1', 'e', 'f'],
            ['a2', 'b2', 'c2', 'd2', 'e', 'f'],
            ['a3', 'b3', 'c3', 'd3', 'e', 'f'],
            ['a4', 'b4', 'c4', 'd4', 'e', 'f'],
            ['a5', 'b5', 'c5', 'd5', 'e', 'f'],
            ['a6', 'b6', 'c6', 'd6', 'e', 'f'],
            ['a7', 'b7', 'c7', 'd7', 'e', 'f'],
            ['a8', 'b8', 'c8', 'd8', 'e', 'f'],
            ['a9', 'b9', 'c9', 'd9', 'e', 'f'],
            ['a10', 'b10', 'c10', 'd10', 'e', 'f'],
            ];
        return [
            'primera columna, primeros 3 renglones' => [$numberKeys, 0,0,3],
            'segunda columna todo' => [$numberKeys, 1,0,-1],
            'tercera columna todo renglones 3 al 6' => [$numberKeys, 2,3,6],
        ];
    }
}