<?php


use PHPUnit\Framework\TestCase;

class CobranzaHistoryLogTest extends TestCase
{
    const ID = 'cc483a12801aa75111ee210e1992123456';
    const PAGARE_ID = 'cc483a12801ab56811ee24bef85cfc08';
    const VALE_ID = '54bf6469e2ccbf5c11ee2da3bf42b32a';


    public static function setUpBeforeClass(): void
    {
        $items = [
            0 => [
                'history_id' => '104',
                'date' => '2023-08-01 14:01:25',
                'user_nick' => 'rony',
                'action' => 'update',
                'record' => json_encode(strim(<<< JSON
{
    "link": "",
    "pago": "{\"f8bc123029a8aa5211edafba77faa4df\":{\"cheque_pago_id\":\"f8bc123029a8aa5211edafba77faa4df\",\"cheque_id\":\"f8bc123029a8b39a11ed9142334c8c35\",\"fecha\":\"2023-02-18 12:31:32\",\"quantity\":\"3860.50\",\"quantity_total\":\"3860.50\",\"deposit_total\":\"10000.00\",\"ide_amount\":\"0.00\",\"ide_percent\":\"0.00\",\"tarjeta_amount\":\"0.00\",\"tarjeta_percent\":\"0.00\",\"moneda_id\":\"1\",\"tipo_cambio\":\"1.000000\",\"metodo_pago_id\":\"2\",\"banco_cuenta_id\":\"36\",\"banco_cuenta_mov_link_id\":\"f8bc123029a8aa5211edafba77ff5d2e\",\"referencia\":\"SPEI RECIBIDO\",\"comentario\":\"\",\"ultimo_cambio\":\"2023-02-18 12:31:32\",\"ultimo_cambio_por\":\"yolanda_ug\",\"alta_db\":\"2023-02-18 12:31:33\",\"alta_por\":\"yolanda_ug\",\"cuenta_t_mov_id\":\"f8bc123029a8aa5211edafba77fa9b31\",\"vs_doc\":\"\",\"vs_doc_key\":\"\",\"vs_pago_key\":\"\",\"puede_borrar\":\"No\",\"cuentaT_id\":\"82\",\"quantity_ctat\":\"3860.50\",\"numero\":\"1\",\"deposit_fecha\":\"2023-02-18 11:59:16\",\"comision_percent\":\"0.00\",\"comision_amount\":\"0.00\",\"factura\":\"MST\",\"ivacobradox100\":\"0.00\",\"ivacobradototal\":\"0.00\",\"empresa_id\":\"17\",\"factura_numero\":\"\",\"cash_nota_num\":\"NUMERO6\",\"cliente\":\"ROSALIA GABRIELA ROCHA ORTEGA\",\"tienda_id\":\"7\",\"tipo_cash_nota\":\"OTRO\",\"cobra_iva\":\"NO\",\"iva_incluido\":\"NO\",\"numero_referencia\":\"4812\",\"cash_num_cobro_iva\":null,\"activo\":\"Si\",\"origen\":\"CHEQUE\",\"cliente_rfc\":\"\",\"saldo\":\"76490.00\",\"comments\":null,\"revisado\":\"No\",\"autorizado\":\"No\",\"autorizado_por\":null,\"autorizado_el\":null,\"rechazado\":\"No\",\"afecta_cuentat\":\"SI\",\"fecha_capturado\":\"2023-02-18 12:31:32\",\"iva_revisado_por\":null,\"iva_revisado\":\"No\",\"iva_revisado_el\":null,\"MetodoPago\":\"\",\"FormaPago\":\"\",\"UsoCFDI\":\"\",\"CuentadePago\":\"\",\"json_file_attachments\":null,\"cancelacion_revisada\":null,\"cancelacion_revisada_por\":null,\"cancelacion_revisada_el\":null,\"cancelacion_el\":null},\"f8bc123029a8a69811edb9371d19cb72\":{\"cheque_pago_id\":\"f8bc123029a8a69811edb9371d19cb72\",\"cheque_id\":\"f8bc123029a8b39a11ed9142334c8c35\",\"fecha\":\"2023-03-02 14:16:28\",\"quantity\":\"10000.00\",\"quantity_total\":\"10000.00\",\"deposit_total\":\"10000.00\",\"ide_amount\":\"0.00\",\"ide_percent\":\"0.00\",\"tarjeta_amount\":\"0.00\",\"tarjeta_percent\":\"0.00\",\"moneda_id\":\"1\",\"tipo_cambio\":\"1.000000\",\"metodo_pago_id\":\"2\",\"banco_cuenta_id\":\"36\",\"banco_cuenta_mov_link_id\":\"f8bc123029a8a69811edb9371d1e2b4c\",\"referencia\":\"SPEI RECIBIDO\",\"comentario\":\"\",\"ultimo_cambio\":\"2023-03-02 14:16:28\",\"ultimo_cambio_por\":\"yolanda_ug\",\"alta_db\":\"2023-03-02 14:16:28\",\"alta_por\":\"yolanda_ug\",\"cuenta_t_mov_id\":\"f8bc123029a8a69811edb9371d19bc9d\",\"vs_doc\":\"\",\"vs_doc_key\":\"\",\"vs_pago_key\":\"\",\"puede_borrar\":\"No\",\"cuentaT_id\":\"82\",\"quantity_ctat\":\"10000.00\",\"numero\":\"2\",\"deposit_fecha\":\"2023-03-01 09:42:38\",\"comision_percent\":\"0.00\",\"comision_amount\":\"0.00\",\"factura\":\"MST\",\"ivacobradox100\":\"0.00\",\"ivacobradototal\":\"0.00\",\"empresa_id\":\"17\",\"factura_numero\":\"\",\"cash_nota_num\":\"NUMERO6\",\"cliente\":\"ROSALIA GABRIELA ROCHA ORTEGA\",\"tienda_id\":\"7\",\"tipo_cash_nota\":\"OTRO\",\"cobra_iva\":\"NO\",\"iva_incluido\":\"NO\",\"numero_referencia\":\"6032\",\"cash_num_cobro_iva\":null,\"activo\":\"Si\",\"origen\":\"CHEQUE\",\"cliente_rfc\":\"\",\"saldo\":\"66490.00\",\"comments\":null,\"revisado\":\"No\",\"autorizado\":\"No\",\"autorizado_por\":null,\"autorizado_el\":null,\"rechazado\":\"No\",\"afecta_cuentat\":\"SI\",\"fecha_capturado\":\"2023-03-02 14:16:28\",\"iva_revisado_por\":null,\"iva_revisado\":\"No\",\"iva_revisado_el\":null,\"MetodoPago\":\"\",\"FormaPago\":\"\",\"UsoCFDI\":\"\",\"CuentadePago\":\"\",\"json_file_attachments\":null,\"cancelacion_revisada\":null,\"cancelacion_revisada_por\":null,\"cancelacion_revisada_el\":null,\"cancelacion_el\":null},\"f8bc123029a8b5f011edc8d87e8a71ed\":{\"cheque_pago_id\":\"f8bc123029a8b5f011edc8d87e8a71ed\",\"cheque_id\":\"f8bc123029a8b39a11ed9142334c8c35\",\"fecha\":\"2023-03-22 11:39:27\",\"quantity\":\"10000.00\",\"quantity_total\":\"10000.00\",\"deposit_total\":\"10000.00\",\"ide_amount\":\"0.00\",\"ide_percent\":\"0.00\",\"tarjeta_amount\":\"0.00\",\"tarjeta_percent\":\"0.00\",\"moneda_id\":\"1\",\"tipo_cambio\":\"1.000000\",\"metodo_pago_id\":\"2\",\"banco_cuenta_id\":\"19\",\"banco_cuenta_mov_link_id\":\"f8bc123029a8b5f011edc8d87e8d383f\",\"referencia\":\"DEPOSITO EFECTIVO PRACTIC\",\"comentario\":\"\",\"ultimo_cambio\":\"2023-03-22 11:39:27\",\"ultimo_cambio_por\":\"yolanda_ug\",\"alta_db\":\"2023-03-22 11:39:28\",\"alta_por\":\"yolanda_ug\",\"cuenta_t_mov_id\":\"f8bc123029a8b5f011edc8d87e8a682e\",\"vs_doc\":\"\",\"vs_doc_key\":\"\",\"vs_pago_key\":\"\",\"puede_borrar\":\"No\",\"cuentaT_id\":\"82\",\"quantity_ctat\":\"10000.00\",\"numero\":\"3\",\"deposit_fecha\":\"2023-03-21 17:58:26\",\"comision_percent\":\"0.00\",\"comision_amount\":\"0.00\",\"factura\":\"MST\",\"ivacobradox100\":\"0.00\",\"ivacobradototal\":\"0.00\",\"empresa_id\":\"3\",\"factura_numero\":\"\",\"cash_nota_num\":\"NUMERO6\",\"cliente\":\"ROSALIA GABRIELA ROCHA ORTEGA\",\"tienda_id\":\"7\",\"tipo_cash_nota\":\"OTRO\",\"cobra_iva\":\"NO\",\"iva_incluido\":\"NO\",\"numero_referencia\":\"8013\",\"cash_num_cobro_iva\":null,\"activo\":\"Si\",\"origen\":\"CHEQUE\",\"cliente_rfc\":\"\",\"saldo\":\"56490.00\",\"comments\":null,\"revisado\":\"No\",\"autorizado\":\"No\",\"autorizado_por\":null,\"autorizado_el\":null,\"rechazado\":\"No\",\"afecta_cuentat\":\"SI\",\"fecha_capturado\":\"2023-03-22 11:39:27\",\"iva_revisado_por\":null,\"iva_revisado\":\"No\",\"iva_revisado_el\":null,\"MetodoPago\":\"\",\"FormaPago\":\"\",\"UsoCFDI\":\"\",\"CuentadePago\":\"\",\"json_file_attachments\":null,\"cancelacion_revisada\":null,\"cancelacion_revisada_por\":null,\"cancelacion_revisada_el\":null,\"cancelacion_el\":null},\"cc483a12801a951311ede0820c5e9c98\":{\"cheque_pago_id\":\"cc483a12801a951311ede0820c5e9c98\",\"cheque_id\":\"f8bc123029a8b39a11ed9142334c8c35\",\"fecha\":\"2023-04-21 14:21:07\",\"quantity\":\"10000.00\",\"quantity_total\":\"10000.00\",\"deposit_total\":\"10000.00\",\"ide_amount\":\"0.00\",\"ide_percent\":\"0.00\",\"tarjeta_amount\":\"0.00\",\"tarjeta_percent\":\"0.00\",\"moneda_id\":\"1\",\"tipo_cambio\":\"1.000000\",\"metodo_pago_id\":\"2\",\"banco_cuenta_id\":\"36\",\"banco_cuenta_mov_link_id\":\"cc483a12801a951311ede0820c5fb8bf\",\"referencia\":\"SPEI RECIBIDO\",\"comentario\":\"\",\"ultimo_cambio\":\"2023-04-21 14:21:07\",\"ultimo_cambio_por\":\"yolanda_ug\",\"alta_db\":\"2023-04-21 14:21:07\",\"alta_por\":\"yolanda_ug\",\"cuenta_t_mov_id\":\"cc483a12801a951311ede0820c5e9ab6\",\"vs_doc\":\"\",\"vs_doc_key\":\"\",\"vs_pago_key\":\"\",\"puede_borrar\":\"No\",\"cuentaT_id\":\"82\",\"quantity_ctat\":\"10000.00\",\"numero\":\"4\",\"deposit_fecha\":\"2023-04-21 14:03:27\",\"comision_percent\":\"0.00\",\"comision_amount\":\"0.00\",\"factura\":\"MST\",\"ivacobradox100\":\"0.00\",\"ivacobradototal\":\"0.00\",\"empresa_id\":\"17\",\"factura_numero\":\"\",\"cash_nota_num\":\"NUMERO6\",\"cliente\":\"ROSALIA GABRIELA ROCHA ORTEGA\",\"tienda_id\":\"7\",\"tipo_cash_nota\":\"OTRO\",\"cobra_iva\":\"NO\",\"iva_incluido\":\"NO\",\"numero_referencia\":\"11024\",\"cash_num_cobro_iva\":null,\"activo\":\"Si\",\"origen\":\"CHEQUE\",\"cliente_rfc\":\"\",\"saldo\":\"46490.00\",\"comments\":null,\"revisado\":\"No\",\"autorizado\":\"No\",\"autorizado_por\":null,\"autorizado_el\":null,\"rechazado\":\"No\",\"afecta_cuentat\":\"SI\",\"fecha_capturado\":\"2023-04-21 14:21:07\",\"iva_revisado_por\":null,\"iva_revisado\":\"No\",\"iva_revisado_el\":null,\"MetodoPago\":\"\",\"FormaPago\":\"\",\"UsoCFDI\":\"\",\"CuentadePago\":\"\",\"json_file_attachments\":null,\"cancelacion_revisada\":null,\"cancelacion_revisada_por\":null,\"cancelacion_revisada_el\":null,\"cancelacion_el\":null}}",
    "paid": "0",
    "tipo": "NOTA",
    "saldo": "0.00",
    "anexos": null,
    "nombre": null,
    "numero": "6",
    "alta_db": "2023-01-10 17:56:07",
    "borrado": "No",
    "cobrado": "0",
    "esta_en": "user",
    "pending": "0",
    "remarks": "NOTA 6",
    "accepted": "Accepted",
    "alta_por": "mireya",
    "atrasado": "0",
    "banco_id": "0",
    "new_date": null,
    "pago_log": "",
    "quantity": "80350.50",
    "cheque_id": "f8bc123029a8b39a11ed9142334c8c35",
    "delivered": "2023-02-18 12:31:32",
    "moneda_id": "1",
    "paid_when": null,
    "rechazado": "No",
    "tienda_id": "7",
    "abierto_el": null,
    "autorizado": "No",
    "borrado_el": null,
    "cliente_id": "f8bc123029a8bfc111ed9e8f74174cb9",
    "link_table": null,
    "modificado": "0",
    "abierto_por": "",
    "borrado_por": null,
    "remarks_wot": "NOTA 6",
    "ultimo_pago": "2023-04-21 14:21:07",
    "bloqueado_el": null,
    "categoria_id": "2",
    "puede_borrar": "No",
    "tipo_de_tela": null,
    "autorizado_el": null,
    "name_on_check": "",
    "original_date": "2023-01-05",
    "paid_revisado": "No",
    "ultimo_cambio": "2023-08-01 14:01:24",
    "autorizado_por": null,
    "cuentat_mov_id": null,
    "numero_sistema": null,
    "super_atrasado": "0",
    "total_payments": "33860.50",
    "initial_payment": "0.00",
    "desautorizado_el": "2023-08-01 14:01:24",
    "lugar_de_entrada": null,
    "paid_revisado_el": null,
    "primer_delivered": "No",
    "delivered_directo": "1",
    "numero_contenedor": null,
    "origen_cuentat_id": null,
    "paid_revisado_por": null,
    "remarks_bloqueado": "",
    "ultimo_cambio_por": "rony",
    "ultimo_movimiento": "CLIENTE",
    "set_origen_cuentat": "2023-01-10 17:56:07",
    "cliente_proveedor_id": null,
    "puede_origen_cuentat": "No",
    "cuentaT_transferto_id": "1",
    "remarks_bloqueado_por": "",
    "cuentaT_deliveredto_id": "15",
    "remarks_bloqueado_fecha": null,
    "disponible_para_sustituir": "0.00"
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            ],
            1 => [
                'history_id' => '105',
                'date' => '2023-08-01 14:01:29',
                'user_nick' => 'rony',
                'action' => 'update',
                'record' => json_encode(strim(<<< JSON
{
    "link": "",
    "pago": "{\"f8bc123029a8aa5211edafba77faa4df\":{\"cheque_pago_id\":\"f8bc123029a8aa5211edafba77faa4df\",\"cheque_id\":\"f8bc123029a8b39a11ed9142334c8c35\",\"fecha\":\"2023-02-18 12:31:32\",\"quantity\":\"3860.50\",\"quantity_total\":\"3860.50\",\"deposit_total\":\"10000.00\",\"ide_amount\":\"0.00\",\"ide_percent\":\"0.00\",\"tarjeta_amount\":\"0.00\",\"tarjeta_percent\":\"0.00\",\"moneda_id\":\"1\",\"tipo_cambio\":\"1.000000\",\"metodo_pago_id\":\"2\",\"banco_cuenta_id\":\"36\",\"banco_cuenta_mov_link_id\":\"f8bc123029a8aa5211edafba77ff5d2e\",\"referencia\":\"SPEI RECIBIDO\",\"comentario\":\"\",\"ultimo_cambio\":\"2023-02-18 12:31:32\",\"ultimo_cambio_por\":\"yolanda_ug\",\"alta_db\":\"2023-02-18 12:31:33\",\"alta_por\":\"yolanda_ug\",\"cuenta_t_mov_id\":\"f8bc123029a8aa5211edafba77fa9b31\",\"vs_doc\":\"\",\"vs_doc_key\":\"\",\"vs_pago_key\":\"\",\"puede_borrar\":\"No\",\"cuentaT_id\":\"82\",\"quantity_ctat\":\"3860.50\",\"numero\":\"1\",\"deposit_fecha\":\"2023-02-18 11:59:16\",\"comision_percent\":\"0.00\",\"comision_amount\":\"0.00\",\"factura\":\"MST\",\"ivacobradox100\":\"0.00\",\"ivacobradototal\":\"0.00\",\"empresa_id\":\"17\",\"factura_numero\":\"\",\"cash_nota_num\":\"NUMERO6\",\"cliente\":\"ROSALIA GABRIELA ROCHA ORTEGA\",\"tienda_id\":\"7\",\"tipo_cash_nota\":\"OTRO\",\"cobra_iva\":\"NO\",\"iva_incluido\":\"NO\",\"numero_referencia\":\"4812\",\"cash_num_cobro_iva\":null,\"activo\":\"Si\",\"origen\":\"CHEQUE\",\"cliente_rfc\":\"\",\"saldo\":\"76490.00\",\"comments\":null,\"revisado\":\"No\",\"autorizado\":\"No\",\"autorizado_por\":null,\"autorizado_el\":null,\"rechazado\":\"No\",\"afecta_cuentat\":\"SI\",\"fecha_capturado\":\"2023-02-18 12:31:32\",\"iva_revisado_por\":null,\"iva_revisado\":\"No\",\"iva_revisado_el\":null,\"MetodoPago\":\"\",\"FormaPago\":\"\",\"UsoCFDI\":\"\",\"CuentadePago\":\"\",\"json_file_attachments\":null,\"cancelacion_revisada\":null,\"cancelacion_revisada_por\":null,\"cancelacion_revisada_el\":null,\"cancelacion_el\":null},\"f8bc123029a8a69811edb9371d19cb72\":{\"cheque_pago_id\":\"f8bc123029a8a69811edb9371d19cb72\",\"cheque_id\":\"f8bc123029a8b39a11ed9142334c8c35\",\"fecha\":\"2023-03-02 14:16:28\",\"quantity\":\"10000.00\",\"quantity_total\":\"10000.00\",\"deposit_total\":\"10000.00\",\"ide_amount\":\"0.00\",\"ide_percent\":\"0.00\",\"tarjeta_amount\":\"0.00\",\"tarjeta_percent\":\"0.00\",\"moneda_id\":\"1\",\"tipo_cambio\":\"1.000000\",\"metodo_pago_id\":\"2\",\"banco_cuenta_id\":\"36\",\"banco_cuenta_mov_link_id\":\"f8bc123029a8a69811edb9371d1e2b4c\",\"referencia\":\"SPEI RECIBIDO\",\"comentario\":\"\",\"ultimo_cambio\":\"2023-03-02 14:16:28\",\"ultimo_cambio_por\":\"yolanda_ug\",\"alta_db\":\"2023-03-02 14:16:28\",\"alta_por\":\"yolanda_ug\",\"cuenta_t_mov_id\":\"f8bc123029a8a69811edb9371d19bc9d\",\"vs_doc\":\"\",\"vs_doc_key\":\"\",\"vs_pago_key\":\"\",\"puede_borrar\":\"No\",\"cuentaT_id\":\"82\",\"quantity_ctat\":\"10000.00\",\"numero\":\"2\",\"deposit_fecha\":\"2023-03-01 09:42:38\",\"comision_percent\":\"0.00\",\"comision_amount\":\"0.00\",\"factura\":\"MST\",\"ivacobradox100\":\"0.00\",\"ivacobradototal\":\"0.00\",\"empresa_id\":\"17\",\"factura_numero\":\"\",\"cash_nota_num\":\"NUMERO6\",\"cliente\":\"ROSALIA GABRIELA ROCHA ORTEGA\",\"tienda_id\":\"7\",\"tipo_cash_nota\":\"OTRO\",\"cobra_iva\":\"NO\",\"iva_incluido\":\"NO\",\"numero_referencia\":\"6032\",\"cash_num_cobro_iva\":null,\"activo\":\"Si\",\"origen\":\"CHEQUE\",\"cliente_rfc\":\"\",\"saldo\":\"66490.00\",\"comments\":null,\"revisado\":\"No\",\"autorizado\":\"No\",\"autorizado_por\":null,\"autorizado_el\":null,\"rechazado\":\"No\",\"afecta_cuentat\":\"SI\",\"fecha_capturado\":\"2023-03-02 14:16:28\",\"iva_revisado_por\":null,\"iva_revisado\":\"No\",\"iva_revisado_el\":null,\"MetodoPago\":\"\",\"FormaPago\":\"\",\"UsoCFDI\":\"\",\"CuentadePago\":\"\",\"json_file_attachments\":null,\"cancelacion_revisada\":null,\"cancelacion_revisada_por\":null,\"cancelacion_revisada_el\":null,\"cancelacion_el\":null},\"f8bc123029a8b5f011edc8d87e8a71ed\":{\"cheque_pago_id\":\"f8bc123029a8b5f011edc8d87e8a71ed\",\"cheque_id\":\"f8bc123029a8b39a11ed9142334c8c35\",\"fecha\":\"2023-03-22 11:39:27\",\"quantity\":\"10000.00\",\"quantity_total\":\"10000.00\",\"deposit_total\":\"10000.00\",\"ide_amount\":\"0.00\",\"ide_percent\":\"0.00\",\"tarjeta_amount\":\"0.00\",\"tarjeta_percent\":\"0.00\",\"moneda_id\":\"1\",\"tipo_cambio\":\"1.000000\",\"metodo_pago_id\":\"2\",\"banco_cuenta_id\":\"19\",\"banco_cuenta_mov_link_id\":\"f8bc123029a8b5f011edc8d87e8d383f\",\"referencia\":\"DEPOSITO EFECTIVO PRACTIC\",\"comentario\":\"\",\"ultimo_cambio\":\"2023-03-22 11:39:27\",\"ultimo_cambio_por\":\"yolanda_ug\",\"alta_db\":\"2023-03-22 11:39:28\",\"alta_por\":\"yolanda_ug\",\"cuenta_t_mov_id\":\"f8bc123029a8b5f011edc8d87e8a682e\",\"vs_doc\":\"\",\"vs_doc_key\":\"\",\"vs_pago_key\":\"\",\"puede_borrar\":\"No\",\"cuentaT_id\":\"82\",\"quantity_ctat\":\"10000.00\",\"numero\":\"3\",\"deposit_fecha\":\"2023-03-21 17:58:26\",\"comision_percent\":\"0.00\",\"comision_amount\":\"0.00\",\"factura\":\"MST\",\"ivacobradox100\":\"0.00\",\"ivacobradototal\":\"0.00\",\"empresa_id\":\"3\",\"factura_numero\":\"\",\"cash_nota_num\":\"NUMERO6\",\"cliente\":\"ROSALIA GABRIELA ROCHA ORTEGA\",\"tienda_id\":\"7\",\"tipo_cash_nota\":\"OTRO\",\"cobra_iva\":\"NO\",\"iva_incluido\":\"NO\",\"numero_referencia\":\"8013\",\"cash_num_cobro_iva\":null,\"activo\":\"Si\",\"origen\":\"CHEQUE\",\"cliente_rfc\":\"\",\"saldo\":\"56490.00\",\"comments\":null,\"revisado\":\"No\",\"autorizado\":\"No\",\"autorizado_por\":null,\"autorizado_el\":null,\"rechazado\":\"No\",\"afecta_cuentat\":\"SI\",\"fecha_capturado\":\"2023-03-22 11:39:27\",\"iva_revisado_por\":null,\"iva_revisado\":\"No\",\"iva_revisado_el\":null,\"MetodoPago\":\"\",\"FormaPago\":\"\",\"UsoCFDI\":\"\",\"CuentadePago\":\"\",\"json_file_attachments\":null,\"cancelacion_revisada\":null,\"cancelacion_revisada_por\":null,\"cancelacion_revisada_el\":null,\"cancelacion_el\":null},\"cc483a12801a951311ede0820c5e9c98\":{\"cheque_pago_id\":\"cc483a12801a951311ede0820c5e9c98\",\"cheque_id\":\"f8bc123029a8b39a11ed9142334c8c35\",\"fecha\":\"2023-04-21 14:21:07\",\"quantity\":\"10000.00\",\"quantity_total\":\"10000.00\",\"deposit_total\":\"10000.00\",\"ide_amount\":\"0.00\",\"ide_percent\":\"0.00\",\"tarjeta_amount\":\"0.00\",\"tarjeta_percent\":\"0.00\",\"moneda_id\":\"1\",\"tipo_cambio\":\"1.000000\",\"metodo_pago_id\":\"2\",\"banco_cuenta_id\":\"36\",\"banco_cuenta_mov_link_id\":\"cc483a12801a951311ede0820c5fb8bf\",\"referencia\":\"SPEI RECIBIDO\",\"comentario\":\"\",\"ultimo_cambio\":\"2023-04-21 14:21:07\",\"ultimo_cambio_por\":\"yolanda_ug\",\"alta_db\":\"2023-04-21 14:21:07\",\"alta_por\":\"yolanda_ug\",\"cuenta_t_mov_id\":\"cc483a12801a951311ede0820c5e9ab6\",\"vs_doc\":\"\",\"vs_doc_key\":\"\",\"vs_pago_key\":\"\",\"puede_borrar\":\"No\",\"cuentaT_id\":\"82\",\"quantity_ctat\":\"10000.00\",\"numero\":\"4\",\"deposit_fecha\":\"2023-04-21 14:03:27\",\"comision_percent\":\"0.00\",\"comision_amount\":\"0.00\",\"factura\":\"MST\",\"ivacobradox100\":\"0.00\",\"ivacobradototal\":\"0.00\",\"empresa_id\":\"17\",\"factura_numero\":\"\",\"cash_nota_num\":\"NUMERO6\",\"cliente\":\"ROSALIA GABRIELA ROCHA ORTEGA\",\"tienda_id\":\"7\",\"tipo_cash_nota\":\"OTRO\",\"cobra_iva\":\"NO\",\"iva_incluido\":\"NO\",\"numero_referencia\":\"11024\",\"cash_num_cobro_iva\":null,\"activo\":\"Si\",\"origen\":\"CHEQUE\",\"cliente_rfc\":\"\",\"saldo\":\"46490.00\",\"comments\":null,\"revisado\":\"No\",\"autorizado\":\"No\",\"autorizado_por\":null,\"autorizado_el\":null,\"rechazado\":\"No\",\"afecta_cuentat\":\"SI\",\"fecha_capturado\":\"2023-04-21 14:21:07\",\"iva_revisado_por\":null,\"iva_revisado\":\"No\",\"iva_revisado_el\":null,\"MetodoPago\":\"\",\"FormaPago\":\"\",\"UsoCFDI\":\"\",\"CuentadePago\":\"\",\"json_file_attachments\":null,\"cancelacion_revisada\":null,\"cancelacion_revisada_por\":null,\"cancelacion_revisada_el\":null,\"cancelacion_el\":null}}",
    "paid": "0",
    "tipo": "NOTA",
    "saldo": "0.00",
    "anexos": null,
    "nombre": null,
    "numero": "6",
    "alta_db": "2023-01-10 17:56:07",
    "borrado": "No",
    "cobrado": "0",
    "esta_en": "user",
    "pending": "0",
    "remarks": "NOTA 6",
    "accepted": "Accepted",
    "alta_por": "mireya",
    "atrasado": "0",
    "banco_id": "0",
    "new_date": null,
    "pago_log": "",
    "quantity": "80350.50",
    "cheque_id": "f8bc123029a8b39a11ed9142334c8c35",
    "delivered": "2023-02-18 12:31:32",
    "moneda_id": "1",
    "paid_when": null,
    "rechazado": "No",
    "tienda_id": "7",
    "abierto_el": null,
    "autorizado": "No",
    "borrado_el": null,
    "cliente_id": "f8bc123029a8bfc111ed9e8f74174cb9",
    "link_table": null,
    "modificado": "0",
    "abierto_por": "",
    "borrado_por": null,
    "remarks_wot": "NOTA 6",
    "ultimo_pago": "2023-04-21 14:21:07",
    "bloqueado_el": null,
    "categoria_id": "2",
    "puede_borrar": "No",
    "tipo_de_tela": null,
    "autorizado_el": null,
    "name_on_check": "No name",
    "original_date": "2023-01-05",
    "paid_revisado": "No",
    "ultimo_cambio": "2023-08-01 14:01:29",
    "autorizado_por": null,
    "cuentat_mov_id": null,
    "numero_sistema": null,
    "super_atrasado": "0",
    "total_payments": "33860.50",
    "initial_payment": "0.00",
    "desautorizado_el": "2023-08-01 14:01:24",
    "lugar_de_entrada": null,
    "paid_revisado_el": null,
    "primer_delivered": "No",
    "delivered_directo": "1",
    "numero_contenedor": null,
    "origen_cuentat_id": null,
    "paid_revisado_por": null,
    "remarks_bloqueado": "",
    "ultimo_cambio_por": "rony",
    "ultimo_movimiento": "CLIENTE",
    "set_origen_cuentat": "2023-01-10 17:56:07",
    "cliente_proveedor_id": null,
    "puede_origen_cuentat": "No",
    "cuentaT_transferto_id": "1",
    "remarks_bloqueado_por": "",
    "cuentaT_deliveredto_id": "15",
    "remarks_bloqueado_fecha": null,
    "disponible_para_sustituir": "0.00"
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            ],
        ];
        $_id = self::ID;
        $action = "test";
        $motive = '';
        $cheque_table = 'cheque_hist';
        $pagare_table = 'pagare_hist';
        $vale_table = 'vale_hist';

        $insertValues = [
            'action' => $action,
            'motive' => $motive,
            'pk' => $_id,
            'user_nick' => empty($user_nick) ? $_SESSION['usuario'] : $user_nick,
            'date' => 'NOW()'
        ];

        $select_item = ia_singleton("SELECT * FROM `cheque_hist` WHERE pk=" .strit($_id));
        if(!empty($select_item)) {
            $sql = "DELETE FROM cheque_hist WHERE pk = ".strit($_id);
            $ok = ia_query($sql,true,false);
        }

        foreach($items as $item){
            $insertValues['record'] = $item["record"];
            $_sql[] = ia_insert($cheque_table,$insertValues);
            ia_transaction($_sql);
        }


        $pagare_items = [
            0 => [
                'history_id' => '11',
                'date' => '2023-08-01 19:18:53',
                'user_nick' => 'rony',
                'action' => 'update',
                'record' => json_encode(strim(<<< JSON
{
    "link": "",
    "pago": "",
    "paid": "0",
    "tipo": "",
    "saldo": "0.00",
    "anexos": null,
    "nombre": null,
    "numero": "1032",
    "alta_db": "2023-07-17 10:32:53",
    "borrado": "No",
    "cobrado": "0",
    "esta_en": "user",
    "pending": "0",
    "remarks": "MRSU5293546     925 ROLLOS     SPORT TOK<br />23,665.5 kg  x  2.93  = <strong>$69,339.92</strong>",
    "accepted": "Accepted",
    "alta_por": "nancy_gt",
    "atrasado": "0",
    "banco_id": "0",
    "new_date": null,
    "pago_log": "",
    "quantity": "69339.92",
    "delivered": "2023-07-17 10:32:53",
    "moneda_id": "2",
    "pagare_id": "cc483a12801ab56811ee24bef85cfc08",
    "paid_when": null,
    "rechazado": "No",
    "tienda_id": "3",
    "abierto_el": null,
    "autorizado": "Si",
    "borrado_el": null,
    "cliente_id": "00226bbf3f60ba6f11e2cef3625846f2",
    "link_table": null,
    "modificado": "0",
    "abierto_por": "",
    "borrado_por": null,
    "remarks_wot": "MRSU5293546     925 ROLLOS     SPORT TOK23,665.5 kg  x  2.93  = $69,339.92",
    "ultimo_pago": null,
    "bloqueado_el": null,
    "categoria_id": "2",
    "deliverd_log": "
17/Jul/23  10:32 nancy_gt pone deliverd to nancy_gt, esperando acepte, y lo acepta él mismo",
    "puede_borrar": "No",
    "tipo_de_tela": null,
    "autorizado_el": "2023-07-17 14:24:26",
    "html_verified": "",
    "name_on_check": "",
    "original_date": "2023-07-17",
    "paid_revisado": "No",
    "ultimo_cambio": "2023-08-01 19:18:53",
    "autorizado_por": "rony",
    "cuentat_mov_id": null,
    "numero_sistema": null,
    "super_atrasado": "0",
    "total_payments": "0.00",
    "initial_payment": "0.00",
    "desautorizado_el": null,
    "lugar_de_entrada": null,
    "paid_revisado_el": null,
    "primer_delivered": "No",
    "delivered_directo": "0",
    "numero_contenedor": null,
    "origen_cuentat_id": null,
    "paid_revisado_por": null,
    "remarks_bloqueado": "No",
    "ultimo_cambio_por": "rony",
    "ultimo_movimiento": "ALTA",
    "set_origen_cuentat": "2023-07-17 10:32:53",
    "cliente_proveedor_id": null,
    "puede_origen_cuentat": "Si",
    "cuentaT_transferto_id": "128",
    "remarks_bloqueado_por": "",
    "cuentaT_deliveredto_id": "128",
    "remarks_bloqueado_fecha": null,
    "disponible_para_sustituir": "0.00"
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            ],
            1 => [
                'history_id' => '12',
                'date' => '2023-08-01 19:18:57',
                'user_nick' => 'rony',
                'action' => 'update',
                'record' => json_encode(strim(<<< JSON
{
    "link": "",
    "pago": "",
    "paid": "0",
    "tipo": "",
    "saldo": "0.00",
    "anexos": null,
    "nombre": null,
    "numero": "1032",
    "alta_db": "2023-07-17 10:32:53",
    "borrado": "No",
    "cobrado": "0",
    "esta_en": "user",
    "pending": "0",
    "remarks": "MRSU5293546     925 ROLLOS     SPORT TOK<br />23,665.5 kg  x  2.93  = <strong>$69,339.92</strong>",
    "accepted": "Accepted",
    "alta_por": "nancy_gt",
    "atrasado": "0",
    "banco_id": "0",
    "new_date": null,
    "pago_log": "",
    "quantity": "69339.92",
    "delivered": "2023-07-17 10:32:53",
    "moneda_id": "2",
    "pagare_id": "cc483a12801ab56811ee24bef85cfc08",
    "paid_when": null,
    "rechazado": "No",
    "tienda_id": "3",
    "abierto_el": null,
    "autorizado": "Si",
    "borrado_el": null,
    "cliente_id": "00226bbf3f60ba6f11e2cef3625846f2",
    "link_table": null,
    "modificado": "0",
    "abierto_por": "",
    "borrado_por": null,
    "remarks_wot": "MRSU5293546     925 ROLLOS     SPORT TOK23,665.5 kg  x  2.93  = $69,339.92",
    "ultimo_pago": null,
    "bloqueado_el": null,
    "categoria_id": "2",
    "deliverd_log": "
17/Jul/23  10:32 nancy_gt pone deliverd to nancy_gt, esperando acepte, y lo acepta él mismo",
    "puede_borrar": "No",
    "tipo_de_tela": null,
    "autorizado_el": "2023-07-17 14:24:26",
    "html_verified": "",
    "name_on_check": "",
    "original_date": "2023-07-17",
    "paid_revisado": "No",
    "ultimo_cambio": "2023-08-01 19:18:57",
    "autorizado_por": "rony",
    "cuentat_mov_id": null,
    "numero_sistema": null,
    "super_atrasado": "0",
    "total_payments": "0.00",
    "initial_payment": "0.00",
    "desautorizado_el": null,
    "lugar_de_entrada": null,
    "paid_revisado_el": null,
    "primer_delivered": "No",
    "delivered_directo": "0",
    "numero_contenedor": null,
    "origen_cuentat_id": null,
    "paid_revisado_por": null,
    "remarks_bloqueado": "No",
    "ultimo_cambio_por": "rony",
    "ultimo_movimiento": "ALTA",
    "set_origen_cuentat": "2023-07-17 10:32:53",
    "cliente_proveedor_id": null,
    "puede_origen_cuentat": "Si",
    "cuentaT_transferto_id": "128",
    "remarks_bloqueado_por": "",
    "cuentaT_deliveredto_id": "128",
    "remarks_bloqueado_fecha": null,
    "disponible_para_sustituir": "0.00"
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            ],
            2 => [
                'history_id' => '13',
                'date' => '2023-08-01 19:19:08',
                'user_nick' => 'rony',
                'action' => 'update',
                'record' => json_encode(strim(<<< JSON
{
    "link": "",
    "pago": "",
    "paid": "0",
    "tipo": "",
    "saldo": "0.00",
    "anexos": null,
    "nombre": null,
    "numero": "1032",
    "alta_db": "2023-07-17 10:32:53",
    "borrado": "No",
    "cobrado": "0",
    "esta_en": "user",
    "pending": "0",
    "remarks": "MRSU5293546     925 ROLLOS     SPORT TOK<br />23,665.5 kg  x  2.93  = <strong>$69,339.92</strong>",
    "accepted": "Accepted",
    "alta_por": "nancy_gt",
    "atrasado": "0",
    "banco_id": "0",
    "new_date": null,
    "pago_log": "",
    "quantity": "69339.92",
    "delivered": "2023-07-17 10:32:53",
    "moneda_id": "2",
    "pagare_id": "cc483a12801ab56811ee24bef85cfc08",
    "paid_when": null,
    "rechazado": "No",
    "tienda_id": "8",
    "abierto_el": null,
    "autorizado": "Si",
    "borrado_el": null,
    "cliente_id": "00226bbf3f60ba6f11e2cef3625846f2",
    "link_table": null,
    "modificado": "0",
    "abierto_por": "",
    "borrado_por": null,
    "remarks_wot": "MRSU5293546     925 ROLLOS     SPORT TOK23,665.5 kg  x  2.93  = $69,339.92",
    "ultimo_pago": null,
    "bloqueado_el": null,
    "categoria_id": "2",
    "deliverd_log": "
17/Jul/23  10:32 nancy_gt pone deliverd to nancy_gt, esperando acepte, y lo acepta él mismo",
    "puede_borrar": "No",
    "tipo_de_tela": null,
    "autorizado_el": "2023-07-17 14:24:26",
    "html_verified": "",
    "name_on_check": "",
    "original_date": "2023-07-17",
    "paid_revisado": "No",
    "ultimo_cambio": "2023-08-01 19:19:08",
    "autorizado_por": "rony",
    "cuentat_mov_id": null,
    "numero_sistema": null,
    "super_atrasado": "0",
    "total_payments": "0.00",
    "initial_payment": "0.00",
    "desautorizado_el": null,
    "lugar_de_entrada": null,
    "paid_revisado_el": null,
    "primer_delivered": "No",
    "delivered_directo": "0",
    "numero_contenedor": null,
    "origen_cuentat_id": null,
    "paid_revisado_por": null,
    "remarks_bloqueado": "No",
    "ultimo_cambio_por": "rony",
    "ultimo_movimiento": "ALTA",
    "set_origen_cuentat": "2023-07-17 10:32:53",
    "cliente_proveedor_id": null,
    "puede_origen_cuentat": "Si",
    "cuentaT_transferto_id": "128",
    "remarks_bloqueado_por": "",
    "cuentaT_deliveredto_id": "128",
    "remarks_bloqueado_fecha": null,
    "disponible_para_sustituir": "0.00"
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            ],
        ];
        $_id = 'cc483a12801ab56811ee24bef85cfc08';
        $insert_pagare_values = [
            'action' => $action,
            'motive' => $motive,
            'pk' => $_id,
            'user_nick' => empty($user_nick) ? $_SESSION['usuario'] : $user_nick,
            'date' => 'NOW()'
        ];

        $select_item = ia_singleton("SELECT * FROM `pagare_hist` WHERE pk=" .strit($_id));
        if(!empty($select_item)) {
            $sql = "DELETE FROM pagare_hist WHERE pk = ".strit($_id);
            $ok = ia_query($sql,true,false);
        }

        foreach($pagare_items as $pagare_item){
            $insert_pagare_values['record'] = $pagare_item["record"];
            $_sql[] = ia_insert($pagare_table,$insert_pagare_values);
            ia_transaction($_sql);
        }


        $vale_id = self::VALE_ID;
        $vale_items = [
            0 => [
                'history_id' => '1',
                'date' => '2023-07-28 19:06:28',
                'user_nick' => 'rony',
                'action' => 'insert',
                'record' => json_encode(strim(<<< JSON
{
    "pago": "",
    "paid": "0",
    "tipo": "",
    "fecha": "2023-07-28 19:06:27",
    "saldo": "0.00",
    "anexos": null,
    "origen": "VALE",
    "UsoCFDI": null,
    "abierto": "0",
    "alta_db": "2023-07-28 19:06:27",
    "borrado": "No",
    "cliente": "",
    "factura": "",
    "pending": "0",
    "remarks": null,
    "vale_id": "54bf6469e2ccbf5c11ee2da3bf42b32a",
    "alta_por": "rony",
    "aplicado": "0",
    "comments": null,
    "devuelto": "0",
    "pago_log": "",
    "quantity": "1000.00",
    "revisado": "No",
    "FormaPago": null,
    "cancelado": "0",
    "cobra_iva": null,
    "moneda_id": "1",
    "paid_when": null,
    "rechazado": "No",
    "tienda_id": "1",
    "MetodoPago": null,
    "abierto_el": null,
    "autorizado": "No",
    "borrado_el": null,
    "cliente_id": "f8bc123029a8bfc111ed9e8f74174cb9",
    "comentario": null,
    "cuentaT_id": "1",
    "empresa_id": null,
    "extraviado": "0",
    "ide_amount": "0.00",
    "pagosVales": null,
    "referencia": null,
    "abierto_por": "",
    "borrado_por": null,
    "cliente_rfc": null,
    "ide_percent": "0.00",
    "remarks_wot": null,
    "tipo_cambio": "1.000000",
    "ultimo_pago": null,
    "vale_number": "1952",
    "CuentadePago": null,
    "bloqueado_el": null,
    "categoria_id": "2",
    "iva_incluido": "NO",
    "iva_revisado": "No",
    "puede_borrar": "Si",
    "tipo_de_tela": null,
    "autorizado_el": null,
    "cash_nota_num": null,
    "deposit_fecha": "0000-00-00",
    "deposit_total": "0.00",
    "html_verified": "",
    "paid_revisado": "No",
    "ultimo_cambio": "2023-07-28 19:06:27",
    "afecta_cuentat": "SI",
    "autorizado_por": null,
    "cancelacion_el": null,
    "factura_numero": null,
    "ivacobradox100": "0.00",
    "metodo_pago_id": "1",
    "numero_sistema": null,
    "quantity_total": "1000.00",
    "tarjeta_amount": "0.00",
    "tipo_cash_nota": null,
    "total_payments": "0.00",
    "banco_cuenta_id": null,
    "cliente_de_paso": "0",
    "comision_amount": "0.00",
    "cuenta_t_mov_id": "54bf6469e2ccbf5c11ee2da3c3a65346",
    "deposit_cliente": null,
    "fecha_capturado": "2023-07-28 19:06:27",
    "iva_revisado_el": null,
    "ivacobradototal": "0.00",
    "tarjeta_percent": "0.00",
    "comision_percent": "0.00",
    "desautorizado_el": null,
    "entregado_a_rony": "0",
    "iva_revisado_por": null,
    "lugar_de_entrada": null,
    "paid_revisado_el": null,
    "numero_contenedor": null,
    "numero_referencia": null,
    "paid_revisado_por": null,
    "quantity_recibido": "1000.00",
    "recibido_por_rony": "0",
    "remarks_bloqueado": "No",
    "ultimo_cambio_por": "rony",
    "ultimo_movimiento": "ALTA",
    "cash_num_cobro_iva": null,
    "recibido_moneda_id": "1",
    "cancelacion_revisada": null,
    "conversion_monto_usd": "0.00",
    "dinero_en_cuentaT_id": "1",
    "json_file_attachments": null,
    "quantity_recibido_usd": "0.00",
    "remarks_bloqueado_por": "",
    "conversion_tipo_cambio": "0.00000",
    "cancelacion_revisada_el": null,
    "remarks_bloqueado_fecha": null,
    "banco_cuenta_mov_link_id": "",
    "cancelacion_revisada_por": null,
    "conversion_ultimo_cambio": null,
    "conversion_fuera_de_rango": null,
    "puede_cambiar_tipo_cambio": "Si",
    "conversion_ultimo_cambio_por": ""
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            ],
            1 => [
                'history_id' => '3',
                'date' => '2023-07-31 11:44:51',
                'user_nick' => 'rony',
                'action' => 'delete',
                'record' => json_encode(strim(<<< JSON
{
    "pago": "",
    "paid": "0",
    "tipo": "",
    "fecha": "2023-07-28 19:06:27",
    "saldo": "0.00",
    "anexos": null,
    "origen": "VALE",
    "UsoCFDI": null,
    "abierto": "0",
    "alta_db": "2023-07-28 19:06:27",
    "borrado": "No",
    "cliente": "",
    "factura": "",
    "pending": "0",
    "remarks": null,
    "vale_id": "54bf6469e2ccbf5c11ee2da3bf42b32a",
    "alta_por": "rony",
    "aplicado": "0",
    "comments": null,
    "devuelto": "0",
    "pago_log": "",
    "quantity": "1000.00",
    "revisado": "No",
    "FormaPago": null,
    "cancelado": "0",
    "cobra_iva": null,
    "moneda_id": "1",
    "paid_when": null,
    "rechazado": "No",
    "tienda_id": "1",
    "MetodoPago": null,
    "abierto_el": null,
    "autorizado": "No",
    "borrado_el": null,
    "cliente_id": "f8bc123029a8bfc111ed9e8f74174cb9",
    "comentario": null,
    "cuentaT_id": "1",
    "empresa_id": null,
    "extraviado": "0",
    "ide_amount": "0.00",
    "pagosVales": null,
    "referencia": null,
    "abierto_por": "",
    "borrado_por": null,
    "cliente_rfc": null,
    "ide_percent": "0.00",
    "remarks_wot": null,
    "tipo_cambio": "1.000000",
    "ultimo_pago": null,
    "vale_number": "1952",
    "CuentadePago": null,
    "bloqueado_el": null,
    "categoria_id": "2",
    "iva_incluido": "NO",
    "iva_revisado": "No",
    "puede_borrar": "Si",
    "tipo_de_tela": null,
    "autorizado_el": null,
    "cash_nota_num": null,
    "deposit_fecha": "0000-00-00",
    "deposit_total": "0.00",
    "html_verified": "",
    "paid_revisado": "No",
    "ultimo_cambio": "2023-07-28 19:06:27",
    "afecta_cuentat": "SI",
    "autorizado_por": null,
    "cancelacion_el": null,
    "factura_numero": null,
    "ivacobradox100": "0.00",
    "metodo_pago_id": "1",
    "numero_sistema": null,
    "quantity_total": "1000.00",
    "tarjeta_amount": "0.00",
    "tipo_cash_nota": null,
    "total_payments": "0.00",
    "banco_cuenta_id": null,
    "cliente_de_paso": "0",
    "comision_amount": "0.00",
    "cuenta_t_mov_id": "54bf6469e2ccbf5c11ee2da3c3a65346",
    "deposit_cliente": null,
    "fecha_capturado": "2023-07-28 19:06:27",
    "iva_revisado_el": null,
    "ivacobradototal": "0.00",
    "tarjeta_percent": "0.00",
    "comision_percent": "0.00",
    "desautorizado_el": null,
    "entregado_a_rony": "0",
    "iva_revisado_por": null,
    "lugar_de_entrada": null,
    "paid_revisado_el": null,
    "numero_contenedor": null,
    "numero_referencia": null,
    "paid_revisado_por": null,
    "quantity_recibido": "1000.00",
    "recibido_por_rony": "0",
    "remarks_bloqueado": "No",
    "ultimo_cambio_por": "rony",
    "ultimo_movimiento": "ALTA",
    "cash_num_cobro_iva": null,
    "recibido_moneda_id": "1",
    "cancelacion_revisada": null,
    "conversion_monto_usd": "0.00",
    "dinero_en_cuentaT_id": "1",
    "json_file_attachments": null,
    "quantity_recibido_usd": "0.00",
    "remarks_bloqueado_por": "",
    "conversion_tipo_cambio": "0.00000",
    "cancelacion_revisada_el": null,
    "remarks_bloqueado_fecha": null,
    "banco_cuenta_mov_link_id": "",
    "cancelacion_revisada_por": null,
    "conversion_ultimo_cambio": null,
    "conversion_fuera_de_rango": null,
    "puede_cambiar_tipo_cambio": "Si",
    "conversion_ultimo_cambio_por": ""
}
JSON), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
            ],
        ];

        $insert_vale_values = [
            'action' => $action,
            'motive' => $motive,
            'pk' => $vale_id,
            'user_nick' => empty($user_nick) ? $_SESSION['usuario'] : $user_nick,
            'date' => 'NOW()'
        ];

        $select_item = ia_singleton("SELECT * FROM `vale_hist` WHERE pk=" .strit($vale_id));
        if(!empty($select_item)) {
            $sql = "DELETE FROM vale_hist WHERE pk = ".strit($vale_id);
            $ok = ia_query($sql,true,false);
        }

        foreach($vale_items as $vale_item){
            $insert_vale_values['record'] = $vale_item["record"];
            $_sql[] = ia_insert($vale_table,$insert_vale_values);
            ia_transaction($_sql);
        }


        /* insertar chueque a base de datos ++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
        $cheque_id = self::ID;
        $cheque = [
            'cheque_id' => $cheque_id,
            'cliente_id' => '74867af2fe60824211e4588d0c589616',
            'cliente_proveedor_id' => NULL,
            'name_on_check' => 'No name',
            'nombre' => 'FIAT TEXTIL',
            'tienda_id' => '2',
            'quantity' => '132753.60',
            'moneda_id' => '1',
            'numero' => '0212',
            'banco_id' => '1',
            'original_date' => '2023-07-10',
            'new_date' => NULL,
            'atrasado' => '0',
            'paid' => '0',
            'super_atrasado' => '0',
            'pending' => '0',
            'modificado' => '0',
            'cobrado' => '0',
            'link_table' => NULL,
            'link' => '',
            'initial_payment' => '0.00',
            'total_payments' => '100.00',
            'disponible_para_sustituir' => '0.00',
            'cuentaT_deliveredto_id' => '71',
            'esta_en' => 'user',
            'cuentaT_transferto_id' => '71',
            'remarks' => 'CASH 6974<br />IVA 8%',
            'anexos' => NULL,
            'ultimo_cambio' => '2023-07-31 15:16:07',
            'ultimo_cambio_por' => 'rony',
            'alta_db' => '2023-06-23 16:47:12',
            'alta_por' => 'betty',
            'origen_cuentat_id' => '13',
            'accepted' => 'Accepted',
            'deliverd_log' => '29/Jun/23  18:13 mireya pone Accept, queda delivered to mireya 23/Jun/23  16:47 betty pone deliverd to mireya, esperando acepte',
            'delivered' => '2023-06-23 16:47:12',
            'puede_origen_cuentat' => 'No',
            'set_origen_cuentat' => '2023-06-23 16:47:12',
            'puede_borrar' => 'No',
            'primer_delivered' => 'No',
            'delivered_directo' => '0',
            'abierto_por' => 'rony',
            'abierto_el' => '2023-08-02 12:38:52',
            'paid_when' => NULL,
            'autorizado' => 'Si',
            'autorizado_por' => 'rony',
            'autorizado_el' => '2023-06-23 18:57:05',
            'borrado' => 'No',
            'borrado_por' => NULL,
            'borrado_el' => NULL,
            'numero_sistema' => NULL,
            'numero_contenedor' => NULL,
            'tipo_de_tela' => NULL,
            'lugar_de_entrada' => NULL,
            'ultimo_movimiento' => 'ALTA',
            'desautorizado_el' => NULL,
            'categoria_id' => '2',
            'remarks_wot' => 'CASH 6974IVA 8%',
            'saldo' => '0.00',
            'paid_revisado' => 'No',
            'paid_revisado_por' => NULL,
            'paid_revisado_el' => NULL,
            'cuentat_mov_id' => 'cc483a12801ab9ba11ee1217e466c2ae',
            'rechazado' => 'No',
            'tipo' => '',
            'ultimo_pago' => '2023-07-31 14:39:39',
            'html_verified' => '',
            'bloqueado_el' => NULL,
            'remarks_bloqueado' => 'No',
            'remarks_bloqueado_fecha' => NULL,
            'remarks_bloqueado_por' => '',
        ];

        $sql = "DELETE FROM cheque WHERE cheque_id = ".strit($cheque_id);
        $ok = ia_query($sql,true,false);


        $_sql[] = ia_insert('cheque',$cheque);
        ia_transaction($_sql);

        /* insertar pagare a base de datos ++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
        $pagare_id = self::PAGARE_ID;
        $pagare = [
            'pagare_id' => $pagare_id,
            'cliente_id' => '3085a908ba06b56411e41cc4929f509e',
            'cliente_proveedor_id' => NULL,
            'name_on_check' => '',
            'nombre' => NULL,
            'tienda_id' => '1',
            'quantity' => '1380011.17',
            'moneda_id' => '1',
            'numero' => '1030',
            'banco_id' => '0',
            'original_date' => '2023-07-13',
            'new_date' => NULL,
            'atrasado' => '0',
            'paid' => '0',
            'super_atrasado' => '0',
            'pending' => '0',
            'modificado' => '0',
            'cobrado' => '0',
            'link_table' => NULL,
            'link' => '',
            'initial_payment' => '0.00',
            'total_payments' => '1322350.30',
            'disponible_para_sustituir' => '0.00',
            'cuentaT_deliveredto_id' => '69',
            'esta_en' => 'user',
            'cuentaT_transferto_id' => '69',
            'remarks' => 'PONU7385810    965 ROLLOS   SOCCER + DUBLIN<br />9,234.30 Kg  X 3.54 = 32,689.42 USD    SOCCER<br />13,774.20 Kg X 3.47 = 47,796.47 USD    DUBLIN<br />TOTAL...............................80,485.90 USD<br />T.C.                                    17.1460<br /><strong>TOTAL........................1,380,011.17 PESOS</strong>',
            'anexos' => NULL,
            'ultimo_cambio' => '2023-07-26 13:01:46',
            'ultimo_cambio_por' => 'mireya',
            'alta_db' => '2023-07-13 18:31:09',
            'alta_por' => 'ale',
            'origen_cuentat_id' => NULL,
            'accepted' => 'Accepted',
            'deliverd_log' => '13/Jul/23  18:31 ale pone deliverd to ale, esperando acepte, y lo acepta él mismo',
            'delivered' => '2023-07-13 18:31:09',
            'puede_origen_cuentat' => 'Si',
            'set_origen_cuentat' => '2023-07-13 18:31:09',
            'puede_borrar' => 'No',
            'primer_delivered' => 'No',
            'delivered_directo' => '1',
            'abierto_por' => 'rony',
            'abierto_el' => '2023-08-02 13:13:31',
            'paid_when' => NULL,
            'autorizado' => 'Si',
            'autorizado_por' => 'rony',
            'autorizado_el' => '2023-07-14 19:39:46',
            'borrado' => 'No',
            'borrado_por' => NULL,
            'borrado_el' => NULL,
            'numero_sistema' => NULL,
            'numero_contenedor' => NULL,
            'tipo_de_tela' => NULL,
            'lugar_de_entrada' => NULL,
            'ultimo_movimiento' => 'ALTA',
            'desautorizado_el' => NULL,
            'categoria_id' => '2',
            'remarks_wot' => '',
            'saldo' => '0.00',
            'paid_revisado' => 'No',
            'paid_revisado_por' => NULL,
            'paid_revisado_el' => NULL,
            'cuentat_mov_id' => NULL,
            'rechazado' => 'No',
            'tipo' => '',
            'ultimo_pago' => '2023-07-26 13:01:47',
            'html_verified' => '',
            'bloqueado_el' => NULL,
            'remarks_bloqueado' => 'No',
            'remarks_bloqueado_fecha' => NULL,
            'remarks_bloqueado_por' => '',
        ];

        $sql = "DELETE FROM pagare WHERE pagare_id = ".strit($pagare_id);
        $ok = ia_query($sql,true,false);


        $_sql[] = ia_insert('pagare',$pagare);
        ia_transaction($_sql);

        /* insertar vale a base de datos ++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
        $vale_id = self::VALE_ID;
        $vale = [
            'vale_id' => $vale_id,
            'cliente' => '',
            'cliente_de_paso' => '0',
            'cliente_id' => 'f8bc123029a8bad511edc29a492f642f',
            'cuentaT_id' => '1',
            'dinero_en_cuentaT_id' => '1',
            'vale_number' => '1949',
            'referencia' => NULL,
            'fecha' => '2023-07-28 19:02:21',
            'quantity' => '1000.00',
            'quantity_total' => '1000.00',
            'quantity_recibido' => '1000.00',
            'quantity_recibido_usd' => '0.00',
            'pagosVales' => NULL,
            'ide_amount' => '0.00',
            'ide_percent' => '0.00',
            'tarjeta_amount' => '0.00',
            'tarjeta_percent' => '0.00',
            'deposit_total' => '0.00',
            'moneda_id' => '0',
            'recibido_moneda_id' => '1',
            'tipo_cambio' => '1.000000',
            'total_payments' => '0.00',
            'paid' => '0',
            'aplicado' => '0',
            'entregado_a_rony' => '0',
            'recibido_por_rony' => '0',
            'abierto' => '0',
            'devuelto' => '0',
            'cancelado' => '0',
            'extraviado' => '0',
            'comentario' => NULL,
            'banco_cuenta_mov_link_id' => '',
            'banco_cuenta_id' => NULL,
            'deposit_fecha' => '0000-00-00',
            'metodo_pago_id' => '1',
            'remarks' => NULL,
            'anexos' => NULL,
            'ultimo_cambio' => '2023-07-28 19:02:21',
            'ultimo_cambio_por' => 'rony',
            'alta_db' => '2023-07-28 19:02:21',
            'alta_por' => 'rony',
            'comision_percent' => '0.00',
            'comision_amount' => '0.00',
            'pending' => '0',
            'abierto_por' => 'rony',
            'abierto_el' => '2023-08-02 13:23:48',
            'paid_when' => NULL,
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'factura' => '',
            'ivacobradox100' => '0.00',
            'ivacobradototal' => '0.00',
            'empresa_id' => NULL,
            'factura_numero' => NULL,
            'cash_nota_num' => NULL,
            'tienda_id' => '1',
            'tipo_cash_nota' => NULL,
            'cobra_iva' => NULL,
            'cash_num_cobro_iva' => NULL,
            'cliente_rfc' => NULL,
            'origen' => 'VALE',
            'iva_incluido' => 'NO',
            'numero_referencia' => NULL,
            'cuenta_t_mov_id' => '54bf6469e2ccbf5c11ee2da3307ba3a2',
            'deposit_cliente' => NULL,
            'autorizado_el' => NULL,
            'borrado' => 'No',
            'borrado_por' => NULL,
            'borrado_el' => NULL,
            'numero_sistema' => NULL,
            'numero_contenedor' => NULL,
            'tipo_de_tela' => NULL,
            'lugar_de_entrada' => NULL,
            'ultimo_movimiento' => 'ALTA',
            'desautorizado_el' => NULL,
            'comments' => NULL,
            'revisado' => 'No',
            'rechazado' => 'No',
            'puede_borrar' => 'Si',
            'afecta_cuentat' => 'SI',
            'fecha_capturado' => '2023-07-28 19:02:21',
            'categoria_id' => '1',
            'iva_revisado_por' => NULL,
            'iva_revisado' => 'No',
            'iva_revisado_el' => NULL,
            'MetodoPago' => NULL,
            'FormaPago' => NULL,
            'UsoCFDI' => NULL,
            'CuentadePago' => NULL,
            'remarks_wot' => NULL,
            'saldo' => '0.00',
            'paid_revisado' => 'No',
            'paid_revisado_por' => NULL,
            'paid_revisado_el' => NULL,
            'json_file_attachments' => NULL,
            'cancelacion_revisada' => NULL,
            'cancelacion_revisada_por' => NULL,
            'cancelacion_revisada_el' => NULL,
            'cancelacion_el' => NULL,
            'tipo' => '',
            'ultimo_pago' => NULL,
            'html_verified' => '',
            'conversion_tipo_cambio' => '0.00000',
            'conversion_monto_usd' => '0.00',
            'conversion_ultimo_cambio' => NULL,
            'conversion_ultimo_cambio_por' => '',
            'conversion_fuera_de_rango' => NULL,
            'puede_cambiar_tipo_cambio' => 'Si',
            'bloqueado_el' => NULL,
            'remarks_bloqueado' => 'No',
            'remarks_bloqueado_fecha' => NULL,
            'remarks_bloqueado_por' => '',
        ];

        $sql = "DELETE FROM vale WHERE vale_id = ".strit($vale_id);
        $ok = ia_query($sql,true,false);


        $_sql[] = ia_insert('vale',$vale);
        ia_transaction($_sql);

    }

    /**
     * @covers CobranzaHistoryLog::getChequeHistory
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers assoc_mysql2mysqli
     * @covers ia_sqlArrayIndx
     * @covers the_error_handler
     * @covers strit
     * @covers sqlMysqli::log_trace
     */
    public function testgetChequeHistory(){
        $cheque_id = self::ID;
        $histories = CobranzaHistoryLog::getChequeHistory($cheque_id);

        $this->assertIsArray($histories);

        foreach( $histories as $hist ){
            $this->assertArrayHasKey('record', $hist);
        }
    }

    /**
     * @covers CobranzaHistoryLog::historyChequeSave
     * @covers strit
     * @covers Historian::__construct
     * @covers Historian::primaryKeyEncode
     * @covers Historian::set
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayKey
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArray
     * @covers sqlMysqli::log_trace
     * @covers the_error_handler
     */
    public function testhistoryChequeSave()
    {
        $cheque_id = self::ID;
        CobranzaHistoryLog::historyChequeSave('insert', $cheque_id);
        $select_item = ia_singleton("SELECT * FROM `cheque_hist` WHERE pk=" .strit($cheque_id));

        $this->assertEquals($cheque_id, $select_item['pk']);
    }


    /**
     * @covers CobranzaHistoryLog::getPagareHistory
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers assoc_mysql2mysqli
     * @covers ia_sqlArrayIndx
     * @covers the_error_handler
     * @covers strit
     * @covers sqlMysqli::log_trace
     */
    public function testgetPagareHistory(){
        $_id = self::PAGARE_ID;
        $histories = CobranzaHistoryLog::getPagareHistory($_id);

        $this->assertIsArray($histories);

        foreach( $histories as $hist ){
            $this->assertArrayHasKey('record', $hist);
        }
    }

    /**
     * @covers CobranzaHistoryLog::historyPagareSave
     * @covers strit
     * @covers Historian::__construct
     * @covers Historian::primaryKeyEncode
     * @covers Historian::set
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayKey
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArray
     * @covers sqlMysqli::log_trace
     * @covers the_error_handler
     */
    public function testhistoryPagareSave()
    {
        $pagare_id = self::PAGARE_ID;
        CobranzaHistoryLog::historyPagareSave('insert', $pagare_id);
        $select_item = ia_singleton("SELECT * FROM `pagare_hist` WHERE pk=" .strit($pagare_id));

        $this->assertEquals($pagare_id, $select_item['pk']);
    }

    /**
     * @covers CobranzaHistoryLog::getValeHistory
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers assoc_mysql2mysqli
     * @covers ia_sqlArrayIndx
     * @covers the_error_handler
     * @covers strit
     * @covers sqlMysqli::log_trace
     */
    public function testgetValeHistory(){
        $_id = self::VALE_ID;
        $histories = CobranzaHistoryLog::getValeHistory($_id);

        $this->assertIsArray($histories);

        foreach( $histories as $hist ){
            $this->assertArrayHasKey('record', $hist);
        }
    }

    /**
     * @covers CobranzaHistoryLog::historyValeSave
     * @covers strit
     * @covers Historian::__construct
     * @covers Historian::primaryKeyEncode
     * @covers Historian::set
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayKey
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArray
     * @covers sqlMysqli::log_trace
     * @covers the_error_handler
     */
    public function testhistoryValeSave()
    {
        $vale_id = self::VALE_ID;
        CobranzaHistoryLog::historyValeSave('insert', $vale_id);
        $select_item = ia_singleton("SELECT * FROM `vale_hist` WHERE pk=" .strit($vale_id));

        $this->assertEquals($vale_id, $select_item['pk']);
    }

    /**
     * @covers CobranzaHistoryLog::formatHistoryChanges
     * @covers mysqlDate2display
     * @covers mysqlDateTime2display
     * @covers the_error_handler
     * @covers CobranzaHistoryLog::getCliente
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers assoc_mysql2mysqli
     * @covers ia_singleton
     * @covers sqlMysqli::log_trace
     * @covers strit
     */
    public function testFormatHistoryChanges(){
        $entra = [
            0 => [
                'history_id' => '171',
                'action' => 'update',
                'date' => '2023-08-01 15:51:49',
                'user_nick' => 'rony',
                'record' => 'update',
                'time_lapse' => '',
            ],
            1 => [
                'history_id' => '172',
                'action' => 'update',
                'date' => '2023-08-01 15:51:57',
                'user_nick' => 'rony',
                'time_lapse' => '8 seg',
                'record' => [
                    'pago' => [
                        'eliminado' => [
                            '54bf6469e2ccbf5c11ee30ad2babe0fa' => [
                                'cheque_pago_id' => '54bf6469e2ccbf5c11ee30ad2babe0fa',
                                'cheque_id' => 'f8bc123029a8bb9511ed9b521b46d710',
                                'fecha' => '2023-08-01 15:51:21',
                                'quantity' => '500.00',
                                'quantity_total' => '500.00',
                                'deposit_total' => '0.00',
                                'ide_amount' => '0.00',
                                'ide_percent' => '0.00',
                                'tarjeta_amount' => '0.00',
                                'tarjeta_percent' => '0.00',
                                'moneda_id' => '1',
                                'tipo_cambio' => '1.000000',
                                'metodo_pago_id' => '1',
                                'banco_cuenta_id' => '0',
                                'banco_cuenta_mov_link_id' => '',
                                'referencia' => '',
                                'comentario' => '',
                                'ultimo_cambio' => '2023-08-01 15:51:21',
                                'ultimo_cambio_por' => 'rony',
                                'alta_db' => '2023-08-01 15:51:21',
                                'alta_por' => 'rony',
                                'cuenta_t_mov_id' => '54bf6469e2ccbf5c11ee30ad2babdaa4',
                                'vs_doc' => '',
                                'vs_doc_key' => '',
                                'vs_pago_key' => '',
                                'puede_borrar' => 'Si',
                                'cuentaT_id' => '1',
                                'quantity_ctat' => '500.00',
                                'numero' => '1',
                                'deposit_fecha' => '0000-00-00 00:00:00',
                                'comision_percent' => '0.00',
                                'comision_amount' => '0.00',
                                'factura' => '',
                                'ivacobradox100' => '0.00',
                                'ivacobradototal' => '0.00',
                                'empresa_id' => '0',
                                'factura_numero' => '',
                                'cash_nota_num' => '',
                                'cliente' => '',
                                'tienda_id' => '1',
                                'tipo_cash_nota' => '',
                                'cobra_iva' => '',
                                'iva_incluido' => 'NO',
                                'numero_referencia' => '',
                                'cash_num_cobro_iva' => NULL,
                                'activo' => 'Si',
                                'origen' => 'CHEQUE',
                                'cliente_rfc' => '',
                                'saldo' => '39500.00',
                                'comments' => NULL,
                                'revisado' => 'No',
                                'autorizado' => 'No',
                                'autorizado_por' => NULL,
                                'autorizado_el' => NULL,
                                'rechazado' => 'No',
                                'afecta_cuentat' => 'SI',
                                'fecha_capturado' => '2023-08-01 15:51:21',
                                'iva_revisado_por' => NULL,
                                'iva_revisado' => 'No',
                                'iva_revisado_el' => NULL,
                                'MetodoPago' => '',
                                'FormaPago' => '',
                                'UsoCFDI' => '',
                                'CuentadePago' => '',
                                'json_file_attachments' => NULL,
                                'cancelacion_revisada' => NULL,
                                'cancelacion_revisada_por' => NULL,
                                'cancelacion_revisada_el' => NULL,
                                'cancelacion_el' => NULL,
                            ],
                        ],
                    ],
                    'pago_log' => [
                        'agregado' => [
                            '54bf6469e2ccbf5c11ee30ad4111143b' => [
                                'cheque_pago_log_id' => '54bf6469e2ccbf5c11ee30ad4111143b',
                                'cheque_pago_id' => '54bf6469e2ccbf5c11ee30ad2babe0fa',
                                'cheque_id' => 'f8bc123029a8bb9511ed9b521b46d710',
                                'fecha_borrado' => '2023-08-01',
                                'fecha' => '2023-08-01 15:51:21',
                                'quantity' => '500.00',
                                'quantity_total' => '500.00',
                                'deposit_total' => '0.00',
                                'ide_amount' => '0.00',
                                'ide_percent' => '0.00',
                                'tarjeta_amount' => '0.00',
                                'tarjeta_percent' => '0.00',
                                'moneda_id' => '1',
                                'tipo_cambio' => '1.000000',
                                'metodo_pago_id' => '1',
                                'banco_cuenta_id' => '0',
                                'banco_cuenta_mov_link_id' => '',
                                'referencia' => '',
                                'comentario' => "",
                                'ultimo_cambio' => '2023-08-01 15:51:57',
                                'ultimo_cambio_por' => 'rony',
                                'alta_db' => '2023-08-01 15:51:57',
                                'alta_por' => 'rony',
                                'numero' => '1',
                                'cuentaT_id' => '1',
                                'deposit_fecha' => '0000-00-00',
                                'comision_percent' => '0.00',
                                'comision_amount' => '0.00',
                                'factura' => '',
                                'ivacobradox100' => '0.00',
                                'ivacobradototal' => '0.00',
                                'empresa_id' => '0',
                                'factura_numero' => '',
                                'cash_nota_num' => '',
                                'cliente' => '',
                                'tienda_id' => '1',
                                'tipo_cash_nota' => '',
                                'cobra_iva' => '',
                                'saldo' => '0.00',
                                'origen' => 'CHEQUE',
                                'activo' => 'No',
                                'numero_referencia' => '',
                                'iva_revisado_por' => NULL,
                                'iva_revisado' => 'No',
                                'iva_revisado_el' => NULL,
                                'MetodoPago' => NULL,
                                'FormaPago' => NULL,
                                'UsoCFDI' => NULL,
                                'CuentadePago' => NULL,
                                'revisado' => 'No',
                                'autorizado' => 'No',
                                'autorizado_por' => NULL,
                                'autorizado_el' => NULL,
                                'rechazado' => 'No',
                                'ultimo_movimiento' => NULL,
                                'desautorizado_el' => NULL,
                                'puede_borrar' => 'Si',
                                'cuenta_t_mov_id' => '54bf6469e2ccbf5c11ee30ad41111a30',
                                'json_file_attachments' => NULL,
                                'cancelacion_revisada' => NULL,
                                'cancelacion_revisada_por' => NULL,
                                'cancelacion_revisada_el' => NULL,
                                'cancelacion_el' => NULL,
                            ],
                        ],
                    ],
                    'abierto_el' => ' - 2023-08-01 15:51:51',
                    'abierto_por' => ' - rony',
                    'puede_borrar' => 'No - Si',
                    'total_payments' => '600.00 - 100.00',
                ],
            ],
            2 => [
                'history_id' => '173',
                'action' => 'update',
                'date' => '2023-08-01 15:52:01',
                'user_nick' => 'rony',
                'time_lapse' => '12 seg',
                'record' => [
                    'abierto_el' => '2023-08-01 15:51:51 - ',
                    'abierto_por' => 'rony - ',
                    'bloqueado_el' => ' - 2023-08-01 15:52:01',
                    'puede_borrar' => 'Si - No',
                ],
            ],
            3 => [
                'history_id' => '195',
                'action' => 'update',
                'date' => '2023-08-01 16:02:32',
                'user_nick' => 'rony',
                'time_lapse' => '10 min',
                'record' => [
                    'cliente_id' => '74867af2fe60bbd911ed7e3631d62545 - cc483a12801ab47611ee057b1a37bb87',
                ],
            ],
        ];
        $espera = [
            0 => [
                'fecha' => '01/Ago/23  15:51',
                'user' => 'rony',
                'action' => 'update',
                'hace' => '',
                'detalles' => [
                    0 => 'Registro de la Nota',
                ],
            ],
            1 => [
                'fecha' => '01/Ago/23  15:51',
                'user' => 'rony',
                'action' => 'update',
                'hace' => '8 seg',
                'important' => true,
                'detalles' => [
                    0 => "<span id='log_54bf6469e2ccbf5c11ee30ad4111143b' class='miniLogToolTip'><strong style='color: red;'>Pago eliminado:</strong><strong> cantidad $500.00</strong></span>",
                    1 => "<span class='miniLogToolTip'><strong style='color: red;'>Total de pagos:</strong> Era 600.00<span class='cambio-a'><strong> Cambio a 100.00</strong></span></span>",
                ],
            ],
            2 => [
                'fecha' => '01/Ago/23  15:52',
                'user' => 'rony',
                'action' => 'update',
                'hace' => '12 seg',
            ],
            3 => [
                'fecha' => '01/Ago/23  16:02',
                'user' => 'rony',
                'action' => 'update',
                'hace' => '10 min',
                'detalles' => [
                    0 => "<span class='miniLogToolTip'><strong style='color: red;'>cliente:</strong> Era ALBERTO RODRIGUEZ HERNANDEZ<span class='cambio-a'><strong> Cambio a ALBERTO RIOS</strong></span></span>",
                ],
            ],
        ];

        $format = CobranzaHistoryLog::formatHistoryChanges($entra, 'cheque');
        $this->assertEquals($espera, $format);
    }

    /**
     * @covers CobranzaHistoryLog::printHistoryTable
     */
    public function testprintHistoryTable(){
        $espera = [
            0 => [
                'fecha' => '01/Ago/23  15:51',
                'user' => 'rony',
                'action' => 'update',
                'hace' => '',
                'detalles' => [
                    0 => 'Registro de la Nota',
                ],
            ],
            1 => [
                'fecha' => '01/Ago/23  15:51',
                'user' => 'rony',
                'action' => 'update',
                'hace' => '8 seg',
                'important' => true,
                'detalles' => [
                    0 => "<span id='54bf6469e2ccbf5c11ee30ad4111143b' class='miniLogToolTip'><strong style='color: red;'>Pago eliminado:</strong><strong> cantidad $500.00</strong></span>",
                    1 => "<span class='miniLogToolTip'><strong style='color: red;'>abierto_el:</strong> Era <strong>NADA</strong><span class='cambio-a'><strong> Cambio a 2023-08-01 15:51:51</strong></span></span>",
                    2 => "<span class='miniLogToolTip'><strong style='color: red;'>abierto_por:</strong> Era <strong>NADA</strong><span class='cambio-a'><strong> Cambio a rony</strong></span></span>",
                    3 => "<span class='miniLogToolTip'><strong style='color: red;'>puede_borrar:</strong> Era No<span class='cambio-a'><strong> Cambio a Si</strong></span></span>",
                    4 => "<span class='miniLogToolTip'><strong style='color: red;'>Total de pagos:</strong> Era 600.00<span class='cambio-a'><strong> Cambio a 100.00</strong></span></span>",
                ],
            ],
            2 => [
                'fecha' => '01/Ago/23  15:52',
                'user' => 'rony',
                'action' => 'update',
                'hace' => '12 seg',
                'detalles' => [
                    0 =>  "<span class='miniLogToolTip'><strong style='color: red;'>abierto_el:</strong> Era 2023-08-01 15:51:51<span class='cambio-a'><strong> Cambio a <strong>NADA</strong></strong></span></span>",
                    1 => "<span class='miniLogToolTip'><strong style='color: red;'>abierto_por:</strong> Era rony<span class='cambio-a'><strong> Cambio a <strong>NADA</strong></strong></span></span>",
                    2 =>  "<span class='miniLogToolTip'><strong style='color: red;'>bloqueado_el:</strong> Era <strong>NADA</strong><span class='cambio-a'><strong> Cambio a 2023-08-01 15:52:01</strong></span></span>",
                    3 => "<span class='miniLogToolTip'><strong style='color: red;'>puede_borrar:</strong> Era Si<span class='cambio-a'><strong> Cambio a No</strong></span></span>",
                ],
            ],
            3 => [
                'fecha' => '01/Ago/23  16:02',
                'user' => 'rony',
                'action' => 'update',
                'hace' => '10 min',
                'detalles' => [
                    0 => "<span class='miniLogToolTip'><strong style='color: red;'>cliente:</strong> Era ALBERTO RODRIGUEZ HERNANDEZ<span class='cambio-a'><strong> Cambio a ALBERTO RIOS</strong></span></span>",
                ],
            ],
        ];
        $table = CobranzaHistoryLog::printHistoryTable($espera);

        $this->assertNotEmpty($table);
        $this->assertStringContainsString("table", $table);

    }

}
