<?php

/** @noinspection PhpArrayIndexImmediatelyRewrittenInspection */
/** @noinspection PhpMultipleClassesDeclarationsInOneFile */
/** @noinspection PhpIllegalPsrClassPathInspection */

declare(strict_types=1);

use JetBrains\PhpStorm\ArrayShape;
use JetBrains\PhpStorm\Pure;
use PHPUnit\Framework\TestCase;

class DepositarEnParaTest extends DepositarEn {

    public function __construct(string|int|null $completar_id = null, string|int|float|null $minutos_done_id = null) {
        parent::__construct($completar_id, $minutos_done_id);
    }

    public function publicProcesa():array {
        return $this->procesa();
    }


    public function publicSacaTotales($d):array {
        return $this->sacaTotales($d);
    }

    public function publicRotaPorTiempo(array &$d, array &$updateRecord) {
        $this->rotaPorTiempo($d, $updateRecord);
    }

    public function publicLeeDepositaEn():array {
        return $this->leeDepositaEn();
    }

    public function publicMaxFilaPorCola() {
        $this->posicionRotarEnCola = $this->maxFilaPorCola();
    }

    public function ponUnoPorCarrilRow() {
        foreach($this->maxPorCarril as &$rows)
            foreach($rows as &$r)
                $r=1;
    }
}
// global $usuarios; $usuarios = getForTestsUserIdTypes([]);

/**
 *
 * @covers DepositarEnTest
 * @covers DepositarEnParaTest
 * @covers DepositarEn::cambiaDia
 * @covers DepositarEn::__construct
 * @covers DepositarEn::setParametros
 * @covers DepositarEn::simula_completar_por_monto
 * @covers DepositarEn::simula_rotar_por_minutos
 * @covers DepositarEn::ajustaFilaPorCarril
 * @covers DepositarEn::banco_cuenta_saldos_get
 * @covers DepositarEn::cambiaDiaNoCuentanDepositosAntesDeAhorita
 * @covers DepositarEn::cambiaDiaCuentanDepositosAntesDeAhorita
 * @covers DepositarEn::cambiaDiaContinuanDeAyer
 * @covers DepositarEn::deduceLugaresPorCarril
 * @covers DepositarEn::depositasEnNoCompletan
 * @covers DepositarEn::leeDepositaEn
 * @uses DepositarEn::maxFilaPorCola
 * @covers DepositarEn::ponPorCarril
 * @uses DepositarEn::rotaPorTiempo
 * @uses DepositarEn::sacaTotales
 * @covers DepositarEn::sumaDepositadoRevisaCompletado
 * @covers DepositarEn::tiempoMostradoActualiza
 * @covers DepositarEn::updateTable
 * @covers DepositarEn::normalizaDepRota
 * @covers DepositarEn::procesa
 * @uses Iac\inc\sql\IacMysqli::query
 * @uses Iac\inc\sql\IacMysqli::runSql
 * @uses Iac\inc\sql\IacMysqli::selectArrayKey
 * @uses Iac\inc\sql\IacMysqli::singleton
 * @uses Iac\inc\sql\IacSqlBuilder::fieldit
 * @uses Iac\inc\sql\IacSqlBuilder::update
 * @uses Iac\inc\sql\IacSqlBuilder::where
 * @uses Iac\inc\sql\IacStringer::strim
 * @uses Iac\inc\sql\IacStringer::strit
 * @uses ::assoc_mysql2mysqli
 * @uses ::ia_dontQuote
 * @uses ::ia_insert
 * @uses ::ia_query
 * @uses ::ia_singleton
 * @uses ::ia_sqlArray
 * @uses ::ia_sqlArrayIndx
 * @uses ::ia_update
 * @uses sqlMysqli::log_trace
 * @uses ::strit
 * @uses ::txtHaceCuantoTiempo
 * @uses ::usuarioTipoRony()
 * @uses Iac\inc\sql\IacMysqli
 * @uses ::ia_errores_a_dime
 * @uses ::actualizaIngresos
 * @uses ::ia_sqlKeyValue
 * @uses ::ia_transaction
 * @uses ::stritc
 * @uses ::leeParametrosVitex
 *
 * @version 12/27/2021
 */

class DepositarEnTest extends TestCase
{
    /*
        Una vez y Tiempo o Monto, alta no cuenta depositos del día pero dice si cuentan
     *
     */

    public static DepositarEn $depositaEn;

    public static array $deposita_en_estaban;
    public static array $banco_cuenta_saldos_estaban;

    public static array $bancoCandenceBancomer = [
        'banco_cuenta_id' => 35,
        'nombre' => 'CANDACE BANCOMER',
        'empresa_id' => '16',
        ];

    /**
     * Guarda los deposita_en y banco_cuenta_saldos existentes pues las pruebas lo borran
     *
     * Corre antes de todas las pruebas de esta clase
     * Pone bodegas y usuarios de prueba
     */
    public static function setUpBeforeClass(): void {
        $_SESSION['usuario_id'] = '1';
        self::$deposita_en_estaban = ia_sqlArrayIndx("SELECT * FROM deposita_en WHERE banco_cuenta_id>0");
        self::$banco_cuenta_saldos_estaban = ia_sqlArrayIndx("SELECT * FROM banco_cuenta_saldos");
        self::banco_cuenta_saldos_candence_bancomer();
    }

    /**
     * Restaura deposita_en borrados y banco_cuenta_saldos modificados por las pruebas
     *
     * Corre al terminarse todas las pruebas de esta clase
     * Elimina bodegas y usuarios de prueba
     */
    public static function tearDownAfterClass(): void {
        unset($_SESSION['usuario_id']);
        /** @noinspection SqlWithoutWhere */
        ia_query("delete from deposita_en");
        foreach(self::$deposita_en_estaban as $d) {

            ia_query(ia_insert('deposita_en', $d, [], '', true));
        }
        foreach(self::$banco_cuenta_saldos_estaban as $d) {
            unset($d['deposit_today'], $d['deposit_this_month'], $d['deposit_this_year'], $d['deposit_custom']);
            ia_query(ia_insert('banco_cuenta_saldos', $d, [], '', true));
        }
    }

    #[ArrayShape([DepositarEn::ROTA_SAFETY => "string", DepositarEn::ROTA_DIARIO => "string", DepositarEn::ROTA_TIEMPO_MONTO => "string", DepositarEn::ROTA_REDONDO => "string", DepositarEn::ROTA_SIEMPRE => "string", DepositarEn::ROTA_UNA_VEZ => "string", DepositarEn::ROTA_NO_DEPOSITAR => "string"])]
    public static function getDepRotaIndex():array {
        return [
            DepositarEn::ROTA_SAFETY => "1",
            DepositarEn::ROTA_DIARIO => "2",
            DepositarEn::ROTA_TIEMPO_MONTO => "3",
            DepositarEn::ROTA_REDONDO => "4",
            DepositarEn::ROTA_SIEMPRE => "5",
            DepositarEn::ROTA_UNA_VEZ => "6",
            DepositarEn::ROTA_NO_DEPOSITAR => "7",
        ];
    }

    #[Pure]
    #[ArrayShape([DepositarEn::SHAPE_DEPOSITA_EN])]
    public static function getDepositarEn($fecha = '', array|string $dep_rota = ''):array {
        if(empty($fecha))
            $fecha = Date('Y-m-d 09:00:00');
        $coso = [
            "1" => [ // safety
                'deposita_en_id' => "1",
                'dep_label' => 'CANDACE BANCOMER',
                'dep_agrupa_por' => '3',
                'banco_cuenta_id' => '35',
                'moneda_id' => '1',
                'dep_fila' => '11',
                'dep_fila_ini' => '1',
                'dep_columna' => '1',
                'dep_sube' => '0',
                'dep_tipo_deposito' => '3',
                'dep_importante' => '0',
                'dep_default' => '1',
                'dep_rota' => DepositarEn::ROTA_SAFETY,
                'fecha' => $fecha,
                'dep_amount_sin_limite' => '1',
                'dep_amount_es_max' => '0',
                'dep_amount_ini' => '0.00',
                'deposit_today_ini' => '0.00',
                'depositado_anteriormente' => '0.00',
                'completada' => DepositarEn::STATUS_VIGENTE,
                'fecha_completada' => null,
                'vale' => 'Active',
                'alta_db' => $fecha,
                'dep_no_depositar' => '0',
                'ultimo_cambio' =>  $fecha,
                'dep_solo_primera_fila' => '0',
                'dep_amount_visible' => '0',
                'minutos_a_mostrar' => '20',
                'minutos_mostrado' => '0',
                'last_shown' => $fecha,
                'veces_a_mostrar' => '81',
                'veces_mostrado' => '0',
                'completado_veces' => '0',
                'estaba_en' => DepositarEn::ESTA_VISIBLE,
                'cola' => 'A',
                'va_depositado' => '0.00',
                'falta_depositar' => '0.00',
                'inicie_el' => $fecha,
                'inicie_causa' => '',
                'inicie_deposit_today' => '0.00',
                'corriendo_para_hoy' => 'SI',
                'aviso' => 'Sólo menores a $5,000',
            ],
            "2" => [ // Diario
                'deposita_en_id' => "2",
                'dep_label' => self::$bancoCandenceBancomer['nombre'],
                'dep_agrupa_por' => '3',
                'banco_cuenta_id' => '35',
                'moneda_id' => '1',
                'dep_fila' => '3',
                'dep_fila_ini' => '2',
                'dep_columna' => '2',
                'dep_sube' => '0',
                'dep_tipo_deposito' => '3',
                'dep_importante' => '0',
                'dep_default' => '0',
                'dep_rota' => DepositarEn::ROTA_DIARIO,
                'fecha' => $fecha,
                'dep_amount_sin_limite' => '0',
                'dep_amount_es_max' => '0',


                'dep_amount_ini' => '55555.00',
                'deposit_today_ini' => '55.00',
                'depositado_anteriormente' => '500.00',
                'va_depositado' => '55.00',
                'falta_depositar' => '55055.00',
                'inicie_deposit_today' => '55.00',
                'inicie_causa' => 'letrero anterior',

                'completada' => DepositarEn::STATUS_VIGENTE,
                'fecha_completada' => NULL,
                'vale' => 'Active',
                'alta_db' => $fecha,
                'dep_no_depositar' => '0',
                'ultimo_cambio' =>  $fecha,
                'dep_solo_primera_fila' => '0',
                'dep_amount_visible' => '1',
                'minutos_a_mostrar' => '4',
                'minutos_mostrado' => '70',
                'last_shown' => $fecha,
                'veces_a_mostrar' => '24',
                'veces_mostrado' => '1',
                'completado_veces' => '1',
                'estaba_en' => DepositarEn::ESTA_VISIBLE,
                'cola' => 'A',
                'inicie_el' => $fecha,
                'corriendo_para_hoy' => 'SI',
                'aviso' => 'asdf',
            ],
            "3" => [ // Tiempo o monto
                'deposita_en_id' => "3",
                'dep_label' => 'CANDACE BANCOMER',
                'dep_agrupa_por' => '3',
                'banco_cuenta_id' => '35',
                'moneda_id' => '1',
                'dep_fila' => '4',
                'dep_fila_ini' => '3',
                'dep_columna' => '3',
                'dep_sube' => '0',
                'dep_tipo_deposito' => '3',
                'dep_importante' => '0',
                'dep_default' => '0',
                'dep_rota' => DepositarEn::ROTA_TIEMPO_MONTO,
                'fecha' => $fecha,
                'dep_amount_sin_limite' => '0',
                'dep_amount_es_max' => '0',
                'dep_amount_ini' => '5555.00',
                'deposit_today_ini' => '0.00',
                'depositado_anteriormente' => '55.00',
                'va_depositado' => '555.00',
                'falta_depositar' => '5000.00',
                'completada' => DepositarEn::STATUS_VIGENTE,
                'fecha_completada' => NULL,
                'vale' => 'Active',
                'alta_db' => $fecha,
                'dep_no_depositar' => '0',
                'ultimo_cambio' =>  $fecha,
                'dep_solo_primera_fila' => '1',
                'dep_amount_visible' => '1',
                'minutos_a_mostrar' => '8',
                'minutos_mostrado' => '4',
                'last_shown' => $fecha,
                'veces_a_mostrar' => '38',
                'veces_mostrado' => '27',
                'completado_veces' => '0',
                'estaba_en' => DepositarEn::ESTA_VISIBLE,
                'cola' => 'A',
                'inicie_el' => $fecha,
                'inicie_causa' =>  '',
                'inicie_deposit_today' => '0.00',
                'corriendo_para_hoy' => 'NO',
                'aviso' => '',
            ],
            "4" => [ // Redondo
                'deposita_en_id' => "4",
                'dep_label' => 'CANDACE BANCOMER',
                'dep_agrupa_por' => '3',
                'banco_cuenta_id' => '35',
                'moneda_id' => '1',
                'dep_fila' => '5',
                'dep_fila_ini' => '4',
                'dep_columna' => '4',
                'dep_sube' => '0',
                'dep_tipo_deposito' => '3',
                'dep_importante' => '0',
                'dep_default' => '0',
                'dep_rota' => DepositarEn::ROTA_REDONDO,
                'fecha' => $fecha,
                'dep_amount_sin_limite' => '0',
                'dep_amount_es_max' => '0',
                'dep_amount_ini' => '80000.00',
                'deposit_today_ini' => '0.00',
                'depositado_anteriormente' => '0.00',
                'completada' => DepositarEn::STATUS_VIGENTE,
                'fecha_completada' => NULL,
                'vale' => 'Active',
                'alta_db' => $fecha,
                'dep_no_depositar' => '0',
                'ultimo_cambio' =>  $fecha,
                'dep_solo_primera_fila' => '1',
                'dep_amount_visible' => '1',
                'minutos_a_mostrar' => '20',
                'minutos_mostrado' => '70',
                'last_shown' => $fecha,
                'veces_a_mostrar' => '81',
                'veces_mostrado' => '1',
                'completado_veces' => '0',
                'estaba_en' => DepositarEn::ESTA_VISIBLE,
                'cola' => 'A',
                'va_depositado' => '0.00',
                'falta_depositar' => '80000.00',
                'inicie_el' => $fecha,
                'inicie_causa' =>  '',
                'inicie_deposit_today' => '0.00',
                'corriendo_para_hoy' => 'SI',
                'aviso' => '',
            ],
            "5" => [ // Siempre
                'deposita_en_id' => "5",
                'dep_label' => self::$bancoCandenceBancomer['nombre'],
                'dep_agrupa_por' => '3',
                'banco_cuenta_id' => self::$bancoCandenceBancomer['banco_cuenta_id'],
                'moneda_id' => '1',
                'dep_fila' => '6',
                'dep_fila_ini' => '5',
                'dep_columna' => '5',
                'dep_sube' => '0',
                'dep_tipo_deposito' => '3',
                'dep_importante' => '0',
                'dep_default' => '0',
                'dep_rota' => DepositarEn::ROTA_SIEMPRE,
                'fecha' => $fecha,
                'dep_amount_sin_limite' => '1',

                'dep_amount_ini' => '55555.00',
                'deposit_today_ini' => '55.00',
                'depositado_anteriormente' => '500.00',
                'va_depositado' => '55.00',
                'falta_depositar' => '0.00',
                'inicie_deposit_today' => '55.00',
                'inicie_causa' => 'letrero anterior',

                'dep_amount_es_max' => '0',
                'completada' => DepositarEn::STATUS_VIGENTE,
                'fecha_completada' => NULL,
                'vale' => 'Active',
                'alta_db' => $fecha,
                'dep_no_depositar' => '0',
                'ultimo_cambio' =>  $fecha,
                'dep_solo_primera_fila' => '0',
                'dep_amount_visible' => '0',
                'minutos_a_mostrar' => '20',
                'minutos_mostrado' => '0',
                'last_shown' => $fecha,
                'veces_a_mostrar' => '81',
                'veces_mostrado' => '0',
                'completado_veces' => '0',
                'estaba_en' => DepositarEn::ESTA_VISIBLE,
                'cola' => 'A',
                'inicie_el' => $fecha,
                'corriendo_para_hoy' => 'SI',
                'aviso' => '',
            ],
            "6" => [ // Una vez
                'deposita_en_id' => "6",
                'dep_label' => 'CANDACE BANCOMER',
                'dep_agrupa_por' => '3',
                'banco_cuenta_id' => '35',
                'moneda_id' => '1',
                'dep_fila' => '7',
                'dep_fila_ini' => '6',
                'dep_columna' => '6',
                'dep_sube' => '0',
                'dep_tipo_deposito' => '3',
                'dep_importante' => '0',
                'dep_default' => '0',
                'dep_rota' => DepositarEn::ROTA_UNA_VEZ,
                'fecha' => $fecha,
                'dep_amount_sin_limite' => '0',
                'dep_amount_es_max' => '0',
                'dep_amount_ini' => '5555.00',
                'deposit_today_ini' => '0.00',
                'depositado_anteriormente' => '55.00',
                'va_depositado' => '555.00',
                'falta_depositar' => '5000.00',

                'completada' => DepositarEn::STATUS_VIGENTE,
                'fecha_completada' => NULL,
                'vale' => 'Active',
                'alta_db' => $fecha,
                'dep_no_depositar' => '0',
                'ultimo_cambio' =>  $fecha,
                'dep_solo_primera_fila' => '0',
                'dep_amount_visible' => '0',
                'minutos_a_mostrar' => '20',
                'minutos_mostrado' => '1423',
                'last_shown' => $fecha,
                'veces_a_mostrar' => '81',
                'veces_mostrado' => '1',
                'completado_veces' => '0',
                'estaba_en' => DepositarEn::ESTA_VISIBLE,
                'cola' => 'A',

                'inicie_el' => $fecha,
                'inicie_causa' => '',
                'inicie_deposit_today' => '0.00',
                'corriendo_para_hoy' => 'NO',
                'aviso' => '',
            ],
            "7" => [ // No Depositar
                'deposita_en_id' => "7",
                'dep_label' => 'CANDACE BANCOMER',
                'dep_agrupa_por' => '3',
                'banco_cuenta_id' => '35',
                'moneda_id' => '1',
                'dep_fila' => '8',
                'dep_fila_ini' => '7',
                'dep_columna' => '7',
                'dep_sube' => '0',
                'dep_tipo_deposito' => '3',
                'dep_importante' => '0',
                'dep_default' => '0',
                'dep_rota' => DepositarEn::ROTA_NO_DEPOSITAR,
                'fecha' => $fecha,
                'dep_amount_sin_limite' => '0',
                'dep_amount_es_max' => '0',
                'dep_amount_ini' => '0.00',
                'deposit_today_ini' => '0.00',
                'depositado_anteriormente' => '0.00',
                'completada' => DepositarEn::STATUS_VIGENTE,
                'fecha_completada' => null,
                'vale' => 'Active',
                'alta_db' => $fecha,
                'dep_no_depositar' => '1',
                'ultimo_cambio' =>  $fecha,
                'dep_solo_primera_fila' => '0',
                'dep_amount_visible' => '0',
                'minutos_a_mostrar' => '20',
                'minutos_mostrado' => '2',
                'last_shown' => $fecha,
                'veces_a_mostrar' => '81',
                'veces_mostrado' => '0',
                'completado_veces' => '0',
                'estaba_en' => DepositarEn::ESTA_VISIBLE,
                'cola' => 'A',
                'va_depositado' => '0.00',
                'falta_depositar' => '0.00',
                'inicie_el' => $fecha,
                'inicie_causa' => '',
                'inicie_deposit_today' => '10.00',
                'corriendo_para_hoy' => 'NO',
                'aviso' => '',
            ],
        ];
        if(is_array($dep_rota))
            return array_intersect_key($coso, array_flip($dep_rota));
        return empty($dep_rota) ? $coso : $coso[ self::getDepRotaIndex()[$dep_rota]];
    }



    /**
     * @covers DepositarEn::getCompletadoDiff
     */
    public function testGetCompletadoDiff() {

        $this->assertEquals(10.90, self::$depositaEn->getCompletadoDiff() ,
            "Default value");
    }

    /**
     * @covers DepositarEn::sacaTotales
     */
    public function testSacaTotalesPorEmpresa() {

        $empresaConMasDeUnaCuenta =
            "SELECT e.empresa_id, e.empresa, count(*) as cuantas, MAX(bc.ultima_conciliacion) as max_ultima_conciliacion
            FROM banco_cuenta bc JOIN empresa e USING (empresa_id)
            WHERE bc.vale = 'Active' AND bc.moneda_id = 1 AND e.vale = 'Active'
            GROUP BY 1, 2
            HAVING count(*) > 1";

        $variasCuentas = ia_singleton($empresaConMasDeUnaCuenta);

        $updateSaldos =[
            'sbc' => 2.00,
            'deposit_cash' => 101,
            'deposit_total' => 101,
            'ingreso_today' => 101,
            'ultima_conciliacion'=>'NOW()',
        ];
        $updateSaldosSql = ia_update('banco_cuenta_saldos', $updateSaldos,
            " banco_cuenta_id IN (SELECT banco_cuenta_id FROM banco_cuenta WHERE empresa_id = $variasCuentas[empresa_id] )");
        ia_query($updateSaldosSql);
        $expectedDepositToday = 101 * $variasCuentas['cuantas'];
        $expectedSBC = 2* $variasCuentas['cuantas'];

        $d = self::getDepositarEn(Date('Y-m-d'), DepositarEn::ROTA_UNA_VEZ);
        $d['dep_agrupa_por'] = 1; // por empresa
        $d['empresa_id'] = $variasCuentas['empresa_id']; // por empresa

        $depEn = new DepositarEnParaTest();
        $depEn->saldos = $depEn->banco_cuenta_saldos_get();
        $totales = $depEn->publicSacaTotales($d);
        $this->assertEquals($expectedDepositToday, $totales['deposit_today'], 'Total de deposit today por empresa');
        $this->assertEquals($expectedSBC, $totales['sbc'], 'Total de deposit salvo buen cobro (sbc)');
        $this->assertStringContainsString('<strong>' . strtoupper($variasCuentas['empresa']) .'</strong>', $totales['txt_ultima_conciliacion'], "Nombre de la empresa en txt_ultima_conciliacion");

    }

    /**
     * @covers DepositarEn::sacaTotales
     */
    public function testSacaTotalesPorBanco() {

        $empresaConMasDeUnaCuenta =
            "SELECT b.banco_id, b.banco, count(*) as cuantas, MAX(bc.ultima_conciliacion) as max_ultima_conciliacion
            FROM banco_cuenta bc JOIN banco b USING (banco_id) JOIN empresa e USING(empresa_id)
            WHERE bc.vale = 'Active' AND bc.moneda_id = 1 AND e.vale = 'Active' AND bc.nombre NOT LIKE '%RONY%'
            GROUP BY 1, 2
            HAVING count(*) > 1";

        $variasCuentas = ia_singleton($empresaConMasDeUnaCuenta);

        $updateSaldos =[
            'sbc' => 3.00,
            'deposit_cash' => 103,
            'deposit_total' => 103,
            'ingreso_today' => 103,
            'ultima_conciliacion'=>'NOW()',
        ];
        $updateSaldosSql = ia_update('banco_cuenta_saldos', $updateSaldos,
            " banco_cuenta_id IN 
            (SELECT bc.banco_cuenta_id FROM banco_cuenta bc JOIN empresa e USING(empresa_id) WHERE bc.moneda_id=1 AND bc.vale='Active' AND e.vale = 'Active' AND bc.banco_id = $variasCuentas[banco_id] )");
        ia_query($updateSaldosSql);


        $son = (int)$variasCuentas['cuantas'];
        $expectedDepositToday = 103 * $son;
        $expectedSBC =  3 * $son;

        $d = self::getDepositarEn(Date('Y-m-d'), DepositarEn::ROTA_UNA_VEZ);
        $d['dep_agrupa_por'] = 2; // por banco
        $d['banco_id'] = $variasCuentas['banco_id']; // por banco

        $depEn = new DepositarEnParaTest();
        $depEn->saldos = $depEn->banco_cuenta_saldos_get();
        $totales = $depEn->publicSacaTotales($d);

        $this->assertEquals($expectedSBC, $totales['sbc'], 'Total de deposit salvo buen cobro (sbc) por banco');

        $this->assertEquals($expectedDepositToday, $totales['deposit_today'], 'Total de deposit today por banco');



        $this->assertStringContainsString('<strong>' . strtoupper( $variasCuentas['banco'] ).'</strong>', $totales['txt_ultima_conciliacion'], "Nombre del banco en txt_ultima_conciliacion");

    }

//// Cambia día
    /**
     * Prueba deposita en pasan de ayer a hoy, sin completar.
     *
     * @covers DepositarEn::procesa
     * @covers DepositarEn::cambiaDiaCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaNoCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaContinuanDeAyer
     * @covers DepositarEn::normalizaDepRota
     * @covers DepositarEn::sacaTotales
     *
     * @dataProvider providerTodosAyer
     */
    public function testCambiaDia(array $base) {
        self::banco_cuenta_saldos_candence_bancomer();
        $this->InsertaDepositaEn($base);

        $depEn = new DepositarEnParaTest();
        $depEn->saldos = $depEn->banco_cuenta_saldos_get();
        $deposita_en_todos = $depEn->publicLeeDepositaEn();
        /** @var $depositaEn = #[ArrayShape([DepositarEn::SHAPE_DEPOSITA_EN])] */
        $depositaEn = reset( $deposita_en_todos );

        $hoy = Date('Y-m-d');
        /** @noinspection PhpSwitchCanBeReplacedWithMatchExpressionInspection */
        switch($base['dep_rota']) {
            case DepositarEn::ROTA_NO_DEPOSITAR:
            case DepositarEn::ROTA_SIEMPRE:
            case DepositarEn::ROTA_SAFETY:
                $depositaEnExpected = $this->iniciaDiaNoCompletan($depositaEn, $hoy);
                break;
            case DepositarEn::ROTA_REDONDO:
                $depositaEnExpected = $this->noCuentanDepositosAntesDeAhorita($depositaEn, $hoy);
                break;
            case DepositarEn::ROTA_UNA_VEZ:
            case DepositarEn::ROTA_TIEMPO_MONTO:
                $depositaEnExpected = $this->continuanDeAyer($depositaEn, $hoy);
                break;
            default:
                $depositaEnExpected = $this->cuentanDepositosAntesDeAhorita($depositaEn, $hoy);
        }
        $depositaEnExpected['dep_fila'] = 1;
        $got =  $depEn->publicProcesa();
        $depositaEn = reset( $got);


        ksort($depositaEn);
        ksort($depositaEnExpected);
        if(!empty($depositaEn['inicie_el']))
            $depositaEn['inicie_el'] = Date('Y-m-d', strtotime($depositaEn['inicie_el']));
        if(!empty($depositaEn['fecha_completada']))
            $depositaEn['fecha_completada'] = Date('Y-m-d', strtotime($depositaEn['fecha_completada']));

        unset($depositaEn['last_shown'], $depositaEnExpected['last_shown']);
        $this->assertEquals($depositaEnExpected, $depositaEn);

    }

        #[Pure]
        #[ArrayShape([DepositarEn::SHAPE_DEPOSITA_EN])]
        public function providerTodosAyer():array {
            return [
                DepositarEn::ROTA_DIARIO => [self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_DIARIO)],

                DepositarEn::ROTA_UNA_VEZ => [self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_UNA_VEZ)],
                DepositarEn::ROTA_TIEMPO_MONTO => [self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_TIEMPO_MONTO)],

                DepositarEn::ROTA_REDONDO => [self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_REDONDO)],

                DepositarEn::ROTA_SIEMPRE => [self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_SIEMPRE)],
                DepositarEn::ROTA_NO_DEPOSITAR => [self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_NO_DEPOSITAR)],
                DepositarEn::ROTA_SAFETY => [self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_SAFETY)],
            ];
        }

        public function cuentanDepositosAntesDeAhorita(array $depositaEn, $hoy): array {
            $depEn = new DepositarEnParaTest();
            $depEn->saldos = $depEn->banco_cuenta_saldos_get();
            $saldoAhora = $depEn->publicSacaTotales($depositaEn);

            $depositaEnExpected = $depositaEn;
            $depEn->normalizaDepRota($depositaEnExpected);
            $depositaEnExpected['fecha'] = $hoy;
            $depositaEnExpected['corriendo_para_hoy'] = 'SI';
            $depositaEnExpected['depositado_anteriormente'] = 0.0;
            $depositaEnExpected['deposit_today_ini'] = 0.0;
            $depositaEnExpected['estaba_en'] = DepositarEn::ESTA_VISIBLE;
            $depositaEnExpected['completada'] = DepositarEn::STATUS_VIGENTE;
            $depositaEnExpected['completado_veces'] = 0;
            $depositaEnExpected['fecha_completada'] = NULL;
            $depositaEnExpected['minutos_mostrado'] = 0;
            $depositaEnExpected['veces_mostrado'] = 1;
            $depositaEnExpected['inicie_causa'] = DepositarEn::LETRERO_CAMBIO_DIA;
            $depositaEnExpected['inicie_el'] = Date('Y-m-d');
            $depositaEnExpected['last_shown'] = NULL;
            $depositaEnExpected['dep_fila'] = (int)$depositaEn['dep_fila_ini'];

            $depositaEnExpected = array_merge($depositaEnExpected, $saldoAhora);
            $depositaEnExpected['deposit_today'] = $saldoAhora['deposit_today'] ?? 0.00;
            $depositaEnExpected['va_depositado'] = (float)$depositaEnExpected['deposit_today'];
            $depositaEnExpected['inicie_deposit_today'] =  $depositaEnExpected['deposit_today'];
            $depositaEnExpected['falta_depositar'] = $depositaEn['dep_amount_ini'] - $depositaEnExpected['va_depositado'];

            return $depositaEnExpected;
        }

        public function iniciaDiaNoCompletan(array $depositaEn, $hoy): array {
            $depEn = new DepositarEnParaTest();
            $depEn->saldos = $depEn->banco_cuenta_saldos_get();
            $saldoAhora = $depEn->publicSacaTotales($depositaEn);
            $depositaEnExpected = $depositaEn;
            $depEn->normalizaDepRota($depositaEnExpected);
            $depositaEnExpected['fecha'] = $hoy;
            $depositaEnExpected['corriendo_para_hoy'] = 'SI';
            $depositaEnExpected['depositado_anteriormente'] = 0.0;

            $depositaEnExpected['estaba_en'] = DepositarEn::ESTA_VISIBLE;
            $depositaEnExpected['completada'] = DepositarEn::STATUS_VIGENTE;
            $depositaEnExpected['completado_veces'] = 0;
            $depositaEnExpected['fecha_completada'] = NULL;
            $depositaEnExpected['minutos_mostrado'] = 0;
            $depositaEnExpected['veces_mostrado'] = 1;
            $depositaEnExpected['inicie_causa'] = $depositaEn['dep_rota'] === DepositarEn::ROTA_REDONDO ? DepositarEn::LETRERO_OCULTA_PASA_MUESTRA : DepositarEn::LETRERO_CAMBIO_DIA;
            $depositaEnExpected['inicie_el'] = Date('Y-m-d');
            $depositaEnExpected['last_shown'] = NULL;
            $depositaEnExpected['dep_fila'] = '1';

            $depositaEnExpected = array_merge($depositaEnExpected, $saldoAhora);
            $depositaEnExpected['deposit_today'] = $saldoAhora['deposit_today'] ?? 0.00;
            $depositaEnExpected['deposit_today_ini'] = $depositaEnExpected['deposit_today'];
            $depositaEnExpected['va_depositado'] = 0.0;
            $depositaEnExpected['inicie_deposit_today'] =  $depositaEnExpected['deposit_today'];
            $depositaEnExpected['falta_depositar'] = $depositaEn['dep_amount_ini'];


            return $depositaEnExpected;
        }

        public function noCuentanDepositosAntesDeAhorita(array $depositaEn, $hoy): array {
            $depEn = new DepositarEnParaTest();
            $depEn->saldos = $depEn->banco_cuenta_saldos_get();
            $saldoAhora = $depEn->publicSacaTotales($depositaEn);
            $depositaEnExpected = $depositaEn;
            $depEn->normalizaDepRota($depositaEnExpected);
            $depositaEnExpected['fecha'] = $hoy;
            $depositaEnExpected['corriendo_para_hoy'] = 'SI';
            $depositaEnExpected['depositado_anteriormente'] = 0.0;

            $depositaEnExpected['estaba_en'] = DepositarEn::ESTA_VISIBLE;
            $depositaEnExpected['completada'] = DepositarEn::STATUS_VIGENTE;
            $depositaEnExpected['completado_veces'] = 0;
            $depositaEnExpected['fecha_completada'] = NULL;
            $depositaEnExpected['minutos_mostrado'] = 0;
            $depositaEnExpected['veces_mostrado'] = 1;
            $depositaEnExpected['inicie_causa'] = $depositaEn['dep_rota'] === DepositarEn::ROTA_REDONDO ? DepositarEn::LETRERO_OCULTA_PASA_MUESTRA : DepositarEn::LETRERO_CAMBIO_DIA;
            $depositaEnExpected['inicie_el'] = Date('Y-m-d');
            $depositaEnExpected['last_shown'] = NULL;
            $depositaEnExpected['dep_fila'] = (int)$depositaEn['dep_fila_ini'];

            $depositaEnExpected = array_merge($depositaEnExpected, $saldoAhora);
            $depositaEnExpected['deposit_today'] = $saldoAhora['deposit_today'] ?? 0.00;
            $depositaEnExpected['deposit_today_ini'] = $depositaEnExpected['deposit_today'];
            $depositaEnExpected['va_depositado'] = 0.00;
            $depositaEnExpected['inicie_deposit_today'] =  $depositaEnExpected['deposit_today'];
            $depositaEnExpected['falta_depositar'] = $depositaEn['dep_amount_ini'];


            return $depositaEnExpected;
        }

        public function continuanDeAyer(array $depositaEn, $hoy): array {
            $depEn = new DepositarEnParaTest();
            $depEn->saldos = $depEn->banco_cuenta_saldos_get();
            $saldoAhora = $depEn->publicSacaTotales($depositaEn);
            $depositaEnExpected = $depositaEn;
            $depEn->normalizaDepRota($depositaEnExpected);
            $depositaEnExpected['fecha'] = $hoy;
            $depositaEnExpected['corriendo_para_hoy'] = 'NO';

            $depositaEnExpected['estaba_en'] = DepositarEn::ESTA_VISIBLE;
            $depositaEnExpected['completada'] = DepositarEn::STATUS_VIGENTE;
            $depositaEnExpected['fecha_completada'] = NULL;

            $depositaEnExpected['inicie_causa'] = DepositarEn::LETRERO_CONTINUO_DE_AYER . number_format((float)$depositaEn['falta_depositar'], 2);
            $depositaEnExpected['inicie_el'] = Date('Y-m-d');
            $depositaEnExpected['last_shown'] = NULL;
            $depositaEnExpected['dep_fila'] = (int)$depositaEn['dep_fila_ini'];
            $depositaEnExpected['veces_mostrado']++;
            $depositaEnExpected = array_merge($depositaEnExpected, $saldoAhora);



            $depositaEnExpected['deposit_today'] = $saldoAhora['deposit_today'] ?? 0.00;

            // 'depositado_anteriormente' => '55.00',
            //     'va_depositado' => '555.00',
            //     'falta_depositar' => '5000.00',

            $depositaEnExpected['depositado_anteriormente'] = $depositaEnExpected['va_depositado'];
            $depositaEnExpected['va_depositado'] += (float)$depositaEnExpected['deposit_today'];

            $depositaEnExpected['falta_depositar'] = (float)$depositaEnExpected['dep_amount_ini'] - $depositaEnExpected['va_depositado'];


            $depositaEnExpected['inicie_deposit_today'] =  '0.00';
            $depositaEnExpected['deposit_today_ini'] = 0.0;

            return $depositaEnExpected;
        }

    /**
     * Corre varias veces y no deben cambiar de la primera corrida, De 1 en 1 deposita_en
     *
     * @covers DepositarEn::procesa
     * @covers DepositarEn::cambiaDiaCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaNoCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaContinuanDeAyer
     * @covers DepositarEn::normalizaDepRota
     * @uses Iac\inc\sql\IacMysqli
     * @uses ::ia_errores_a_dime
     * @uses ::actualizaIngresos
     * @uses ::ia_sqlKeyValue
     * @uses ::ia_transaction
     * @uses ::stritc
     * @dataProvider providerTodosAyer
     */
    public function testCorreSinCambios(array $base) {
        self::banco_cuenta_saldos_candence_bancomer();
        $_SESSION['usuario_id'] = 1;
        $base['last_shown'] = null;

        $this->InsertaDepositaEn($base);

        $depEn = new DepositarEnParaTest();
        $depEn->publicProcesa();
        $expected = ia_singleton("SELECT * FROM deposita_en WHERE deposita_en_id=" . strit($base['deposita_en_id']));
        $expected['last_shown'] = Date('Y-m-d');
        $expected['minutos_mostrado'] = '0';
        $expected['veces_mostrado']++;

        $depEn->publicProcesa();
        $actual = ia_singleton("SELECT * FROM deposita_en WHERE deposita_en_id=" . strit($base['deposita_en_id']));
        $actual['last_shown'] = $this->convertDateTimeToDate($actual['last_shown']);

        unset($expected['minutos_mostrado'],$expected['veces_mostrado'],$actual['minutos_mostrado'],$actual['veces_mostrado'] );
        $this->assertEquals($expected, $actual);
    }

    /**
     * @dataProvider providerTodosAyer
     */
    public function testCambiaDiaYCompletan(array $base) {
        $depositado = 55555.00 * 3.01;
        self::banco_cuenta_saldos_candence_bancomer($depositado);

        $this->InsertaDepositaEn($base);
        $expected = ia_singleton("SELECT * FROM deposita_en WHERE deposita_en_id=" . strit($base['deposita_en_id']) );
        $expected['last_shown'] = $expected['inicie_el'] = $expected['fecha'] = Date('Y-m-d');
        $expected['inicie_deposit_today'] = $expected['deposit_today_ini'] = "$depositado";



        $depEn = new DepositarEnParaTest();
        $depEn->publicProcesa();
        $actual = ia_singleton("SELECT * FROM deposita_en WHERE deposita_en_id=" . strit($base['deposita_en_id']) );
        foreach(['last_shown', 'inicie_el', 'fecha_completada'] as $dateTime)
            if(!empty($actual[$dateTime]))
                $actual[$dateTime] = $this->convertDateTimeToDate($actual[$dateTime]);

        switch($base['dep_rota']) {
            case DepositarEn::ROTA_SIEMPRE:
            case DepositarEn::ROTA_SAFETY:
            case DepositarEn::ROTA_NO_DEPOSITAR:
                $expected['veces_mostrado'] = '1';
                $expected['inicie_causa'] = DepositarEn::LETRERO_CAMBIO_DIA;
                $expected['corriendo_para_hoy'] = 'SI';
                $expected['dep_fila'] = '1';
                $expected['depositado_anteriormente'] = '0.00';
                $expected['va_depositado'] = '0.00';
                if($base['dep_rota'] !== DepositarEn::ROTA_SIEMPRE)
                    $expected['falta_depositar'] = '0.00';
                else
                    $expected['falta_depositar'] = '55555.00';
                $expected['minutos_mostrado'] = '0';
                break;

            case DepositarEn::ROTA_DIARIO:
                $expected['dep_fila'] = $expected['dep_fila_ini'];
                $expected['depositado_anteriormente'] = '0.00';
                $expected['veces_mostrado'] = '0';
                $expected['completado_veces'] = '0';
                $expected['minutos_mostrado'] = '0';
                $expected['last_shown'] = null;
                $expected['inicie_causa'] = DepositarEn::LETRERO_CAMBIO_DIA;
                $expected['falta_depositar'] = "0.00";
                $expected['deposit_today_ini'] = '0.00';
                $expected['completada'] = DepositarEn::STATUS_COMPLETADA;
                $expected['fecha_completada'] = Date('Y-m-d');
                $expected['completado_veces'] = (string)($expected['completado_veces'] + 1);
                $expected['estaba_en'] = DepositarEn::ESTA_OCULTA;
                $expected['inicie_deposit_today'] = $expected['va_depositado'] = "$depositado";
                break;

            case DepositarEn::ROTA_TIEMPO_MONTO:
            case DepositarEn::ROTA_UNA_VEZ:
                /** @noinspection PhpRedundantOptionalArgumentInspection */
            $expected['inicie_causa'] =
                    DepositarEn::LETRERO_CONTINUO_DE_AYER . number_format((float)$expected['falta_depositar'], 0, '', ',') . '.';

                $expected['dep_fila'] = $expected['dep_fila_ini'];
                $expected['falta_depositar'] = "0.00";
                $expected['deposit_today_ini'] = '0.00';
                $expected['depositado_anteriormente'] = $expected['va_depositado'];
                $expected['completada'] = DepositarEn::STATUS_COMPLETADA;
                $expected['fecha_completada'] = Date('Y-m-d');
                $expected['completado_veces'] = (string)($expected['completado_veces'] + 1);
                $expected['estaba_en'] = DepositarEn::ESTA_OCULTA;

                $expected['inicie_deposit_today'] =  "0.00";
                $expected['va_depositado'] += $depositado;
                $expected['va_depositado'] = "$expected[va_depositado]";
                break;

            case DepositarEn::ROTA_REDONDO:
                $expected['corriendo_para_hoy'] = 'SI';
                $expected['completado_veces'] = '0';
                $expected['minutos_mostrado'] = '0';
                $expected['last_shown'] = null;
                $expected['dep_fila'] = '1';
                $expected['inicie_causa'] = DepositarEn::LETRERO_OCULTA_PASA_MUESTRA;

        }

        unset($expected['last_shown'], $actual['last_shown']);
        $this->assertEquals($expected, $actual);
    }

    /**
     * @covers DepositarEn::muestra
     */
    public function testMuestra() {
        $depositado = 1103.55;
        self::banco_cuenta_saldos_candence_bancomer($depositado);

        $diario = self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_DIARIO);
        $this->InsertaDepositaEn($diario);

        $diario['inicie_el'] = $diario['fecha'] = Date('Y-m-d');
        $diario['deposit_today_ini'] = 0.0;
        $diario['va_depositado'] = $depositado;
        $diario['falta_depositar'] = $diario['dep_amount_ini'] - $depositado;
        $diario['inicie_deposit_today'] = $diario['deposit_today'] ="$depositado";
        $diario['corriendo_para_hoy'] = 'SI';
        $diario['completado_veces'] = '0';
        $diario['minutos_mostrado'] = 0;
        $diario['veces_mostrado'] = 1;
        $diario['completado_veces'] = 0;
        $diario['dep_fila'] = 1;
        $diario['depositado_anteriormente'] = 0.0;
        $diario['inicie_causa'] = DepositarEn::LETRERO_CAMBIO_DIA;
        $diario['banco_id'] = '1';
        $diario['empresa_id'] = '16';
        $diario['moneda'] = 'PESOS';
        $diario['ultima_conciliacion'] = Date('Y-m-d');
        $diario['sbc'] = '0.00';
        $diario['min_ultima_conciliacion'] = '';
        $diario['do_flash_tab'] = false;

        $redondo = self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_REDONDO);
        ia_query(ia_insert('deposita_en', $redondo));

        $unaVez = self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_UNA_VEZ);
        $unaVez['dep_amount_ini'] = $depositado - 100;
        ia_query(ia_insert('deposita_en', $unaVez));

        $redondo['inicie_el'] = $redondo['fecha'] = Date('Y-m-d');
        $redondo['inicie_deposit_today'] = $redondo['deposit_today_ini'] = $redondo['deposit_today'] ="$depositado";
        $redondo['corriendo_para_hoy'] = 'SI';
        $redondo['completado_veces'] = '0';
        $redondo['minutos_mostrado'] = 0;
        $redondo['veces_mostrado'] = 1;
        $redondo['completado_veces'] = 0;
        $redondo['dep_fila'] = 2;
        $redondo['va_depositado'] = $redondo['depositado_anteriormente'] = 0.0;
        $redondo['inicie_causa'] = DepositarEn::LETRERO_OCULTA_PASA_MUESTRA;
        $redondo['banco_id'] = '1';
        $redondo['empresa_id'] = '16';
        $redondo['moneda'] = 'PESOS';
        $redondo['ultima_conciliacion'] = Date('Y-m-d');
        $redondo['sbc'] = '0.00';
        $redondo['min_ultima_conciliacion'] = '';
        $redondo['do_flash_tab'] = false;
        unset(
            $diario['last_shown'],
            $diario['veces_a_mostrar'],
            $diario['veces_mostrado'],
            $redondo['last_shown'],
            $redondo['veces_a_mostrar'],
            $redondo['veces_mostrado']
        );
        $expected = ["r01"  => [$diario], "r02"  => [$redondo] ];
        $depEn = new DepositarEnParaTest();
        /** @noinspection PhpExpressionResultUnusedInspection */
        $depEn->ponUnoPorCarrilRow();

        $actual = $depEn->muestra();
        foreach($actual as &$row) {
            foreach ($row as  $r => &$a) {
                $this->assertArrayHasKey('saldo', $a, "Envía saldo");
                $this->assertArrayHasKey('txt_ultima_conciliacion', $a, "Envía txt_ultima_conciliacion");
                unset($a['txt_ultima_conciliacion'], $a['saldo']);
                foreach (['last_shown', 'inicie_el', 'fecha_completada', 'alta_db', 'ultimo_cambio', 'ultima_conciliacion'] as $dateTime)
                    if (!empty($a[$dateTime]))
                        $a[$dateTime] = $this->convertDateTimeToDate($a[$dateTime]);
                unset(
                    $a['last_shown'],
                    $a['veces_a_mostrar'],
                    $a['veces_mostrado']
                );
            }
        }


        $this->assertEquals($expected, $actual);
    }

    /**
     * @covers DepositarEn::deposita_en_edit
     */
    public function paDeposita_en_edit() {
        $depositado = 1103.55;
        self::banco_cuenta_saldos_candence_bancomer($depositado);

        $diario = self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_DIARIO);
        $this->InsertaDepositaEn($diario);

        $diario['inicie_el'] = $diario['fecha'] = Date('Y-m-d');
        $diario['deposit_today_ini'] = 0.0;
        $diario['va_depositado'] = $depositado;
        $diario['falta_depositar'] = $diario['dep_amount_ini'] - $depositado;
        $diario['inicie_deposit_today'] = $diario['deposit_today'] ="$depositado";
        $diario['corriendo_para_hoy'] = 'SI';
        $diario['completado_veces'] = '0';
        $diario['minutos_mostrado'] = 0;
        $diario['veces_mostrado'] = 1;
        $diario['completado_veces'] = 0;
        $diario['dep_fila'] = 1;
        $diario['depositado_anteriormente'] = 0.0;
        $diario['inicie_causa'] = DepositarEn::LETRERO_CAMBIO_DIA;
        $diario['banco_id'] = '1';
        $diario['empresa_id'] = '16';
        $diario['moneda'] = 'PESOS';
        $diario['ultima_conciliacion'] = Date('Y-m-d');
        $diario['sbc'] = '0.00';
        $diario['min_ultima_conciliacion'] = '';
        $diario['do_flash_tab'] = false;

        $unaVez = self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_UNA_VEZ);
        $unaVez['dep_amount_ini'] = $depositado - 100;
        ia_query(ia_insert('deposita_en', $unaVez));

        $redondo = self::getDepositarEn( '2021-01-01', DepositarEn::ROTA_REDONDO);
        ia_query(ia_insert('deposita_en', $redondo));

        $redondo['inicie_el'] = $redondo['fecha'] = Date('Y-m-d');
        $redondo['inicie_deposit_today'] = $redondo['deposit_today_ini'] = $redondo['deposit_today'] ="$depositado";
        $redondo['corriendo_para_hoy'] = 'SI';
        $redondo['completado_veces'] = '0';
        $redondo['minutos_mostrado'] = 0;
        $redondo['veces_mostrado'] = 1;
        $redondo['completado_veces'] = 0;
        $redondo['dep_fila'] = 2;
        $redondo['va_depositado'] = $redondo['depositado_anteriormente'] = 0.0;
        $redondo['inicie_causa'] = DepositarEn::LETRERO_OCULTA_PASA_MUESTRA;
        $redondo['banco_id'] = '1';
        $redondo['empresa_id'] = '16';
        $redondo['moneda'] = 'PESOS';
        $redondo['ultima_conciliacion'] = Date('Y-m-d');
        $redondo['sbc'] = '0.00';
        $redondo['min_ultima_conciliacion'] = '';
        $redondo['do_flash_tab'] = false;

        $expected = [
            $diario['deposita_en_id']  => $diario,
            $redondo['deposita_en_id']  => $redondo,
            $unaVez['deposita_en_id']  => $unaVez,
        ];
        $depEn = new DepositarEnParaTest();
        /** @noinspection PhpExpressionResultUnusedInspection */
        $depEn->ponUnoPorCarrilRow();

        $actual = $depEn->deposita_en_edit();
        print_r($actual);

        $this->assertEquals($expected, $actual);
    }
//// Clicks de usuario tipo rony forzán

    /**
     * Click en reinicia día, todos deben iniciar como si se acabaran de dar de alta
     *
     * @covers DepositarEn::procesa
     * @covers DepositarEn::cambiaDiaCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaNoCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaContinuanDeAyer
     * @covers DepositarEn::normalizaDepRota
     *
     *
     * @dataProvider providerTodosHoy
     */
    public function testClickReiniciaDia(array $base) {
        self::banco_cuenta_saldos_candence_bancomer();
        // prepara deposita_en $base a probar
        $_SESSION['usuario_id'] = 1;
        $_REQUEST['refresh'] = 1;
        $_REQUEST['refresh_day'] = 1;

            $base['estaba_en'] = DepositarEn::ESTA_OCULTA;
            $base['completada'] = DepositarEn::STATUS_COMPLETADA;

            $base['last_shown'] =
            $base['fecha_completada'] =
            $base['inicie_el'] = Date('Y-m-d', strtotime("yesterday"));

            $base['dep_fila'] = 4;
            $base['depositado_anteriormente'] =
            $base['deposit_today_ini'] =
            $base['falta_depositar'] =
            $base['va_depositado'] =
            $base['inicie_deposit_today'] = 12.5;

            $base['completado_veces'] =
            $base['minutos_mostrado'] =
            $base['veces_mostrado'] = 3;


        // prepara db
            $this->InsertaDepositaEn($base);

            $depEn = new DepositarEnParaTest();
            $depEn->saldos = $depEn->banco_cuenta_saldos_get();
            $deposita_en_todos = $depEn->publicLeeDepositaEn();
            $depositaEn = reset( $deposita_en_todos );
            $saldoAhora = $depEn->publicSacaTotales($depositaEn);

        // pon expected
            $depositaEnExpected = $depositaEn;

            $depositaEnExpected = array_merge($depositaEnExpected, $saldoAhora);
            $depositaEn['dep_rota'] = $base['dep_rota'];
            $depositaEnExpected['deposit_today'] =
            $depositaEnExpected['deposit_today_ini'] =
            $depositaEnExpected['inicie_deposit_today'] =    '1111.00';
            $depositaEnExpected['falta_depositar'] = $depositaEn['dep_amount_ini'];
            $depositaEnExpected['depositado_anteriormente'] =
            $depositaEnExpected['va_depositado'] = 0.0;


            $depositaEnExpected['estaba_en'] = DepositarEn::ESTA_VISIBLE;
            $depositaEnExpected['completada'] = DepositarEn::STATUS_VIGENTE;
            $depositaEnExpected['fecha_completada'] = NULL;
            $depositaEnExpected['corriendo_para_hoy'] = 'SI';

            $depositaEnExpected['completado_veces'] = 0;
            $depositaEnExpected['minutos_mostrado'] = 0;
            $depositaEnExpected['veces_mostrado'] = 1;


            $depositaEnExpected['last_shown'] = NULL;
            $depositaEnExpected['inicie_el'] = Date('Y-m-d');
            $depositaEnExpected['inicie_causa'] = DepositarEn::LETRERO_CLICK_REINICIA_DIA;

            $depositaEnExpected['dep_fila'] = 1;

        // corre
            $got =  $depEn->publicProcesa();
            $depositaEn = reset( $got);
            unset( $_REQUEST['refresh_day'], $_REQUEST['refresh']);
       // ajusta orden y minutos para comprobar
            ksort($depositaEn);
            ksort($depositaEnExpected);
            if(!empty($depositaEn['inicie_el']))
                $depositaEn['inicie_el'] = Date('Y-m-d', strtotime($depositaEn['inicie_el']));
            if(!empty($depositaEn['fecha_completada']))
                $depositaEn['fecha_completada'] = Date('Y-m-d', strtotime($depositaEn['fecha_completada']));

        // prueba
            unset($depositaEnExpected['last_shown'], $depositaEn['last_shown']);
            $this->assertEquals($depositaEnExpected, $depositaEn);
    }

    /**
     * Simula un click en forzá reinicia o edición importante
     *
     * @covers DepositarEn::procesa
     * @covers DepositarEn::cambiaDiaCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaNoCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaContinuanDeAyer
     * @covers DepositarEn::normalizaDepRota
     *
     *
     * @dataProvider providerTodosHoy
     */
    public function testClickForzaReinicio(array $base) {
        self::banco_cuenta_saldos_candence_bancomer();
        // prepara deposita_en $base a probar
        $_SESSION['usuario_id'] = 1;
        $_REQUEST['forza_refresh'] = 1;
        $_REQUEST['deposita_en_id'] = $base['deposita_en_id'];

        $base['estaba_en'] = DepositarEn::ESTA_OCULTA;
        $base['completada'] = DepositarEn::STATUS_COMPLETADA;

        $base['last_shown'] =
        $base['fecha_completada'] =
        $base['inicie_el'] = Date('Y-m-d', strtotime("yesterday"));

        $base['dep_fila'] = 4;
        $base['depositado_anteriormente'] =
        $base['deposit_today_ini'] =
        $base['falta_depositar'] =
        $base['va_depositado'] =
        $base['inicie_deposit_today'] = 12.5;

        $base['completado_veces'] =
        $base['minutos_mostrado'] =
        $base['veces_mostrado'] = 3;


        // prepara db
        $this->InsertaDepositaEn($base);

        $depEn = new DepositarEnParaTest();
        $depEn->saldos = $depEn->banco_cuenta_saldos_get();
        $deposita_en_todos = $depEn->publicLeeDepositaEn();
        $depositaEn = reset( $deposita_en_todos );
        $saldoAhora = $depEn->publicSacaTotales($depositaEn);

        // pon expected
        $depositaEnExpected = $depositaEn;

        $depositaEnExpected = array_merge($depositaEnExpected, $saldoAhora);
        $depositaEn['dep_rota'] = $base['dep_rota'];
        $depositaEnExpected['deposit_today'] =
        $depositaEnExpected['deposit_today_ini'] =
        $depositaEnExpected['inicie_deposit_today'] =    '1111.00';
        $depositaEnExpected['falta_depositar'] = $depositaEn['dep_amount_ini'];
        $depositaEnExpected['depositado_anteriormente'] =
        $depositaEnExpected['va_depositado'] = 0.0;


        $depositaEnExpected['estaba_en'] = DepositarEn::ESTA_VISIBLE;
        $depositaEnExpected['completada'] = DepositarEn::STATUS_VIGENTE;
        $depositaEnExpected['fecha_completada'] = NULL;
        $depositaEnExpected['corriendo_para_hoy'] = 'SI';

        $depositaEnExpected['completado_veces'] = 0;
        $depositaEnExpected['minutos_mostrado'] = 0;
        $depositaEnExpected['veces_mostrado'] = 1;


        $depositaEnExpected['last_shown'] = NULL;
        $depositaEnExpected['inicie_el'] = Date('Y-m-d');
        $depositaEnExpected['inicie_causa'] = DepositarEn::LETRERO_REINICIA_POR_ID;

        $depositaEnExpected['dep_fila'] = 1;

        // corre
        $got =  $depEn->publicProcesa();
        $depositaEn = reset( $got);
        unset( $_REQUEST['deposita_en_id'], $_REQUEST['forza_refresh']);
        // ajusta orden y minutos para comprobar
        ksort($depositaEn);
        ksort($depositaEnExpected);
        if(!empty($depositaEn['inicie_el']))
            $depositaEn['inicie_el'] = Date('Y-m-d', strtotime($depositaEn['inicie_el']));
        if(!empty($depositaEn['fecha_completada']))
            $depositaEn['fecha_completada'] = Date('Y-m-d', strtotime($depositaEn['fecha_completada']));

        // prueba
        unset($depositaEnExpected['last_shown'], $depositaEn['last_shown']);
        $this->assertEquals($depositaEnExpected, $depositaEn);

    }

        #[Pure]
        #[ArrayShape([DepositarEn::SHAPE_DEPOSITA_EN])]
        public function providerTodosHoy():array {
            $hoy = Date('Y-m-d');
            return [
                DepositarEn::ROTA_DIARIO => [self::getDepositarEn( $hoy, DepositarEn::ROTA_DIARIO)],
                DepositarEn::ROTA_REDONDO => [self::getDepositarEn( $hoy, DepositarEn::ROTA_REDONDO)],
                DepositarEn::ROTA_UNA_VEZ => [self::getDepositarEn( $hoy, DepositarEn::ROTA_UNA_VEZ)],
                DepositarEn::ROTA_TIEMPO_MONTO => [self::getDepositarEn( $hoy, DepositarEn::ROTA_TIEMPO_MONTO)],
                DepositarEn::ROTA_SIEMPRE => [self::getDepositarEn( $hoy, DepositarEn::ROTA_SIEMPRE)],
                DepositarEn::ROTA_NO_DEPOSITAR => [self::getDepositarEn( $hoy, DepositarEn::ROTA_NO_DEPOSITAR)],
                DepositarEn::ROTA_SAFETY => [self::getDepositarEn( $hoy, DepositarEn::ROTA_SAFETY)],
            ];
        }

    /**
     * Click en completar completen los deposita_en (redondo rota porque , De 1 en 1 deposita_en
     *
     * @covers DepositarEn::procesa
     * @covers DepositarEn::cambiaDiaCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaNoCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaContinuanDeAyer
     * @covers DepositarEn::normalizaDepRota
     *
     *
     * @dataProvider providerPuedenPasarACompletadaHoy
     */
    public function testClickCompletar(array $base) {
        self::banco_cuenta_saldos_candence_bancomer();
        $_SESSION['usuario_id'] = 1;

        $base['estaba_en'] = DepositarEn::ESTA_VISIBLE;
        $base['completada'] = DepositarEn::STATUS_VIGENTE;
        $base['fecha_completada'] = NULL;
        $base['completado_veces'] = 2;
        $this->InsertaDepositaEn($base);

        $expected = [
            'completada' => $base['dep_rota'] === DepositarEn::ROTA_REDONDO ? DepositarEn::STATUS_VIGENTE : DepositarEn::STATUS_COMPLETADA,
            'completado_veces' => '3',
            'fecha_completada' => Date('Y-m-d'),
            'dep_rota' => $base['dep_rota'],

        ];

        $depEn = new DepositarEnParaTest($base['deposita_en_id']);
        $got =  $depEn->publicProcesa();

        $depositaEn = ia_singleton("SELECT * FROM deposita_en WHERE deposita_en_id=" . strit($base['deposita_en_id']));
        $actual = array_intersect_key($depositaEn, $expected);

        $actual['fecha_completada'] = Date('Y-m-d', strtotime($actual['fecha_completada'] ?? 'today'));
        $this->assertEquals($expected, $actual);
        if($base['dep_rota'] !== DepositarEn::ROTA_REDONDO)
            $this->assertEquals([], $got);
    }

        #[Pure]
        #[ArrayShape([DepositarEn::SHAPE_DEPOSITA_EN])]
        public function providerPuedenPasarACompletadaHoy():array {
            $hoy = Date('Y-m-d');
            return [

                DepositarEn::ROTA_DIARIO => [self::getDepositarEn($hoy, DepositarEn::ROTA_DIARIO)],
                DepositarEn::ROTA_REDONDO => [self::getDepositarEn($hoy, DepositarEn::ROTA_REDONDO)],
                DepositarEn::ROTA_UNA_VEZ => [self::getDepositarEn($hoy, DepositarEn::ROTA_UNA_VEZ)],
                DepositarEn::ROTA_TIEMPO_MONTO => [self::getDepositarEn($hoy, DepositarEn::ROTA_TIEMPO_MONTO)],
            ];
        }

    /**
     * Click en forza rotar sólo tiempo monto cambia, De 1 en 1 deposita_en
     *
     * @covers DepositarEn::procesa
     * @covers DepositarEn::cambiaDiaCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaNoCuentanDepositosAntesDeAhorita
     * @covers DepositarEn::cambiaDiaContinuanDeAyer
     * @covers DepositarEn::normalizaDepRota
     *
     *
     * @dataProvider providerTodosAyer
     */
    public function testClickRota(array $base) {
        self::banco_cuenta_saldos_candence_bancomer();
        $_SESSION['usuario_id'] = 1;

        $this->InsertaDepositaEn($base);
        $setup = new DepositarEnParaTest();
        $setup->publicProcesa();
        $expected = ia_singleton("SELECT * FROM deposita_en WHERE deposita_en_id=" . strit($base['deposita_en_id']));

        $depEn = new DepositarEnParaTest(null,$base['deposita_en_id']);
        $depEn->publicProcesa();
        $actual = ia_singleton("SELECT * FROM deposita_en WHERE deposita_en_id=" . strit($base['deposita_en_id']));

        foreach(['alta_db', 'ultimo_cambio', 'last_shown', 'inicie_el'] as $dateTime) {
            $actual[$dateTime] = $this->convertDateTimeToDate($actual[$dateTime]);
            $expected[$dateTime] = $this->convertDateTimeToDate($expected[$dateTime]);
        }

        $expected['last_shown'] = Date('Y-m-d');
        $expected['minutos_mostrado'] = '0';
        unset(
            $expected['minutos_mostrado'], $actual['minutos_mostrado'],
            $expected['veces_mostrado'], $actual['veces_mostrado'],
            $expected['last_shown'], $actual['last_shown']
        );
        $this->assertEquals($expected, $actual);

    }


//// Rota por tiempo
    /**
     * roten por tiempo Tiempo o Monto y no las demás , De 1 en 1 deposita_en
     *
     * @covers DepositarEn::rotaPorTiempo
     * @covers DepositarEn::maxFilaPorCola
     *
     *
     * @uses DepositarEn::__construct
     * @uses DepositarEn::simula_completar_por_monto
     * @uses DepositarEn::simula_rotar_por_minutos
     * @uses DepositarEn::setParametros
     * @uses ::usuarioTipoRony()
     *
     * @dataProvider providerRotaPorTiempo
     */
    public function testRotaPorTiempo(array $d, array $dExpected, array $updateRecord,array $updateRecordExpected) {
        self::banco_cuenta_saldos_candence_bancomer();

        $depEn = new DepositarEnParaTest();
        $depEn->publicMaxFilaPorCola();
        $depEn->publicRotaPorTiempo($d, $updateRecord);
        $this->assertEquals($dExpected, $d);
        $this->assertEquals($updateRecord, $updateRecordExpected);
    }

        #[Pure]
        #[ArrayShape([DepositarEn::SHAPE_DEPOSITA_EN])]
        public function providerRotaPorTiempo():array {

            $updateRecord = ['campo' => 'no cambia'];
            $ret = [];

            // no rotan por tiempo
                $noRotanPorTiempo = [
                    DepositarEn::ROTA_NO_DEPOSITAR,
                    DepositarEn::ROTA_SIEMPRE,
                    DepositarEn::ROTA_SAFETY,
                    DepositarEn::ROTA_UNA_VEZ,
                    DepositarEn::ROTA_DIARIO,
                    DepositarEn::ROTA_REDONDO
                ];
                foreach($noRotanPorTiempo as $dep_rota) {
                    $deposita_en = $this->getDepositarEn('', $dep_rota);
                    $deposita_en['minutos_a_mostrar'] = 80;
                    $deposita_en['minutos_mostrado'] = 82;
                    $ret[$dep_rota . ' no rota por tiempo aunque es el minuto 82 de 80'] = [
                        $deposita_en, $deposita_en,
                        $updateRecord, $updateRecord
                    ];

                }



            // Tiempo o Monto no rota
                $tiempoMonto = $this->getDepositarEn('', DepositarEn::ROTA_TIEMPO_MONTO);
                $tiempoMonto['minutos_a_mostrar'] = 80;
                $tiempoMonto['minutos_mostrado'] = 21;
                $tiempoMonto['completada'] = DepositarEn::STATUS_COMPLETADA;
                $ret[DepositarEn::ROTA_TIEMPO_MONTO. " no rota: esta completada aunque es el minuto 21 de 80"] =
                    [$tiempoMonto, $tiempoMonto, $updateRecord, $updateRecord];

                $tiempoMonto = $this->getDepositarEn('', DepositarEn::ROTA_TIEMPO_MONTO);
                $tiempoMonto['minutos_a_mostrar'] = 80;
                $tiempoMonto['minutos_mostrado'] = 21;
                $ret[DepositarEn::ROTA_TIEMPO_MONTO. " no rota: es el minuto 21 de 80"] =
                    [$tiempoMonto, $tiempoMonto, $updateRecord, $updateRecord];

                $tiempoMonto = $this->getDepositarEn('', DepositarEn::ROTA_TIEMPO_MONTO);
                $tiempoMonto['minutos_mostrado'] = 82;
                $tiempoMonto['minutos_a_mostrar'] = 0;
                $ret[DepositarEn::ROTA_TIEMPO_MONTO. " no rota: es el minuto 82 de 0, pero 0 es no rotar"] =
                    [$tiempoMonto, $tiempoMonto, $updateRecord, $updateRecord];


            // si rotan por tiempo
                $tiempoMonto = $this->getDepositarEn('', DepositarEn::ROTA_TIEMPO_MONTO);
                $tiempoMonto['minutos_a_mostrar'] = 80;
                $tiempoMonto['minutos_mostrado'] = 82;
                $tiempoMontoExpected = $tiempoMonto;
                $updateRecordExpected = $updateRecord;
                $updateRecordExpected['estaba_en'] = $tiempoMontoExpected['estaba_en'] = DepositarEn::ESTA_OCULTA;
                $updateRecordExpected['dep_fila'] = $tiempoMontoExpected['dep_fila'] =  10;
                $updateRecordExpected['minutos_mostrado'] = $tiempoMontoExpected['minutos_mostrado'] =  0;
                $ret[DepositarEn::ROTA_TIEMPO_MONTO. " ¡Si Rota!  es el minuto 82 de 80"] =
                    [$tiempoMonto, $tiempoMontoExpected, $updateRecord, $updateRecordExpected];

                $tiempoMonto = $this->getDepositarEn('', DepositarEn::ROTA_TIEMPO_MONTO);
                $tiempoMonto['minutos_a_mostrar'] = 80;
                $tiempoMonto['minutos_mostrado'] = 82;
                $tiempoMonto['estaba_en'] = DepositarEn::ESTA_OCULTA;
                $tiempoMontoExpected = $tiempoMonto;
                $updateRecordExpected = $updateRecord;
                $updateRecordExpected['estaba_en'] = $tiempoMontoExpected['estaba_en'] = DepositarEn::ESTA_OCULTA;
                $updateRecordExpected['dep_fila'] = $tiempoMontoExpected['dep_fila'] =  10;
                $updateRecordExpected['minutos_mostrado'] = $tiempoMontoExpected['minutos_mostrado'] =  0;
                $ret[DepositarEn::ROTA_TIEMPO_MONTO. " rota en " . DepositarEn::ESTA_OCULTA . " para estar listo para la proxima"] =
                    [$tiempoMonto, $tiempoMontoExpected, $updateRecord, $updateRecordExpected];

            return $ret;
        }

/// Helpers
    public function convertDateTimeToDate($fecha):string|null {
        if(empty($fecha))
            return $fecha;
        return Date('Y-m-d', strtotime($fecha) );
    }

    public static function banco_cuenta_saldos_candence_bancomer($ingreso_today = 1111.00) {
        $updateSaldoCandenceBancomer =[
            'sbc' => 0.00,
            'deposit_cash' => $ingreso_today,
            'deposit_total' => $ingreso_today,
            'ingreso_today' => $ingreso_today,

            'ultima_conciliacion'=>'NOW()',
        ];
        ia_query(ia_update('banco_cuenta_saldos', $updateSaldoCandenceBancomer,
            ['banco_cuenta_id' => self::$bancoCandenceBancomer['banco_cuenta_id']]));
        self::$depositaEn = new DepositarEn();
    }

    public function InsertaDepositaEn($base) {
        /** @noinspection SqlWithoutWhere */
        ia_query("DELETE FROM deposita_en");
        ia_query(ia_insert('deposita_en', $base, [], '', true));
    }

}
