<?php
declare(strict_types=1);
namespace inc;

use GetColorsHelper;
use PHPUnit\Framework\TestCase;
use Iac\inc\sql\IacSqlBuilder;


/**
 * @covers GetColorsHelper
 */
class GetColorsHelperTest extends TestCase{

    const NOTA_BODEGA_ID = '54bf6469e2ccb35411ee6133087ab12Z';
    const PRODUCTO_GENERAL_ID = '54bf6469e2cc850b11ec1ca9fdfac21f';
    const ES_UPDATE = '0';
    const ES_ALTA = '1';

    const NOTA_BODEGA_ITEM_ID = '54bf6469e2ccb35411ee613308aaaaaa';

    public static function setUpBeforeClass(): void {
        $entrada = [
            'nota_bodega_id' => self::NOTA_BODEGA_ID,
            'numero' => '40173',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Traslado',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => self::PRODUCTO_GENERAL_ID,
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-10-02 08:50:23", "alta_por": "rony", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "1"}]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-10-02 08:50:21", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'ayudantes' => 'SIN AYUDANTES',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-10-02 08:50:24", "display": "SIN AYUDANTES", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-10-02 09:50:30", "alta_por": "rony", "compra_id": "54bf6469e2ccb35411ee6132e361c54a", "fue_error": "No", "numero_compra": 2199}]',
            'numero_compra_actual' => '2199',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "index": "1", "alta_db": "2023-10-02 08:50:27", "display": "IVÁN BRAYAN MATA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $entrada_items = [
            0 => [
                'nota_bodega_item_id' => '0a0027000013903911eeaa9106aec87f',
                'nota_bodega_id' => self::NOTA_BODEGA_ID,
                'producto_bodega_id' => '74867af2fe60845411ecaa03953dd312_54bf6469e2cc850b11ec1c9b55f17f78_54bf6469e2cc850b11ec1c8e8e9a60a2',
                'rollos' => '2.00',
                'quantity' => '50.20',
                'es_saldo' => 'No',
                'en_remate' => 'No',
                'lento' => 'No',
                'super_lento' => 'No',
                'alta_db' => '2024-01-03 18:37:15',
                'alta_por' => 'sistema',
                'ultimo_cambio' => '2024-01-03 18:37:15',
                'ultimo_cambio_por' => 'rony',
                //'bodega_id' => '74867af2fe60845411ecaa03953dd312',
                //'color_id' => '54bf6469e2cc850b11ec1c8e8e9a60a2',
                'rollosNegativo' => '0',
                'quantityNegativo' => '0',
                'averageMal' => '0',
                'nuevoProducto' => '0',
                'producto_color_calidad' => '',
                'producto_color_calidad_comentario' => '',
            ],
            1 => [
                'nota_bodega_item_id' => '0a0027000013903911eeaa9106b011a9',
                'nota_bodega_id' => self::NOTA_BODEGA_ID,
                'producto_bodega_id' => '74867af2fe60845411ecaa03953dd312_54bf6469e2cc850b11ec1c9b55f17f78_54bf6469e2cc850b11ec1c8ef9bb590d',
                'rollos' => '1.00',
                'quantity' => '25.10',
                'es_saldo' => 'No',
                'en_remate' => 'No',
                'lento' => 'No',
                'super_lento' => 'No',
                'alta_db' => '2024-01-03 18:37:15',
                'alta_por' => 'sistema',
                'ultimo_cambio' => '2024-01-03 18:37:15',
                'ultimo_cambio_por' => 'rony',
                //'bodega_id' => '74867af2fe60845411ecaa03953dd312',
                //'color_id' => '54bf6469e2cc850b11ec1c8ef9bb590d',
                'rollosNegativo' => '0',
                'quantityNegativo' => '0',
                'averageMal' => '0',
                'nuevoProducto' => '0',
                'producto_color_calidad' => '',
                'producto_color_calidad_comentario' => '',
            ],
        ];
        $sql = [];

        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $method = __METHOD__;

        $sql[] = "DELETE /*$method*/ FROM nota_bodega_items WHERE nota_bodega_id = ".strit(self::NOTA_BODEGA_ID);
        $sql[] = "DELETE /*$method*/ FROM nota_bodega WHERE nota_bodega_id = ".strit(self::NOTA_BODEGA_ID);



        $sql[] = $builder->insert('nota_bodega', $entrada, true);
        //$sql[] = $builder->insert('nota_bodega_items', $entrada_items, true),
        foreach($entrada_items as $item){
            $sql[] = $builder->insert('nota_bodega_items', $item, true);
        }

        if(ia_transaction($sql)){
            ia_errores_a_dime();
            var_dump('Error al hacer querys de inicio');
        }

    }

    /**
     * @covers GetColorsHelper::calculateColors
     * @covers GetColorsHelper::getNotaColors
     * @covers GetColorsHelper::getColors
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayKey
     * @covers assoc_mysql2mysqli
     * @covers ia_sqlArray
     * @covers sqlMysqli::log_trace
     * @covers strit
     * @covers the_error_handler
     */
    public function testCalculateColors(){
        /*
            caso 1: Alta de nota, SI_ES_ALTA y trae unicamente todos los colores activos
            caso 2: Actualizar, update una nota. NO_ES_ALTA. y trae colores activos mas los de la nota y no se duplican. NO HAY colores inactivos en en producto colro en la nota
            caso 2: Actualizar, update una nota. NO_ES_ALTA. y trae colores activos mas los de la nota y no se duplican. Esta en otra function

         */
        $method = __METHOD__;
        $resultado = GetColorsHelper::calculateColors(self::PRODUCTO_GENERAL_ID, self::ES_ALTA, self::NOTA_BODEGA_ID);
        $this->assertNotEmpty($resultado, 'Error o no encontre colores activos para el producto ' . self::PRODUCTO_GENERAL_ID);
        $query = "SELECT  /*$method*/ 
            pg.producto_general_id, 
            c.color_id, 
            c.color  as label, 
            c.color , 
            c.orden, 
            pg.producto,
            c.color_valor, 
            c.color_id as real_data, 
            c.color_id as real_value, 
            c.color as value
        FROM producto_color as pc
                 JOIN producto_general AS pg ON pc.producto_general_id = pg.producto_general_id
                 JOIN color as c ON pc.color_id = c.color_id
        WHERE pg.producto_general_id = ".strit(self::PRODUCTO_GENERAL_ID)."  AND pc.prohibido='No'  AND c.activo='Si' AND pc.activo='Si' ORDER BY c.orden, c.color";
        $coloresValidosEnProductoColorYColor = ia_sqlArray($query, "color_id");
        $this->assertEquals($coloresValidosEnProductoColorYColor, $resultado, "en nueva nota verifica traiga solo los colores activos en color y en producto_color y no prohibidos");


        $resultado = GetColorsHelper::calculateColors(self::PRODUCTO_GENERAL_ID, self::ES_UPDATE, self::NOTA_BODEGA_ID);
        $this->assertNotEmpty($resultado, 'Error o no encontre colores activos para el producto ' . self::PRODUCTO_GENERAL_ID);
        $query = "SELECT /*$method*/ 
            pg.producto_general_id, 
            c.color_id, 
            c.color  as label, 
            c.color , 
            c.orden, 
            pg.producto,
            c.color_valor, 
            c.color_id as real_data, 
            c.color_id as real_value, 
            c.color as value
        FROM nota_bodega nb JOIN nota_bodega_items as pc ON nb.nota_bodega_id = pc.nota_bodega_id
                 JOIN producto_general AS pg ON nb.producto_general_id = pg.producto_general_id
                 JOIN color as c ON pc.color_id = c.color_id
        WHERE  nb.nota_bodega_id = ".strit(self::NOTA_BODEGA_ID)." ORDER BY c.orden, c.color";
        $coloresEnItemsDeLaNota = ia_sqlArray($query, "color_id");

        $this->assertEquals(array_merge($coloresValidosEnProductoColorYColor, $coloresEnItemsDeLaNota), $resultado, "en update colores activos, no prohibidos o estan en los items de la nota");

    }

    /**
     * @covers GetColorsHelper::calculateColors
     * @covers GetColorsHelper::getNotaColors
     * @covers GetColorsHelper::getColors
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayKey
     * @covers assoc_mysql2mysqli
     * @covers ia_sqlArray
     * @covers sqlMysqli::log_trace
     * @covers strit
     * @covers the_error_handler
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::commit
     * @covers Iac\inc\sql\IacMysqli::queryArray
     * @covers Iac\inc\sql\IacMysqli::transaction
     * @covers ia_transaction
     */
    public function testNonActiveColor(){
        $method = __METHOD__;
        $sql[] = "UPDATE /*$method*/ producto_color SET activo = 'No' WHERE (producto_color_id = '74867af2fe60ad6b11ec6f20d6ceeb0b' and producto_general_id = ".strit(self::PRODUCTO_GENERAL_ID).")";

        if(ia_transaction($sql)){
            ia_errores_a_dime();
            var_dump('Error al hacer querys testNonActiveColor');
        }
        /*
         * Inactivar un color en la nota de alta no viene
         * Al editar una nota y no esta en su nota_bodega_items no viene
         * Al editar una nota y SI esta en su nota_bodega_items si viene
         *
         */

        $resultado = GetColorsHelper::calculateColors(self::PRODUCTO_GENERAL_ID, self::ES_UPDATE, self::NOTA_BODEGA_ID);
        $this->assertArrayNotHasKey('74867af2fe60ad6b11ec6f20d6ceeb0b', $resultado, 'Desactiva en producto_color un color que no esta en la nota En Update no debe traerlo');

        $resultado_alta = GetColorsHelper::calculateColors(self::PRODUCTO_GENERAL_ID, self::ES_ALTA, self::NOTA_BODEGA_ID);
        $this->assertArrayNotHasKey('74867af2fe60ad6b11ec6f20d6ceeb0b', $resultado_alta, 'Desactiva en producto_color un color que no esta en la nota En Alta no debe traerlo');
    }


    public function testNonActiveItemsOnUpdate(){
        $entrada = [
            'nota_bodega_id' => '54bf6469e2ccb35411ee6133087abc12',
            'numero' => '40173',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Traslado',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-10-02 08:50:23", "alta_por": "rony", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "1"}]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-10-02 08:50:21", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'ayudantes' => 'SIN AYUDANTES',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-10-02 08:50:24", "display": "SIN AYUDANTES", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-10-02 09:50:30", "alta_por": "rony", "compra_id": "54bf6469e2ccb35411ee6132e361c54a", "fue_error": "No", "numero_compra": 2199}]',
            'numero_compra_actual' => '2199',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "index": "1", "alta_db": "2023-10-02 08:50:27", "display": "IVÁN BRAYAN MATA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $entrada_items = [
            0 => [
                'nota_bodega_item_id' => '0a0027000013903911eeaa9106aec87f',
                'nota_bodega_id' => '54bf6469e2ccb35411ee6133087abc12',
                'producto_bodega_id' => '74867af2fe60845411ecaa03953dd312_54bf6469e2cc850b11ec1c9b55f17f78_54bf6469e2cc850b11ec1c8e8e9a60a2',
                'rollos' => '2.00',
                'quantity' => '50.20',
                'es_saldo' => 'No',
                'en_remate' => 'No',
                'lento' => 'No',
                'super_lento' => 'No',
                'alta_db' => '2024-01-03 18:37:15',
                'alta_por' => 'sistema',
                'ultimo_cambio' => '2024-01-03 18:37:15',
                'ultimo_cambio_por' => 'rony',
                //'bodega_id' => '74867af2fe60845411ecaa03953dd312',
                //'color_id' => '54bf6469e2cc850b11ec1c8e8e9a60a2',
                'rollosNegativo' => '0',
                'quantityNegativo' => '0',
                'averageMal' => '0',
                'nuevoProducto' => '0',
                'producto_color_calidad' => '',
                'producto_color_calidad_comentario' => '',
            ],
            1 => [
                'nota_bodega_item_id' => '0a0027000013903911eeaa9106b011a9',
                'nota_bodega_id' => '54bf6469e2ccb35411ee6133087abc12',
                'producto_bodega_id' => '74867af2fe60845411ecaa03953dd312_54bf6469e2cc850b11ec1c9b55f17f78_54bf6469e2cc850b11ec1c8ef9bb590d',
                'rollos' => '1.00',
                'quantity' => '25.10',
                'es_saldo' => 'No',
                'en_remate' => 'No',
                'lento' => 'No',
                'super_lento' => 'No',
                'alta_db' => '2024-01-03 18:37:15',
                'alta_por' => 'sistema',
                'ultimo_cambio' => '2024-01-03 18:37:15',
                'ultimo_cambio_por' => 'rony',
                //'bodega_id' => '74867af2fe60845411ecaa03953dd312',
                //'color_id' => '54bf6469e2cc850b11ec1c8ef9bb590d',
                'rollosNegativo' => '0',
                'quantityNegativo' => '0',
                'averageMal' => '0',
                'nuevoProducto' => '0',
                'producto_color_calidad' => '',
                'producto_color_calidad_comentario' => '',
            ],
        ];
        $method = __METHOD__;
        $sql = [];

        $builder = new \Iac\inc\sql\IacSqlBuilder();

        $sql[] = "DELETE  /*$method*/ FROM nota_bodega_items WHERE nota_bodega_id = ".strit('54bf6469e2ccb35411ee6133087abc12');
        $sql[] = "DELETE  /*$method*/ FROM nota_bodega WHERE nota_bodega_id = ".strit('54bf6469e2ccb35411ee6133087abc12');

        $sql[] = $builder->insert('nota_bodega', $entrada, true, comment: __METHOD__);
        //$sql[] = $builder->insert('nota_bodega_items', $entrada_items, true),
        foreach($entrada_items as $item){
            $sql[] = $builder->insert('nota_bodega_items', $item, true, comment: __METHOD__);
        }

        $sql[] = "UPDATE /*$method*/ producto_color SET activo = 'No' WHERE producto_general_id = ".strit('54bf6469e2cc850b11ec1ca9fdfac21f')." and color_id in ('54bf6469e2cc850b11ec1c8e8e9a60a2', '54bf6469e2cc850b11ec1c8ef9bb590d')";

        if(ia_transaction($sql)){
            ia_errores_a_dime();
            var_dump('Error al hacer querys testNonActiveItemsInUpdate');
        }

        $nota_bodega = ia_singleton("select /*$method*/ * from nota_bodega where nota_bodega_id = '54bf6469e2ccb35411ee6133087abc12'");
        $resultado_alta = GetColorsHelper::calculateColors($nota_bodega["producto_general_id"], self::ES_UPDATE, $nota_bodega["nota_bodega_id"]);

        $this->assertArrayHasKey('54bf6469e2cc850b11ec1c8e8e9a60a2', $resultado_alta, 'ES UPDATE y el color inactivado en producto color se junta con los activos por que esta en nota item 1');

        $this->assertArrayHasKey('54bf6469e2cc850b11ec1c8ef9bb590d', $resultado_alta, 'ES UPDATE y el color inactivo se junta con los activos por que esta en nota item 1');

    }


}