<?php
declare(strict_types=1);

use PHPUnit\Framework\TestCase;


/**
* @covers Iac\inc\sql\IacMysqli
 * @uses ::assoc_mysql2mysqli
 * @covers ::ia_singleread
 * @covers sqlMysqli::log_trace
 * @uses URLify::downcode
 * @uses URLify::init
 * @uses ::strit
 * @uses ::fieldit
 */
class HelpersFunctionsTest extends TestCase {



    /**
     * Corre antes de todas las pruebas de esta clase
     * Pone bodegas y usuarios de prueba
     */
    public static function setUpBeforeClass(): void {
        $_SESSION["usuario"] = 'rony';
    }

    /**
     * @covers ::cuentat_mov_default_record
     * @dataProvider  providerCuentat_mov_default_record
     * @test
     */
    public function testCuentat_mov_default_record($id,$cantidad,$tipo,$moneda,$tipoCampo,$fecha, $expected) {
        $this->assertSame($expected,
            cuentat_mov_default_record($id,$cantidad,$tipo,$moneda,$tipoCampo,$fecha) );
    }

    public function providerCuentat_mov_default_record() {
        return [
            'Ingreso todos los valores, pesos' => ['id', '1234.56', 'Ingreso', 1, 1, '2021-01-02 15:16:17',
                [
                    'cuentaT_mov_id' => 'id',
                    'cuentaT_id' => '',
                    'fecha' => '2021-01-02 15:16:17',
                    'cuentaT_tipo_mov_id' => 1,
                    'monto' => '1234.56',
                    'egreso' => 0,
                    'moneda_id' => 1,
                    'tipo_cambio' => 1,
                    'banco_cuenta_id' => 0,
                    'referencia' => '',
                    'remarks' => '',
                    'banco_cuenta_mov_link_id' => '',
                    'cuentaT_deliveredto_id' => 0,
                    'esta_en' => 'done',
                    'cuentaT_transferto_id' => 0,
                    'quantity_total' => 0,
                    'ultimo_cambio' => 'NOW()',
                    'ultimo_cambio_por' => 'rony',
                    'alta_db' => 'NOW()',
                    'alta_por' => 'rony',
                    'tipo' => 'Ingreso',
                    'origen_mov_id' => '',
                    'contra_mov_id' => '',
                    'saldo_corriente_mxp' => 0.0,
                    'saldo_corriente_usd' => 0.0,
                ],
            ],

            'Transfer Accepted todos los valores, pesos' => ['id', '1234.56', 'Transfer Accepted', 1, 1, '2021-01-02 15:16:17',
                [
                    'cuentaT_mov_id' => 'id',
                    'cuentaT_id' => '',
                    'fecha' => '2021-01-02 15:16:17',
                    'cuentaT_tipo_mov_id' => 1,
                    'monto' => '1234.56',
                    'egreso' => 0,
                    'moneda_id' => 1,
                    'tipo_cambio' => 1,
                    'banco_cuenta_id' => 0,
                    'referencia' => '',
                    'remarks' => '',
                    'banco_cuenta_mov_link_id' => '',
                    'cuentaT_deliveredto_id' => 0,
                    'esta_en' => 'done',
                    'cuentaT_transferto_id' => 0,
                    'quantity_total' => 0,
                    'ultimo_cambio' => 'NOW()',
                    'ultimo_cambio_por' => 'rony',
                    'alta_db' => 'NOW()',
                    'alta_por' => 'rony',
                    'tipo' => 'Transfer Accepted',
                    'origen_mov_id' => '',
                    'contra_mov_id' => '',
                    'saldo_corriente_mxp' => 0.0,
                    'saldo_corriente_usd' => 0.0,
                ],
            ],

            'Egresos usd todos los valores, pesos' => ['id2', '1234.56', 'Egreso', 2, 21, '2021-01-02 15:16:17',
                [
                    'cuentaT_mov_id' => 'id2',
                    'cuentaT_id' => '',
                    'fecha' => '2021-01-02 15:16:17',
                    'cuentaT_tipo_mov_id' => 1,
                    'monto' => 0,
                    'egreso' => '1234.56',
                    'moneda_id' => 2,
                    'tipo_cambio' => 21,
                    'banco_cuenta_id' => 0,
                    'referencia' => '',
                    'remarks' => '',
                    'banco_cuenta_mov_link_id' => '',
                    'cuentaT_deliveredto_id' => 0,
                    'esta_en' => 'done',
                    'cuentaT_transferto_id' => 0,
                    'quantity_total' => 0,
                    'ultimo_cambio' => 'NOW()',
                    'ultimo_cambio_por' => 'rony',
                    'alta_db' => 'NOW()',
                    'alta_por' => 'rony',
                    'tipo' => 'Egreso',
                    'origen_mov_id' => '',
                    'contra_mov_id' => '',
                    'saldo_corriente_mxp' => 0.0,
                    'saldo_corriente_usd' => 0.0,
                ],
            ],

            'Transfer Sent usd todos los valores, pesos' => ['id2', '1234.56', 'Transfer Sent', 2, 21, '2021-01-02 15:16:17',
                [
                    'cuentaT_mov_id' => 'id2',
                    'cuentaT_id' => '',
                    'fecha' => '2021-01-02 15:16:17',
                    'cuentaT_tipo_mov_id' => 1,
                    'monto' => 0,
                    'egreso' => '1234.56',
                    'moneda_id' => 2,
                    'tipo_cambio' => 21,
                    'banco_cuenta_id' => 0,
                    'referencia' => '',
                    'remarks' => '',
                    'banco_cuenta_mov_link_id' => '',
                    'cuentaT_deliveredto_id' => 0,
                    'esta_en' => 'done',
                    'cuentaT_transferto_id' => 0,
                    'quantity_total' => 0,
                    'ultimo_cambio' => 'NOW()',
                    'ultimo_cambio_por' => 'rony',
                    'alta_db' => 'NOW()',
                    'alta_por' => 'rony',
                    'tipo' => 'Transfer Sent',
                    'origen_mov_id' => '',
                    'contra_mov_id' => '',
                    'saldo_corriente_mxp' => 0.0,
                    'saldo_corriente_usd' => 0.0,
                ],
            ],


        ];
    }


    /**
     * @covers ::ia_SqlOptionsData
     * @uses ::ia_sqlArrayIndx
     * @uses ::strim
     * @uses ::ia_htmlentities()
     * @dataProvider providerIa_SqlOptionsData
     */
    public function testIa_SqlOptionsData(string $sql, string|array $selected, array $extra, string $optionTag, $expected) {
        $this->assertEquals(strim($expected),
            strim(ia_SqlOptionsData($sql, $selected, $extra, $optionTag) )
        );
    }

    public function providerIa_SqlOptionsData() {
        return [
            'no options, sin extra' => ['SELECT tienda_id, tienda FROM tienda WHERE 1=0', [], [], " class='None' ",
                ''
                ],
            'no options, extra ' => ['SELECT tienda_id, tienda FROM tienda WHERE 1=0', [], ['Seleccione'], ' class="None" ',
                "<option value='0' class=\"None\" >Seleccione</option>"
            ],
            'with options, selected  array' => ['SELECT iac_usr_id, lower(nick) as nick FROM iac_usr WHERE iac_usr_id=1', [0, 1], ['Seleccione'], ' class="None" ',
                "<option value='0' SELECTED='selected' class=\"None\" >Seleccione</option> <option value='1' SELECTED='selected' class=\"None\" >rony</option>"
            ],
            'with options, selected extra string' => ['SELECT tienda_id, tienda FROM tienda WHERE 1=0', "0", ['Seleccione'], ' class="None" ',
                "<option value='0' SELECTED='selected' class=\"None\" >Seleccione</option>"
            ],
            'with option selected string' => ["SELECT iac_usr_id, lower(nick) as nick, 'class' as 'red' FROM iac_usr WHERE iac_usr_id=1", "1", [], ' ',
                "<option value='1' SELECTED='selected ' data-red='class'>rony</option>"
            ],
            'with option con class' => ["SELECT iac_usr_id, lower(nick) as nick, 'red' as 'class' FROM iac_usr WHERE iac_usr_id=1", "", [], ' ',
                "<option value='1' class='red'>rony</option>"
            ],
            'with option con style' => ["SELECT iac_usr_id, lower(nick) as nick, 'color:red' as 'style' FROM iac_usr WHERE iac_usr_id=1", "", [], ' ',
                "<option value='1' style='color:red'>rony</option>"
            ],
        ];
    }


    /**
     * @covers ::moneda_id_select
     * @covers ::moneda_options
     * @uses ::_keyTrimmed
     * @uses ::ia_sqlArray
     * @covers ::ia_singleread
     * @uses ::param
     * @uses ::strim
     * @uses ::ia_htmlentities
     * @uses ::ia_Options_array
     * @dataProvider providerMoneda_id_select
     */
    public function testMoneda_id_select_defautls() {
        $tipoCambio = ia_singleread("SELECT tc FROM moneda WHERE moneda_id=2");
        $expected = "<select name='moneda_id' id='moneda_id' > <option value='1' data-tc='1.000000'>PESOS</option> <option value='2' data-tc='$tipoCambio'>USD</option></select>";
        $this->assertEquals(strim($expected),
            strim(moneda_id_select()),
            "defaults"
        );

    }

    /**
     * @covers ::moneda_id_select
     * @covers ::moneda_options
     * @uses ::_keyTrimmed
     * @uses ::ia_sqlArray
     * @uses ::param
     * @uses ::strim
     * @uses ::ia_htmlentities
     * @uses ::ia_Options_array
     * @dataProvider providerMoneda_id_select
     */
    public function testMoneda_id_select($name, $dfl, $conTodas, $tag, $soloEsta, $expected) {
        $this->assertEquals(strim($expected),
            strim(moneda_id_select($name, $dfl, $conTodas, $tag, $soloEsta))
        );

    }

    public function providerMoneda_id_select() {
        $tipoCambio = ia_singleread("SELECT tc FROM moneda WHERE moneda_id=2");
        return [
            'selected pesos' => ['moneda_id', 1, true, ' class="red"', false,
                "<select name='moneda_id' id='moneda_id' class=\"red\"> <option value='1' SELECTED='selected' data-tc='1.000000'>PESOS</option> <option value='2' data-tc='$tipoCambio'>USD</option></select>"
            ],
            'selected solo usd' => ['moneda_id', 1, true, ' class="red"', "2",
                "<select name='moneda_id' id='moneda_id' class=\"red\"> <option value='2' data-tc='$tipoCambio'>USD</option></select>"
            ],
        ];
    }



    /**
     * @covers ::deuda_puede
     * @covers ::gasto_puede
     * @covers ::tienda_puede
     * @covers ::tiendas_puede_consultar
     * @covers ::tiendas_puede_editar
     * @uses ::usuarioTipoRony
     */
    public function testUsuarioTipoRonyPuedeTodo() {
        $_SESSION['usuario_id'] = '1';
        $this->assertTrue(deuda_puede(), "Rony puede todo en deuda");
        $this->assertTrue(gasto_puede(), "Rony puede todo en gasto");
        $this->assertTrue(tiendas_puede_consultar(), "Rony puede tiendas consultar cobranza");
        $this->assertTrue(tiendas_puede_consultar('', 'otro'), "Rony puede tiendas consultar otro");
        $this->assertTrue(tiendas_puede_editar(), "Rony puede tiendas editar cobranza");
        $this->assertTrue(tiendas_puede_editar('', 'otro'), "Rony puede tiendas editar otro");
        $this->assertEquals('Editar', tienda_puede(1), "Rony puede tiendas editar otro");


        $usarios = getForTestsUserIdTypes([]);
        $_SESSION['usuario_id'] = $usarios['Usuario Tipo Rony'];
        $this->assertTrue(deuda_puede(), "Tipo Rony puede todo en deuda");
        $this->assertTrue(gasto_puede(), "Tipo Rony puede todo en gasto");
        $this->assertTrue(tiendas_puede_consultar(), "Tipo Rony puede tiendas consultar cobranza");
        $this->assertTrue(tiendas_puede_consultar('', 'otro'), "Tipo Rony puede tiendas consultar otro");
        $this->assertTrue(tiendas_puede_editar(), "Tipo Rony puede tiendas editar cobranza");
        $this->assertTrue(tiendas_puede_editar('', 'otro'), "Tipo Rony puede tiendas editar otro");
        $this->assertEquals('Editar', tienda_puede(1), "Tipo Rony puede tiendas editar otro");
    }

}