<?php
declare(strict_types=1);

/**
 * Tests para Historian
 *
 * @covers HistorianTest
 * @covers Historian::__construct
 *
 * @version 09/12/2021
 */

use PHPUnit\Framework\TestCase;

// global $usuarios; $usuarios = getForTestsUserIdTypes([]);

class HistorianTest extends TestCase
{

    /**
     * @covers Historian::primaryKeyEncode
     *
     * @dataProvider providerPrimaryKeyEncode
     */
    public function testPrimaryKeyEncode(Historian $hist, array $values, string $expected) {
        $this->assertEquals($expected, $hist->primaryKeyEncode($values));
    }

    public function providerPrimaryKeyEncode():array
    {
        return [
            'deduce primary key' => [new Historian('table_deduce'),
                ["table_deduce_id"=>'deduce', 'table_deduce'=>'table_deduce', 'id'=>'id', 'pk'=>'pk'] , 'deduce'],
            'un primary key' => [new Historian('tabla', ['tabla_id']),
               ['tabla_id'=>'mi_id', 'tabla'=>'tabla', 'id'=>'id', 'pk'=>'pk'], "mi_id"],
            'dos primary keys' => [new Historian('tabla_varios', ['pk1_id', 'pk2_id']),
                ['pk1_id'=>'valor1','pk2_id'=>'valor2', 'tabla_varios'=>'table_deduce', 'id'=>'id', 'pk'=>'pk'], "valor1\tvalor2"],
        ];
    }


    public function getInsertHistorian() {

    }

    /**
     * @covers Historian::afterBefore
     * @covers Historian::setIngoreDifferenceForFields
     * @covers Historian::getIngoreDifferenceForFields
     *
     *
     * @dataProvider providerAfterBefore
     */
    public function testAfterBefore(array $after, array $before, array|null $ignoreFields, array $expected) {

        $historian = new Historian('table_name');
        if(!empty($ignoreFields)) {
            $historian->setIngoreDifferenceForFields($ignoreFields);
            $this->assertEquals($ignoreFields, $historian->getIngoreDifferenceForFields());
        }
        $method = getProtectedMethod('afterBefore', $historian);
        $this->assertEquals(
            $expected,
            $method->invoke($historian, $after, $before)
        );
    }

        public function providerAfterBefore():array {
            return [
                'empty arrays' => [ [], [], null, []  ],
                'no diference' => [ ['a'=>1, 'b'=>'B', 'c'=>'C'], ['a'=>1, 'b'=>'B', 'c'=>'C'], null, [] ],
                'diference in default ignore fields' => [
                    ['a'=>1, 'b'=>'B', 'c'=>'C', 'ultimo_cambio'=>'1', 'ultimo_cambio_por'=>'1'],
                    ['a'=>1, 'b'=>'B', 'c'=>'C', 'ultimo_cambio'=>'2'],
                    null,
                    []
                ],
                'Sólo valores en before' => [ [], ['a'=>1, 'b'=>'B', 'c'=>'C'], null, []  ],
                'Sólo valores en after' => [ ['a'=>1, 'b'=>'B', 'c'=>'C'], [], null, ['a'=>1, 'b'=>'B', 'c'=>'C']  ],
                'Hay cambios' => [
                    ['Same'=>1, 'changes'=>'Value After', 'only after'=>'1', 'ultimo_cambio_por'=>'1'],
                    ['Same'=>1, 'changes'=>'Value Before', 'c'=>'C', 'only before'=>'2'],null,
                    ['changes'=>'Value After', 'only after'=>'1',]
                ],
                'Sub arrays' => [
                    ['Same'=>[1,2,3,4 => [5,6,7]], 'changes'=>[1,2,3,4 => ['Value After',6,7]], 'only after'=>[9,8,7], 'ultimo_cambio_por'=>['1']],
                    ['Same'=>[1,2,3,4 => [5,6,7]], 'changes'=>[1,2,3,4 => ['Value Before',6,7]], 'c'=>'C', 'only before'=>[90, 80, 70, 'Not shown']],
                    null,
                    ['changes'=>[4 => ['Value After']], 'only after'=>[9,8,7],]
                ],
                'diference in changed ignore fields' => [
                    ['a'=>1, 'b'=>'B', 'c'=>'C', 'ignore_field_1'=>'1', 'ignore_field_2'=>'1', 'ultimo_cambio_por'=>'1'],
                    ['a'=>1, 'b'=>'B', 'c'=>'C', 'ignore_field_1'=>'2'], ['ignore_field_1', 'ignore_field_2'],
                    ['ultimo_cambio_por'=>'1']
                ],
            ];
        }


}
