<?php

/*
 array2Select
table_jqgrid_existencias
table_jqgrid_existencias
getLabelBodega

unsetItem
unsetItem
adjustBrightness
limpiaDatos
searchValueInArrayByColumn
get_url_origin
get_full_url
bodegasResumenNumeroNotas
miniLog

producto_color_reset

 */

declare(strict_types=1);

use PHPUnit\Framework\TestCase;

/**
 * @uses URLify::downcode
 * @uses URLify::init
 * @uses ::strit
 * @uses ::fieldit
 * @uses ::strim
 * @uses ::the_error_handler
 */
class Ia_utileriasTest extends TestCase {

    /**
     * @covers ::ia_sqlErrors
     */
    public function testia_sqlErrors() {
        global $gIAsql;
        $gIAsql['err'] = '';
        $this->assertEquals('', ia_sqlErrors(), "No errors");
        $gIAsql['err'] = '<li>error</li>';
        $this->assertEquals('<ul><li>error</li></ul>', ia_sqlErrors(), "<li>error</li>");
    }

    /**
     * @covers ::ia_dontQuote
     * @dataProvider providerIa_dontQuote
     */
    public function testIa_dontQuote(string $string, bool $expected) {
        $this->assertEquals($expected, ia_dontQuote($string));
    }

    public function providerIa_dontQuote() {
        return [
            'sin parentesis' => ['sinParentesis', false],
            'abre parentesis' => ['sinParentesis(', false],
            'abre parentesis enmedio' => ['sinP(arentesis(', false],
            'cierra parentesis' => ['sinParentesis)', false],
            'cierra parentesis enmedio' => ['sinP)arentesis)', false],
            'cierra abre parentesis enmedio' => ['sinP)arente)sis', false],
            'otra function' => ['gatos()', false],
            'date add' => ['date_add(...)', true],
            'date sub' => ['date_add(...)', true],

        ];
    }

    /**
     * @covers ::ia_guid
     * @covers ::ia_singleread
     * @uses Iac\inc\sql\IacMysqli
     * @uses sqlMysqli::log_trace
     */
    public function testIa_guid() {
        $guid_1 = ia_guid();
        $this->assertEquals(32, strlen($guid_1), "guid 32 caracteres");
        $guid_2 = ia_guid();
        $this->assertTrue($guid_2 > $guid_1, "guid es creciente");
        $this->assertFalse($guid_2 === $guid_1, "solicitud de 2 guid seguidas dio false");
    }

    /**
     * @covers ::ia_Options_KeyDisplay
     * @uses ::ia_htmlentities
     * @uses ::strim
     * @dataProvider providerIa_Options_KeyDisplay
     */
    public function testIa_Options_KeyDisplay(array $array, string|array|int|float $selected,string $optionAttr, string $expected) {

        $this->assertEquals(strim($expected),
            strim(ia_Options_KeyDisplay($array, $selected, $optionAttr))
        );
    }

    public function providerIa_Options_KeyDisplay() {
        return [
            "empty options" => [[], 'sel', 'class="options"', ''],
            "options non selected" => [['a'=>'A', 'B'=>'<B>'], 'sel', " class='options'",
                "<option value='a' class='options'>A</option>\r\n<option value='B' class='options'>&lt;B&gt;</option>"],

            "options one selected" => [['a'=>'A', 'B'=>'<B>'], 'a', " class='options'",
                "<option value='a' SELECTED='selected' class='options'>A</option>\r\n<option value='B' class='options'>&lt;B&gt;</option> "],
            "options 2 selected" => [['a'=>'A', 'B'=>'<B>'], ['a', 'B'], " class='options'",
                "<option value='a' SELECTED='selected' class='options'>A</option>\r\n<option value='B' SELECTED='selected' class='options'>&lt;B&gt;</option> "],

        ];
    }


    /**
     * @covers ::ia_OptionsSetData
     * @uses ::ia_htmlentities
     * @uses ::strim
     * @dataProvider providerIa_OptionsSetData
     */
    public function testIa_OptionsSetData(array $array, string|array|int|float $selected, array $extra, string $optionAttr, string $expected) {
        $this->assertEquals(strim($expected),
            strim(ia_OptionsSetData($array, $selected, $extra, $optionAttr))
        );
    }

    public function providerIa_OptionsSetData() {
        return [
            "empty options" => [[], 'sel', [], 'class="options"', ''],
            "options non selected" => [['a'=>'A', 'B'=>'<B>'], 'sel', [], " class='options'",
                "<option data-data='a' value='a' class='options' >A</option>\r\n<option data-data='B' value='B' class='options' >&lt;B&gt;</option>"],

            "options one selected" => [['a'=>'A', 'B'=>'<B>'], 'a', [], " class='options'",
                "<option data-data='a' value='a' SELECTED='selected' class='options' >A</option>\r\n<option data-data='B' value='B' class='options' >&lt;B&gt;</option> "],

            "options extra" => [['a'=>'A', 'B'=>'<B>'], 'a', ['c'=>'laC'], " class='options'",
                "<option value='c' class='options' >laC</option>\r\n<option data-data='a' value='a' SELECTED='selected' class='options' >A</option>\r\n<option data-data='B' value='B' class='options' >&lt;B&gt;</option> "],

            "options extra selected" => [['a'=>'A', 'B'=>'<B>'], 'c', ['c'=>'laC'], " class='options'",
                "<option value='c' SELECTED='selected' class='options' >laC</option>\r\n<option data-data='a' value='a' class='options' >A</option>\r\n<option data-data='B' value='B' class='options' >&lt;B&gt;</option> "],

            "options extra selected array" => [['a'=>'A', 'B'=>'<B>'], ['c'=>'laC'], ['c'=>'laC'], " class='options'",
                "<option value='c' SELECTED='selected' class='options' >laC</option>\r\n<option value='a' class='options' >A</option>\r\n<option value='B' class='options' >&lt;B&gt;</option> "],

            "options 2 selected" => [['a'=>'A', 'B'=>'<B>'], ['a'=>'a', 'B'=>'B'], [], " class='options'",
               "<option value='a' SELECTED='selected' class='options' >A</option>\r\n<option value='B' SELECTED='selected' class='options' >&lt;B&gt;</option> "],

            "options 2 selected values is array" => [['a'=>['es la A', 'soy la A'], 'B'=>'<B>'], ['a'=>'a', 'B'=>'B'], [], " class='options'",
                "<option value='a' SELECTED='selected' class='options' >soy la A</option>\r\n<option value='B' SELECTED='selected' class='options' >&lt;B&gt;</option> "],
            "options 2 selected values is array 3" => [['a'=>['es la A', 'esta es A', 'soy la A'], 'B'=>'<B>'], ['a'=>'a', 'B'=>'B'], [], " class='options'",
                "<option value='a' SELECTED='selected' data-2='soy la A' class='options' >esta es A</option>\r\n<option value='B' SELECTED='selected' class='options' >&lt;B&gt;</option> "],

        ];
    }

    /**
     * @covers ::ia_Options_array
     * @uses ::ia_htmlentities
     * @uses ::strim
     * @dataProvider providerIa_Options_array()
     */
    public function testIa_Options_array(array $array, string|array|int|float $selected,string $optionAttr, string $expected) {
        $this->assertEquals(strim($expected),
            strim(ia_Options_array($array, $selected, $optionAttr))
        );
    }

    public function providerIa_Options_array() {
        return [
            "empty options" => [[], 'sel', 'class="options"', ''],
            "options non selected" => [['a'=>'A', 'B'=>'<B>'], 'sel', " class='options'",
                "<option value='a' class='options'>A</option>\r\n<option value='B' class='options'>&lt;B&gt;</option>"],

            "options one selected" => [['a'=>'A', 'B'=>'<B>'], 'a', " class='options'",
                "<option value='a' SELECTED='selected' class='options'>A</option>\r\n<option value='B' class='options'>&lt;B&gt;</option> "],
            "options 2 selected" => [['a'=>'A', 'B'=>'<B>'], ['a', 'B'], " class='options'",
                "<option value='a' SELECTED='selected' class='options'>A</option>\r\n<option value='B' SELECTED='selected' class='options'>&lt;B&gt;</option> "],

            "value is array(1)" => [['a'=>['soyA'], 'B'=>'<B>'], 'a', " class='options'",
                "<option value='soyA' class='options'></option>\r\n<option value='B' class='options'>&lt;B&gt;</option> "],

            "value is array(2)" => [['a'=>['soyA', 'la A 2'], 'B'=>'<B>'], 'a', " class='options'",
                "<option value='soyA' class='options'>la A 2</option>\r\n<option value='B' class='options'>&lt;B&gt;</option> "],

            "value is array(3)" => [['a'=>['soyA', 'la A 2', 'la A 3'], 'B'=>'<B>'], 'a', " class='options'",
                "<option value='soyA' class='options' data-2='la A 3'>la A 2</option>\r\n<option value='B' class='options'>&lt;B&gt;</option> "],

            "value is array(4) class" => [['a'=>['soyA', 'la A 2', 'la A 3', 'class'=>'laClase'], 'B'=>'<B>'], 'a', " class='options'",
                "<option value='soyA' class='options' data-2='la A 3' class='laClase'>la A 2</option>\r\n<option value='B' class='options'>&lt;B&gt;</option> "],

        ];
    }


    /**
     * @covers removeAccents
     * @covers URLify::init
     * @covers URLify::downcode
     * @dataProvider providerRemoveAccents
     */
    public function testRemoveAccents($string, $expected) {
        $this->assertEquals($expected, removeAccents($string));
    }

    public function providerRemoveAccents() {
        return [
            'all chars' => ['àáâãäçèéêëìíîïñòóôõöùúûüýÿÀÁÂÃÄÇÈÉÊËÌÍÎÏÑÒÓÔÕÖÙÚÛÜÝ', 'aaaaaceeeeiiiinooooouuuuyyAAAAACEEEEIIIINOOOOOUUUUY'],
            'frase' => ['Él píngüino GÜERÓ', 'El pinguino GUERO']
        ];
    }

    /**
    * @covers ::filename_safe
     * @uses ::removeAccents
     * @dataProvider providerFilename_safe
     */
    public function testFilename_safe(string $fileName, string $expected) {
        $this->assertEquals($expected, filename_safe($fileName));
    }

    public function providerFilename_safe() {
        return [
            'normal' => ['file2020_12_01.docx', 'file2020_12_01.docx'],
            'inicia punto' => ['.file2020_12_01.docx', '_file2020_12_01.docx'],
            'con acento' => ['árchivoÁzul.dos', 'archivoAzul.dos'],
            'con path' => ['/dir1/dir2\\file.ext', '_dir1_dir2_file.ext'],
            'con con redirect' => ['>dir1<dir2|fi&le.ext', '_dir1_dir2_fi_le.ext'],
        ];
    }

    /**
     * @covers  ::strit()
     * @dataProvider providerStrIt
     */
    public function testStrit($str, $expected) {
        $this->assertEquals($expected, strit($str));
    }

    public function providerStrIt() {
        return [
            "sin apostrofe" => ["sin apostrofe", "'sin apostrofe'"],
            "con apostrofe" => ["con'", "'con'''"],
            "con null" => [null, "''"],
            "doble apostrofe" => ["con '' doble", "'con '''' doble'"],
            "escape char protegido" => ["char\\b", "'char\\\\b'"],
        ];
    }

    /**
     * @covers strit_array
     * @uses strit
     */
    public function testStrit_array() {
        $this->assertEquals(["'uno'", "'dos'", "'12.5'"], strit_array(["uno", "dos", 12.5]), "Arrray with strings and numbers");
        $this->assertEquals([], strit_array([]), "empty array");
    }
    /**
     * @covers  ::stritc()
     * @dataProvider providerStrItc
     */
    public function testStritc($str, $expected) {
        $this->assertEquals($expected, stritc($str));
    }

    public function providerStrItc() {
        return [
            "sin apostrofe" => ["sin apostrofe", "'sin apostrofe',"],
            "con apostrofe" => ["con'", "'con''',"],
            "con null" => [null, "'',"],
            "doble apostrofe" => ["con '' doble", "'con '''' doble',"],
            "escape char protegido" => ["char\\b", "'char\\\\b',"],
        ];
    }

    /**
     * @covers ::fieldit()
    * @dataProvider providerFieldIt
    */
    public function testFieldIt($fieldName, $expected) {

        $this->assertEquals($expected, fieldit($fieldName));
    }

    public function providerFieldIt():array {
        return [
            'fieldName not quoted' => ['fieldName', "`fieldName`"],
            'fieldName quoted' => ['`fieldName`', "`fieldName`"],
            'fieldName badly quoted' => ['`fieldName`;DELETE * FROM A', "`fieldName;DELETE * FROM A`"],

            'db.fieldName not quoted' => ['db.fieldName', "`db`.`fieldName`"],
            'db.fieldName quoted' => ['`db`.`fieldName`', "`db`.`fieldName`"],
            'db.fieldName db quoted' => ['`db`.fieldName', "`db`.`fieldName`"],
            'db.fieldName fieldName quoted' => ['db.`fieldName`', "`db`.`fieldName`"],
            'schema db.fieldName ' => ['schema.db.fieldName', "`schema`.`db`.`fieldName`"],
        ];
    }

    /**
     * @covers ::ia_mktime_day
     */
    public function testIa_mktime_day() {
        $this->assertEquals(1609567200, ia_mktime_day(1, 2, 2021),
            'Dia a las 0:00:00'
        );
    }

    /**
     * @covers ::date_limit()
     * @covers ::_numOr0()
     * @dataProvider providerDate_limit

     */
    public function testDate_limit(int|float|string|null $lim,string|null $base_date,bool $incluye_dom,bool $incluye_sab,bool $forzaInicioAno,string $expected) {
        $this->assertEquals($expected,
            date_limit($lim, $base_date, $incluye_dom, $incluye_sab, $forzaInicioAno)
        );
    }

    public function providerDate_limit() {
        return [

            'empty date, today' => ["+0d", null, true, true, false, Date('Y-m-d')],

            'limit ninguno' => [null, null, true, true, false, ''],
            'limit timestamp' => [time(), null, true, true, false, Date('Y-m-d')],
            'limit 2021-01-02' => ['2021-01-02', null, true, true, false, '2021-01-02'],
            'limit 2021' => ['2021', null, true, true, false, '2021-01-01'],
            'limit +1w 1d sábados: Si domingo: Si' => ['+1w +1d', '2021-10-14', true, true, false, '2021-10-22'],

            'limit +1y sábados: Si, domingo: Si de un jueves' => ['+1y', '2021-04-01', true, true, false, '2022-04-01'],
            'limit +1y sábados: Si, domingo: No de un jueves' => ['+1y', '2021-04-01', true, false, false, '2022-05-23'],
            'limit +1y sábados: No, domingo: Si de un jueves' => ['+1y', '2021-04-01', false, true, false, '2022-05-23'],
            'limit +1y sábados: Si, domingo: Si de un domingo' => ['+1y', '2021-04-04', true, true, false, '2022-04-04'],
            'limit +1y sábados: No, domingo: Si de un domingo' => ['+1y', '2021-04-04', false, true, false, '2022-05-27'],

            'limit +1d sábados: Si, domingo: Si de un viernes' => ['+1d', '2021-04-02', true, true, false, '2021-04-03'],
            'limit +1d sábados: No, domingo: Si de un viernes?' => ['+1d', '2021-04-02', false, true, false, '2021-04-03'],
            'limit +1d sábados: Si, domingo: No de un viernes' => ['+1d', '2021-04-02', true, true, false, '2021-04-03'],
            'limit +1d sábados: No, domingo: No de un viernes' => ['+1d', '2021-04-02', false, false, false, '2021-04-04'],
            'limit +1d sábados: No, domingo: Si de un sabado' => ['+1d', '2021-04-03', false, true, false, '2021-04-05'],
            'limit +1d sábados: No, domingo: No de un sabado' => ['+1d', '2021-04-03', false, false, false, '2021-04-06'],

            'limit +1y 1m 1d 1 sábados: Si, domingo: Si' => ['+1y 1m 1d 1', '2021-04-01', true, true, false, '2022-05-03'],
            'limit +1y 1m 1d 1x sábados: Si, domingo: Si' => ['+1y 1m 1d 1x', '2021-04-01', true, true, false, '2022-05-02'],
            'limit +1y 1m 1d  sábados: Si, domingo: No' => ['+1y 1m 1d', '2021-04-01', true, false, false, '2022-06-27'],
            'limit +1y 1m 1d  sábados: No, domingo: Si' => ['+1y 1m 1d', '2021-04-01', false, true, false, '2022-06-27'],
            'limit +1y 1m 1d  sábados: No, domingo: No' => ['+1y 1m 1d', '2021-04-01', false, false, false, '2022-08-22'],
            'limit +1y 1m 1d  inicio año' => ['+1y 1m 1d', '2021-04-01', true, true, true, '2022-01-01'],

        ];
    }

    /**
     * @covers ::to_plural
     */
    public function testTo_plural() {
        $this->assertEquals("gatos", to_plural("gatos"), "ya plural");
        $this->assertEquals("gatoces", to_plural("gatoz"), "termina en z");
        $this->assertEquals("punto.", to_plural("punto."), "termina en punto");
        $this->assertEquals("camiones", to_plural("camion", ), "masculinio");
        $this->assertEquals("cajonas", to_plural("cajon", false), "femenino");
        $vocales = ['a','e','i','o','u', 'y', 'w'];
        foreach($vocales as $vocal)
            $this->assertEquals("terminaEn$vocal" . 's', to_plural("terminaEn$vocal"), "terminaEn$vocal");
    }

    /**
     * @covers ::to_label
     * @covers ::ia_htmlentities
     * @dataProvider  providerTo_label
     */
    public function testTo_label(string $fieldName,bool $capWords,bool $htmlentities, $expected ) {
        $this->assertEquals($expected,
            to_label($fieldName, $capWords, $htmlentities));
    }

    public function providerTo_label() {
        return [
            'usuario' => ['usuario', true, true, 'Usuario' ],
            'comentario' => ['comentario', true, false, 'Comentario' ],
            'frase' => ['existencia de bodega', true, false, 'Existencia de Bodega' ],
            'frase sin caps' => ['existencia de bodega', false, false, 'existencia de bodega' ],
            'rfc' => ['rfc', true, false, 'RFC' ],
            'curp' => ['curp', false, false, 'CURP' ],
            'cp' => ['cp', true, false, 'C.P.' ],
            'imss' => ['imss', true, false, 'IMSS' ],
        ];
    }

    /**
     * @covers ::filename_extension
     * @dataProvider  providerFilename_extension
     */
    public function testFilename_extension($fileName, $expected) {
        $this->assertEquals($expected, filename_extension($fileName));
    }

    public function providerFilename_extension() {
        return [
          'no extension' => ['fileName', ''],
          'no extension with dot' => ['fileName.', ''],
          'hidden file ie .htaccess' => ['.fileName', ''],
          'docx extension' => ['fileName.docx', 'docx'],
          '2 dots gif extension' => ['fileName.docx.gif', 'gif'],
        ];
    }

    /**
     * @covers ::array_val
     */
    public function testArray_val() {
        $this->assertEquals('ValorKey1', array_val('Key1', ['Key1' => 'ValorKey1'], 'Default'),
            'Tiene Key');
        $this->assertEquals('Default', array_val('Key2', ['Key1' => 'ValorKey1'], 'Default'),
            'No tiene Key');
    }

    /**
     * @covers ::file_icon
     * @dataProvider providerFile_icon
     */
    public function testFile_icon($fileName, $expected) {
        $this->assertEquals($expected, file_icon($fileName));
    }

    public function providerFile_icon() {
        global $gIApath;
        $tests = [
            'no extension' => ['fileNamed', false],
            'unknown extension' => ['file.unkownExtension', "$gIApath[WebPath]img/ext/clip.gif"],
            "xlsx" => ["file.xlsx", "$gIApath[WebPath]img/ext/xlsx.gif"],
        ];
        foreach(["jpg", "jpeg", "gif", "png", "bmp", "ico"] as $ext)
            $tests["image $ext"] = ["file.$ext", "$gIApath[WebPath]img/ext/jpg.gif"];
        foreach(["avi", "mpeg", "rm", "wmp"] as $ext)
            $tests["video $ext"] = ["file.$ext", "$gIApath[WebPath]img/ext/video.gif"];
        return $tests;
    }

    /**
     * @covers ::file_is_image
     * @dataProvider  providerFile_is_image
     */
    public function testFile_is_image($fileName, $expected) {
        $this->assertEquals($expected, file_is_image($fileName));
    }

    public function providerFile_is_image() {
        $tests = [
            'No extension' => ['Noextension', false],
            'file.doc' => ['file.doc', false],
        ];
        foreach(['jpg', 'jpeg', 'gif', 'png'] as $ext)
            $tests["file.$ext"] = ["file.$ext", true];
        return $tests;
    }

    /**
     * @covers ::ia_img_format
     * @uses ::strim
     * @dataProvider  providerIa_img_format
     */
    public function testIa_img_format(string|int|float $w, string|int|float $h,bool $cssFormat,string $expected) {
        $this->assertEquals(
            strim($expected),
            strim(ia_img_format($w, $h, $cssFormat))
        );
    }

    public function providerIa_img_format() {
        return [
            'cssFormat' => [11, 12, true, "width: 11"."px; height: 12".'px'],
            'normalFormat' => [11, 12, false, "width='11' height='12'"],
        ];
    }

    /**
     * @covers ::ip_server_set
     */
    public function testIp_server_set() {
        $_SERVER['blank'] = '';
        $_SERVER['value_unknown'] = 'unknown';
        $_SERVER['exists'] = 'exists';
        $this->assertFalse( ip_server_set('NOT A $_SERVER KEY'), 'NOT A $_SERVER KEY');
        $this->assertFalse( ip_server_set('blank'), '$_SERVER KEY is empty');
        $this->assertFalse( ip_server_set('value_unknown'), '$_SERVER KEY is unknown');
        $this->assertTrue(ip_server_set('exists'), '$_SERVER key exists');
    }

    /**
     * @covers ::uploadErrorStr
     */
    public function testUploadErrorStr() {
        for($errorNumber = 0; $errorNumber <= 9; ++$errorNumber) {
            $_FILES["upload"]["error"] = "$errorNumber";
            $this->assertEquals($this->uploadErrorOkStr($errorNumber),
                uploadErrorStr("upload")
            );
        }
    }

    /**
     * @covers ::file_upload_error
     */
    public function testFile_upload_error() {
        for($errorNumber = 0; $errorNumber <= 9; ++$errorNumber) {
            $this->assertEquals($this->uploadErrorOkStr($errorNumber),
                file_upload_error("$errorNumber")
            );
        }
    }

    public function uploadErrorOkStr($indx) {
        if( $indx==0)
            return '';
        elseif( $indx==1)
            return 'El archivo es demasiado grande';
        elseif( $indx==2)
            return 'El archivo es demasiado grande';
        elseif( $indx==3)
            return 'Solo subio parte del archivo';
        elseif( $indx==4)
            return 'No subio el archivo';
        elseif( $indx==6)
            return 'No subio el archivo a tmp';
        elseif( $indx==7)
            return 'Error al escribir el archivo';
        elseif( $indx==8)
            return 'Tipo de archivo invalido';
        else
            return 'Error al subir el archivo';
    }

    /**
     * @covers ::ip_extract
     * @dataProvider providerIp_extract
     */
    public function testIp_extract(string $ip, $expected) {
        $actual = ip_extract($ip);
        if(count($actual) > 1)
            $actual = [$actual[0]];
        $this->assertEquals($expected, $actual);
    }

    public function providerIp_extract() {
        return [
            'sin ip' => ['Friendly proxy', []],
            'localhost' => ['localhost', ['localhost']],
            'localhost proxied' => ['localhost proxied for', ['localhost']],
            '127.0.0.1' => ['127.0.0.1', ['127.0.0.1']],
            'ipv4 and phrase' => ['192.168.1.24 soy git', ['192.168.1.24']],
           'ipv6' => ['2001:db8:3333:4444:5555:6666:7777:8888', ['2001:db8:3333:4444:5555:6666:7777:8888']],
           'ipv6 test2' => ['2001:db8:3333:4444:CCCC:DDDD:EEEE:FFFF', ['2001:db8:3333:4444:CCCC:DDDD:EEEE:FFFF']],
           'ipv6 con frase' => ['2001:db8:3333:4444:CCCC:DDDD:EEEE:FFFF soy alguien', ['2001:db8:3333:4444:CCCC:DDDD:EEEE:FFFF']],
        ];
    }

    /**
     * @covers ::ia_convertBytes
     * @dataProvider providerIa_convertBytes
     */
    public function testIa_convertBytes(string|int|float $bytes, string $expected) {
          $this->assertEquals($expected, ia_convertBytes($bytes));
    }

    public function providerIa_convertBytes() {
        return [
            'Non Numeric' => ['No Soy numero', 'No Soy numero'],
            '1024K' => ['1024', '1 Kb'],
            '2 mega' => [1024*1024*2, '2.00 Mb'],
            '-10' => [-10, '-10 b'],
        ];
    }

    /**
     * @covers ::file_size_formatted
     * @dataProvider providerFile_size_formatted
     *
     * @param int|float|string $size
     * @param string $expected
     */
    public function testFile_size_formatted(int|float|string $size, string $expected) {
        $this->assertEquals($expected, file_size_formatted($size));
    }

    public function providerFile_size_formatted() {
        return [
            'bytes' => [14, '14b'],
            'k redondeado' => [1100, '1Kb'],
            'Mb redondeado' => [2.2312*1024*1024, '2.2Mb'],
            'Gb redondeado' => [3.1312*1024*1024*1024, '3.1Gb'],
        ];
    }

    /**
     * @covers ::javait
     */
    public function testJavait( ) {
        $this->assertEquals('"gato\'s dijo: \\\'miau\\\'"', javait('gato\'s dijo: "miau"', '"'),
            'entre comillas "' );
        $this->assertEquals('"gato\'s dijo: \\\'miau\\\'"', javait('gato\'s dijo: "miau"', '"'),
            "entre apostrofes '");
        $this->assertEquals("null", javait(null), " null value");
    }

    /**
     * @covers ::jsit
     */
    public function testjsit() {
        $this->assertEquals('"gato\'s dijo: \\"miau\\""', jsit('gato\'s dijo: "miau"', '"'),
            'entre comillas "' );
        $this->assertEquals("null", jsit(null), " null value");
    }

    /**
     * @covers ::comillea
     */
    public function testComillea() {
        $this->assertEquals('"gato\'s dijo: \'miau\'"', comillea('gato\'s dijo: "miau"', '"'),
            'entre comillas "' );
        $this->assertEquals('"null"', comillea(null), " null value");
    }

    /**
     * @covers ::param
     * @uses ::_keyTrimmed
     */
    public function testParam() {
        $_REQUEST['cual'] = '   soyCual   ';
        $this->assertEquals('soyCual', param('cual', 'cualDefault'), 'Parametros si esta' );
        unset($_REQUEST['cual']);
    }

    /**
     * @covers ::param_post
     * @uses ::_keyTrimmed
     */
    public function testParam_post() {
        $_POST['cual'] = '   soyCual   ';
        $this->assertEquals('soyCual', param_post('cual', 'cualDefault'), 'Parametros si esta' );
        unset($_POST['cual']);
    }

    /**
     * @covers ::param_get
     * @covers ::_keyTrimmed
     */
    public function testParam_get() {
        $_GET['cual'] = '   soyCual   ';
        $this->assertEquals('soyCual', param_get('cual', 'cualDefault'), 'Parametros si esta' );
        unset($_GET['cual']);
        $this->assertEquals('cualDefault', param_get('cual', 'cualDefault'), 'Usa el default' );
        $_GET['cualArray'] = ['  cualUno', 'cualDos'];
        $this->assertEquals(['cualUno', 'cualDos'], param_get('cualArray', 'cualDefault'), 'Array parameter' );
        unset($_GET['cual']);
    }

    /**
     * @covers ::getParams
     */
    public function testGetParams() {
        if(empty($_REQUEST))
            $_REQUEST = ['getParams' => 'request'];
        $this->assertEquals($_REQUEST, getParams(), 'Por default $_REQUEST');
        $this->assertEquals($_REQUEST, getParams(null), 'null $_REQUEST');
        unset( $_REQUEST['getParams']);
        if(empty($_POST))
            $_POST = ['getParams' => 'post'];
        $this->assertEquals($_POST, getParams('post'), 'post parameters');
        unset( $_POST['getParams']);
        if(empty($_GET))
            $_GET = ['getParams' => 'get'];
        $this->assertEquals($_GET, getParams('get'), 'get parameters ');
        unset( $_GET['getParams']);
    }

    /**
     * @covers ::ia_fileName
     * @covers ::sanitizeFileName
     * @covers ::valida_carpetas
     * @covers ::valExisteFile
     * @dataProvider  providerIa_fileName
     */
    public function testIa_fileName(string $path,string  $elName,string  $gWebDir,string $expected) {
        $this->assertEquals($expected,
            ia_fileName($path, $elName, $gWebDir)
        );
    }

    public function providerIa_fileName() {
        global $gWebDir;
        return [
          'Si Existe' =>  ['tests/inc/', 'Ia_UtileriasTest.php', $gWebDir, 'ia_utileriastest--_1.php'],
          'No Existe' =>  ['tests/inc/', 'NoExisteFileTest.php', $gWebDir, 'noexistefiletest.php'],
        ];
    }

    /**
     * @test
     * @covers ::colores
     */
    public function testColores() {
        $expectedEN =  [
            'blue' =>	'azul',
            'green' =>	'verde',
            'red' =>	'rojo',
            'orange' =>	'naranja',
            'yellow' =>	'amarillo',
            'pink' =>	'rosa',
            'purple' =>  'morado',
            'black' =>	'negro',
            'white' =>	'blanco',
            'grey' =>   'gris',
            'gray' => 	'gris',
            'brown' =>	'marrón',
            'violet' =>	'violeta',
        ];
        $this->assertEquals(array_flip($expectedEN), colores(), "Por default");
        $this->assertEquals(array_flip($expectedEN), colores('es'), "Español");
        $this->assertEquals($expectedEN, colores('en'), "No Español");
    }

    /// Estan en config.php por el momentos
    ///
    /**
     * @covers ::sessvalset
     */
    public function testSessvalset() {
        $key = 'testSess';
        unset($_SESSION[$key]);
        sessvalset($key,'value' );
        $this->assertEquals('value', $_SESSION[$key], "valor nuevo de session");
        sessvalset($key,'cambiado' );
        $this->assertEquals('cambiado', $_SESSION[$key], "valor actualizado de session");
        sessvalset($key,'cambiado' );
        $this->assertEquals('cambiado', $_SESSION[$key], "valor no cambio");
    }

    /**
     * @covers ::mysqlDate2display
     * @covers ::mysqlDateTime2display
     */
    public function testMysqlDate2display() {
        $this->assertEquals('', mysqlDate2display(''), "empty");
        $this->assertEquals('', mysqlDateTime2display(''), "empty");
        $this->assertEquals('', mysqlDate2display('0000-00-00'), "sql empty date 0000-00-00");
        $this->assertEquals('02/Ene/21  12:13', mysqlDate2display('2021-01-02 12:13:14'), "datetime to nice datetime");
        $this->assertEquals('02/Ene/21', mysqlDate2display('2021-01-02'), "date to nice date");
    }

    /**
     * @covers ::mysqlTimestamp2display
     * @covers ::mysqlDateTime2display
     */
    public function testMysqlTimestamp2display() {
        $date = '2021-01-02 12:13:14';
        $expected = '02/Ene/21  12:13';
        $this->assertEquals( $expected,
            mysqlTimestamp2display($date), "dateTime no timestamp!"
        );
    }

    /**
     * @covers ::siteRootUrl
     * @covers ::getUrlBase
     * @covers ::getUrlTo
     *
     */
    public function test_siteRootUrl() {

            $_SERVER['SERVER_NAME'] = 'server_name';
            $_SERVER['SERVER_PORT'] = 'port';
            $_SERVER['HTTPS'] = 'on';

        $this->assertEquals('https://server_name:port/vitex', siteRootUrl(), 'En https');
        $this->assertEquals('https://server_name:port/vitex/pagina.php', getUrlTo('pagina.php'),
            'getUrlTo, getUrlBase En https');


        $era = $_SERVER['HTTPS'];
        $_SERVER['HTTPS'] = '';
        $this->assertEquals('http://server_name:port/vitex', siteRootUrl(), 'Sin https');
        $this->assertEquals('http://server_name:port/vitex/pagina.php', getUrlTo('pagina.php'),
            'getUrlTo, getUrlBase Sin https');

        $_SERVER['SERVER_PORT'] = '80';
        $this->assertEquals('http://server_name/vitex/pagina.php', getUrlTo('pagina.php'),
            'getUrlTo, getUrlBase En https con puerto 80');
        unset($_SERVER['SERVER_NAME'], $_SERVER['SERVER_PORT'], $_SERVER['HTTPS']);

    }

    /**
     * @covers ::strim
     * @dataProvider providerStrim
     */
    public function testStrim($string, $expected) {
        $this->assertEquals($expected, strim($string));
    }

    public function providerStrim() {
        return [
            'null' => [null, ''],
            'Empty string' => ['', ''],
            'Espacios string' => ['   ', ''],
            'Espacios entre palabras'=>['   palab,ra          larga      ','palab,ra larga'],
            'Tabs entre palabras' => ["palabra\t\t\ttab\totro", "palabra tab otro"]
        ];
    }


    /**
     * @covers ::ia_image_tag_size
     * @covers ::file_is_image
     * @covers ::file_size_formatted
     * @dataProvider provider_ia_image_tag_size
     */
    public function test_ia_image_tag_size($fileName, $expected) {
        $this->assertEquals($expected, ia_image_tag_size($fileName));
    }
        public function provider_ia_image_tag_size():array {
            return [
               'empty File Name' => ['', ''],
               'File Name NOT FOUND' => ['not_found_image.xyz', ''],
               'File is not an image' => ['/wamp/www/vitex/index.php', ''],
               'png image' => ['/wamp/www/vitex/img/16-autorizar.png', 'w: 20px h:20px 2Kb'],
            ];
        }

        /**
         * @covers ::ia_image_tagsize_fitmax
         * @covers ::ia_img_format
         * @dataProvider provider_ia_image_tagsize_fitmax
         */
        public function test_ia_image_tagsize_fitmax($imageFile, $max_width, $max_height, $cssFormat, $enLarge, $expected) {
            $this->assertEquals($expected, ia_image_tagsize_fitmax($imageFile, $max_width, $max_height, $cssFormat, $enLarge));
        }

            public function provider_ia_image_tagsize_fitmax():array {
                return [
                    'obtengo ceros enlarge' => [[0,0], 128, 128, true, true, 'width: 128px; height: 128px'],
                    'obtengo ceros !enlarge' => [[0,0], 128, 128, true, false, 'width: 0px; height: 0px'],
                    'mismo tamaño css' => [[128,128], 128, 128, true, false, 'width: 128px; height: 128px'],
                    'mismo tamaño no css' => [[128,128], 128, 128, false, false, "width='128' height='128'"],
                    'mas grande css' => [[64,64], 128, 128, true, false, 'width: 64px; height: 64px'],
                    'mas grande no css' => [[64,64], 128, 128, false, false, "width='64' height='64'"],
                    'mas chica css !enlarge' => [[128,128], 64, 64, true, false, 'width: 64px; height: 64px'],
                    'mas chica css enlarge' => [[128,128], 64, 64, true, true, 'width: 64px; height: 64px'],
                    'mas chica css enlarge w &lt; h' => [[128,128], 32, 64, true, true, 'width: 32px; height: 32px'],
                    'mas chica css enlarge w &gt; h' => [[128,128], 64, 32, true, true, 'width: 64px; height: 64px'],
                    'mas chica h &gt; w' => [[128,128], 32, 64, true, false, 'width: 32px; height: 32px'],
                    'mas chica w &gt; h enlarge' => [[128,128], 64, 32, true, false, 'width: 64px; height: 64px'],
                    'mas chica w &gt; h !enlarge' => [[128,128], 64, 32, true, false, 'width: 64px; height: 64px'],
                ];
            }
    /**
     * @covers ::arrayDiff()
     * @covers ::array_list_diff()
     */
    public function testArrayDiff() {
        $a = [
            'igual'=>'igual ambos',
            'igual arr1'=>['ig2'=>1,'ig3'=>1,'ig1'=>1,],
            'dif'=>'difA',
            'dif arr'=>['SubArrAmbos'=>'ambos', 'SubArrDiferente'=>'difeA', 'subArrSoloA'=>'a'],
            'soloA'=>'SA',
            'n' => 1.345,
            'd' => 1.1,
            'n1' => 1,
            'n2' => 1,
            "bc" => "3.1415923",
            'ArraySoloEnA' => [1,2,3],
            'ArrayEnAStringEnB' => [1,2,3],
            'null' => null,
            'subList' => ['a', 'b','c', 'd'],
        ];

        $b = [
            'soloB'=>'SB',
            'igual'=>'igual ambos',
            'igual arr1'=>['ig1'=>1,'ig2'=>1,'ig3'=>1,],

            'dif arr'=>['SubArrAmbos'=>'ambos', 'SubArrDiferente'=>'difeB', 'subArrSoloB'=>'b'],
            'd' => 1,
            'dif'=>'difB',
            'n' => 1.447,
            "bc" => "3.1415924",
            'n1' => 1,
            'n2' => "1",
            'null' => null,

            'subList' => ['d', 'a','b', 'c'],
            'ArrayEnAStringEnB' => 'string en b',
            'ArraySolEnB' => [11,12,13],
        ];

        $expected = [
            'dif' => [
                0 => 'difA',
                1 => 'difB',
            ],
            'dif arr' => [
                'SubArrDiferente' => [
                    0 => 'difeA',
                    1 => 'difeB',
                ],
                'subArrSoloA' => [
                    0 => 'a',
                    1 => NULL,
                ],
                'subArrSoloB' => [
                    0 => NULL,
                    1 => 'b',
                ],
            ],
            'soloA' => [
                0 => 'SA',
                1 => NULL,
            ],
            'n' => [
                0 => 1.345,
                1 => 1.447,
            ],
            'd' => [
                0 => 1.1,
                1 => 1,
            ],

            'ArraySoloEnA' => [
                0 => [
                    0 => 1,
                    1 => 2,
                    2 => 3,
                ],
                1 => NULL,
            ],
            'ArrayEnAStringEnB' => [
                0 => [
                    0 => 1,
                    1 => 2,
                    2 => 3,
                ],
                1 => 'string en b',
            ],
            'soloB' => [
                0 => NULL,
                1 => 'SB',
            ],
            'ArraySolEnB' => [
                0 => NULL,
                1 => [
                    0 => 11,
                    1 => 12,
                    2 => 13,
                ],
            ],
          'subList' => [['a','d'], ['b','a'],['c','b'], ['d', 'c']],
        ];

        $this->assertEquals($expected, arrayDiff($a, $b));
    }

    /**
     * @covers ::searchValueInArrayByColumn
     * @dataProvider provider_searchValueInArrayByColumn
     */
    public function test_searchValueInArrayByColumn($value, $array, $column, $expected) {
        $this->assertEquals($expected, searchValueInArrayByColumn($value, $array, $column));
    }
        public function provider_searchValueInArrayByColumn():array {
            return [
                'numeros'=> [
                    3, [['pi'=>3, 'e'=>'la e'],['pi'=>'pi', 'e'=>'2.72'] ], 'pi',
                    ['pi'=>3, 'e'=>'la e']
                ],
                'letras'=> [
                    'pi', [['pi'=>'3.14', 'e'=>'la e'],['pi'=>'pi', 'e'=>'2.72'] ], 'pi',
                    ['pi'=>'pi', 'e'=>'2.72']
                ],
                'dos matches'=> [
                    'pi', [['pi'=>'3.14', 'e'=>'la e'],['pi'=>'pi', 'e'=>'2.72'],['pi'=>'3.14', 'e'=>'la e2'] ], 'pi' ,
                    ['pi'=>'pi', 'e'=>'2.72']
                ],
                'no encuentra' => [
                    'sigma', [['pi'=>'3.14', 'e'=>'la e'],['pi'=>'pi', 'e'=>'2.72'],['pi'=>'3.14', 'e'=>'la e2'] ], 'pi' ,
                    []
                ],
            ];
        }

    /**
     * @covers ::get_full_url
     * @covers ::get_url_origin
     */
    public function test_get_full_url() {
        $server['REQUEST_URI'] = '/request_uri';
        $server['HTTPS'] = 'on';
        $server['SERVER_PROTOCOL']='HTTP/2';
        $server['SERVER_PORT'] = '443'; // 82, 80
        $server['HTTP_X_FORWARDED_HOST'] = 'FORWARDED_HOST';
        $server['HTTP_HOST'] = 'HOST';
        $server['SERVER_NAME'] = 'SERVER_NAME';

        $this->assertEquals('https://FORWARDED_HOST/request_uri', get_full_url($server, true), 'HTTPS CON forwarded for header');
        $this->assertEquals('https://HOST/request_uri', get_full_url($server, false), 'HTTPS Sin forwarded for header');
        // Le quitaron la funcionalidad de puerto a la function!!
        //   $server['SERVER_PORT'] = '8080';
        //   $this->assertEquals('https://FORWARDED_HOST:8080/request_uri', get_full_url($server, true), 'HTTPS 8080 CON forwarded for header');
        // $this->assertEquals('https://HOST:8080/request_uri', get_full_url($server, false), 'HTTPS 8080 Sin forwarded for header');


    }
    /**
     * @covers ::bcformat()
     * @covers ::numeric2string()
     * @dataProvider provider_bcformat
     */
    public function test_bcformat($number, $decimals, $expected) {
        $this->assertEquals($expected, bcformat($number, $decimals));
    }
        public function provider_bcformat():array {
            return [
                'entero sin comas'=>['99.00', 0, '99'],
                'entero con comas'=>['123456', 0, '123,456'],
                'entero negativo'=>['-123456', 0, '-123,456'],
                'decimal sin comas'=>['99', 2, '99.00'],
                'decimal con comas'=>['123456.7810', 2, '123,456.78'],
                'decimal negativo'=>['-123456.78', 2, '-123,456.78'],

                'float' => [3.1415,1,'3.1'],
                'null' => [null,0,''],
                'cero' => ['0',0,'0'],
                'vacio'  => ['',0,''],
                'no numerico' => ['qwerty',2,'qwerty'],
            ];
        }

    /**
     * @covers ::bcabs()
     * @dataProvider provider_bcabs
     */
    public function test_bcabs($number, $decimals, $expected) {
        $this->assertEquals($expected, bcabs($number, $decimals));
    }
        public function provider_bcabs():array {
            return [
              'cero'=>['0', 0, '0'],
              'negativo int'=>['-1', 2, '1.00'],
              'negativo float'=>['-12345.23', 2, '12345.23'],
              'positivo float'=>['1234', 2, '1234'],
            ];
        }

    /**
    * @covers limpiaDatos
    * @covers strim
    */
    public function test_limpiaDatos() {
       $in = [
            'data_id' => '  no Cambia  ',
            'numero_id' => 123456,
            'rollos' =>  '123,456',
            'quantity' =>  '123,456.78',
           'otro' =>'123,456',
           'nombre_id_lic' => '  la   licencia es   id del Lic'
       ];
        $expected = [
            'data_id' => '  no Cambia  ',
            'numero_id' => 123456,
            'rollos' =>  '123456',
            'quantity' =>  '123456.78',
            'otro' =>'123,456',
            'nombre_id_lic' => 'la licencia es id del Lic'
        ];
        $this->assertEquals($expected, limpiaDatos($in) );
    }

    /**
     * @covers ::array2Select
     * @uses ::strim
     * @uses ::ia_htmlentities
     */
    public function test_array2Select() {
        $datos = [['id'=>1,'label'=>'uno'],['id'=>2,'label'=>'dos'],['id'=>3,'label'=>'tres']];
        self::assertEquals(
          strim("<select class='selectize' name='select' id='select' ><option value=''>Seleccione</option><option value='1' >uno </option><option value='2' >dos </option><option value='3' >tres </option></select>"),
            strim(array2Select($datos, 'id', 'label')),
            'Todo en defaults'
        );
        self::assertEquals(
            "<option value=''>Seleccione</option><option value='1' >uno </option><option value='2' selected='selected' >dos </option><option value='3' >tres </option>",
            strim(array2Select($datos, 'id', 'label', set_val: 2, onlyOptions: true)),
            'Only Options set Selected 2'
        );
        self::assertEquals(
            "<option value='1' >uno </option><option value='2' selected='selected' >dos </option><option value='3' selected='selected' >tres </option>",
            strim(array2Select($datos, 'id', 'label', set_val: [2,3], onlyOptions: true, addNull: false)),
            'Only Options set Selected 2 and 3, sin seleccione'
        );
        self::assertEquals(
            "<select class='notSelectize' name='select' id='select' ><option value=''>Seleccione</option><option value='1' data-cat='1' data-dog='uno' >uno </option><option value='2' data-cat='2' data-dog='dos' >dos </option><option value='3' data-cat='3' data-dog='tres' >tres </option></select>",
            strim(array2Select($datos, 'id', 'label', set_val: ['two'], onlyOptions: false, isSelectize:false,
                extra_data: [ 'cat'=>'id','dog'=>'label'] )
            ),
            'Extra options Selected 2'
        );
    }

    /**
     * @covers param
     * @covers _keyTrimmed
     * @covers strim
     */
    public function test_param() {
        $this->assertEquals('not in request', param('NOT IN', 'not in request'), "key not in param default string");
        $this->assertEquals([], param('NOT IN', []), "key not in param default array" );
        $tests = [
         'strim string' =>  ['p'=>'p1', 'v'=>" v  \r\n    1 ", 'e'=>'v 1', 'd'=>'defaulted'],
         'numeric' => ['p'=>'p2', 'v'=>1, 'e'=>'1', 'd'=>'defaulted'],
        'empty' =>  ['p'=>'p3', 'v'=>'', 'e'=>'',  'd'=>'defaulted'],
        'numeric zero' =>  ['p'=>'p4', 'v'=>0, 'e'=>'0',  'd'=>'defaulted'],
         'string zero' => ['p'=>'p5', 'v'=>'0',  'e'=>'0',  'd'=>'defaulted'],
         'array trim' =>  [
             'p'=>'p1', 'v'=>[
                 " v  \r\n    1 ",
                 " v  \r\n    2 ",
                 "0",
             ],
             'e'=>[
                 'v 1',
                 'v 2',
                 '0'
             ],
             'd'=>[]
         ],
        ];
        foreach($tests as $msg => $t) {
            $_REQUEST[$t['p']] = $t['v'];
            $this->assertEquals($t['e'], param($t['p'], $t['d']), $msg);
            unset($_REQUEST[$t['p']]);
        }
        $_REQUEST['textarea'] = " v  \r\n    1 ";
        $this->assertEquals(" v  \r\n    1 ", param('textarea', '', false), "No trim");
        $_REQUEST['textarea'] = [" v  \r\n    1 ", " v  \r\n    2 "];
        $this->assertEquals($_REQUEST['textarea'], param('textarea', '', false), "No trim array");
        unset($_REQUEST['textarea']);
    }

    /**
     * @covers ::strim
     */
    public function test_strim() {
        $in = [
            'empty' => '',
            'cero string' => '0',
            'cero' => 0,
            'null' => null,
            'notrim' => 'Felix',
            'trim me' => '   aba    baba  ',
            'trim special chars' => "\tnew line \r\n cat\r\n",
        ];
        $expected = [
            'empty' => '',
            'cero string' => '0',
            'cero' => '0',
            'null' => null,
            'notrim' => 'Felix',
            'trim me' => 'aba baba',
            'trim special chars' => "new line cat",
        ];
        $this->assertEquals($expected, strim($in));
    }

    /**
     * @covers ::keyRemap()
     * @dataProvider provider_keyRemap
     */
    public function test_keyRemap($array, $keys, $expected) {
        $this->assertEquals($expected, keyRemap($array, $keys));
    }

    public function provider_keyRemap():array {
        return [
            'text_keys' =>  [['producto_id'=>3, 'color'=>4], ['color'=>'color.color'] , ['producto_id'=>3, 'color.color'=>4]],
            'varios_keys' =>  [['producto_id'=>31, 'color'=>41], ['color'=>'color.color', 'producto_id'=>'pid'] , ['pid'=>31, 'color.color'=>41]],
            'mixed_keys' =>  [[12, 'producto_id'=>32, 'color'=>42, 52], ['color'=>'color.color'] , [12, 'producto_id'=>32, 'color.color'=>42, 52]],
            'solo primer nivel' =>  [['producto_id'=>['color' => 33], 'color'=>43], ['color'=>'color.color'] , ['producto_id'=>['color' => 33], 'color.color'=>43]],
        ];
    }

    /**
     * @covers ::unsetItem
     */
    public function test_unsetItem() {
        $keysSeQuitan = ['A', 'Array', 'Key No Esta'];
        $expected = $array = ['A'=>'aba  Se Quita', 'Array'=>['Se Qutia', 1,2,3], 'B'=>'b  se queda', 'C Array se queda'=>['A'=>'se queda'] ];
        foreach($keysSeQuitan as $k)
            unset($expected[$k]);
        $this->assertEquals($expected, unsetItem($array, $keysSeQuitan));
    }


    /**
     * @covers ::array_sort()
     */
    public function test_array_sort() {
        $array = [
          'a'=>['item'=>10, 'sort_item'=>22],
          'b'=>['item'=>110, 'sort_item'=>2],
          'c'=>['item'=>120, 'sort_item'=>222],
          'd'=>['item'=>130, 'sort_item'=>4],
          444
        ];
        $expected_ascending = [
            'b'=>['item'=>110, 'sort_item'=>2],
            'd'=>['item'=>130, 'sort_item'=>4],
            'a'=>['item'=>10, 'sort_item'=>22],
            'c'=>['item'=>120, 'sort_item'=>222],
            444
        ];
        $this->assertEquals($expected_ascending, array_sort($array, 'sort_item'));
        $this->assertEquals(array_reverse($expected_ascending), array_sort($array, 'sort_item', SORT_DESC));
    }


    /**
     * @covers ::num2Key
     * @dataProvider providerNum2Key()
     */
    public function test_num2Key($num, $columnLetters) {
        $this->assertEquals($columnLetters, num2Key($num));
    }

    public function providerNum2Key() {
        return [
          'Negative column' => [-7,'A'],
          'First column zero based, A' => [0,'A'],
          'Second column column, B' => [1,'B'],
          'Last single letter column column, Z' => [25,'Z'],
          'First double letter column' => [26,'AA'],
          'AC Column' => [28,'AC'],
          'DC Column' => [106,'DC'],
          'BB Column' => [53,'BB'],
          'AQK Column' => [1128,'AQK'],
          'BBB Column' => [8097,'KYL'],
        ];
    }

    /**
     * @covers ::is_container_number
     * @dataProvider providerIsContainerNumber
     */
    public function test_is_container_number($container_number, $is) {
        $this->assertEquals($is, is_container_number($container_number));
    }

    public function providerIsContainerNumber() {
        return [
          "empty string" => ['', false],
          "invalid string" => ['container', false],
          "invalid pattern 1" => ['1aaa1234567', false],
          "invalid pattern 2" => ['abc-1234567', false],
          "invalid pattern 3" => ['abcd1x34567', false],

          "invalid pattern 4" => ['bicu1234565t', false],
          "valid BICU" => ['bicu1234565', true],
          "invalid check digit" => ['bicu1234567', false],
          "valid VSLU" => ['VSLU1145675', true],
          "valid TGCU0090699" => ['TGCU0090699', true],
          "SUDU5856051" => ['SUDU5856051', true],
          "MSKU9259770" => ['MSKU9259770', true],

        ];
    }

    /**
     * @covers ::diasEntreFechas
     * @dataProvider provider_diasEntreFechas
     */
    public function test_diasEntreFechas($fechaMin, $fechaMax, $expected) {
        $this->assertEquals($expected, diasEntreFechas($fechaMin, $fechaMax));
    }
    public function provider_diasEntreFechas() {
        return [
            'Sin fechas' => ['', '', ''],
            'Nulls' => [null, null, ''],
            'mismo dia' => ['2023-01-10','2023-01-10', ' (0 días)'],
            'ayer, fecha Max empty' => [Date('Y-m-d', strtotime("yesterday")),null, ' (1 días)'],
            'ayer' => [Date('Y-m-d', strtotime("yesterday")), Date('Y-m-d'), ' (1 días)'],
            '+3 dias' => ['2023-01-10','2023-01-13', ' (3 días)'],
            '-5 dias' => ['2023-01-10','2023-01-05', ' (5 días)'],
        ];
    }

    /**
     * @covers ::fechaDiff
     * @dataProvider provider_fechaDiff
     */
    public function test_fechaDiff($dateTime1, $dateTime2, $maxParts, $expected) {
        $this->assertEquals($expected, fechaDiff($dateTime1, $dateTime2, $maxParts));
    }

    public function provider_fechaDiff() {
        return [
            'empty' => ['', '', 2, ''],
            'same date' => ['2023-03-21 21:14:15', '2023-03-21 21:14:15', 2, ''],
            'one hour ahead' => ['2023-03-21 21:14:15', '2023-03-21 22:14:15', 2, '1 hr'],
            'one hour behind' => ['2023-03-21 20:14:15', '2023-03-21 21:14:15', 2, '1 hr'],
            'one hour one part' => ['2023-03-21 20:14:15', '2023-03-21 21:17:18', 1, '1 hr'],
            'one hour 50 minutes' => ['2023-03-21 10:10:10', '2023-03-21 11:30:19', 2, '1 hr, 20 min'],
            'one day 3 hours' => ['2023-03-21 10:10:10', '2023-03-22 13:30:19', 2, '1 día, 3 hrs'],
            'one day 2 hours 20 min' => ['2023-03-21 10:10:10', '2023-03-22 13:30:19', 3, '1 día, 3 hrs, 20 min'],
            'casi 2 dias a 3' => ['2023-03-23 10:10:10', '2023-03-21 11:30:19', 3, '1 día, 22 hrs, 39 min'],
            'casi 2 dias a 2' => ['2023-03-23 10:10:10', '2023-03-21 11:30:19', 2, '1 día, 22 hrs'],
            'casi 2 dias a 1' => ['2023-03-23 10:10:10', '2023-03-21 11:30:19', 1, '1 día'],

        ];
    }
}