<?php
declare(strict_types=1);

use PHPUnit\Framework\TestCase;
use Iac\inc\sql\IacSqlBuilder;

class NotaBodegaTest extends TestCase
{
    const NOTA_BODEGA_ID = '74867af2fe6080d411ed44bd2998c4dd';

    const ENTRADA_BODEGA_ID = '54bf6469e2ccb35411ee6133087383d0';

    const SALIDA_BODEGA_ID = '54bf6469e2ccb35411ee6132e361c54a';

    public static function setUpBeforeClass(): void {
        $nota = [
            'nota_bodega_id' => '74867af2fe6080d411ed44bd2998c4dd',
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $sql = "DELETE FROM nota_bodega WHERE nota_bodega_id = ".strit($nota["nota_bodega_id"]);

        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $queries = [
            $sql,
            $builder->insert('nota_bodega', $nota)
        ];

        if(ia_transaction($queries)){
            ia_errores_a_dime();
            var_dump('Error al Hacer querys NOTA BODEGA');
        }


        $entrada = [
            'nota_bodega_id' => '54bf6469e2ccb35411ee6133087383d0',
            'numero' => '40173',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Traslado',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-10-02 08:50:23", "alta_por": "rony", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "1"}]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-10-02 08:50:21", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'ayudantes' => 'SIN AYUDANTES',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-10-02 08:50:24", "display": "SIN AYUDANTES", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-10-02 09:50:30", "alta_por": "rony", "compra_id": "54bf6469e2ccb35411ee6132e361c54a", "fue_error": "No", "numero_compra": 2199}]',
            'numero_compra_actual' => '2199',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "index": "1", "alta_db": "2023-10-02 08:50:27", "display": "IVÁN BRAYAN MATA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $entrada_items = [
            'nota_bodega_item_id' => '54bf6469e2ccb35411ee613308768c06',
            'nota_bodega_id' => '54bf6469e2ccb35411ee6133087383d0',
            'producto_bodega_id' => '74867af2fe60845411ecaa03953dd312_54bf6469e2cc850b11ec1ca9fdfac21f_54bf6469e2cc850b11ec1c8ef9bb590d',
            'rollos' => '1.00',
            'quantity' => '25.10',
            'es_saldo' => 'No',
            'en_remate' => 'No',
            'lento' => 'No',
            'super_lento' => 'No',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            //'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            //'color_id' => '54bf6469e2cc850b11ec1c8ef9bb590d',
            'rollosNegativo' => '0',
            'quantityNegativo' => '0',
            'averageMal' => '0',
            'nuevoProducto' => '0',
            'producto_color_calidad' => '',
            'producto_color_calidad_comentario' => '',
        ];
        $entrada_nota_bodega_contranota = [
            'nota_bodega_contra_nota_bodega_id' => '12309',
            'nota_bodega_id' => '54bf6469e2ccb35411ee6133087383d0',
            'contra_nota_bodega_id' => '54bf6469e2ccb35411ee6132e361c54a',
            'numero_nota' => '2199',
            'alta_db' => '2023-10-02 09:50:31',
            'alta_por' => 'rony',
        ];

        /*Salida inserts ------------------------------------------------------------------------------------------------*/
        $salida = [
            'nota_bodega_id' => '54bf6469e2ccb35411ee6132e361c54a',
            'numero' => '2199',
            'bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6',
            'grupo' => 'COYUYA',
            'entrada_salida' => 'Salida',
            'tipo' => 'Traslado',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60845411ecaa03a5fe75f8',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '40173',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-10-02 08:49:18", "alta_por": "rony", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "1"}]',
            'alta_db' => '2023-10-02 09:49:28',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:49:28',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-10-02 08:49:17", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'ayudantes' => 'SIN AYUDANTES',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-10-02 08:49:21", "display": "SIN AYUDANTES", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-10-02 09:50:30", "alta_por": "rony", "compra_id": "54bf6469e2ccb35411ee6132e361c54a", "fue_error": "No", "numero_compra": "40173"}]',
            'numero_compra_actual' => '40173',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "index": "1", "alta_db": "2023-10-02 08:49:24", "display": "IVÁN BRAYAN MATA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '2199',
            //'numero_order_text' => '00000000000000000000000000002199',
            //'numero_real' => '2199',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:49:28',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:49:28',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $salida_items = [
            'nota_bodega_item_id' => '54bf6469e2ccb35411ee6132e3735eff',
            'nota_bodega_id' => '54bf6469e2ccb35411ee6132e361c54a',
            'producto_bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6_54bf6469e2cc850b11ec1ca9fdfac21f_54bf6469e2cc850b11ec1c8ef9bb590d',
            'rollos' => '1.00',
            'quantity' => '25.10',
            'es_saldo' => 'No',
            'en_remate' => 'No',
            'lento' => 'No',
            'super_lento' => 'No',
            'alta_db' => '2023-10-02 09:49:28',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:49:28',
            'ultimo_cambio_por' => 'rony',
            //'bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6',
            //'color_id' => '54bf6469e2cc850b11ec1c8ef9bb590d',
            'rollosNegativo' => '0',
            'quantityNegativo' => '0',
            'averageMal' => '0',
            'nuevoProducto' => '0',
            'producto_color_calidad' => '',
            'producto_color_calidad_comentario' => '',
        ];
        $salida_nota_bodega_contranota = [
            'nota_bodega_contra_nota_bodega_id' => '12310',
            'nota_bodega_id' => '54bf6469e2ccb35411ee6132e361c54a',
            'contra_nota_bodega_id' => '54bf6469e2ccb35411ee6133087383d0',
            'numero_nota' => '40173',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
        ];


        $sql_delete_items_entrada = "DELETE FROM nota_bodega_items WHERE (nota_bodega_id = ".strit($entrada["nota_bodega_id"]) . ")";
        $sql_delete_contranota_entrada = "DELETE FROM nota_bodega_contra_nota_bodega WHERE (nota_bodega_id = ".strit($entrada["nota_bodega_id"]) . ")";
        $sql_delete_nota_entrada = "DELETE FROM nota_bodega WHERE nota_bodega_id = ".strit($entrada["nota_bodega_id"]);

        $sql_delete_items_salida = "DELETE FROM nota_bodega_items WHERE (nota_bodega_id = ".strit($salida["nota_bodega_id"]) . ")";
        $sql_delete_contranota_salida = "DELETE FROM nota_bodega_contra_nota_bodega WHERE (nota_bodega_id = ".strit($salida["nota_bodega_id"]) . ")";
        $sql_delete_nota_salida = "DELETE FROM nota_bodega WHERE nota_bodega_id = ".strit($salida["nota_bodega_id"]);

        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $queries = [
            $sql_delete_items_entrada,
            $builder->insert('nota_bodega_items', $entrada_items),
            $sql_delete_contranota_entrada,
            $builder->insert('nota_bodega_contra_nota_bodega', $entrada_nota_bodega_contranota),
            $sql_delete_nota_entrada,
            $builder->insert('nota_bodega', $entrada),
            $sql_delete_items_salida,
            $builder->insert('nota_bodega_items', $salida_items),
            $sql_delete_contranota_salida,
            $builder->insert('nota_bodega_contra_nota_bodega', $salida_nota_bodega_contranota),
            $sql_delete_nota_salida,
            $builder->insert('nota_bodega', $salida),
        ];

        if(ia_transaction($queries)){
            ia_errores_a_dime();
            var_dump('Error al hacer querys ENTRADA SALIDA');
        }

    }

    /**
     * @covers NotaBodegaTest::testSuperLockNotaByID
     * @covers strit
     * @covers Historian::__construct
     * @covers Historian::primaryKeyEncode
     * @covers Historian::set
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacSqlBuilder::update
     * @covers Iac\inc\sql\IacSqlBuilder::where
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers NotaBodega::__construct
     * @covers NotaBodega::superLockNotaByID
     * @covers NotaBodegaHistoryLog::HistorySaveNotaBodega
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArrayIndx
     * @covers param
     * @covers sqlMysqli::log_trace
     * @covers strim
     * @covers the_error_handler
     */
    public function testSuperLockNotaByID(){

        $espera = [
            'code' => 200,
            'status' => true,
            'message' => 'Se bloqueo la nota'
        ];

        $notaBodega = new NotaBodega();
        $response = $notaBodega->superLockNotaByID(self::NOTA_BODEGA_ID, 1);

        $nota =  ia_singleton("select * from nota_bodega where nota_bodega_id = " . strit(self::NOTA_BODEGA_ID));

        $this->assertEquals($espera, $response);
        $this->assertEquals($nota['super_lock'], 1);
    }

    /**
     * @covers NotaBodega::unlockTrasladoMatch
     * @covers Historian::__construct
     * @covers Historian::primaryKeyEncode
     * @covers Historian::set
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::commit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::queryArray
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacMysqli::transaction
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers NotaBodega::__construct
     * @covers NotaBodega::getNotaByID
     * @covers NotaBodegaHistoryLog::HistorySaveNotaBodega
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArrayIndx
     * @covers ia_transaction
     * @covers param
     * @covers sqlMysqli::log_trace
     * @covers strim
     * @covers strit
     * @covers the_error_handler
     * @covers NotaBodega::unlockPorTiempo
     */
    public function testunlockPorTiempo(){
        $notaBodega = new NotaBodega();
        $response = $notaBodega->unlockPorTiempo(self::NOTA_BODEGA_ID, '1');
        $nota =  ia_singleton("select * from nota_bodega where nota_bodega_id = ". strit(self::NOTA_BODEGA_ID) );

        $espera = [
            'code' => 200,
            'status' => true,
            'message' => 'Unlock por tiempo'
        ];

        $this->assertEquals($espera, $response);
        $this->assertEquals($nota['lock_por_tiempo'], 1);
    }

}
