<?php
declare(strict_types=1);

use PHPUnit\Framework\TestCase;

/**
 * @covers Iac\inc\sql\IacMysqli
 * @covers sqlMysqli::log_trace
 * @covers Iac\inc\sql\IacSqlBuilder
 * @covers Iac\inc\sql\IacStringer
 * @covers strit
 * @covers assoc_mysql2mysqli
 * @covers ia_singleton
 * @covers ia_sqlArrayIndx
 * @covers param
 * @covers strim
 * @covers the_error_handler
 * @covers \ia_transaction()
 * @covers \ia_query()
 * @covers \NotaFormHelper
 * @covers \PermisosBodega
 * @covers \app_nota_bodega
 * @covers ia_singleread
 * @covers ia_sqlArray
 * @covers \iacase
 *
 */
class NotaFormHelperTest extends TestCase
{

    const NOTA_BODEGA_ID = '74867af2fe6080d411ed44bd2998c4dZ';
    const NOTA_TRASLADO_ID = '54bf6469e2ccb35411ee6133087383dZ';
    const NOTA_DEVOLUCION_ID = '0a00270000128e4f11ef188d22b7eb1Z';
    const BODEGA_NO_REQUIERE_PEDIDO_POR = '74867af2fe60845411ecaa03a5fe75f8'; // VIRGOMA

    const TIPOS_NOTAS = ['Movimiento',  'Traslado', 'Devolucion', 'Correccion', 'Cancelacion', 'Container',  'Borrado'];

    const TIPOS_NOTA_VALIDAR = ['Movimiento', 'Traslado', 'Devolucion'];

    public static function setUpBeforeClass(): void {
        return;
        $nota = [
            'nota_bodega_id' => self::NOTA_BODEGA_ID,
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $sql = "DELETE FROM nota_bodega WHERE nota_bodega_id = ".strit($nota["nota_bodega_id"]);
        $sqli = "DELETE FROM nota_bodega_items WHERE nota_bodega_id = ".strit($nota["nota_bodega_id"]);

        $traslado = [
            'nota_bodega_id' => self::NOTA_TRASLADO_ID,
            'numero' => '40173',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Traslado',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-10-02 08:50:23", "alta_por": "rony", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "1"}]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-10-02 08:50:21", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'ayudantes' => 'SIN AYUDANTES',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-10-02 08:50:24", "display": "SIN AYUDANTES", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-10-02 09:50:30", "alta_por": "rony", "compra_id": "54bf6469e2ccb35411ee6132e361c54a", "fue_error": "No", "numero_compra": 2199}]',
            'numero_compra_actual' => '2199',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "index": "1", "alta_db": "2023-10-02 08:50:27", "display": "IVÁN BRAYAN MATA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $sql2 = "DELETE FROM nota_bodega WHERE nota_bodega_id = ".strit($traslado["nota_bodega_id"]);
        $sql2i = "DELETE FROM nota_bodega_items WHERE nota_bodega_id = ".strit($traslado["nota_bodega_id"]);

        $devolucion = [
            'nota_bodega_id' => self::NOTA_DEVOLUCION_ID,
            'numero' => '3285',
            'bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6',
            'grupo' => 'COYUYA',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Devolucion',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'ayudantes_json' => '',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '',
            'numero_compra_actual' => '',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $sql3 = "DELETE FROM nota_bodega WHERE nota_bodega_id = ".strit($devolucion["nota_bodega_id"]);
        $sql3i = "DELETE FROM nota_bodega_items WHERE nota_bodega_id = ".strit($devolucion["nota_bodega_id"]);

        $sql4 = "UPDATE `bodega` SET `pedido_por_requeridos` = 'No' WHERE `bodega_id` = ".strit(self::BODEGA_NO_REQUIERE_PEDIDO_POR);

        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $queries = [
            $sql,
            $sqli,
            $sql2,
            $sql2i,
            $sql3,
            $sql3i,
            $sql4,
            $builder->insert('nota_bodega', $nota),
            $builder->insert('nota_bodega', $traslado),
            $builder->insert('nota_bodega', $devolucion)
        ];

        if(ia_transaction($queries)){
            ia_errores_a_dime();
            var_dump('Error al Hacer querys NOTA BODEGA');
            global $gSqlClass;
            var_dump( $gSqlClass->errorLog_get());
        }

    }

    protected function tearDown(): void {
        $method = __METHOD__;
        $queries = [
              "DELETE /*$method*/ FROM nota_bodega WHERE nota_bodega_id = ".strit(self::NOTA_BODEGA_ID),
              "DELETE /*$method*/ FROM nota_bodega_items WHERE nota_bodega_id = ".strit(self::NOTA_BODEGA_ID),
        ];
        if(ia_transaction($queries)){
            ia_errores_a_dime();
            var_dump('Error al Hacer querys NOTA BODEGA');
            global $gSqlClass;
            var_dump( $gSqlClass->errorLog_get());
        }
        parent::tearDown(); // TODO: Change the autogenerated stub
    }


    /**
     * @covers NotaFormHelper::hasLock
     */
    public function testhasLock(){

        $nota = [
            'nota_bodega_id' => self::NOTA_BODEGA_ID,
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $hasLock = NotaFormHelper::hasLock($nota);
        $this->assertEquals($hasLock, false, "sin locks");

        $tests = [
            'traslado_match_lock' => false,
            'lock' => false,
            'lock_por_tiempo_nota_ajuste' => false
        ];
        foreach($tests as $t => $expected) {
            $nota[$t] = '1';
            $this->assertEquals($expected, NotaFormHelper::hasLock($nota),  "Lock $t:  Debe ser NOT Locked");
            $nota[$t] = '0';
            $this->assertEquals($expected, NotaFormHelper::hasLock($nota),  "Lock $t:  Debe ser NOT Locked");
        }

        $test2 = [
            "lock_por_tiempo" => true,
            "reset_lock" => true,
            "lock_por_nota_posterior_ajuste" => true,
            "super_lock" => true,
        ];

        foreach($test2 as $t => $expected) {
            $nota[$t] = '1';
            $this->assertEquals($expected, NotaFormHelper::hasLock($nota),  "Lock $t:  Debe ser Locked");
            $nota[$t] = '0';
            $this->assertEquals(false, NotaFormHelper::hasLock($nota),  "Lock $t:  Debe ser NOT Locked");
        }

        $nota_empty = [];
        $this->assertEquals(false, NotaFormHelper::hasLock($nota_empty), "sin campos de lock en el array");
    }

    /**
     * @covers NotaFormHelper::validateCampoNumeroCompra
     * @covers strit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacSqlBuilder::update
     * @covers Iac\inc\sql\IacSqlBuilder::where
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArrayIndx
     * @covers param
     * @covers sqlMysqli::log_trace
     * @covers strim
     * @covers the_error_handler
     */
    public function testvalidateCampoNumeroCompra(){
        $nota = [
            'nota_bodega_id' => self::NOTA_BODEGA_ID,
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $validate = NotaFormHelper::validateCampoNumeroCompra($nota["numero_compra"], "Movimiento");
        $this->assertEquals($validate["succes"], "CORRECT");

        $validate2 = NotaFormHelper::validateCampoNumeroCompra('', "Movimiento");
        $this->assertEquals("FAIL",$validate2["succes"], "Tipo Movimiento con # Nota string vacio");

        $validate3 = NotaFormHelper::validateCampoNumeroCompra($nota["numero_compra"], "OTRO");
        $this->assertEquals($validate3["message"], "No necesita validacion", "Tipo de nota desconocido no necesita numero de compra");
    }

    /**
        * @dataProvider provider_validateCampoNumeroCompra
     */
    public function test_validateCampoNumeroCompra_conDataProvider($numeroCompra, $tipo, $esperadoSuccess) {
        $this->assertEquals( $esperadoSuccess, NotaFormHelper::validateCampoNumeroCompra($numeroCompra, $tipo)  );
    }

    public function provider_validateCampoNumeroCompra() {

        $numeroCompra_1_intento_Ok ='[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]';
        $numeroCompra_1_dato_FueError_Si ='[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "Si", "numero_compra": "10135"}]';
        $numeroCompra_2_Mal_Error ='[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "Si", "numero_compra": "10135"}, {"index": 2, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10136"}]]';
        $numeroCompra_3_Mal_Error ='[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}, {"index": 2, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "Si", "numero_compra": "10136"}]]';

        $resultadoOk = [
          "type" => 'NumeroCompra',
          "succes" => 'CORRECT',
          "message" => '',
          "ikon" => '<i class="ui-icon ui-icon-check txt_shadow_2px text-verified"></i>',
          "confirm" => [],
        ];
        $resultadoFail = [
          "type" => 'NumeroCompra',
          "succes" => 'FAIL',
          "message" => 'Numero Compra no capturado',
          "ikon" => '<i class="ui-icon ui-icon-closethick txt_shadow_2px text-danger"></i>',
          "confirm" => [],
        ];
        $resultadoNoSeRevisa = [
          "type" => 'NumeroCompra',
          "succes" => '',
          "message" => 'No necesita validacion',
          "ikon" => '',
          "confirm" => [],
        ];
        $tests = [];
        foreach(self::TIPOS_NOTAS as $tipo){

            if(!in_array($tipo, self::TIPOS_NOTA_VALIDAR)){
                $tests["Tipo = $tipo que no valida destino match"] = [$numeroCompra_1_intento_Ok, $tipo, $resultadoNoSeRevisa];
                continue;
            }

            $tests["Tipo = $tipo con 1 num de compra en Ok"] = [$numeroCompra_1_intento_Ok, $tipo, $resultadoOk];
            $tests["Tipo = $tipo con 1 num de compra en Fail"] = [$numeroCompra_2_Mal_Error, $tipo,  $resultadoFail];
        }
        return $tests;
    }


    public function testvalidateAyudantesV2(){
        $validateFail = [
            'type' => 'Ayudantes',
            'succes' => 'FAIL',
            'message' => 'Ayudantes no Corresponden',
            'ikon' => '<i class="ui-icon ui-icon-closethick txt_shadow_2px text-danger tooltip" title="Los ayudantes no trabajan para el destino."></i>',
            'confirm' => [
                '11ed2021f8920ffba2c174867af2fe60' => [
                    'id' => '11ed2021f8920ffba2c174867af2fe60',
                    'ikon' => '<i class="ui-icon ui-icon-closethick txt_shadow_2px text-danger"></i>',
                    'check' => 0,
                    'lbl' => 'OSCAR NOE MENDOZA BOCANEGRA',
                    'estatus' => false,
                ],
            ],
        ];

        $nota_bodega = [
            'nota_bodega_id' => self::NOTA_BODEGA_ID,
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $ayudantesToValidate = [
            "ayudantes" => json_decode(($nota_bodega['ayudantes_json'] ?? ''), true),
            "bodega_id" => $nota_bodega['bodega_id'],
            "origen_id" => $nota_bodega['origen_id'],
            "destino_fuerza_ok" => $nota_bodega["destino_fuerza_ok"] ?? 'NO',
            "tipo" => $nota_bodega["tipo"] ?? '',
        ];

        $inc = NotaFormHelper::validateAyudantesV2($ayudantesToValidate);
        $this->assertEquals($validateFail, $inc, "FAIL Ayudantes no Corresponden");


        $emptyAyudantes = [
            'type' => 'Ayudantes',
            'succes' => 'FAIL',
            'message' => 'Ayudantes no capturado',
            'ikon' => '<i class="ui-icon ui-icon-closethick txt_shadow_2px text-danger tooltip" title="Ayudantes no capturado"></i>',
            'confirm' => [

            ],
        ];
        $nota_bodega['ayudantes_json'] = '[]';
        $ayudantesToValidateEmpty = [
            "ayudantes" => json_decode(($nota_bodega['ayudantes_json'] ?? ''), true),
            "bodega_id" => $nota_bodega['bodega_id'],
            "origen_id" => $nota_bodega['origen_id'],
            "destino_fuerza_ok" => $nota_bodega["destino_fuerza_ok"] ?? 'NO',
            "tipo" => $nota_bodega["tipo"] ?? '',
        ];
        $inc2 = NotaFormHelper::validateAyudantesV2($ayudantesToValidateEmpty);
        $this->assertEquals($emptyAyudantes, $inc2, "FAIL Ayudantes no Capturados");


        $destinoForaneo = [
            'type' => 'Ayudantes',
            'succes' => 'CORRECT',
            'message' => 'No requiere Ayudantes porque el destino es: GDL',
            'ikon' => '<i class="ui-icon ui-icon-check txt_shadow_2px text-verified tooltip" title="No requiere Ayudantes porque el destino es: GDL "></i>',
            'confirm' => [

            ],
        ];

        $nota_bodega['origen_id'] = '11ec6cb303b9a8a5ad6b74867af2fe60';
        $ayudantesToValidateEmpty = [
            "ayudantes" => json_decode(($nota_bodega['ayudantes_json'] ?? ''), true),
            "bodega_id" => $nota_bodega['bodega_id'],
            "origen_id" => $nota_bodega['origen_id'],
            "destino_fuerza_ok" => $nota_bodega["destino_fuerza_ok"] ?? 'NO',
            "tipo" => $nota_bodega["tipo"] ?? '',
        ];

        $inc3 = NotaFormHelper::validateAyudantesV2($ayudantesToValidateEmpty);
        $this->assertEquals($destinoForaneo, $inc3, "CORRECT Ayudantes con destino foraneo");

    }



    public function testvalidateClientesV2(){
        $emptyClientes = [
            'type' => 'clientes',
            'succes' => 'FAIL',
            'message' => 'Cliente no capturado',
            'ikon' => '<i class="ui-icon ui-icon-closethick txt_shadow_2px text-danger tooltip" title="Cliente no capturado"></i>',
            'confirm' => [

            ],
        ];

        $nota_bodega = [
            'nota_bodega_id' => self::NOTA_BODEGA_ID,
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $nota_bodega['cliente'] = '[]';
        $clientes = json_decode($nota_bodega['cliente'] ?? '', true);
        $inc = NotaFormHelper::validateClientesV2($clientes, $nota_bodega['tipo'], $nota_bodega['origen_id'], $nota_bodega['entrada_salida'], $nota_bodega["destino_fuerza_ok"] ?? 'No');

        $this->assertEquals($emptyClientes, $inc, "Fail Cliente no capturado");

        $nota_bodega["tipo"] = 'TEST';
        $sinValidacion =  [
            "type" => 'clientes',
            "succes" => '',
            "message" => 'No necesita validacion',
            "ikon" => '',
            "confirm" => [],
        ];
        $inc2 = NotaFormHelper::validateClientesV2($clientes, $nota_bodega['tipo'], $nota_bodega['origen_id'], $nota_bodega['entrada_salida'], $nota_bodega["destino_fuerza_ok"] ?? 'No');

        $this->assertEquals($sinValidacion, $inc2, "Fail No necesita validacion");

    }


    public function testvalidatePedidoPorV2(){
        $pedidoporCorrect = [
            'type' => 'Pedido por',
            'succes' => 'CORRECT',
            'message' => '',
            'ikon' =>  '<i class="ui-icon ui-icon-check txt_shadow_2px text-verified"></i>',
            'confirm' => [
                '74867af2fe60a78c11ed27d2889f69d1' => [
                    'id' => '74867af2fe60a78c11ed27d2889f69d1',
                    'lbl' => 'JUSTINO LORENZO CUEVAS',
                    'ikon' => '<i class="ui-icon ui-icon-check txt_shadow_2px text-verified"></i>',
                    'check' => 1,
                ],
            ],
        ];
        $nota_bodega = [
            'nota_bodega_id' => '74867af2fe6080d411ed44bd2998c4dZ',
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        if( $nota_bodega["entrada_salida"] === 'Salida' || $nota_bodega["tipo"] === 'Devolucion' ){
            $idBodegas = $nota_bodega["origen_id"];
        }else{
            $idBodegas = $nota_bodega["bodega_id"];
        }
        $pedidoporToValidate = [
            "pedido_por" => json_decode($nota_bodega["pedido_por"] ?? '', true),
            "tipo" => $nota_bodega['tipo'],
            "entrada_salida" => $nota_bodega['entrada_salida'],
            "bodega_id" => $idBodegas,
            "destino_fuerza_ok" => $nota_bodega["destino_fuerza_ok"] ?? 'No'
        ];
        $inc = NotaFormHelper::validatePedidoPorV2($pedidoporToValidate);
        $this->assertEquals($pedidoporCorrect, $inc, "$nota_bodega[tipo] : CORRECT pedido por");


        $trasladoEmptyPedidopor = [
            'type' => 'Pedido por',
            'succes' => 'FAIL',
            'message' => 'Pedido por no capturado',
            'ikon' => '<i class="ui-icon ui-icon-closethick txt_shadow_2px text-danger tooltip" title="Pedido por no capturado"></i>',
            'confirm' => [],
        ];
        $nota_bodega_salida_pedido_por_vacio = [
            'nota_bodega_id' => 'cc483a12801a9a1911eec797bf1872de',
            'numero' => '20019',
            'bodega_id' => '74867af2fe60ad6b11ec6cb3ea28e494',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Traslado',
            'fecha' => '2024-02-09',
            'label' => '',
            'origen_id' => 'f8bc123029a8941811ed8c4b723f74f3',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9a9c616331',
            'colores' => 'PLUMBAGO',
            'contra_nota_bodega_id' => '8873',
            'para_quien' => '',
            'total_rolls' => '4.00',
            'total_quantity' => '96.20',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '1',
            'traslado_match_lock_el' => '2024-02-12 09:41:37',
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => '2024-05-30 11:28:29',
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"check": "1", "index": "", "nombre": "BODEGAS PROPIAS", "alta_db": "2024-02-09 16:08:07", "alta_por": "isidro", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "116"}]',
            'alta_db' => '2024-02-09 16:08:25',
            'alta_por' => 'isidro',
            'ultimo_cambio' => '2024-05-30 11:28:39',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"check": "", "index": "", "nombre": "FRANCISCO JAVIER VALDIVIA", "alta_db": "2024-02-09 16:07:01", "alta_por": "isidro", "fue_error": "No", "alta_por_id": "116", "figuratransporte_id": "cc483a12801aa56111edd95826585910"}]',
            'chofer_responsable_id' => 'cc483a12801aa56111edd95826585910',
            'ayudantes' => 'FRANCISCO JAVIER VALDIVIA GALICIA;',
            'ayudantes_json' => '[{"id": "11ed2021f8f0035ba2c174867af2fe60", "lbl": "FRANCISCO JAVIER VALDIVIA GALICIA", "check": "0", "index": "1", "alta_db": "2024-02-09 16:07:26", "alta_por": "isidro", "fue_error": "No", "alta_por_id": "116"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => "
Pedido por NO CAPTURADO",
            'inconsistencias_nivel' => 'warning',
            'num_colores' => '1',
            'numero_compra' => '[]',
            'numero_compra_actual' => '',
            'lock_el' => NULL,
            'super_lock_el' => '2024-05-30 11:28:22',
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[]',
            'system_lock' => '0',
            'system_lock_el' => '2024-05-30 11:28:26',
            'system_lock_por' => 'rony',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '1',
            'reset_lock_el' => '2024-03-25 13:48:09',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => 'RESET LOCK, Por ajuste de inventario en la Bodega GRIS del Producto FELPA CHINA en color: ACERO, AGUA, AGUACATE, AQUA, ARENA, BANDERA, BEIGE, BLANCO, BOTELLA, BUGAMBILIA, CAFE, CANARIO, CIELO, CIELO BABY, CLAVEL, FIUSHA, FRESA, GREY, HUESO, JADE, KAKI, LILA, LILA BABY, LIMON, MANGO, MANZANA, MARINO, MELON, MELON BABY, MENTA, MENTA BABY, MILITAR, MORADO, MOSTAZA, NARANJA, NEGRO, ORO, ORQUIDEA, OXFORD, PALO DE ROSA, PERLA, PIMENTON, PISTACHE, PIZARRA, PLUMBAGO, REY, ROJO, ROSA BABY, ROSA PASTEL, SHEDRON, TURQUESA, UVA, VAINILLA, VINO.',
            'reset_lock_por_nota_ajuste' => 'cc483a12801aae3311eeeae09b269b63',
            'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'numero_as_num' => '20019',
            'numero_order_text' => '00000000000000000000000000020019',
            'numero_real' => '20019',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2024-02-09 16:08:25',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2024-02-09 16:08:25',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
            'nota_unidades' => 'KG',
            'verificado_list' => NULL,
            'ano' => '2024',
            'dia' => '40',
            'extras' => '',
            'pueden_corregir_errores' => 'Si',
            'alta_db_idx' => '2024-02-09',
            'cliente_actual_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente_actual' => 'BODEGAS PROPIAS',
            'lock_por_tiempo_motivo' => '',
            'super_lock_motivo' => '',
            'lock_por_tiempo_por' => 'rony',
            'system_lock_motivo' => '',
        ];
        if( $nota_bodega_salida_pedido_por_vacio["entrada_salida"] === 'Salida' || $nota_bodega_salida_pedido_por_vacio["tipo"] === 'Devolucion' ){
            $idBodegas = $nota_bodega_salida_pedido_por_vacio["origen_id"];
        }else{
            $idBodegas = $nota_bodega_salida_pedido_por_vacio["bodega_id"];
        }
        $pedidoporToValidate2 = [
            "pedido_por" => json_decode($nota_bodega_salida_pedido_por_vacio["pedido_por"] ?? '', true),
            "tipo" => $nota_bodega_salida_pedido_por_vacio['tipo'],
            "entrada_salida" => $nota_bodega_salida_pedido_por_vacio['entrada_salida'],
            "bodega_id" => $idBodegas,
            "destino_fuerza_ok" => $nota_bodega_salida_pedido_por_vacio["destino_fuerza_ok"] ?? 'No'
        ];
        $inc3 = NotaFormHelper::validatePedidoPorV2($pedidoporToValidate2);
        $this->assertEquals($trasladoEmptyPedidopor, $inc3, "$nota_bodega[tipo] : FAIL Pedido por no capturado");

        $pedido_por_bodega_inconsistencias = [
            'type' => 'Pedido por',
            'succes' => 'CORRECT',
            'message' => 'Bodega VIRGOMA no requiere Pedido Por (por parametros)',
            'ikon' => '<i class="ui-icon ui-icon-check txt_shadow_2px text-verified tooltip" title="Bodega VIRGOMA no requiere Pedido Por (por parametros)"></i>',
            'confirm' => [],
        ];
        $nota_bodega_salida_traslado = [
            'nota_bodega_id' => 'cc483a12801a9f0a11ef0320dc255fde',
            'numero' => '21978',
            'bodega_id' => '74867af2fe60ad6b11ec6cb3ea28e494',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Traslado',
            'fecha' => '2024-04-25',
            'label' => '',
            'origen_id' => self::BODEGA_NO_REQUIERE_PEDIDO_POR,
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'VERDE NEON',
            'contra_nota_bodega_id' => '58874',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '21.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => '2024-05-30 10:45:38',
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"check": "1", "index": "", "nombre": "BODEGAS PROPIAS", "alta_db": "2024-04-25 10:28:03", "alta_por": "isidro", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "116"}]',
            'alta_db' => '2024-04-25 10:28:34',
            'alta_por' => 'isidro',
            'ultimo_cambio' => '2024-05-30 10:45:47',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'CARLOS ALBERTO GARCIA LOZADA;',
            'ayudantes_json' => '[{"id": "11ed2021f8923746a2c174867af2fe60", "lbl": "CARLOS ALBERTO GARCIA LOZADA", "check": "1", "index": "1", "alta_db": "2024-04-25 10:28:10", "alta_por": "isidro", "fue_error": "No", "alta_por_id": "116"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => "
Pedido por NO CAPTURADO",
            'inconsistencias_nivel' => 'warning',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2024-05-30 10:45:47", "alta_por": "rony", "compra_id": "cc483a12801a9f0a11ef0320f570b17f", "fue_error": "No", "numero_compra": 58874}]',
            'numero_compra_actual' => '58874',
            'lock_el' => NULL,
            'super_lock_el' => '2024-05-30 10:45:36',
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[]',
            'system_lock' => '0',
            'system_lock_el' => '2024-05-30 10:45:42',
            'system_lock_por' => 'rony',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'numero_as_num' => '21978',
            'numero_order_text' => '00000000000000000000000000021978',
            'numero_real' => '21978',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2024-04-25 10:28:34',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2024-04-25 10:28:34',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
            'nota_unidades' => 'KG',
            'verificado_list' => NULL,
            'ano' => '2024',
            'dia' => '116',
            'extras' => '',
            'pueden_corregir_errores' => 'Si',
            'alta_db_idx' => '2024-04-25',
            'cliente_actual_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente_actual' => 'BODEGAS PROPIAS',
            'lock_por_tiempo_motivo' => '',
            'super_lock_motivo' => '
Se DESBLOQUEO por CLICK de Rony el: 2024-05-30 10:45:36
',
            'lock_por_tiempo_por' => 'rony',
            'system_lock_motivo' => '',
        ];
        $nota_bodega_salida_traslado["pedido_por"] = '[]';
        if( $nota_bodega_salida_traslado["entrada_salida"] === 'Salida' || $nota_bodega_salida_traslado["tipo"] === 'Devolucion' ){
            $idBodegas = $nota_bodega_salida_traslado["origen_id"];
        }else{
            $idBodegas = $nota_bodega_salida_traslado["bodega_id"];
        }

        /*$pedidoporToValidate2 = [
            "pedido_por" => json_decode($nota_bodega_salida_traslado["pedido_por"] ?? '', true),
            "tipo" => $nota_bodega_salida_traslado['tipo'],
            "entrada_salida" => $nota_bodega_salida_traslado['entrada_salida'],
            "bodega_id" => $idBodegas,
            "destino_fuerza_ok" => $nota_bodega_salida_traslado["destino_fuerza_ok"] ?? 'No'
        ];
        $inc4 = NotaFormHelper::validatePedidoPorV2($pedidoporToValidate2);
        $this->assertEquals($pedido_por_bodega_inconsistencias, $inc4, "$nota_bodega_salida_traslado[tipo] : Bordega no requiere Pedido Por (por parametros)");*/

    }


    /**
     * @covers NotaFormHelper::calculaIconosInconsistencias
     * @covers NotaFormHelper::validateAyudantesV2
     * @covers NotaFormHelper::validateCampoNumeroCompra
     * @covers NotaFormHelper::validateClientesV2
     * @covers NotaFormHelper::validatePedidoPorV2
     * @covers usuarioTipoRony
     * @covers strit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacSqlBuilder::update
     * @covers Iac\inc\sql\IacSqlBuilder::where
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArrayIndx
     * @covers param
     * @covers sqlMysqli::log_trace
     * @covers strim
     * @covers the_error_handler
     */
    public function testcheckCanEditField()
    {
        $nota = [
            'nota_bodega_id' => self::NOTA_BODEGA_ID,
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $inc = NotaFormHelper::calculaIconosInconsistencias([], $nota);
        $this->assertEquals(true, !empty($inc['numero_compra']), "¿Registro Inconsistencia por Numero de Compra? no sabemos si la correcta");
        $this->assertEquals(true, !empty($inc['clientes']), );
        $this->assertEquals(true, !empty($inc['ayudantes']), );
        $this->assertEquals(true, !empty($inc['pedido_por']), );

        $traslado = [
            'nota_bodega_id' => self::NOTA_TRASLADO_ID,
            'numero' => '40173',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Traslado',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-10-02 08:50:23", "alta_por": "rony", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "1"}]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-10-02 08:50:21", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'ayudantes' => 'SIN AYUDANTES',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-10-02 08:50:24", "display": "SIN AYUDANTES", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-10-02 09:50:30", "alta_por": "rony", "compra_id": "54bf6469e2ccb35411ee6132e361c54a", "fue_error": "No", "numero_compra": 2199}]',
            'numero_compra_actual' => '2199',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "index": "1", "alta_db": "2023-10-02 08:50:27", "display": "IVÁN BRAYAN MATA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $inc2 = NotaFormHelper::calculaIconosInconsistencias([], $traslado);

        $this->assertEquals(!empty($inc2['destino_match']), true);
        $this->assertEquals(!empty($inc2['numero_compra']), true);
        $this->assertEquals(!empty($inc2['clientes']), true);
        $this->assertEquals(!empty($inc2['ayudantes']), true);
        $this->assertEquals(!empty($inc2['pedido_por']), true);

        $trasladoSalida_nota_bodega_id = '0a00270000128e4f11ef1892fdec208Z';
        $trasladoSalida = [
            'nota_bodega_id' => $trasladoSalida_nota_bodega_id,
            'numero' => '40173',
            'bodega_id' => '74867af2fe60ad6b11ec6f24d9e472b6',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Traslado',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => 'cc483a12801aa9bd11ee150406c64444',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-10-02 08:50:23", "alta_por": "rony", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "1"}]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-10-02 08:50:21", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'ayudantes' => 'SIN AYUDANTES',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-10-02 08:50:24", "display": "SIN AYUDANTES", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-10-02 09:50:30", "alta_por": "rony", "compra_id": "54bf6469e2ccb35411ee6132e361c54a", "fue_error": "No", "numero_compra": 2199}]',
            'numero_compra_actual' => '2199',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "index": "1", "alta_db": "2023-10-02 08:50:27", "display": "IVÁN BRAYAN MATA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $inc21 = NotaFormHelper::calculaIconosInconsistencias([], $trasladoSalida);
        $this->assertEquals(!empty($inc21['destino_match']), true);
        $this->assertEquals(!empty($inc21['numero_compra']), true);
        $this->assertEquals(!empty($inc21['clientes']), true);
        $this->assertEquals(!empty($inc21['ayudantes']), true);
        $this->assertEquals(!empty($inc21['pedido_por']), true);

        $devolucion = [
            'nota_bodega_id' => self::NOTA_DEVOLUCION_ID,
            'numero' => '3285',
            'bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6',
            'grupo' => 'COYUYA',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Devolucion',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'ayudantes_json' => '',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '',
            'numero_compra_actual' => '',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $inc3 = NotaFormHelper::calculaIconosInconsistencias([], $devolucion);

        $this->assertEquals(!empty($inc3['destino_match']), true);
        $this->assertEquals(!empty($inc3['numero_compra']), true);
        $this->assertEquals(!empty($inc3['clientes']), true);
        $this->assertEquals(!empty($inc3['ayudantes']), true);
        $this->assertEquals(!empty($inc3['pedido_por']), true);

        $devolucion = [
            'nota_bodega_id' => self::NOTA_DEVOLUCION_ID,
            'numero' => '3285',
            'bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6',
            'grupo' => 'COYUYA',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Devolucion',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'ayudantes_json' => '',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '',
            'numero_compra_actual' => '',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $devolucion["pedido_por"] = '[{"id": "74867af2fe60a78c11ed27d1cc51b84b", "lbl": "ALBERTO ABDUL MASSIH TRAD", "index": "1", "alta_db": "2024-05-08 16:23:51", "display": "ALBERTO ABDUL MASSIH TRAD", "alta_por": "nancy", "fue_error": "No", "alta_por_id": "85"}]';
        $inc4 = NotaFormHelper::calculaIconosInconsistencias([], $devolucion);

        $this->assertEquals(!empty($inc4['destino_match']), true);
        $this->assertEquals(!empty($inc4['numero_compra']), true);
        $this->assertEquals(!empty($inc4['clientes']), true);
        $this->assertEquals(!empty($inc4['ayudantes']), true);
        $this->assertEquals(!empty($inc4['pedido_por']), true);


        $devolucion = [
            'nota_bodega_id' => self::NOTA_DEVOLUCION_ID,
            'numero' => '3285',
            'bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6',
            'grupo' => 'COYUYA',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Devolucion',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'ayudantes_json' => '',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '',
            'numero_compra_actual' => '',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $devolucion["pedido_por"] = '[{"id": "cc483a12801aa56111edd957ea9f1038", "lbl": "ANA LAURA GONZALEZ", "check": "0", "index": "1", "alta_db": "2024-05-22 17:46:20", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]';
        $inc4 = NotaFormHelper::calculaIconosInconsistencias([], $devolucion);

        $this->assertEquals(!empty($inc4['destino_match']), true);
        $this->assertEquals(!empty($inc4['numero_compra']), true);
        $this->assertEquals(!empty($inc4['clientes']), true);
        $this->assertEquals(!empty($inc4['ayudantes']), true);
        $this->assertEquals(!empty($inc4['pedido_por']), true);


        $devolucion = [
            'nota_bodega_id' => self::NOTA_DEVOLUCION_ID,
            'numero' => '3285',
            'bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6',
            'grupo' => 'COYUYA',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Devolucion',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'ayudantes_json' => '',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '',
            'numero_compra_actual' => '',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $devolucion["cliente"] = '[{"check": "0", "index": "", "nombre": "ANGEL RIVEROS", "alta_db": "2024-05-08 16:23:47", "alta_por": "nancy", "fue_error": "No", "cliente_id": "", "alta_por_id": "85"}]';
        $inc5 = NotaFormHelper::calculaIconosInconsistencias([], $devolucion);

        $this->assertEquals(!empty($inc5['destino_match']), true);
        $this->assertEquals(!empty($inc5['numero_compra']), true);
        $this->assertEquals(!empty($inc5['clientes']), true);
        $this->assertEquals(!empty($inc5['ayudantes']), true);
        $this->assertEquals(!empty($inc5['pedido_por']), true);

        $devolucion = [
            'nota_bodega_id' => self::NOTA_DEVOLUCION_ID,
            'numero' => '3285',
            'bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6',
            'grupo' => 'COYUYA',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Devolucion',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'ayudantes_json' => '',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '',
            'numero_compra_actual' => '',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $devolucion["cliente"] = '';
        $inc6 = NotaFormHelper::calculaIconosInconsistencias([], $devolucion);

        $this->assertEquals(!empty($inc6['destino_match']), true);
        $this->assertEquals(!empty($inc6['numero_compra']), true);
        $this->assertEquals(!empty($inc6['clientes']), true);
        $this->assertEquals(!empty($inc6['ayudantes']), true);
        $this->assertEquals(!empty($inc6['pedido_por']), true);


        $nota = [
            'nota_bodega_id' => self::NOTA_BODEGA_ID,
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $nota["cliente"] = '';
        $inc7 = NotaFormHelper::calculaIconosInconsistencias([], $nota);
        $this->assertEquals(!empty($inc7['destino_match']), true);
        $this->assertEquals(!empty($inc7['numero_compra']), true);
        $this->assertEquals(!empty($inc7['clientes']), true);
        $this->assertEquals(!empty($inc7['ayudantes']), true);
        $this->assertEquals(!empty($inc7['pedido_por']), true);


        $traslado = [
            'nota_bodega_id' => self::NOTA_TRASLADO_ID,
            'numero' => '40173',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Traslado',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => '74867af2fe60ad6b11ec6d7b5b255fb6',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-10-02 08:50:23", "alta_por": "rony", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "1"}]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-10-02 08:50:21", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'ayudantes' => 'SIN AYUDANTES',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-10-02 08:50:24", "display": "SIN AYUDANTES", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-10-02 09:50:30", "alta_por": "rony", "compra_id": "54bf6469e2ccb35411ee6132e361c54a", "fue_error": "No", "numero_compra": 2199}]',
            'numero_compra_actual' => '2199',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "index": "1", "alta_db": "2023-10-02 08:50:27", "display": "IVÁN BRAYAN MATA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $traslado["cliente"] = '';
        $inc8 = NotaFormHelper::calculaIconosInconsistencias([], $traslado);

        $this->assertEquals(!empty($inc8['destino_match']), true);
        $this->assertEquals(!empty($inc8['numero_compra']), true);
        $this->assertEquals(!empty($inc8['clientes']), true);
        $this->assertEquals(!empty($inc8['ayudantes']), true);
        $this->assertEquals(!empty($inc8['pedido_por']), true);


        $trasladoSalida = [
            'nota_bodega_id' => $trasladoSalida_nota_bodega_id,
            'numero' => '40173',
            'bodega_id' => '74867af2fe60ad6b11ec6f24d9e472b6',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Traslado',
            'fecha' => '2023-10-02',
            'label' => '',
            'origen_id' => 'cc483a12801aa9bd11ee150406c64444',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'NEGRO',
            'contra_nota_bodega_id' => '2199',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"nombre": "BODEGAS PROPIAS", "alta_db": "2023-10-02 08:50:23", "alta_por": "rony", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "1"}]',
            'alta_db' => '2023-10-02 09:50:30',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2023-10-02 09:50:30',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"nombre": "JESUS SALVADOR VIRUEGAS", "alta_db": "2023-10-02 08:50:21", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1", "figuratransporte_id": "74867af2fe6087aa11ec94cccc5bd45c"}]',
            'chofer_responsable_id' => '74867af2fe6087aa11ec94cccc5bd45c',
            'ayudantes' => 'SIN AYUDANTES',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "index": "1", "alta_db": "2023-10-02 08:50:24", "display": "SIN AYUDANTES", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2023-10-02 09:50:30", "alta_por": "rony", "compra_id": "54bf6469e2ccb35411ee6132e361c54a", "fue_error": "No", "numero_compra": 2199}]',
            'numero_compra_actual' => '2199',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "index": "1", "alta_db": "2023-10-02 08:50:27", "display": "IVÁN BRAYAN MATA", "alta_por": "rony", "fue_error": "No", "alta_por_id": "1"}]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            //'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            //'cliente_actual' => '["BODEGAS PROPIAS"]["11eca7b75d17fc8d81a354bf6469e2cc"]',
            //'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            //'numero_as_num' => '40173',
            //'numero_order_text' => '00000000000000000000000000040173',
            //'numero_real' => '40173',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            //'cliente_actual_id' => '["11eca7b75d17fc8d81a354bf6469e2cc"]',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-10-02 09:50:30',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $trasladoSalida["cliente"] = '';
        $inc9 = NotaFormHelper::calculaIconosInconsistencias([], $trasladoSalida);
        $this->assertEquals(!empty($inc9['destino_match']), true);
        $this->assertEquals(!empty($inc9['numero_compra']), true);
        $this->assertEquals(!empty($inc9['clientes']), true);
        $this->assertEquals(!empty($inc9['ayudantes']), true);
        $this->assertEquals(!empty($inc9['pedido_por']), true);


    }

    /**
     * @covers NotaFormHelper::TrasladoMatch
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::commit
     * @covers usuarioTipoRony
     * @covers strit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacSqlBuilder::update
     * @covers Iac\inc\sql\IacSqlBuilder::where
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArrayIndx
     * @covers param
     * @covers sqlMysqli::log_trace
     * @covers strim
     * @covers the_error_handler
     * @covers Iac\inc\sql\IacMysqli::queryArray
     * @covers Iac\inc\sql\IacMysqli::selectKeyValue
     * @covers Iac\inc\sql\IacMysqli::transaction
     * @covers ia_sqlKeyValue
     * @covers ia_transaction
     *
     */
    public function testTrasladoMatch(){
        $method = __METHOD__;
        $trasladoEntrada_nota_bodega_id = 'cc483a12801aa3c711ef0fc98a5f00eZ';
        $sql1 = [
            'nota_bodega_id' => $trasladoEntrada_nota_bodega_id,
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'numero' => '60094',
            'tipo_inconsistencia' => 'contra_nota',
            'inconsistencia' => '<b style="color:red">Contra Notas:</b><p></p><ol><b>COLORES:</b><li><b class="rojo">\'NEGRO\' NO</b> ESTA EN LAS CONTRA NOTAS</li><li><b class="rojo">\'ROJO\' NO</b> ESTA EN LAS CONTRA NOTAS</li></ol><p><table class="laTabla"><caption class="rojo">CANTIDADES NO COINCIDEN</caption>',
            'nivel' => 'danger',
            'puede_verlo' => 'todos',
            'estado' => 'activo',
            'alta_por' => 'rony',
        ];
        $sql2 = [

            'nota_bodega_id' => $trasladoEntrada_nota_bodega_id,
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'numero' => '60094',
            'tipo_inconsistencia' => 'average',
            'inconsistencia' => 'Revisa el <b style="color:red">average</b> de <b style="color:red">PERLA</b>,',
            'nivel' => 'danger',
            'puede_verlo' => 'todos',
            'estado' => 'activo',
            'alta_db' => '2024-05-21 15:18:19',
            'alta_por' => 'rony',
        ];

        $trasladoEntrada = [
            'nota_bodega_id' => $trasladoEntrada_nota_bodega_id,
            'numero' => '60094',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Traslado',
            'fecha' => '2024-05-11',
            'origen_id' => '74867af2fe60ad6b11ec6f25148a346a',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca805917aea',
            'colores' => 'LIMON, NEGRO, PERLA, ROJO',
            'contra_nota_bodega_id' => '1793',
            'para_quien' => '',
            'total_rolls' => '32.00',
            'total_quantity' => '562.80',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => '2024-05-21 12:28:03',
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'NO VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"check": "1", "index": "", "nombre": "BODEGAS PROPIAS", "alta_db": "2024-05-11 13:11:57", "alta_por": "rosa", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "134"}]',
            'alta_db' => '2024-05-11 13:06:15',
            'alta_por' => 'rosa',
            'ultimo_cambio' => '2024-05-21 15:18:19',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '2',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"check": "", "index": "", "nombre": "HUGO ARMANDO GONZÁLEZ ACOSTA", "alta_db": "2024-05-11 13:11:55", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134", "figuratransporte_id": "cc483a12801a8beb11edf0e6825349db"}]',
            'chofer_responsable_id' => 'cc483a12801a8beb11edf0e6825349db',
            'ayudantes' => 'SIN AYUDANTES;',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "check": "1", "index": "1", "alta_db": "2024-05-11 13:11:58", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '4',
            'numero_compra' => '[{"index": 1, "alta_db": "2024-05-21 15:18:18", "alta_por": "rony", "compra_id": "cc483a12801aa3c711ef0fb2debec700", "fue_error": "No", "numero_compra": 1793}]',
            'numero_compra_actual' => '1793',
            'lock_el' => NULL,
            'super_lock_el' => '2024-05-21 12:36:20',
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "check": "1", "index": "1", "alta_db": "2024-05-11 13:12:00", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134"}]',
            'system_lock' => '0',
            'system_lock_el' => '2024-05-21 14:09:36',
            'system_lock_por' => 'rony',
            'modificacion_importante' => 'Si',
            'modificacion_importante_el' => '2024-05-21 15:18:19',
            'modificacion_importante_por' => 'rony',
            'modificacion_importante_cuantas' => '2',

            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => '',
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'numero_as_num' => '60094',
            'numero_order_text' => '00000000000000000000000000060094',
            'numero_real' => '60094',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2024-05-11 13:06:15',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2024-05-11 13:06:15',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
            'nota_unidades' => 'KG',
            'verificado_list' => NULL,
            'ano' => '2024',
            'dia' => '132',
            'extras' => '',
            'pueden_corregir_errores' => 'No',
            'alta_db_idx' => '2024-05-11',
            'cliente_actual_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente_actual' => 'BODEGAS PROPIAS',

            'lock_por_tiempo_por' => 'rony',
        ];

        $sql[] = "DELETE /*$method*/ FROM inconsistencia_nota_bodega WHERE nota_bodega_id = ".strit($trasladoEntrada["nota_bodega_id"]);
        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $sql[] = $builder->insert('inconsistencia_nota_bodega', $sql1, comment: __METHOD__ . " " . __LINE__);
        $sql[] = $builder->insert('inconsistencia_nota_bodega', $sql2, comment: __METHOD__ . " " . __LINE__);

        if(ia_transaction($sql)){
            ia_errores_a_dime();
            var_dump('Error al Hacer querys NOTA BODEGA 2');
            global $gSqlClass;
            var_dump( $gSqlClass->errorLog_get());
        }
        $validate = NotaFormHelper::TrasladoMatch($trasladoEntrada);
        $this->assertEquals(array_key_exists('succes', $validate), true);
        $this->assertEquals(($validate['succes'] ?? ''), 'FAIL', 'validar traslado match FAIL');

        $trasladoEntrada["tipo"] = 'Devolucion';
        $validate = NotaFormHelper::TrasladoMatch($trasladoEntrada);
        $this->assertEquals(array_key_exists('succes', $validate), true);
        $this->assertEquals($validate["succes"], '', 'validar traslado match FAIL 2');
        $this->assertEquals(array_key_exists('message', $validate), true);
        $this->assertEquals(($validate['message'] ?? ''), 'No necesita validacion', 'validar traslado match FAIL 3');


        $trasladoSalida_nota_bodega_id = '0a00270000128e4f11ef1892fdec208Z';
        $trasladoSalida = [
            'nota_bodega_id' => $trasladoSalida_nota_bodega_id,
            'numero' => '1796',
            'bodega_id' => '74867af2fe60ad6b11ec6f24d9e472b6',
            'grupo' => 'COYUYA',
            'entrada_salida' => 'Salida',
            'tipo' => 'Traslado',
            'fecha' => '2024-05-22',
            'label' => '',
        'origen_id' => 'cc483a12801aa9bd11ee150406c64444',
			'paid' => '0',
			'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
			'colores' => 'BLANCO',
			'contra_nota_bodega_id' => '',
			'para_quien' => '',
			'total_rolls' => '1.00',
			'total_quantity' => '25.10',
			'remarks' => '',
			'remarks_paid' => '',
			'remarks_internos' => NULL,
			'estado' => '0',
			'lock' => '0',
			'traslado_match_lock' => '0',
			'traslado_match_lock_el' => NULL,
			'lock_por_tiempo' => '0',
			'lock_por_tiempo_el' => NULL,
			'super_lock' => '0',
			'verificaciones_propias' => '0',
			'verificaciones_otras_bodegas' => '0',
			'estado_verificacion' => 'FALTAN VERIFICACIONES',
			'numero_solicitud' => NULL,
			'solicitud_carta_porte_id' => NULL,
			'tipo_nota' => '',
			'tipo_nota_json' => '[]',
			'numero_tipo_nota' => '',
			'numero_tipo_nota_json' => '[]',
			'quantity_tipo_nota' => '0.00',
			'quantity_tipo_nota_json' => '[]',
			'documento' => 'nada',
			'cp_figuratransporte_id' => '',
			'cp_autotransporte_id' => '',
			'confirmacion_etiquetado' => 'No',
			'empresa_id_etiquetado' => '',
			'forma_etiquetado' => '',
			'responsable_etiquetado' => '',
			'numero_contenedor' => '',
			'autorizado' => 'No',
			'autorizado_por' => NULL,
			'autorizado_el' => NULL,
			'recibido' => 'No',
			'recibido_por' => NULL,
			'recibido_el' => NULL,
			'cp_cliente_id' => '',
			'cliente_cp' => '',
			'cliente_id' => '',
			'cliente' => '[]',
			'alta_db' => '2024-05-22 18:28:28',
			'alta_por' => 'rony',
			'ultimo_cambio' => '2024-05-22 18:28:28',
			'ultimo_cambio_por' => 'rony',
			'iac_edits' => '0',
			'remarks_recibido' => NULL,
			'json_file_attachments_nota_foto' => NULL,
			'json_file_attachments' => NULL,
			'chofer_responsable' => '[]',
			'chofer_responsable_id' => '',
			'ayudantes' => '',
			'ayudantes_json' => '[]',
			'ultimo_movimiento' => NULL,
			'es_apartado' => 'No',
			'autorizacion_ultimo_movimiento' => 'No',
			'autorizacion_ultimo_movimiento_por' => NULL,
			'autorizacion_ultimo_movimiento_el' => NULL,
			'autorizacion_ultimo_movimiento_cuantos' => '0',
			'autorizacion_ultimo_movimiento_rony' => 'No',
			'autorizacion_ultimo_movimiento_por_rony' => NULL,
			'autorizacion_ultimo_movimiento_el_rony' => NULL,
			'inconsistencias_text' => '',
			'inconsistencias_nivel' => 'warning',
			'num_colores' => '1',
			'numero_compra' => '[]',
			'numero_compra_actual' => '',
			'lock_el' => NULL,
			'super_lock_el' => NULL,
			'unlock_hasta' => NULL,
			'unsuper_lock_hasta' => NULL,
			'traslado_forza_ok' => 'No',
			'traslado_fuerza_el' => NULL,
			'pedido_por' => '[]',
			'system_lock' => '0',
			'system_lock_el' => NULL,
			'system_lock_por' => '',
			'modificacion_importante' => 'No',
			'modificacion_importante_el' => NULL,
			'modificacion_importante_por' => '',
			'modificacion_importante_cuantas' => '0',
			'modificacion_importante_text' => NULL,
			'modificacion_importante_json' => '',
			'modificacion_importante_autorizada' => 'No',
			'modificacion_importante_autorizada_el' => NULL,
			'modificacion_importante_autorizada_por' => '',
			'modificacion_importante_autorizada_cuantas' => '0',
			'modificacion_importante_autorizada_requeridas' => '2',
			'modificacion_importante_autorizada_text' => NULL,
			'destino_fuerza_ok' => 'No',
			'destino_fuerza_el' => NULL,
			'verificada' => 'No',
			'verificada_el' => NULL,
			'verificada_por' => '',
			'pagare_id' => '',
			'numero_pagare' => '',
			'fabrica_id' => '',
			'motivo_de_lock' => NULL,
			'por_sistema' => '0',
			'existencia_snap_shot' => '[]',
			'existencia_snap_shot_html' => NULL,
			'motivo_cambio_importante' => '',
			'reset_lock' => '0',
			'reset_lock_el' => NULL,
			'reset_lock_por' => '',
			'reset_lock_motivo' => NULL,
			'reset_lock_por_nota_ajuste' => NULL,
			'activo' => '1',
			'pedido' => '[]',
			'numero_pi' => '',
			'own_reference' => '',
			'numero_as_num' => '1796',
			'numero_order_text' => '00000000000000000000000000001796',
			'numero_real' => '1796',
			'producto_general_calidad' => '',
			'producto_general_calidad_comentario' => '',
			'bodega_state' => '',
			'lock_por_tiempo_nota_ajuste' => '0',
			'lock_por_tiempo_nota_ajuste_el' => NULL,
			'lock_por_tiempo_nota_ajuste_por' => '',
			'lock_por_tiempo_nota_ajuste_nota_id' => '',
			'lock_por_tiempo_nota_ajuste_motivo' => '',
			'lock_por_nota_posterior_ajuste' => '0',
			'lock_por_nota_posterior_ajuste_el' => '2024-05-22 18:28:28',
			'lock_por_nota_posterior_ajuste_id' => '',
			'lock_por_nota_posterior_ajuste_motivo' => '',
			'nota_unidades' => '',
			'verificado_list' => NULL,
			'ano' => '2024',
			'dia' => '143',
			'extras' => '',
			'pueden_corregir_errores' => 'Si',
			'alta_db_idx' => '2024-05-22',
			'cliente_actual_id' => NULL,
			'cliente_actual' => '',
			'lock_por_tiempo_motivo' => '',
			'super_lock_motivo' => NULL,
			'lock_por_tiempo_por' => '',
			'system_lock_motivo' => NULL,
		];


        $sql3 = [
                'nota_bodega_id' => $trasladoSalida_nota_bodega_id,
                'bodega_id' => '74867af2fe60ad6b11ec6f24d9e472b6',
                'numero' => '1796',
                'tipo_inconsistencia' => 'pedido_por',
                'inconsistencia' => "Pedido por NO CAPTURADO",
                'nivel' => 'warning',
                'puede_verlo' => 'todos',
                'estado' => 'activo',
                'alta_db' => '2024-05-22 18:28:29',
                'alta_por' => 'rony',
            ];
        $sql4 = [
                'nota_bodega_id' => $trasladoSalida_nota_bodega_id,
                'bodega_id' => '74867af2fe60ad6b11ec6f24d9e472b6',
                'numero' => '1796',
                'tipo_inconsistencia' => 'contra_nota',
                'inconsistencia' => "Contra Notas:
FALTO CAPTURAR EL CLIENTE

SUS CONTRA NOTAS:
 ESPERANDO CONTRA NOTA DE ENTRADA
",
                'nivel' => 'danger',
                'puede_verlo' => 'todos',
                'estado' => 'activo',
                'alta_db' => '2024-05-22 18:28:29',
                'alta_por' => 'rony',
            ];
        $sql5 = [
                'nota_bodega_id' => $trasladoSalida_nota_bodega_id,
                'bodega_id' => '74867af2fe60ad6b11ec6f24d9e472b6',
                'numero' => '1796',
                'tipo_inconsistencia' => 'negativos',
                'inconsistencia' => "Hay Existencia Negativa: BLANCO",
                'nivel' => 'info',
                'puede_verlo' => 'todos',
                'estado' => 'activo',
                'alta_db' => '2024-05-22 18:28:29',
                'alta_por' => 'rony',
            ];

        $sql[] = "DELETE /*$method*/ FROM inconsistencia_nota_bodega WHERE nota_bodega_id = ".strit($trasladoSalida["nota_bodega_id"]);
        $sql[] = $builder->insert('inconsistencia_nota_bodega', $sql3, comment: __METHOD__ . " " . __LINE__);
        $sql[] = $builder->insert('inconsistencia_nota_bodega', $sql4, comment: __METHOD__ . " " . __LINE__);
        $sql[] = $builder->insert('inconsistencia_nota_bodega', $sql5, comment: __METHOD__ . " " . __LINE__);

        if(ia_transaction($sql)){
            ia_errores_a_dime();
            var_dump('Error al Hacer querys NOTA BODEGA 3');
            global $gSqlClass;
            var_dump( $gSqlClass->errorLog_get());
        }

        $validate2 = NotaFormHelper::TrasladoMatch($trasladoSalida);
        $this->assertEquals(array_key_exists('succes', $validate2), true);
        $this->assertEquals($validate2["succes"], 'WAIT', 'validar traslado match FAIL salida 1 ');
        $this->assertEquals(array_key_exists('message', $validate2), true);
        $this->assertEquals(($validate2['message'] ?? ''), 'Esperando que se capture la contra nota', 'validar traslado match FAIL salida 2');


        $trasladoSalida["traslado_forza_ok"] = 'Si';
        $validate3 = NotaFormHelper::TrasladoMatch($trasladoSalida);
        $this->assertEquals(array_key_exists('succes', $validate3), true);
        $this->assertEquals($validate3["succes"], 'CORRECT', 'validar traslado match FAIL salida 3 ');
        $this->assertEquals(array_key_exists('message', $validate3), true);
        $this->assertEquals(($validate3['message'] ?? ''), 'Traslado Match forzado', 'validar traslado match FAIL salida 4');

        ia_query(
          "DELETE /*$method*/ 
                FROM inconsistencia_nota_bodega 
                WHERE " . $builder->where(['nota_bodega_id'=>[$trasladoEntrada_nota_bodega_id, $trasladoSalida_nota_bodega_id]] )
        );
    }

    /**
     * @covers NotaFormHelper::permisosUpdete
     * @covers NotaFormHelper::permisosUpdeteVerificacion
     * @covers NotaFormHelper::permisosCreate
     * @covers generaGridEditOptions
     * @covers NotaFormHelper::validateCampoNumeroCompra
     * @covers parseClauseIn
     * @covers puedeGastosBanco
     * @covers usuarioTipoRony
     * @covers strit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacSqlBuilder::update
     * @covers Iac\inc\sql\IacSqlBuilder::where
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArrayIndx
     * @covers param
     * @covers sqlMysqli::log_trace
     * @covers puedePermisoUsuario
     * @covers to_label
     * @covers usuarioSupervisaBodega
     * @covers usuarioTipoRony
     * @covers Permisador::puede
     * @covers appRelateBase::campos_incorpora
     * @covers iacase_base::__construct
     * @covers ia_htmlentities
     */
    public function testPermisos(){
        $nota = [
            'nota_bodega_id' => self::NOTA_BODEGA_ID,
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $permisos = NotaFormHelper::permisosUpdete($nota);
        $this->assertEquals(array_key_exists('modo', $permisos), true);
        $this->assertEquals($permisos["modo"], 'DEFAULT', 'validar permisos en nota DEFAULT');

        $permisos_create = NotaFormHelper::permisosCreate($nota);
        $this->assertEquals(array_key_exists('modo', $permisos_create), true);
        $this->assertEquals($permisos_create["modo"], 'r', 'validar permisos en nota Crear');

        $verificacion = [
            'nota_bodega_verificacion_id' => 'cc483a12801ab25111ef1152ce840912',
            'nota_bodega_id' => 'cc483a12801ab25111ef114997824311',
            'numero' => '3281',
            'bodega_id' => '74867af2fe60ad6b11ec6d7b3badcba6',
            'grupo' => 'COYUYA',
            'bodega_verificador_id' => '2',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2024-05-13',
            'label' => NULL,
            'origen_id' => '11ec6cb303b9c80dad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1caf0cb54883',
            'colores' => 'BLANCO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '3.00',
            'total_quantity' => '69.70',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'match' => 'Si',
            'diferencias' => '',
            'tipo_nota' => '',
            'numero_tipo_nota' => '',
            'quantity_tipo_nota' => '',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '',
            'iac_usr_id' => '94',
            'alta_db' => '2024-05-13 12:01:22',
            'alta_por' => 'magda_al',
            'ultimo_cambio' => '2024-05-13 12:01:22',
            'ultimo_cambio_por' => 'magda_al',
            'iac_edits' => '0',
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'ayudantes_json' => '[]',
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'numero_compra' => '',
            'numero_compra_actual' => '',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'motivo_cambio_importante' => '',
            'numero_as_num' => '3281',
            'numero_order_text' => '00000000000000000000000000003281',
            'numero_real' => '3281',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => '',
            'reset_lock_por' => 'sistemas',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2024-05-13 12:01:22',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'nota_unidades' => '',
            'verificado_list' => NULL,
            'extras' => '',
            'pueden_corregir_errores' => 'No',
            'alta_db_idx' => NULL,
            'cliente_actual_id' => NULL,
            'ano' => '2024',
            'mes' => '5',
            'lock_por_tiempo_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => NULL,
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_por' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
            'lock_por_tiempo_por' => '',
            'super_lock_motivo' => NULL,
        ];
        $permisos_verificacion = NotaFormHelper::permisosUpdeteVerificacion($verificacion["bodega_id"]);
        $this->assertEquals(array_key_exists('modo', $permisos_verificacion), true);
        $this->assertEquals($permisos_verificacion["modo"], 'DEFAULT', 'validar permisos en nota DEFAULT');

    }


    /**
     * @covers NotaFormHelper::autorizarModificacionImportante
     * @covers generaGridEditOptions
     * @covers NotaFormHelper::validateCampoNumeroCompra
     * @covers parseClauseIn
     * @covers puedeGastosBanco
     * @covers usuarioTipoRony
     * @covers strit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacSqlBuilder::update
     * @covers Iac\inc\sql\IacSqlBuilder::where
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArrayIndx
     * @covers param
     * @covers sqlMysqli::log_trace
     * @covers puedePermisoUsuario
     * @covers to_label
     * @covers usuarioSupervisaBodega
     * @covers usuarioTipoRony
     * @covers Permisador
     * @covers appRelateBase::campos_incorpora
     * @covers iacase_base::__construct
     * @covers NotaBodegaAutorizacion
     * @covers \TableHelper
     */
    public function testautorizarModificacionImportante()
    {

        $method = __METHOD__;

        $nota_bodega_id = '74867af2fe6080d411ed44bd2998c4dZ';
        $nota = [
            'nota_bodega_id' => $nota_bodega_id,
            'numero' => '6636',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Salida',
            'tipo' => 'Movimiento',
            'fecha' => '2022-10-05',
            'label' => '',
            'origen_id' => '11ec6cb303b9b1e4ad6b74867af2fe60',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1c9b33207801',
            'colores' => 'VINO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.30',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => 'CASH',
            'tipo_nota_json' => '[{"lbl": "CASH", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "tipo_nota": "CASH", "alta_por_id": 108}]',
            'numero_tipo_nota' => '15136',
            'numero_tipo_nota_json' => '[{"lbl": "15136", "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "numero_tipo_nota": "15136"}]',
            'quantity_tipo_nota' => '2150.50',
            'quantity_tipo_nota_json' => '[{"lbl": 2150.5, "index": 1, "alta_db": "2022-10-05 09:51:16", "alta_por": "gaby", "fue_error": "No", "alta_por_id": 108, "quantity_tipo_nota": 2150.5}]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => 'YA TENIA ETIQUETADO',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'Si',
            'recibido_por' => 'eugenia',
            'recibido_el' => '2022-10-05 09:55:37',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[{"nombre": "ROSENDO", "alta_db": "2022-10-05 09:53:57", "alta_por": "gaby", "fue_error": "No", "cliente_id": ""}]',
            'alta_db' => '2022-10-05 09:51:16',
            'alta_por' => 'gaby',
            'ultimo_cambio' => '2022-10-05 09:51:16',
            'ultimo_cambio_por' => 'gaby',
            'iac_edits' => '1',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => 'OSCAR NOE MENDOZA BOCANEGRA',
            'ayudantes_json' => '[{"id": "11ed2021f8920ffba2c174867af2fe60", "lbl": "OSCAR NOE MENDOZA BOCANEGRA", "index": "1", "alta_db": "2022-10-05 09:54:00", "display": "OSCAR NOE MENDOZA BOCANEGRA", "alta_por": "gaby", "fue_error": "No"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => NULL,
            'inconsistencias_nivel' => '',
            'num_colores' => '1',
            'numero_compra' => '[{"index": 1, "alta_db": "2022-10-05 09:55:39", "alta_por": "eugenia", "compra_id": "", "fue_error": "No", "numero_compra": "10135"}]',
            'numero_compra_actual' => '10135',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60a78c11ed27d2889f69d1", "lbl": "JUSTINO LORENZO CUEVAS", "index": "1", "alta_db": "2022-10-05 09:54:02", "display": "JUSTINO LORENZO CUEVAS", "alta_por": "gaby", "fue_error": "No"}]',
            'system_lock' => '1',
            'system_lock_el' => '2023-01-17 18:03:05',
            'system_lock_por' => 'nancy_gt',
            'modificacion_importante' => 'Si',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '2',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '{}',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '2',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => '',
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => NULL,
            'reset_lock' => '0',
            'reset_lock_el' => '2023-01-17 18:03:05',
            'reset_lock_por' => 'nancy_gt',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => NULL,
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '0000-00-00 00:00:00',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2023-09-14 10:55:06',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
        ];
        $modIMP = NotaFormHelper::autorizarModificacionImportante($nota);

        $this->assertEquals(is_array($modIMP), true);
        $this->assertEquals( !empty($modIMP['btn_auth_modificacion_importante']), true);


        $sql1 = [

                'nota_bodega_id' => $nota_bodega_id,
                'iac_usr_id' => '108',
                'tipo' => 'modificacion_importante',
                'valor' => 'No',
                'por_quien' => 'gaby',

                'remarks' => '',
                'tabla_origen' => 'nota_bodega',
            ];

        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $sql[] = "DELETE /*$method*/ FROM autorizacion_modificacion_importante_log WHERE nota_bodega_id = ".strit($nota_bodega_id);
        $sql[] = $builder->insert('autorizacion_modificacion_importante_log', $sql1, comment: __METHOD__ . " " . __LINE__);

        if(ia_transaction($sql)){
            ia_errores_a_dime();
            var_dump('Error al Hacer querys NOTA BODEGA 3');
            global $gSqlClass;
            var_dump( $gSqlClass->errorLog_get());
        }

        $nota["modificacion_importante_autorizada"] = 'Si';
        $modIMP2 = NotaFormHelper::autorizarModificacionImportante($nota);
        $this->assertEquals(is_array($modIMP2), true);
        $this->assertEquals( !empty($modIMP2['btn_auth_modificacion_importante']), true);


        $sql2 = [

                'nota_bodega_id' => $nota_bodega_id,
                'iac_usr_id' => '108',
                'tipo' => 'modificacion_importante',
                'valor' => 'Si',
                'por_quien' => 'gaby',

                'remarks' => '',
                'tabla_origen' => 'nota_bodega',
            ];



        $builder = new \Iac\inc\sql\IacSqlBuilder();
        $sql[] = "DELETE /*$method*/ FROM autorizacion_modificacion_importante_log WHERE nota_bodega_id = ".strit($nota_bodega_id);
        $sql[] = $builder->insert('autorizacion_modificacion_importante_log', $sql2, comment: __METHOD__ . " " . __LINE__);


        if(ia_transaction($sql)){
            ia_errores_a_dime();
            var_dump('Error al Hacer querys NOTA BODEGA 3');
            global $gSqlClass;
            var_dump( $gSqlClass->errorLog_get());
        }

        $nota["modificacion_importante_autorizada"] = 'No';
        $nota["modificacion_importante_autorizada_cuantas"] = 0;
        $modIMP3 = NotaFormHelper::autorizarModificacionImportante($nota);
        $this->assertEquals(is_array($modIMP3), true);
        $this->assertEquals( !empty($modIMP3['btn_auth_modificacion_importante']), true);

    }

    /**
     * @covers NotaFormHelper::normalizeNota
     * @covers generaGridEditOptions
     * @covers parseClauseIn
     * @covers puedeGastosBanco
     * @covers usuarioTipoRony
     * @covers strit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacSqlBuilder::fieldit
     * @covers Iac\inc\sql\IacSqlBuilder::insert
     * @covers Iac\inc\sql\IacSqlBuilder::update
     * @covers Iac\inc\sql\IacSqlBuilder::where
     * @covers Iac\inc\sql\IacStringer::strim
     * @covers Iac\inc\sql\IacStringer::strit
     * @covers assoc_mysql2mysqli
     * @covers ia_query
     * @covers ia_singleton
     * @covers ia_sqlArrayIndx
     * @covers param
     * @covers sqlMysqli::log_trace
     * @covers puedePermisoUsuario
     * @covers to_label
     * @covers usuarioSupervisaBodega
     * @covers usuarioTipoRony
     * @covers Permisador
     * @covers appRelateBase::campos_incorpora
     * @covers iacase_base::__construct
     * @covers NotaBodegaAutorizacion
     * @covers \TableHelper
     * @covers ia_guid
     */
    public function testnormalizeNota(){
        $nota = [
            'nota_bodega_id' => 'cc483a12801a822011ee5e28ee077ef8',
            'numero' => '40173',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'entrada_salida' => '',
            'fecha' => '2023-09-28',
            'origen_id' => '',
            'paid' => '0',
            'remarks' => '',
            'remarks_paid' => '',
            'producto_general_id' => '',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'tipo_nota' => 'CASH',
            'numero_tipo_nota' => '17784',
            'quantity_tipo_nota' => '1506.00',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'cliente_id' => '',
            'cliente' => '',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'numero_compra' => '',
            'pedido_por' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_cambio_importante' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'pedido_por_json' => [
                0 => [
                    'lbl' => 'JOSE LUIS ORTIZ ACEBEDO',
                    'info' => [
                        'value' => 'JOSE LUIS ORTIZ ACEBEDO',
                        'id' => '74867af2fe609f5c11ed29770dadf7cc',
                        'fue_error' => 'No',
                        'alta_db' => '2024-05-24 13:40:55',
                        'alta_por' => 'rony',
                        'alta_por_id' => '1',
                        'index' => '2',
                        'check' => '0',
                    ],
                ],
                1 => [
                    'lbl' => 'JUSTINO LORENZO CUEVAS',
                    'info' => [
                        'value' => 'JUSTINO LORENZO CUEVAS',
                        'id' => '74867af2fe60a78c11ed27d2889f69d1',
                        'fue_error' => 'No',
                        'alta_db' => '2023-09-28 12:00:08',
                        'alta_por' => 'brenda',
                        'alta_por_id' => '137',
                        'index' => '1',
                        'check' => '1',
                    ],
                ],
            ],
            'ayudantes_json' => [
                0 => [
                    'lbl' => 'SIN AYUDANTES',
                    'info' => [
                        'value' => 'SIN AYUDANTES',
                        'id' => '484d7ee23af386f611ed1fe0112d5cb0',
                        'fue_error' => 'No',
                        'alta_db' => '2024-05-24 13:38:29',
                        'alta_por' => 'rony',
                        'alta_por_id' => '1',
                        'index' => '2',
                        'check' => '1',
                    ],
                ],
                1 => [
                    'lbl' => 'EMMANUEL MARTINEZ MORENO',
                    'info' => [
                        'value' => 'EMMANUEL MARTINEZ MORENO',
                        'id' => '11ed2021f892097ca2c174867af2fe60',
                        'fue_error' => 'No',
                        'alta_db' => '2023-09-28 12:00:04',
                        'alta_por' => 'brenda',
                        'alta_por_id' => '137',
                        'index' => '1',
                        'check' => '1',
                    ],
                ],
            ],
            'cliente_label_json' => [
                0 => [
                    'lbl' => 'CLIENTE DE PASO',
                    'info' => [
                        'value' => 'CLIENTE DE PASO',
                        'id' => '11ed5489bfcae9188bdc54bf6469e2cc',
                        'fue_error' => 'No',
                        'alta_db' => '2024-05-24 13:38:28',
                        'alta_por' => 'rony',
                        'alta_por_id' => '1',
                        'index' => '2',
                        'check' => '1',
                    ],
                ],
                1 => [
                    'lbl' => 'DIEGO HERNANDEZ VILLA',
                    'info' => [
                        'value' => 'DIEGO HERNANDEZ VILLA',
                        'id' => '74867af2fe60af4511ed50a7d7d4b25b',
                        'fue_error' => 'No',
                        'alta_db' => '2023-09-28 12:00:00',
                        'alta_por' => 'brenda',
                        'alta_por_id' => '137',
                        'index' => '',
                        'check' => '1',
                    ],
                ],
            ],
            'chofer_responsable_json' => '',
            'numero_compra_json' => [
                0 => [
                    'lbl' => '11711',
                    'info' => [
                        'id' => '',
                        'fue_error' => 'No',
                        'alta_db' => '2023-09-28 12:08:10',
                        'alta_por' => 'eugenia',
                        'alta_por_id' => '113',
                        'index' => '1',
                    ],
                ],
            ],
            'items' => [
                0 => [
                    'color_label' => 'ROSA PASTEL',
                    'color_id' => '54bf6469e2cc850b11ec1c924d1f0101',
                    'rollos' => '1.00',
                    'quantity' => '25.10',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'averageMal' => '0',
                    'nuevoProducto' => '0',
                ],
            ],
        ];

        $nota_bodega = NotaFormHelper::normalizeNota($nota);

        $this->assertEquals(!array_key_exists('pedido_por_json', $nota_bodega), true);
        $this->assertEquals(!array_key_exists('cliente_label_json', $nota_bodega), true);
        $this->assertEquals(!array_key_exists('chofer_responsable_json', $nota_bodega), true);
        $this->assertEquals(!array_key_exists('numero_compra_json', $nota_bodega), true);


        $this->assertEquals(array_key_exists('producto_bodega_id', $nota_bodega['items'][0]), true);
        $this->assertEquals(array_key_exists('pedido_por', $nota_bodega), true);
        $this->assertEquals(array_key_exists('ayudantes_json', $nota_bodega), true);
        $this->assertEquals(array_key_exists('cliente', $nota_bodega), true);
        $this->assertEquals(array_key_exists('chofer_responsable', $nota_bodega), true);
        $this->assertEquals(array_key_exists('numero_compra', $nota_bodega), true);

    }


    public function testvalidateTrasladoMatch(){
        $trasladoSalida_nota_bodega_id = '0a00270000128e4f11ef1892fdec208Z';
        $trasladoSalida = [
            'nota_bodega_id' => $trasladoSalida_nota_bodega_id,
            'numero' => '1796',
            'bodega_id' => '74867af2fe60ad6b11ec6f24d9e472b6',
            'grupo' => 'COYUYA',
            'entrada_salida' => 'Salida',
            'tipo' => 'Traslado',
            'fecha' => '2024-05-22',
            'label' => '',
            'origen_id' => 'cc483a12801aa9bd11ee150406c64444',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca9fdfac21f',
            'colores' => 'BLANCO',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'total_rolls' => '1.00',
            'total_quantity' => '25.10',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => NULL,
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '0',
            'estado_verificacion' => 'FALTAN VERIFICACIONES',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '',
            'cliente' => '[]',
            'alta_db' => '2024-05-22 18:28:28',
            'alta_por' => 'rony',
            'ultimo_cambio' => '2024-05-22 18:28:28',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '0',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[]',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'ayudantes_json' => '[]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_text' => '',
            'inconsistencias_nivel' => 'warning',
            'num_colores' => '1',
            'numero_compra' => '[]',
            'numero_compra_actual' => '',
            'lock_el' => NULL,
            'super_lock_el' => NULL,
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[]',
            'system_lock' => '0',
            'system_lock_el' => NULL,
            'system_lock_por' => '',
            'modificacion_importante' => 'No',
            'modificacion_importante_el' => NULL,
            'modificacion_importante_por' => '',
            'modificacion_importante_cuantas' => '0',
            'modificacion_importante_text' => NULL,
            'modificacion_importante_json' => '',
            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => NULL,
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => NULL,
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'numero_as_num' => '1796',
            'numero_order_text' => '00000000000000000000000000001796',
            'numero_real' => '1796',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => '',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => NULL,
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2024-05-22 18:28:28',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
            'nota_unidades' => '',
            'verificado_list' => NULL,
            'ano' => '2024',
            'dia' => '143',
            'extras' => '',
            'pueden_corregir_errores' => 'Si',
            'alta_db_idx' => '2024-05-22',
            'cliente_actual_id' => NULL,
            'cliente_actual' => '',
            'lock_por_tiempo_motivo' => '',
            'super_lock_motivo' => NULL,
            'lock_por_tiempo_por' => '',
            'system_lock_motivo' => NULL,
        ];
        $trasladoEntrada_nota_bodega_id = 'cc483a12801aa3c711ef0fc98a5f00eZ';
        $trasladoEntrada = [
            'nota_bodega_id' => $trasladoEntrada_nota_bodega_id,
            'numero' => '60094',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'grupo' => '',
            'entrada_salida' => 'Entrada',
            'tipo' => 'Traslado',
            'fecha' => '2024-05-11',
            'origen_id' => '74867af2fe60ad6b11ec6f25148a346a',
            'paid' => '0',
            'producto_general_id' => '54bf6469e2cc850b11ec1ca805917aea',
            'colores' => 'LIMON, NEGRO, PERLA, ROJO',
            'contra_nota_bodega_id' => '1793',
            'para_quien' => '',
            'total_rolls' => '32.00',
            'total_quantity' => '562.80',
            'remarks' => '',
            'remarks_paid' => '',
            'remarks_internos' => NULL,
            'estado' => '0',
            'lock' => '0',
            'traslado_match_lock' => '0',
            'traslado_match_lock_el' => NULL,
            'lock_por_tiempo' => '0',
            'lock_por_tiempo_el' => '2024-05-21 12:28:03',
            'super_lock' => '0',
            'verificaciones_propias' => '0',
            'verificaciones_otras_bodegas' => '1',
            'estado_verificacion' => 'NO VERIFICADA',
            'numero_solicitud' => NULL,
            'solicitud_carta_porte_id' => NULL,
            'tipo_nota' => '',
            'tipo_nota_json' => '[]',
            'numero_tipo_nota' => '',
            'numero_tipo_nota_json' => '[]',
            'quantity_tipo_nota' => '0.00',
            'quantity_tipo_nota_json' => '[]',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'autorizado' => 'No',
            'autorizado_por' => NULL,
            'autorizado_el' => NULL,
            'recibido' => 'No',
            'recibido_por' => NULL,
            'recibido_el' => NULL,
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'cliente_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente' => '[{"check": "1", "index": "", "nombre": "BODEGAS PROPIAS", "alta_db": "2024-05-11 13:11:57", "alta_por": "rosa", "fue_error": "No", "cliente_id": "11eca7b75d17fc8d81a354bf6469e2cc", "alta_por_id": "134"}]',
            'alta_db' => '2024-05-11 13:06:15',
            'alta_por' => 'rosa',
            'ultimo_cambio' => '2024-05-21 15:18:19',
            'ultimo_cambio_por' => 'rony',
            'iac_edits' => '2',
            'remarks_recibido' => NULL,
            'json_file_attachments_nota_foto' => NULL,
            'json_file_attachments' => NULL,
            'chofer_responsable' => '[{"check": "", "index": "", "nombre": "HUGO ARMANDO GONZÁLEZ ACOSTA", "alta_db": "2024-05-11 13:11:55", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134", "figuratransporte_id": "cc483a12801a8beb11edf0e6825349db"}]',
            'chofer_responsable_id' => 'cc483a12801a8beb11edf0e6825349db',
            'ayudantes' => 'SIN AYUDANTES;',
            'ayudantes_json' => '[{"id": "484d7ee23af386f611ed1fe0112d5cb0", "lbl": "SIN AYUDANTES", "check": "1", "index": "1", "alta_db": "2024-05-11 13:11:58", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134"}]',
            'ultimo_movimiento' => NULL,
            'es_apartado' => 'No',
            'autorizacion_ultimo_movimiento' => 'No',
            'autorizacion_ultimo_movimiento_por' => NULL,
            'autorizacion_ultimo_movimiento_el' => NULL,
            'autorizacion_ultimo_movimiento_cuantos' => '0',
            'autorizacion_ultimo_movimiento_rony' => 'No',
            'autorizacion_ultimo_movimiento_por_rony' => NULL,
            'autorizacion_ultimo_movimiento_el_rony' => NULL,
            'inconsistencias_nivel' => 'danger',
            'num_colores' => '4',
            'numero_compra' => '[{"index": 1, "alta_db": "2024-05-21 15:18:18", "alta_por": "rony", "compra_id": "cc483a12801aa3c711ef0fb2debec700", "fue_error": "No", "numero_compra": 1793}]',
            'numero_compra_actual' => '1793',
            'lock_el' => NULL,
            'super_lock_el' => '2024-05-21 12:36:20',
            'unlock_hasta' => NULL,
            'unsuper_lock_hasta' => NULL,
            'traslado_forza_ok' => 'No',
            'traslado_fuerza_el' => NULL,
            'pedido_por' => '[{"id": "74867af2fe60972811ed28749d2e4db0", "lbl": "IVÁN BRAYAN MATA", "check": "1", "index": "1", "alta_db": "2024-05-11 13:12:00", "alta_por": "rosa", "fue_error": "No", "alta_por_id": "134"}]',
            'system_lock' => '0',
            'system_lock_el' => '2024-05-21 14:09:36',
            'system_lock_por' => 'rony',
            'modificacion_importante' => 'Si',
            'modificacion_importante_el' => '2024-05-21 15:18:19',
            'modificacion_importante_por' => 'rony',
            'modificacion_importante_cuantas' => '2',

            'modificacion_importante_autorizada' => 'No',
            'modificacion_importante_autorizada_el' => '0000-00-00 00:00:00',
            'modificacion_importante_autorizada_por' => '',
            'modificacion_importante_autorizada_cuantas' => '0',
            'modificacion_importante_autorizada_requeridas' => '2',
            'modificacion_importante_autorizada_text' => '',
            'destino_fuerza_ok' => 'No',
            'destino_fuerza_el' => NULL,
            'verificada' => 'No',
            'verificada_el' => NULL,
            'verificada_por' => '',
            'pagare_id' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_de_lock' => NULL,
            'por_sistema' => '0',
            'existencia_snap_shot' => '[]',
            'existencia_snap_shot_html' => NULL,
            'motivo_cambio_importante' => '',
            'reset_lock' => '0',
            'reset_lock_el' => NULL,
            'reset_lock_por' => '',
            'reset_lock_motivo' => NULL,
            'reset_lock_por_nota_ajuste' => NULL,
            'activo' => '1',
            'pedido' => '[]',
            'numero_pi' => '',
            'own_reference' => '',
            'numero_as_num' => '60094',
            'numero_order_text' => '00000000000000000000000000060094',
            'numero_real' => '60094',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'bodega_state' => ' ',
            'lock_por_tiempo_nota_ajuste' => '0',
            'lock_por_tiempo_nota_ajuste_el' => '2024-05-11 13:06:15',
            'lock_por_tiempo_nota_ajuste_por' => '',
            'lock_por_tiempo_nota_ajuste_nota_id' => '',
            'lock_por_tiempo_nota_ajuste_motivo' => '',
            'lock_por_nota_posterior_ajuste' => '0',
            'lock_por_nota_posterior_ajuste_el' => '2024-05-11 13:06:15',
            'lock_por_nota_posterior_ajuste_id' => '',
            'lock_por_nota_posterior_ajuste_motivo' => '',
            'nota_unidades' => 'KG',
            'verificado_list' => NULL,
            'ano' => '2024',
            'dia' => '132',
            'extras' => '',
            'pueden_corregir_errores' => 'No',
            'alta_db_idx' => '2024-05-11',
            'cliente_actual_id' => '11eca7b75d17fc8d81a354bf6469e2cc',
            'cliente_actual' => 'BODEGAS PROPIAS',

            'lock_por_tiempo_por' => 'rony',
        ];

        $icon_1 = "<i id='nbforzatraslado' class='fa-duotone fa-hourglass-start jqga_12em tooltip' title='<b>Sin Contra Nota.</b> Esperando que se capture la contra nota'></i>";
        $response1 = NotaFormHelper::validateTrasladoMatch($trasladoSalida);
        $this->assertEquals($icon_1, $response1, "$trasladoSalida[tipo] Sin Contra Nota.");


        $icon_traslado_match_entrada = "<i id='nbforzatraslado' class='ui-icon ui-icon-check jqga_12em text-success tooltip' style='margin-top:-10px' title='Traslado Match <b>OK</b>'></i>";
        $response2 = NotaFormHelper::validateTrasladoMatch($trasladoEntrada);
        $this->assertEquals($icon_traslado_match_entrada, $response2, "$trasladoEntrada[tipo] match OK icono");

        $trasladoSalida["contra_nota_bodega_id"] = '1223';
        $response3 = NotaFormHelper::validateTrasladoMatch($trasladoSalida);
        $icon_traslado_match_3 = "<i id='nbforzatraslado' class='ui-icon ui-icon-check jqga_12em text-success tooltip' style='margin-top:-10px' title='Traslado Match <b>OK</b>'></i>";

        $this->assertEquals($icon_traslado_match_3, $response3, "$trasladoSalida[tipo] Salida contra_nota_bodega_id empty");
        
        $icon_1 = "<i id='nbforzatraslado' onclick='notaForm.forzaTrasladoMatch(false)' class='ui-icon ui-icon-check jqga_12em bg-warning text-dark pointer tooltip' style='margin-top:-10px' title='<b>Tralado Match FORCE.</b> Click para quitar el forza'></i>";
        $trasladoEntrada['traslado_forza_ok'] = 'Si';
        $response1 = NotaFormHelper::validateTrasladoMatch($trasladoEntrada);
        $this->assertEquals($icon_1, $response1, "$trasladoSalida[tipo] TRASLADO FORZADO");

    }

    public function test_getCambiosNota_recalculaExistencia() {
        $nota_bodega_id= ia_singleread("SELECT nb.nota_bodega_id FROM nota_bodega nb WHERE tipo = 'traslado'  ORDER BY fecha DESC LIMIT 1");
        $nota_bodega  = ia_singleton("SELECT * FROM nota_bodega WHERE nota_bodega_id = '$nota_bodega_id'");
        $nota_bodega['items'] = ia_sqlArrayIndx("SELECT * FROM nota_bodega_items WHERE nota_bodega_id = '$nota_bodega_id'");
        $nota_en_db = $nota_bodega;

        self::assertEmpty(NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db), "Son iguales, sin cambios");

        $nota_en_db['entrada_salida'] = $nota_bodega['entrada_salida'] === 'Entrada' ? 'Salida' : 'Entrada';
        $nota_en_db['tipo'] = $nota_bodega['tipo'] === 'Traslado' ? 'Movimiento' : 'Traslado';
        $nota_en_db['fecha'] = '1999-91-91';
        $nota_en_db['producto_general_id'] = '1999-91-91';
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayHasKey('entrada_salida', $diff, "Diferencia en Entrada Salida");
        self::assertArrayHasKey('tipo', $diff, "Diferencia en tipo");
        self::assertArrayHasKey('fecha', $diff, "Diferencia en Fecha");
        self::assertArrayHasKey('producto_general_id', $diff, "producto_general_id ");

        $nota_en_db['producto_general_id'] = $nota_bodega['producto_general_id'];

        $nota_en_db['items'][0]['color_id'] = '100';
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayHasKey('items', $diff, "Diferencia en items - color");
        $nota_en_db['items'][0]['color_id'] = $nota_bodega['items'][0]['color_id'];


        $nota_en_db['items'][0]['quantity'] = $nota_en_db['items'][0]['quantity'] + 1;
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayHasKey('items', $diff, "Diferencia en items - quantity");
        $nota_en_db['items'][0]['quantity'] = $nota_bodega['items'][0]['quantity'];

        $nota_en_db['items'][0]['rollos'] = $nota_en_db['items'][0]['rollos'] + 1;
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayHasKey('items', $diff, "Diferencia en items - rollos");
        $nota_en_db['items'][0]['rollos'] = $nota_bodega['items'][0]['rollos'];

        $item0 = $nota_bodega['items'][0];
        $item1 = $nota_bodega['items'][0];
        $item[1]['color_id'] = "COLORX";

        $nota_en_db['items'][1] = $nota_bodega['items'][0] = $item0;
        $nota_en_db['items'][0] = $nota_bodega['items'][1] = $item1;
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayNotHasKey('items', $diff, "Colores en desorden sin cambios");

        $nota_en_db['items'][1]['color_id'] = 'color cambio';
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayHasKey('items', $diff, "cambio un color");
        $nota_en_db['items'][1] = $nota_bodega['items'][1];

        $nota_en_db['items'][1]['quantity'] = floatval($nota_en_db['items'][1]['quantity']) -1;
        $nota_bodega['items'][1]['quantity'] = floatval($nota_bodega['items'][1]['quantity']) +1;
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayHasKey('items', $diff, "Suma y resta uno a quantity");
        $nota_en_db['items'][1] = $nota_bodega['items'][1];


        $nota_en_db['items'][1]['rollos'] = floatval($nota_en_db['items'][1]['rollos']) -1;
        $nota_bodega['items'][1]['rollos'] = floatval($nota_bodega['items'][1]['rollos']) +1;
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayHasKey('items', $diff, "Suma y resta uno a rollos");
        $nota_en_db['items'][1] = $nota_bodega['items'][1];

        unset($nota_en_db['items'][1]);
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayHasKey('items', $diff, "Tiene mas colores");
        $nota_en_db['items'][1] = $nota_bodega['items'][1];

        unset($nota_bodega['items'][1]);
        $diff = NotaFormHelper::getCambiosNota($nota_bodega, $nota_en_db);
        self::assertArrayHasKey('items', $diff, "Tiene menos colores");
    }
    
    public function testgetCambiosNota(){
        $nota_salida = [
            'nota_bodega_id' => 'cc483a12801a822011ee5e28ee077ef8',
            'numero' => '40173',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'entrada_salida' => 'Salida',
            'fecha' => '2023-09-28',
            'origen_id' => '',
            'paid' => '0',
            'remarks' => '',
            'remarks_paid' => '',
            'producto_general_id' => '',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'tipo_nota' => 'CASH',
            'numero_tipo_nota' => '17784',
            'quantity_tipo_nota' => '1506.00',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'cliente_id' => '',
            'cliente' => '',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'numero_compra' => '',
            'pedido_por' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_cambio_importante' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'pedido_por_json' => '',
            'ayudantes_json' => '',
            'cliente_label_json' => '',
            'chofer_responsable_json' => '',
            'numero_compra_json' => '',
            'items' => [
                0 => [
                    'color_label' => 'ROSA PASTEL',
                    'color_id' => '54bf6469e2cc850b11ec1c924d1f0101',
                    'rollos' => '1.00',
                    'quantity' => '25.10',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'averageMal' => '0',
                    'nuevoProducto' => '0',
                ],
            ],
        ];
        $nota_entrada = [
            'nota_bodega_id' => 'cc483a12801a822011ee5e28ee077ef8',
            'numero' => '40174',
            'bodega_id' => '74867af2fe60845411ecaa03953dd312',
            'entrada_salida' => 'Entrada',
            'fecha' => '2023-09-28',
            'origen_id' => '',
            'paid' => '0',
            'remarks' => '',
            'remarks_paid' => '',
            'producto_general_id' => '',
            'contra_nota_bodega_id' => '',
            'para_quien' => '',
            'tipo_nota' => 'CASH',
            'numero_tipo_nota' => '17784',
            'quantity_tipo_nota' => '1506.00',
            'documento' => 'nada',
            'cp_figuratransporte_id' => '',
            'cp_autotransporte_id' => '',
            'confirmacion_etiquetado' => 'No',
            'empresa_id_etiquetado' => '',
            'forma_etiquetado' => '',
            'responsable_etiquetado' => '',
            'numero_contenedor' => '',
            'cliente_id' => '',
            'cliente' => '',
            'cp_cliente_id' => '',
            'cliente_cp' => '',
            'chofer_responsable' => '',
            'chofer_responsable_id' => '',
            'ayudantes' => '',
            'numero_compra' => '',
            'pedido_por' => '',
            'numero_pagare' => '',
            'fabrica_id' => '',
            'motivo_cambio_importante' => '',
            'producto_general_calidad' => '',
            'producto_general_calidad_comentario' => '',
            'pedido_por_json' => '',
            'ayudantes_json' => '',
            'cliente_label_json' => '',
            'chofer_responsable_json' => '',
            'numero_compra_json' => '',
            'items' => [
                0 => [
                    'color_label' => 'REY',
                    'color_id' => '54bf6469e2cc850b11ec1c8f0c6fc828',
                    'rollos' => '1.00',
                    'quantity' => '25.10',
                    'rollosNegativo' => '0',
                    'quantityNegativo' => '0',
                    'averageMal' => '0',
                    'nuevoProducto' => '0',
                ],
            ],
        ];

        $cambios = NotaFormHelper::getCambiosNota($nota_salida, $nota_entrada);
        $espera = [
            'numero' => [
                0 => '40173',
                1 => '40174',
            ],
            'entrada_salida' => [
                0 => 'Salida',
                1 => 'Entrada',
            ],
            'items' => [
                0 => [
                    'color_id' => [
                        0 => '54bf6469e2cc850b11ec1c924d1f0101',
                        1 => '54bf6469e2cc850b11ec1c8f0c6fc828',
                    ],
                ],
            ],
        ];

        $this->assertEquals($espera, $cambios, 'testvalidateTrasladoMatch cambios en entrada salida numero y items');

        $cambios_2 = NotaFormHelper::getCambiosNota($nota_salida, $nota_salida);
        $this->assertEquals([], $cambios_2, 'testvalidateTrasladoMatch sin cambios');



    }

    public function testgetLabel(){
        $movimiento = [
            'Movimiento',
            'Traslado',
            'Correccion',
            'Cancelacion',
            'Container',
            'Borrado',
            'Devolucion',
            'NEW'
        ];

        $Salida = [
            0 => '<div id="divSALIDAVertical_v2" class="orientacion_v3 lblgrp ">SALIDA VENTA TIENDA</div>',
            1 => '<div id="divSALIDAVertical_v2" class="orientacion_v3 lblgrp traslado-style">SALIDA TRASLADO</div>',
            2 => '<div id="divSALIDAVertical_v2" class="orientacion_v3 lblgrp ajuste-style">SALIDA AJUSTE</div>',
            3 => '<div id="divSALIDAVertical_v2" class="orientacion_v3 lblgrp ">SALIDA CANCELACION</div>',
            4 => '<div id="divSALIDAVertical_v2" class="orientacion_v3 lblgrp ">SALIDA CONTAINER</div>',
            5 => '<div id="divSALIDAVertical_v2" class="orientacion_v3 lblgrp ">SALIDA BORRADO</div>',
            6 => '<div id="divSALIDAVertical_v2" class="orientacion_v3 lblgrp ">SALIDA DEVOLUCION</div>',
            7 => '<div id="divSALIDAVertical_v2" class="orientacion_v3 lblgrp ">SALIDA NUEVA NOTA</div>',
        ];
        $Entrada = [
            0 => '<div id="divENTRADAVertical_v2" class="orientacion_v3 lblgrp ">ENTRADA VENTA TIENDA</div>',
            1 => '<div id="divENTRADAVertical_v2" class="orientacion_v3 lblgrp traslado-style">ENTRADA TRASLADO</div>',
            2 => '<div id="divENTRADAVertical_v2" class="orientacion_v3 lblgrp ajuste-style">ENTRADA AJUSTE</div>',
            3 => '<div id="divENTRADAVertical_v2" class="orientacion_v3 lblgrp ">ENTRADA CANCELACION</div>',
            4 => '<div id="divENTRADAVertical_v2" class="orientacion_v3 lblgrp ">ENTRADA CONTAINER</div>',
            5 => '<div id="divENTRADAVertical_v2" class="orientacion_v3 lblgrp ">ENTRADA BORRADO</div>',
            6 => '<div id="divENTRADAVertical_v2" class="orientacion_v3 lblgrp ">ENTRADA DEVOLUCION</div>',
            7 => '<div id="divENTRADAVertical_v2" class="orientacion_v3 lblgrp ">ENTRADA NUEVA NOTA</div>',
        ];

        $response_salida = [];
        $response_entrada = [];
        foreach($movimiento as $tipo ){
            $response = NotaFormHelper::getLabel($tipo, 'Salida');
            $response_salida[] = $response;
            $response_2 = NotaFormHelper::getLabel($tipo, 'Entrada');
            $response_entrada[] = $response_2;

        }

        $this->assertEquals($response_salida, $Salida, 'testgetLabel - Salida');
        $this->assertEquals($response_entrada, $Entrada, 'testgetLabel - Entrada');

    }



}