<?php

/** @noinspection SqlResolve */
/** @noinspection SqlTypeInspection */
/** @noinspection SqlAddNotNullColumnInspection */
/** @noinspection SqlAmbiguousColumnInspection */
/** @noinspection SqlAutoIncrementDuplicateInspection */
/** @noinspection SqlCheckUsingColumnsInspection */
/** @noinspection SqlConstantConditionInspection */
/** @noinspection SqlDerivedTableAliasInspection */
/** @noinspection SqlDialectInspection */
/** @noinspection SqlDropIndexedColumnInspection */
/** @noinspection SqlIdentifierInspection */
/** @noinspection SqlInsertValuesInspection */
/** @noinspection SqlNoDataSourceInspection */
/** @noinspection SqlNullComparisonInspection */
/** @noinspection SqlResolveInspection */
/** @noinspection SqlShouldBeInGroupByInspection */
/** @noinspection SqlTypeInspection */
/** @noinspection SqlWithoutWhere */




use Iac\inc\sql\IacMysqli;
use Iac\inc\sql\IacSqlException;
use PHPUnit\Framework\TestCase;





/**
 * @group needMysqlDb
 *
 * IaMysqliTest
 *
 * @coversDefaultClass Iac\inc\sql\IacMysqli
 *
 *
 * @covers Iac\inc\sql\IacMysqli
 * @covers Iac\inc\sql\IacMysqli::__construct
 * @covers Iac\inc\sql\IacMysqli::__destruct
 * @covers Iac\inc\sql\IacMysqli::connectionInfo_set
 * @covers Iac\inc\sql\IacMysqli::connect
 * @covers Iac\inc\sql\IacMysqli::connect_real
 * @covers Iac\inc\sql\IacMysqli::connect_toString
 * @covers Iac\inc\sql\IacMysqli::log_sql_error
 * @covers Iac\inc\sql\IacMysqli::log_trace
 * @covers Iac\inc\sql\IacMysqli::close
 * @covers Iac\inc\sql\IacMysqli::throwSqlException_get
 * @covers Iac\inc\sql\IacMysqli::retries2string
 * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
 *
 * @covers Iac\inc\Sql\IacSqlException::__construct
 *
 *
 * requires extension mysqli
 */
class IacMysqliTest extends TestCase {

    static array $credentials;

    /**
     * @throws ReflectionException
     */
    protected static function getMethod($class, $name): ReflectionMethod
    {
        $class = new ReflectionClass( get_class($class) );
        $method = $class->getMethod($name);
        $method->setAccessible(true);
        return $method;
    }

    /**
     * IaMysqliTest::setUpBeforeClass()
     * Get db credentials and setup test tables
     *
     *
     * @return void
     * @throws Iac\inc\Sql\IacSqlException
     */
    public static function setUpBeforeClass():void {
        ia_query("CREATE DATABASE IF NOT EXISTS iamysqltestdb");
        $credentials =  array();
        foreach(
            array('host'=>'mysqli.default_host',
                'username'=>'mysqli.default_user',
                'passwd'=>'mysqli.default_pw',
                'dbname'=>'',
                'port'=>'mysqli.default_port',
                'socket'=>'mysqli.default_socket')
                as $key=>$ini)
        {
            $indx = 'IaMysqli_'.strtoupper($key);
            if(isset($_ENV[$indx]) && !empty($_ENV[$indx]))
                $credentials[$key] = $_ENV[$indx];
            else
                $credentials[$key] = ini_get($ini);
        }
        self::$credentials = $credentials;

        self::$credentials = array('host'=>null,
            'username'=>'root',
            'passwd'=>'986532',
            'dbname'=>'iamysqltestdb',
            'port'=>null,
            'socket'=>null);

        $db = new IacMysqli(
            self::$credentials['host'],
            self::$credentials['username'],
            self::$credentials['passwd'],
            self::$credentials['dbname'],
            self::$credentials['port']
            ,self::$credentials['socket'])
        ;
        if(!$db->connect() ) {
            fwrite(STDOUT, __METHOD__ .": connection to db failed!, check phpunit.xml for db credentials!" . "\r\n");
        }

        //fwrite(STDOUT, __METHOD__ .": Setting up db for tests\r\n");
        $sql = array(
            "DROP TABLE IF EXISTS test_IaMysqli_a",

            "CREATE TABLE test_IaMysqli_a(
                id int unsigned not null primary key auto_increment,
                title enum('Mr','Ms','Mss','Esq') NOT NULL DEFAULT 'Esq',
                name varchar(32) NOT NULL DEFAULT '',
                last_name char(32) NOT NULL DEFAULT '',
                profesion varchar(16) NULL,
                social_set set('FB','G+','Linked In') NULL,
                dob DATE NOT NULL COMMENT 'Required',
                weight tinyint unsigned not null default '60' COMMENT 'kilos',
                weight_at DATETIME NULL,
                height smallint not null default '0' COMMENT 'cm',

                KEY name(name),
                UNIQUE KEY (name,last_name,title)
            ) ENGINE=innodb DEFAULT CHARSET=utf8",

            "INSERT INTO test_IaMysqli_a(id,title,name,last_name,profesion,social_set,dob,weight,weight_at,height) VALUES(1,'Ms','Dana','Smith','Web Designer',5,'2001-03-05',55,'2015-01-02 03:05:06',175)",

            "INSERT INTO test_IaMysqli_a(id,title,name,last_name,profesion,social_set,dob,weight,weight_at,height) VALUES(2,'Mr','Paul','Jomes','Web Tester','FB','2002-04-06',55,'2011-03-04 05:06:07',175)",

            "INSERT INTO test_IaMysqli_a(id,title,name,last_name,profesion,social_set,dob,weight,weight_at,height) VALUES(3,'Mss','Rachel','James','Web User',3,'2002-06-08',55,'2011-08-09 10:11:12',175)",

            "INSERT INTO test_IaMysqli_a(id,title,name,last_name,profesion,social_set,dob,weight,weight_at,height) VALUES(4,'Mss','Mary','Picard','Test transaction',3,'2002-06-07',95,'2011-04-05 06:07:08',115)",

             "DROP TABLE IF EXISTS test_IaMysqli_pv",
            "CREATE  TABLE test_IaMysqli_pv(
                id int unsigned not null,
                property_id smallint unsigned not null,
                property varchar(16),
                PRIMARY KEY property(id,property_id)
            ) ENGINE=innodb DEFAULT CHARSET=utf8",

            "INSERT INTO test_IaMysqli_pv VALUES (1,1,'one'),(1,2,'two'),(1,3,'three'),(2,4,'four')"
        );
        $db->queryArray($sql);
        $err = $db->errorLog_get();
        if(!empty($err)) {
            fwrite(STDOUT, __METHOD__ .": FAILED setting up db for tests:\r\n");
            print_r($err);
        }

    }

    public function dbCreateInstance():IacMysqli {
        return new IacMysqli(self::$credentials['host'],self::$credentials['username'],self::$credentials['passwd'],self::$credentials['dbname'],self::$credentials['port'],self::$credentials['socket']);
    }

    /**
     * test_exception_options_connect
     *
     * @test
     *
     * @testdox Test connect Options Exception
     *
     * @covers Iac\inc\sql\IacMysqli::connect
     *
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     */
    public function test_exception_options_connect() {
        $db = $this->dbCreateInstance();
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");

        //Test invalid mysqli_options
        $db->mysqli_options[] = array(1,9);

        $db->connect();

    }

    /**
     * test_exception_connect_real
     * @test
     *
     * @testdox Test connect_real Exception
     *
     *
     * @covers Iac\inc\sql\IacMysqli::connect_real
     *
     * @covers Iac\inc\sql\IacMysqli::connect
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     */
    public function test_exception_connect_real() {
        $db = $this->dbCreateInstance();
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");
        $db->connInfo[0]['username']="invalid\tnotused";
        $db->connInfo[0]['passwd']='invalidnotgood';
        $db->connect();
    }

    /**
     * test_connect()
     *
     *
     * @covers Iac\inc\sql\IacMysqli::__construct
     * @covers Iac\inc\sql\IacMysqli::connectionInfo_set
     * @covers Iac\inc\sql\IacMysqli::connect
     * @covers Iac\inc\sql\IacMysqli::connect_real
     * @covers Iac\inc\sql\IacMysqli::close
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_connect() {
        $db = $this->dbCreateInstance();

        //Test first credentials fail, second credentials connect
        $cred = $db->connInfo[0];
        $db->connInfo[] = $cred;
        $db->connInfo[0]['username']="invalid\tnotused";
        $db->connInfo[0]['passwd']='invalidnotgood';
        $this->assertTrue($db->connect(),"Second credentials Connection");
        $this->assertTrue($db->close(),"Close connection");

        //Test all credentials fail
        $db->connInfo[1]['username']="invalid\tnotused";
        $db->connInfo[1]['passwd']='invalidnotgood';
        $thrown = false;
        try {
            $db->connect();
        } catch(Exception) {
            $thrown = true;
        }
        $this->assertTrue($thrown,"DB connection should have been refused");

        //Test invalid mysqli_options
        $db->mysqli_options[] = array(1,9);
        $this->assertNotTrue($db->connect(),"Invalid mysqli_options");

        $db->close();
        unset($db);
    }

    /**
     * test_connect_toString()
     *
     *
     * @covers Iac\inc\sql\IacMysqli::connect_toString
     * @covers Iac\inc\sql\IacMysqli::connectionInfo_set
     */
    public function test_connect_toString() {

        $db = new IacMysqli();
        $this->assertEquals('Not connected', $db->connect_toString(null));
        $db->connectionInfo_set('host','usr','pwd','dbname','port','socket');
        $this->assertEquals("host:port/socket dbname as usr", $db->connect_toString($db->connInfo[1]));
       // $this->assertEquals("host:port/socket dbname as usr", $db->connect_toString() );
    }

    /**
     * test_reconnect()
     *
     * testdox: reconnect
     *
     * @covers Iac\inc\sql\IacMysqli::reconnect
     * @covers Iac\inc\sql\IacMysqli::__construct
     * @covers Iac\inc\sql\IacMysqli::connectionInfo_set
     * @covers Iac\inc\sql\IacMysqli::connect
     * @covers Iac\inc\sql\IacMysqli::connect_real
     * @covers Iac\inc\sql\IacMysqli::rollback
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::commit
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::close
     *
     * @covers Iac\inc\sql\IacMysqli::begins_get
     * @covers Iac\inc\sql\IacMysqli::begins_get
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::log_sql_error
     * @covers Iac\inc\sql\IacMysqli::connect_toString
     * @covers Iac\inc\sql\IacMysqli::log_trace
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     * @throws IacSqlException
     */
    public function test_reconnect() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");

        // BEGIN & AUTOCOMMIT
            $thread_id = $db->mysqli->thread_id;
            $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertTrue($db->begin(), "Begin transaction");
        $weight_pre = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-1);
        $this->assertTrue($db->query("UPDATE test_IaMysqli_a SET weight=weight+1 WHERE id=1"),"Query update");
        $this->assertTrue($db->rollback(),"Rollback done");
        $weight_post = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-99);
        $this->assertEquals($weight_pre, $weight_post, "Check rollback done");
        $this->assertEquals(0, $db->begins_get(), "begins count in 0");

        // QUERY
        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertEquals("1", $db->single_read("SELECT id FROM test_IaMysqli_a WHERE id=1",-99), "Check execute reconnects");

        // CLOSE
        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertTrue($db->close(), "Close while server went away");


        unset($db);
    }



    /**
     * @covers Iac\inc\sql\IacMysqli::retries2string
     * @dataProvider provider_retries2string
     */
    public function testRetries2string($num, $desdeUno, $expected) {
        $db = $this->dbCreateInstance();;
        $this->assertEquals('Not connected', $db->connect_toString(null));
        $method = $this->getMethod($db,'retries2string');
        $this->assertEquals($expected, $method->invokeArgs($db, [$num, $desdeUno]) );
    }
    public function provider_retries2string():array {
        return [
           'cero' => [0, false, 'primera'],
           'cero  string' => ['0', false, 'primera'],
           'uno' => [1, false, 'segunda'],
           'dos' => [2, false, 'tercera'],
           'tres, false' => [3, true, 'tres'],
           'tres, true' => [3, false, 'ultima'],
           'default' => [4, false, 4],
        ];
    }

    /**
     * test_log_trace()
     *
     * testdox: log log_trace and trace_get
     *
     * @covers Iac\inc\sql\IacMysqli::log_trace
     * @covers Iac\inc\sql\IacMysqli::trace_get
     *
     */
    public function test_log_trace() {
        $db = $this->dbCreateInstance();
        $db->traceOn =false;
        $db->log_trace("Not traced traceOn is off");
        $this->assertSame( array("sql trace is off, turn it on with \$sql->traceOn=true"), $db->trace_get(), "get log trace off");
        $db->traceOn = true;
        $db->log_trace("trace, no retries");
        $db->log_trace("trace, with retries",1);
        $this->assertEquals(array("trace, no retries","trace, with retries -- retry 1"), $db->trace_get());
    }


    /**
     *  test__destruct
     *
     * @covers Iac\inc\sql\IacMysqli::__destruct
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test__destruct() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->throwSqlException_set(true);
        unset($db);
        $driver = new mysqli_driver();
        $this->assertEquals(MYSQLI_REPORT_OFF, $driver->report_mode, "Resets mysqli driver report mode to off");
    }

    /**
     * test_exception_commit()
     *
     * @test
     *
     * @testdox Test commit exception
     *
     * @covers Iac\inc\sql\IacMysqli::commit
     *
     *
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     *
     * @covers Iac\inc\sql\IacMysqli::begins_get
     * @covers Iac\inc\sql\IacMysqli::reconnect
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     *
     * @throws IacSqlException
     */
    public function test_exception_commit() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");

        $preAutocommit = $db->single_read("SELECT @@autocommit");
        $this->assertTrue($db->begin(),"Begin transaction");
        $this->assertEquals(1,$db->begins_get(),"begins count in 1");
        $height_pre = $db->single_read("SELECT height FROM test_IaMysqli_a WHERE id=1",-2);
        $this->assertTrue($db->query("UPDATE test_IaMysqli_a SET height=height+1 WHERE id=1"),"Update query failed");
        $this->assertTrue($db->commit(),"Commit Failed");
        $height_post = $db->single_read("SELECT height FROM test_IaMysqli_a WHERE id=1",-99);
        $this->assertTrue((int)$height_post > (int)$height_pre, "Commit didn't store updated values");
        $this->assertEquals(0,$db->begins_get(),"begins count in 0");
        $this->assertEquals($preAutocommit,$db->single_read("SELECT @@autocommit"),"Autocommit set to default autocommit");

        // COMMIT
        $this->assertTrue($db->begin(), "Begin transaction");
        //$weightComLost = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-2);
        $this->assertTrue($db->query("UPDATE test_IaMysqli_a SET weight=weight+1 WHERE id=1"), "Query update");
            // kill the thread
            $thread_id = $db->mysqli->thread_id;
            $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertNotTrue($db->commit(), "commit on lost connection");


    }

    /**
     * test_commit()
     *
     * @covers Iac\inc\sql\IacMysqli::commit
     *
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::retries2string
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     *
     * @covers Iac\inc\sql\IacMysqli::begins_get
     * @covers Iac\inc\sql\IacMysqli::reconnect
     *
     * @throws IacSqlException
     */
    public function test_commit() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");

        $preAutocommit = $db->single_read("SELECT @@autocommit");
        $this->assertTrue($db->begin(),"Begin transaction failed");
        $this->assertEquals(1,$db->begins_get(),"begins count in 1");
        $height_pre = $db->single_read("SELECT height FROM test_IaMysqli_a WHERE id=1",-2);
        $this->assertTrue($db->query("UPDATE test_IaMysqli_a SET height=height+1 WHERE id=1"), "Update query failed");
        $this->assertTrue($db->commit(),"Commit failed");
        $height_post = $db->single_read("SELECT height FROM test_IaMysqli_a WHERE id=1",-99);
        $this->assertTrue((int)$height_post > (int)$height_pre, "Commit didn't store update values");
        $this->assertEquals(0,$db->begins_get(),"begins count in 0");
        $this->assertEquals($preAutocommit,$db->single_read("SELECT @@autocommit"),"Autocommit set to default autocommit");

        // COMMIT
        $this->assertTrue($db->begin(), "Begin transaction");
        $weightComLost = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-2);
        $this->assertTrue($db->query("UPDATE test_IaMysqli_a SET weight=weight+1 WHERE id=1"), "Query update");
            // kill the thread
            $thread_id = $db->mysqli->thread_id;
            $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertNotTrue($db->commit(), "commit on lost connection");
        $this->assertEquals($weightComLost,  $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1"), "commit lost the transaction, causes rollback");


        $db->close();
        unset($db);
    }

    /**
     * test_exception_rollback()
     *
     * @test
     *
     * @testdox Test Rollback Excpetion
     *
     * @covers Iac\inc\sql\IacMysqli::rollback
     *
     *
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     *
     * @covers Iac\inc\sql\IacMysqli::begins_get
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     * @covers Iac\inc\sql\IacMysqli::reconnect
     * @throws IacSqlException
     */
    public function test_exception_rollback() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");

        $this->assertTrue($db->begin(), "Begin transaction test disconnect before rollback");
        $weight_pre = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-1);
        $this->assertTrue($db->query("UPDATE test_IaMysqli_a SET weight=weight+1 WHERE id=1"), "Query update");
            $thread_id = $db->mysqli->thread_id;
            $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        //TODO: que debe ser rollback con error por disconnect?
        $this->assertNotTrue($db->rollback(), "Automatic rollback was disconnected before rollback!");
        $weight_post = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-99);
        $this->assertEquals($weight_post, $weight_pre,"Check rollback done");
        $this->assertEquals(0, $db->begins_get(),"begins count in 0");
    }

    /**
     * test_rollback()
     *
     * @covers Iac\inc\sql\IacMysqli::rollback
     *
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     *
     * @covers Iac\inc\sql\IacMysqli::begins_get
     * @covers Iac\inc\sql\IacMysqli::reconnect
     * @throws IacSqlException
     */
    public function test_rollback() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");

        $preAutocommit = $db->single_read("SELECT @@autocommit");
        $this->assertTrue($db->begin(), "Begin transaction failed");
        $weight_pre = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-2);
        $this->assertTrue($db->query("UPDATE test_IaMysqli_a SET weight=weight+1 WHERE id=1"), "Query update failed");
        $this->assertTrue($db->rollback(), "Rollback failed");
        $weight_post = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-99);
        $this->assertEquals($weight_pre,$weight_post, "Check rollback done");
        $this->assertEquals(0,$db->begins_get(),"begins count in 0");
        $this->assertEquals($preAutocommit,$db->single_read("SELECT @@autocommit"),"Autocommit set to default autocommit");


        $this->assertTrue($db->begin(), "Begin transaction test disconnect before rollback");
        $weight_pre = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-1);
        $this->assertTrue($db->query("UPDATE test_IaMysqli_a SET weight=weight+1 WHERE id=1"), "Query update");
            $thread_id = $db->mysqli->thread_id;
            $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        //TODO: que debe ser rollback con error por disconnect?
        $this->assertNotTrue($db->rollback(), "Automatic rollback was disconnected before rollback!");
        $weight_post = $db->single_read("SELECT weight FROM test_IaMysqli_a WHERE id=1",-99);
        $this->assertEquals($weight_post, $weight_pre,"Check rollback done");
        $this->assertEquals(0, $db->begins_get(),"begins count in 0");

        $db->close();
        unset($db);
    }


    /**
     * autocommitToDefault
     *
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     *
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::reconnect
     *
     * @throws ReflectionException
     * @throws IacSqlException
     */
    public function test_autocommitToDefault() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");


        $currentAutocommit = $db->single_read("SELECT @@autocommit");
        $this->assertTrue($currentAutocommit=="1" || $currentAutocommit == "0", "Failed reading current autocommit");
        $current = $currentAutocommit == "1";
        $this->assertTrue($db->autocommit(!$current), "SQL Error setting autocommit()");

        $method = $this->getMethod($db,'autocommitToDefault');
        $this->assertTrue($method->invokeArgs($db,array()), "SQL Error setting autocommitToDefault()");
        //$autocommit = $db->single_read("SELECT @@autocommit");
        $current = $currentAutocommit == "1";
        $this->assertEquals($db->autocommitDefault,$current,"Wrong default autocommit");

        $this->assertTrue( $db->autocommit(!$current), "SQL Error setting autocommit()");
        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertTrue($method->invokeArgs($db,array()), "SQL Error setting autocommitToDefault() after disconnect");
        //$autocommit = $db->single_read("SELECT @@autocommit");
        $current = $currentAutocommit == "1";
        $this->assertEquals($current,$db->autocommitDefault,"Wrong default autocommit");

        $db->retries=0;
        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertNotTrue($method->invokeArgs($db,array()), "No reconnect should fail when disconnected");

    }

    /**
     * test_exception_autocommit
     *
     * @covers Iac\inc\sql\IacMysqli::autocommit
     *
     *
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::reconnect
     * @covers Iac\inc\sql\IacMysqli::connect_real
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     * @throws IacSqlException
     */
    public function test_exception_autocommit()  {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");

        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $db->autocommit(false);
        $this->assertEquals("0",$db->single_read("SELECT @@autocommit"), "Set autocommit with force reconnect");

        $db->reconnect();
        $db->retries = 0;
        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $db->autocommit(false);
    }

    /**
     * test_autocommit
     *
     * @covers Iac\inc\sql\IacMysqli::autocommit
     *
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::reconnect
     * @covers Iac\inc\sql\IacMysqli::connect_real
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     * @throws IacSqlException
     */
    public function test_autocommit()  {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");


        $db->autocommit(false);
        $this->assertEquals("0",$db->single_read("SELECT @@autocommit"), "Set autocommit off");

        $db->autocommit(true);
        $this->assertEquals("1",$db->single_read("SELECT @@autocommit"), "Set autocommit on");

        // test reconnect
        $db->reconnect();
        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $db->autocommit(true);
        $this->assertEquals("1",$db->single_read("SELECT @@autocommit"), "Set autocommit on");

        // test no retries
        $db->reconnect();
        $db->retries=0;
        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertNotTrue($db->autocommit(false), "No reconnect should fail when disconnected, no error raised");

        // test no retries, no reconnect
        $db->reconnect();
        $reflectionClass = new ReflectionClass('Iac\inc\sql\IacMysqli');
        $reflectionProperty = $reflectionClass->getProperty('reconnectOnErrors');
        $reflectionProperty->setAccessible(true);
        $reflectionProperty->setValue($db, array());

        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertNotTrue($db->autocommit(false), "No reconnect should fail when disconnected, no error raised");

    }


    /**
     * test_transaction()
     *
     * @testdox: queryArray & transaction
     *
     * @covers  Iac\inc\sql\IacMysqli::transaction
     * @covers  Iac\inc\sql\IacMysqli::queryArray
     * @covers  Iac\inc\sql\IacMysqli::runSql
     * @covers  Iac\inc\sql\IacMysqli::begin
     * @covers  Iac\inc\sql\IacMysqli::commit
     * @covers  Iac\inc\sql\IacMysqli::rollback
     * @covers  Iac\inc\sql\IacMysqli::autocommit
     * @covers  Iac\inc\sql\IacMysqli::query
     * @covers  Iac\inc\sql\IacMysqli::trace_get
     * @covers  Iac\inc\sql\IacMysqli::errorLog_get
     *
     * @covers  Iac\inc\sql\IacMysqli::single_read
     * @covers  Iac\inc\sql\IacMysqli::singleton
     * @covers  Iac\inc\sql\IacMysqli::autocommitToDefault
     * @covers  Iac\inc\sql\IacMysqli::strit
     * @throws IacSqlException
     */
    public function test_transaction() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->traceOn = true;

     // normal tranaction
        $prevVal = $db->singleton("SELECT height,weight FROM test_IaMysqli_a WHERE id=4","NOT FOUND");
        $this->assertEquals(
            true,
            $db->transaction( array("UPDATE test_IaMysqli_a SET height=height+1 WHERE id=4","UPDATE test_IaMysqli_a SET weight=weight+1 WHERE id=4") ),
            "transaction executed"
        );
        $postVal = $db->singleton("SELECT height,weight FROM test_IaMysqli_a WHERE id=4","NOT FOUND");
        $this->assertEquals(
            true,
            ((int)$postVal['height'] > (int)$prevVal['height']) && ((int)$postVal['weight'] > (int)$prevVal['weight']),
            "Queries executed"
        );

    // error in trnsaction, rollbacks the transaction
        $this->assertEquals(
            false,
            $db->transaction(
                array(
                    "UPDATE test_IaMysqli_a SET height=height+1 WHERE id=4",
                    "UPDATE test_IaMysqli_a SET weight=weight+1 WHERE id=4",
                    "UPDATE TABLE_UNKOWN SET weight=weight+1 WHERE id=4"
                )
            ),
            "transaction error in statement"
        );
        $finalVal = $db->singleton("SELECT height,weight FROM test_IaMysqli_a WHERE id=4","NOT FOUND");
        $this->assertEquals(
            true,
            ((int)$postVal['height'] == (int)$finalVal['height']) && ((int)$postVal['weight'] == (int)$finalVal['weight']),
            "Queries must have been rolled back due to error"
        );

        $sqlArray = [
            "DELETE FROM test_IaMysqli_a WHERE name = 'soySpouse'",
            'SPOUSE' => "INSERT INTO test_IaMysqli_a( name, dob) VALUES( 'soySpouse', NOW())",
            /** @lang text*/ "INSERT INTO  /* id de spouse */ test_IaMysqli_a( name, dob) VALUES({{SPOUSE}}, NOW())",
        ];
        $ok = $db->queryArray($sqlArray, true);

        $this->assertTrue($ok, 'substitute quoted executed ok');
        $sqlTestArray =
            "SELECT COUNT(*) as MustBeOne 
            FROM test_IaMysqli_a WHERE name IN (SELECT id FROM test_IaMysqli_a WHERE name='soySpouse')
            ";
        $this->assertEquals("1", $db->single_read($sqlTestArray));

        $sqlArray = [
            "DELETE FROM test_IaMysqli_a WHERE name = 'soySpouse'",
            'SPOUSE' => "INSERT INTO test_IaMysqli_a( name, dob, profesion) VALUES( 'soySpouse', NOW(), 'qa')",
            "INSERT INTO /* id de spouse */ test_IaMysqli_a( name, dob) VALUES( '[[SPOUSE]]', NOW())",
        ];
        $ok = $db->queryArray($sqlArray, true);

        $this->assertTrue($ok, 'substitute quoted executed ok');
        $sqlTestArray =
            "SELECT COUNT(*) as MustBeOne 
            FROM test_IaMysqli_a WHERE name IN (SELECT id FROM test_IaMysqli_a WHERE name='soySpouse')
            ";
        $this->assertEquals("1", $db->single_read($sqlTestArray));

    // Substition from a select
         $this->assertEquals(
            $db->transaction( array(
                'profesion'=>"SELECT profesion FROM test_IaMysqli_a WHERE id=1",
                    /** @lang text*/   "UPDATE test_IaMysqli_a SET profesion={{profesion}} WHERE name='soySpouse'"
                )
            ),
            true,
            "transaction with select substitution executed"
        );

        $this->assertEquals(
            "Web Designer",
            $db->single_read("SELECT profesion FROM test_IaMysqli_a WHERE name='soySpouse'","NOT FOUND"),
            "select substitution, checked"
        );

        //check logs for no retries!
        $noRetries=true;
        $trace = $db->trace_get();
        foreach($trace as $t)
            if(stripos($t,'segunda') !== false) {
                $noRetries = false;
                break;
            }
        $errLog = $db->errorLog_get();
        foreach($errLog as $t)
            if(stripos($t['sql'],'segunda') !== false) {
                $noRetries = false;
                break;
            }
        $this->assertTrue($noRetries,"Retries logged in non retry statement");
        $db->close();
        unset($db);
    }


    /**
     * test_transaction()
     *
     * @testdox: transaction with exception
     *
     *
     * @covers Iac\inc\sql\IacMysqli::transaction
     * @covers Iac\inc\sql\IacMysqli::begin
     * @covers Iac\inc\sql\IacMysqli::commit
     * @covers Iac\inc\sql\IacMysqli::rollback
     * @covers Iac\inc\sql\IacMysqli::autocommit
     * @covers Iac\inc\sql\IacMysqli::queryArray
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::trace_get
     * @covers Iac\inc\sql\IacMysqli::errorLog_get
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacMysqli::autocommitToDefault
     * @covers Iac\inc\sql\IacMysqli::strit
     * @throws IacSqlException
     */
    function test_transaction_exception() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        //$driver = new mysqli_driver();
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");
    // error in trnsaction, rollbacks the transaction
        $postVal = $db->singleton("SELECT height,weight FROM test_IaMysqli_a WHERE id=4","NOT FOUND");
        $this->assertEquals(
            false,
            $db->transaction(
                array(
                    "UPDATE test_IaMysqli_a SET height=height+1 WHERE id=4",
                    "UPDATE test_IaMysqli_a SET weight=weight+1 WHERE id=4",
                    "UPDATE TABLE_UNKOWN SET weight=weight+1 WHERE id=4"
                )
            ),

            "transaction error in statement"
        );
        $finalVal = $db->singleton("SELECT height,weight FROM test_IaMysqli_a WHERE id=4","NOT FOUND");
        $this->assertEquals(
            true,
            ((int)$postVal['height'] == (int)$finalVal['height']) && ((int)$postVal['weight'] == (int)$finalVal['weight']),
            "Queries must have been rolled back due to error"
        );

    }

    /**
     * test_query()
     *
     * @covers Iac\inc\sql\IacMysqli::query
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::prepare
     * @throws IacSqlException
     */
    public function test_query() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");

        $height_pre = $db->single_read("SELECT height FROM test_IaMysqli_a WHERE id=2",-2);
        $this->assertTrue($db->query("UPDATE test_IaMysqli_a SET height=height+1 WHERE id=2"), "Update query failed");
        $this->assertEquals(1,$db->affected_rows,"Affected rows set");
        $height_post = $db->single_read("SELECT height FROM test_IaMysqli_a WHERE id=2",-99);
        $this->assertTrue((int)$height_post > (int)$height_pre, "Update query failed");

        // TEST Error in query
        $this->assertNotTrue($db->query("UPDATE test_IaMysqli_a SET NotExists=height+1 WHERE id=2"),"Query fails");

        $stmt = $db->prepare('CREATE  TABLE test_IaMysqli_a(a int)');
        $this->assertNotTrue($db->query($stmt), "Prepared statement fails");
        $stmt->close();

    }

    /**
     * test_single_prepare()
     *
     * @testdox: prepared statemnts: prepare, execute
     *
     * @covers Iac\inc\sql\IacMysqli::prepare
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @throws IacSqlException
     */
    public function test_prepare() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");

        $sql = "SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= ? ORDER BY id";
        $stmt = $db->prepare($sql);
        $this->assertEquals($sql,$db->preparedLast,"Stores last prepared statement");

        $id = 3;
        $stmt->bind_param('i',$id);
        $this->assertEquals(
            1,
            $db->single_read($stmt,'NOT FOUND'),

            "single_read: prepared statement"
        );

        $db->preparedLast='';  //for code coverage
        $id = -3;
        $stmt->bind_param('i',$id);
        $this->assertEquals(
            'NOT FOUND',
            $db->single_read($stmt,'NOT FOUND'),

            "single_read: prepared statement, not found"
        );

        $stmt->close();
        unset($stmt);

        $sql = "SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= ? ORDER BY id";
        $stmt3 = $db->prepare($sql);
        $id = 1;
        $stmt3->bind_param('i',$id);
        $this->assertEquals(
            1,
            $db->single_read($stmt3,'NOT FOUND'),

            "single_read: prepared statement"
        );
        $stmt3->close();
        unset($stmt3);

        $stmt2 = $db->prepare("SELECT ErrorColumn FROM test_IaMysqli_a WHERE id <= ? ORDER BY id");
        $this->assertEquals(
            false,
            $stmt2,

            "single_read: prepared statement, error"
        );
        if($stmt2 != false)
            $stmt2->close();
        unset($stmt2);

        $db->close();
        unset($db);
    }

    /**
     * test_single_read()
     *
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::runSql
     *
     * @covers Iac\inc\sql\IacMysqli::reconnect
     * @throws IacSqlException
     */
    public function test_single_read() {

        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertEquals(
            1,
            $db->single_read("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id"),

            "single_read: Sql select return value"
        );
        $this->assertEquals(
            "NOT FOUND",
            $db->single_read("SELECT * FROM test_IaMysqli_a WHERE id = -3", "NOT FOUND"),

            "single_read: Sql Not Found"
        );
        $this->assertEquals(
            false,
            $db->single_read("SELECT * FROM test_IaMysqli_axxx WHERE id=xk", null),

            "single_read: Sql Error"
        );

        // test with reconnect
        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");
        $this->assertEquals(
            1,
            $db->single_read("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id"),

            "single_read: Sql select return value forcing reconnect"
        );

        $db->close();
        unset($db);
    }

    /**
     * @covers Iac\inc\sql\IacMysqli::runSqlPropertyValue
     * @covers Iac\inc\sql\IacMysqli::selectArrayKeyPropertyValue
     *
     * @covers Iac\inc\sql\IacMysqli::selectArrayKey
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     * @covers Iac\inc\Sql\IacSqlException::getSqlStatement
     * @throws IacSqlException
     */
    public function test_exception_selectArrayKeyPropertyValue() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");

        $db->selectArrayKeyPropertyValue(
            array(
                "SELECT id,property_id,property test_IaMysqli_pv",
                "SELECT unkownColumn FROM test_IaMysqli_pv"
            )
            ,$arrayKey
        );

    }

    /**
     * @covers Iac\inc\sql\IacMysqli::runSqlPropertyValue
     * @covers Iac\inc\sql\IacMysqli::selectArrayKeyPropertyValue
     * @covers Iac\inc\sql\IacMysqli::runSql
     *
     * @covers Iac\inc\sql\IacMysqli::prepare
     * @noinspection PhpUnhandledExceptionInspection
     */
    public function test_selectArrayKeyPropertyValue() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");

        $arrayKey = [];
        $this->assertTrue($db->selectArrayKeyPropertyValue("SELECT profesion,id,name,last_name FROM test_IaMysqli_a where id<3",$arrayKey), "selectArrayKeyPropertyValue select failed");
        $this->assertEquals(
            [
                'Web Designer' => [ 1=>[ 'Dana' => 'Smith'] ],
                'Web Tester' => [2=>['Paul' => 'Jomes']],
            ],
            $arrayKey,
            "selectArrayKeyPropertyValue PropertyValue failed combining the array"
        );
        // prepared statement
        $stmt = $db->prepare("SELECT profesion,id,name,last_name FROM test_IaMysqli_a where id<3");
        $this->assertTrue($db->selectArrayKeyPropertyValue($stmt,$arrayKey), "selectArrayKeyPropertyValue prepare select failed");
        $this->assertEquals(
            [
                'Web Designer' => [ 1=>[ 'Dana' => 'Smith'] ],
                'Web Tester' => [2=>['Paul' => 'Jomes']],
            ],
            $arrayKey,
            "selectArrayKeyPropertyValue prepared statement failed"
        );
        //Query array

        $this->assertTrue($db->selectArrayKeyPropertyValue(
                array(
                   "SELECT profesion,id,name,last_name FROM test_IaMysqli_a where id<3",
                   "SELECT profesion,id,name,last_name FROM test_IaMysqli_a where id>=3",

                )
            ,$arrayKey), "selectArrayKeyPropertyValue select failed");
        $this->assertEquals(
            [
                'Web Designer' => [ 1=>[ 'Dana' => 'Smith'] ],
                'Web Tester' => [2=>['Paul' => 'Jomes']],
                'Web User' => [3=>['Rachel' => 'James']],
                'Test transaction' => [4=>['Mary' => 'Picard']],
            ],
            $arrayKey,
            "selectArrayKeyPropertyValue PropertyValue failed combining the array"
        );

        // Query returns empty

        $this->assertTrue($db->selectArrayKeyPropertyValue("SELECT id,property_id,property FROM test_IaMysqli_pv WHERE id=-1 AND property_id<-1",$arrayKey), "selectArrayKeyPropertyValue select failed");
        $this->assertEquals([], $arrayKey, "Failed combining result when no properties found");

        // Query error
        $this->assertNotTrue($db->selectArrayKeyPropertyValue(["SELECT id,property_id,nonexitent FROM test_IaMysqli_pv"],$arrayKey), "Failed detecting Sql error");

    }

    /**
     * @covers Iac\inc\sql\IacMysqli::runSqlPropertyValue
     * @covers Iac\inc\sql\IacMysqli::singletonPropertyValue
     *
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     * @covers Iac\inc\Sql\IacSqlException::getSqlStatement
     * @throws IacSqlException
     *
     * @test
     *
     */
    public function exception_singletonPropertyValue() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");
        $arrayKey = [];
        // Query error
        $db->singletonPropertyValue(
            array(
            "SELECT notrcidyd from test_IaMysqli_pv"
            ),
            $arrayKey
        );
    }

    /**
     * @covers Iac\inc\sql\IacMysqli::runSqlPropertyValue
     * @covers Iac\inc\sql\IacMysqli::singletonPropertyValue
     *
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::prepare
     * @covers Iac\inc\sql\IacMysqli::reconnect
     * @throws IacSqlException
     */
    public function test_singletonPropertyValue() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertTrue($db->singletonPropertyValue("SELECT property_id,property FROM test_IaMysqli_pv WHERE id=1",$singleton),
            "SingletonPropertyValue select failed");

        $singleton = [];
        $db->singletonPropertyValue("SELECT title,profesion,name,last_name FROM test_IaMysqli_a WHERE id = 1", $singleton);

        $this->assertEquals(
            array ('Ms' => 'Web Designer' ,'Dana' => 'Smith'),
            $singleton,
            "singleton PropertyValue failed combining the array"
        );

        //Query array

        $this->assertTrue($db->singletonPropertyValue(
            array(
                "SELECT title,profesion,name,last_name FROM test_IaMysqli_a WHERE id = 1",
                "SELECT title,profesion,name,last_name FROM test_IaMysqli_a WHERE id = 2",
            )
            ,$singleton),
             "SingletonPropertyValue select array failed"
        );
        $this->assertEquals(
            array ('Ms' => 'Web Designer', 'Dana' => 'Smith', 'Mr' => 'Web Tester', 'Paul' => 'Jomes'),
            $singleton,
            "singleton PropertyValue failed combining the array with Sql array commands"
        );

        //Disconect
        $thread_id = $db->mysqli->thread_id;
        $this->assertTrue($db->mysqli->kill($thread_id), "Failed to kill my thread for reconnect test, give permission to db user");

        $this->assertTrue($db->singletonPropertyValue(
            array(
                "SELECT title,profesion,name,last_name FROM test_IaMysqli_a WHERE id = 1",
                "SELECT title,profesion,name,last_name FROM test_IaMysqli_a WHERE id = 2",
            )
            ,$singleton),
            "SingletonPropertyValue select array failed after disconnect"
        );
        $this->assertEquals(
            array ('Ms' => 'Web Designer', 'Dana' => 'Smith', 'Mr' => 'Web Tester', 'Paul' => 'Jomes'),
            $singleton,
            "singleton PropertyValue failed after disconnect combining the array with Sql array commands"
        );

        //Query returns empty
        $this->assertTrue($db->singletonPropertyValue(
            array(
                "SELECT property_id,property FROM test_IaMysqli_pv WHERE id=111 AND property_id<-1",
                "SELECT property_id,property FROM test_IaMysqli_pv WHERE id=111 AND property_id<-1",
            )
            ,$singleton),
             "SingletonPropertyValue select array failed"
        );
        $this->assertEquals([],$singleton,"Error on no porperties to add");

        //Query error
        $this->assertNotTrue($db->singletonPropertyValue(
        /** @lang text*/ "SELECT property_id,property FROM WHERE id=1",$singleton), "Failed detecting Sql error");

        $this->assertNotTrue($db->singletonPropertyValue(
            array(
                "SELECT property_id,property, invalid_column FROM test_IaMysqli_pv WHERE id=111 AND property_id<-1",
                "SELECT property_id,property FROM test_IaMysqli_pv WHERE id=111 AND property_id<-1",
            )
            ,$singleton),
             "Failed detecting Sql array Sql error"
        );
    }

    /**
     * test_singleton()
     *
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_singleton() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertEquals(
            array('id'=>'1','name'=>'Dana','last_name'=>'Smith','title'=>'danga'),
            $db->singleton("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id", null),

            "singleton: Sql select return value"
        );
        $this->assertEquals(
            array('1','Dana','Smith','Ms','danga'),
            $db->singleton("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id", null,MYSQLI_NUM),

            "singleton: Sql select return value, MYSQLI_NUM"
        );
        $this->assertEquals(
            'NOT FOUND',
            $db->singleton("SELECT * FROM test_IaMysqli_a WHERE id = -3",'NOT FOUND'),

            "singleton: Sql Not Found"
        );
        $this->assertEquals(
            false,
            $db->singleton("SELECT * test_IaMysqli_a WHERE id=xk", 'NOT FOUND'),

            "singleton: Sql Error"
        );

        $db->close();
        unset($db);
    }


    /**
     * test_runSql
     *
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::singleton
     *
     * @throws IacSqlException
     * @throws ReflectionException
     */
    public function test_runSql() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $method = $this->getMethod($db,'runSql');
        $get = $method->invokeArgs($db, array("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id", 2, MYSQLI_ASSOC ));
        $this->assertEquals("1",$get,"runSql singleread");
        $this->assertTrue($method->invokeArgs($db, ["", 2, MYSQLI_ASSOC ]), "empty query" );

        $this->assertEquals(
            array('id'=>'1','name'=>'Dana','last_name'=>'Smith','title'=>'danga'),
            $db->singleton("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id", null),
            "singleton: Sql select return value"
        );
        $this->assertEquals(
            array('1','Dana','Smith','Ms','danga'),
            $db->singleton("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id", null,MYSQLI_NUM),

            "singleton: Sql select return value, MYSQLI_NUM"
        );
        $this->assertEquals(
            'NOT FOUND',
            $db->singleton("SELECT * FROM test_IaMysqli_a WHERE id = -3",'NOT FOUND'),

            "singleton: Sql Not Found"
        );
        $this->assertSame(
            false,
            $db->singleton("SELECT * test_IaMysqli_a WHERE id=xk", 'NOT FOUND'),

            "singleton: Sql Error"
        );

        $db->close();
        unset($db);
    }


    /**
     * @covers Iac\inc\sql\IacMysqli::metaData_get
     * @covers Iac\inc\sql\IacMysqli::metaData_clear
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::singleton
     * @covers Iac\inc\sql\IacMysqli::IacSqlInfo_get
     * @covers Iac\inc\sql\IacSqlInfo::constantsFill
     * @covers Iac\inc\sql\IacSqlInfo::flags2Array
     * @covers Iac\inc\sql\IacSqlInfo::result2fields
     * @covers Iac\inc\sql\IacSqlInfo::type2Text
     * @covers metaDataOnSet()
     * @covers getMetaData()
     *
     */
    public function test_metaData() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->metaDataOn = true;
        $expected = [
            'id' => [
                'type' => 'int',
                'typeMysqli' => 'LONG',
                'flags' => [
                    1 => 'NOT_NULL',
                    2 => 'PRI_KEY',
                    32 => 'UNSIGNED',
                    512 => 'AUTO_INCREMENT',
                    32768 => 'GROUP',
                    16384 => 'PART_KEY',
                ],
                'metaData' => (object)['name' => 'id',
                    'orgname' => 'id',
                    'table' => 'test_IaMysqli_a',
                    'orgtable' => 'test_iamysqli_a',
                    'def' => '',
                    'db' => 'iamysqltestdb',  
                    'catalog' => 'def',
                    'max_length' => 0,
                    'length' => 10,
                    'charsetnr' => 63,
                    'flags' => 49699,
                    'type' => 3,
                    'decimals' => 0,],
                'pri_key' => true,
                'pri_key_multiple' => false,
                'auto_increment' => true,
                'null' => false,
                'required' => true,
                'numeric' => true,
                'bytes' => 4,
                'min' => 0,
                'max' => 4294967295,
                'decimals' => 0,
                'integers' => 10,
                'max_chars' => 10,
            ],
            'title' => [
                'type' => 'enum',
                'typeMysqli' => 'STRING',
                'flags' => Array (
                    1 => 'NOT_NULL',
                    16384 => 'PART_KEY',
                    256 => 'ENUM',
                ),
                'metaData' =>  (object)[            'name' => 'title',
                    'orgname' => 'title',
                    'table' => 'test_IaMysqli_a',
                    'orgtable' => 'test_iamysqli_a',
                    'def' => '',
                    'db' => 'iamysqltestdb',  
                    'catalog' => 'def',
                    'max_length' => 0,
                    'length' => 12,
                    'charsetnr' => 255,
                    'flags' => 16641,
                    'type' => 254,
                    'decimals' => 0],
                'null' => false,
                'required' => true,
            ],
            'dob' => [
                'type' => 'date',
                'typeMysqli' => 'DATE',
                'flags' => [
                    1 => 'NOT_NULL',
                    128 => 'BINARY',
                    4096 => 'NO_DEFAULT_VALUE',
                ],
                'metaData' => (object)[
                    'name' => 'dob',
                    'orgname' => 'dob',
                    'table' => 'test_IaMysqli_a',
                    'orgtable' => 'test_iamysqli_a',
                    'def' => '',
                    'db' => 'iamysqltestdb',  
                    'catalog' => 'def',
                    'max_length' => 0,
                    'length' => 10,
                    'charsetnr' => 63,
                    'flags' => 4225,
                    'type' => 10,
                    'decimals' => 0,
                ],
                'null' => false,
                'required' => true,
            ],
            'social_set' => [
                'type' => 'set',
                'typeMysqli' => 'STRING',
                'flags' => [2048 => 'SET'],
                'metaData' =>  (object)[
                    'name' => 'social_set',
                    'orgname' => 'social_set',
                    'table' => 'test_IaMysqli_a',
                    'orgtable' => 'test_iamysqli_a',
                    'def' => '',
                    'db' => 'iamysqltestdb',  
                    'catalog' => 'def',
                    'max_length' => 0,
                    'length' => 60,
                    'charsetnr' => 255,
                    'flags' => 2048,
                    'type' => 254,
                    'decimals' => 0,
                ],
                'null' => true,
                'required' => false,
            ],
        ];
        $sql = "SELECT id, title, dob, social_set FROM test_IaMysqli_a LIMIT 1";
        $got = $db->singleton($sql);
        $this->assertEquals(
            $expected,
            $db->metaData_get(),
            "metaData_get with metaDataOn=true"
        );
        $db->metaDataOn = false;
        global $gSqlClass;
        $era = $gSqlClass;
        $gSqlClass = $db;
        metaDataOnSet(true);
        $this->assertEquals($expected, getMetaData($sql), "inc/sqlConverter.getMetaData");
        $gSqlClass = $era;
        $db->metaData_clear();
        $this->assertEquals([], $db->metaData_get(), "Clear metadata");
    }

    /**
     * test_singleton_full()
     *
     * @covers Iac\inc\sql\IacMysqli::singleton_full
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_singleton_full() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertEquals(
            array('id'=>'1','name'=>'Dana','last_name'=>'Smith','title'=>'danga'),
            $db->singleton_full("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id"),

            "singleton_full: Sql select return value"
        );
        $this->assertEquals(
            array('id'=>'','name'=>'','last_name'=>'','title'=>''),
            $db->singleton_full("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id = -3"),

            "singleton_full: Sql Not Found"
        );
        $this->assertEquals(
            false,
            $db->singleton_full("SELECT * FROM test_IaMysqli_a WHERE id=xk"),

            "singleton_full: Sql Error"
        );
        $db->close();
        unset($db);
    }

    /**
     * test_selectVector()
     *
     * @covers Iac\inc\sql\IacMysqli::selectVector
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_selectVector() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertEquals(
            array ( 0 => '1', 1 => '2', 2 => '3',),
            $db->selectVector("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id", 'NOT FOUND'),

            "selectVector: Sql select return value"
        );
        $this->assertEquals(
            'NOT FOUND',
            $db->selectVector("SELECT * FROM test_IaMysqli_a WHERE id = -3", 'NOT FOUND'),

            "selectVector: Sql Not Found"
        );
        $this->assertEquals(
            false,
            $db->selectVector("SELECT notExistantColumn FROM test_IaMysqli_a WHERE id=1", 'NOT FOUND'),

            "selectVector: Sql Error"
        );
        $db->close();
        unset($db);
    }

    /**
     * test_selectKeyValue()
     *
     * @covers Iac\inc\sql\IacMysqli::selectKeyValue
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_selectKeyValue() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertEquals(
            array ( 1 => 'Dana', 2 => 'Paul', 3 => 'Rachel',),
            $db->selectKeyValue("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id", 'NOT FOUND'),

            "selectKeyValue: Sql select return value"
        );
        $this->assertEquals(
            'NOT FOUND',
            $db->selectKeyValue("SELECT * FROM test_IaMysqli_a WHERE id = -3", 'NOT FOUND'),

            "selectKeyValue: Sql Not Found"
        );
        $this->assertEquals(
            false,
            $db->selectKeyValue("SELECT * FROM test_IaMysqli_a WHERE id=1abab", 'NOT FOUND'),

            "selectKeyValue: Sql Error"
        );
        $db->close();
        unset($db);
    }

    /**
     * test_selectArrayKey()
     *
     * @covers Iac\inc\sql\IacMysqli::selectArrayKey
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_selectArrayKey() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertEquals(
            array ( 1 => array ( 'uid' => '1', 'name' => 'Dana', 'last_name' => 'Smith', 'title' => 'danga', ), 2 => array ( 'uid' => '2', 'name' => 'Paul', 'last_name' => 'Jomes', 'title' => 'danga', ), 3 => array ( 'uid' => '3', 'name' => 'Rachel', 'last_name' => 'James', 'title' => 'danga', ),),
            $db->selectArrayKey("SELECT id as uid,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id","uid", 'NOT FOUND'),

            "selectArrayKey: Sql select return value"
        );
        $this->assertEquals(
            array ( 1 => array ( 'id' => '1', 'name' => 'Dana', 'last_name' => 'Smith', 'title' => 'danga', ), 2 => array ( 'id' => '2', 'name' => 'Paul', 'last_name' => 'Jomes', 'title' => 'danga', ), 3 => array ( 'id' => '3', 'name' => 'Rachel', 'last_name' => 'James', 'title' => 'danga', ),),
            $db->selectArrayKey("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id",null, 'NOT FOUND'),

            "selectArrayKey: Sql select return value no id field specified"
        );
        $this->assertEquals(
            array ( 1 => array ( '1', 'Dana', 'Smith', 'Ms', 'danga', ),
                2 => array ( '2', 'Paul', 'Jomes', 'Mr', 'danga', ),
                3 => array ( '3', 'Rachel', 'James', 'Mss', 'danga', ),),
            $db->selectArrayKey("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id",null, 'NOT FOUND',MYSQLI_NUM),

            "selectArrayKey: Sql select return value MYSQLI_NUM"
        );
        $this->assertEquals(
            'NOT FOUND',
            $db->selectArrayKey("SELECT * FROM test_IaMysqli_a WHERE id = -3","id", 'NOT FOUND'),

            "selectArrayKey: Sql Not Found");
        $this->assertEquals(
            false,
            $db->selectArrayKey("SELECT * FROM test_IaMysqli_axxx WHERE id=xk","id", 'NOT FOUND'),

            "selectArrayKey: Sql Error"
        );
        $db->close();
        unset($db);
    }

    /**
     * test_selectArrayIndex()
     *
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_selectArrayIndex() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertEquals(
            array ( 0 => array ( 'id' => '1', 'name' => 'Dana', 'last_name' => 'Smith', 'title' => 'danga', ), 1 => array ( 'id' => '2', 'name' => 'Paul', 'last_name' => 'Jomes', 'title' => 'danga', ), 2 => array ( 'id' => '3', 'name' => 'Rachel', 'last_name' => 'James', 'title' => 'danga', ),),
            $db->selectArrayIndex("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id", 'NOT FOUND'),

            "selectArrayIndex: Sql select return value"
        );
        $this->assertEquals(
            array (
                0 => array ( '1', 'Dana', 'Smith', 'Ms', 'danga', ),
                1 => array ( '2', 'Paul', 'Jomes', 'Mr', 'danga', ),
                2 => array ( '3', 'Rachel', 'James', 'Mss', 'danga', ),
            ),
            $db->selectArrayIndex("SELECT id,name,last_name,title,'danga' as title FROM test_IaMysqli_a WHERE id <= 3 ORDER BY id", 'NOT FOUND',MYSQLI_NUM),

            "selectArrayIndex: Sql select return value"
        );

        $this->assertEquals(
            'NOT FOUND',
            $db->selectArrayIndex("SELECT * FROM test_IaMysqli_a WHERE id = -3", 'NOT FOUND'),

            "selectArrayIndex: Sql Not Found"
        );
        $this->assertEquals(
            false,
            $db->selectArrayIndex("SELECT * FROM test_IaMysqli_axxx WHERE id=xk", 'NOT FOUND'),

            "selectArrayIndex: Sql Error"
        );
        $db->close();
        unset($db);
    }


    /**
     * test_insertAndGetId()
     *
     *
     * @covers Iac\inc\sql\IacMysqli::insertAndGetId
     * @covers Iac\inc\sql\IacMysqli::query
     *
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers  Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_insertAndGetId() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertTrue($db->query("DELETE FROM test_IaMysqli_a WHERE name='insertided'"), "Delete previous tests");
        $lastId = $db->insertAndGetId("INSERT INTO test_IaMysqli_a(name,dob) VALUES('insertided',NOW())");
        $dbId = $db->single_read("SELECT MAX(id) FROM test_IaMysqli_a WHERE name='insertided'",-1);
        $this->assertEquals($lastId, $dbId, "Check last inserted id by insertIded" );

        $this->assertNotTrue( $db->insertAndGetId(
        /** @lang text*/"INSERT INTO (name) VALUES('insertided')"), "Error in insert query" );
        $db->close();
        unset($db);
    }

    /**
     * last_insert_id
     *
     *
     * @covers  Iac\inc\sql\IacMysqli::last_insert_id
     * @covers  Iac\inc\sql\IacMysqli::query
     *
     * @covers  Iac\inc\sql\IacMysqli::single_read
     * @covers  Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_last_insert_id() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertTrue($db->query("DELETE FROM test_IaMysqli_a WHERE name='insert_id'"), "Delete previous tests");

        $this->assertTrue($db->query("INSERT INTO test_IaMysqli_a(name,dob) VALUES('insert_id',NOW())"), "Failed to insert test Data");
        $lastId = $db->last_insert_id();
        $dbId = $db->single_read("SELECT MAX(id) FROM test_IaMysqli_a WHERE name='insert_id'");
        $this->assertEquals($lastId, $dbId, "Check last inserted id" );
        $db->close();
        unset($db);
    }

    /**
     * test_found_rows()
     *
     * @covers  Iac\inc\sql\IacMysqli::found_rows
     * @covers  Iac\inc\sql\IacMysqli::single_read
     * @covers  Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_found_rows() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->single_read("SELECT SQL_CALC_FOUND_ROWS id FROM test_IaMysqli_a WHERE id <=3 LIMIT 1");
        $this->assertEquals(3,$db->found_rows(),"found rows, inspite of limit");
        $this->assertEquals(1,$db->num_rows,"retreived rows, considering limit");
        $db->close();
        unset($db);
    }

    /**
     * test_log_sql_error()
     *
     * @covers Iac\inc\sql\IacMysqli::log_sql_error
     * @covers Iac\inc\sql\IacMysqli::errorLog_get
     *
     * @covers Iac\inc\sql\IacMysqli::single_read
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @throws IacSqlException
     */
    public function test_log_sql_error() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $this->assertEquals(
            false,
            $db->single_read("SELECT * FROM test_IaMysqli_a WHERE id=xk","NOT FOUND"),

            "error log register"
        );
        /*
        $db->log_sql_error('previous Sql, no mysqli error, no retries',0,false);
        $db->log_sql_error('previous Sql, retries',1,true);
        $db->log_sql_error('previous Sql, no mysqli error',1,false);
        $db->log_sql_error('Sql retried, no mysqli error, no retries',0,false);
        $db->log_sql_error('Sql retried, no mysqli error, retries',1,false);

        $errLog = $db->errorLog_get();
        $this->assertEquals( count($errLog),6,"Error log number of entries");
        //array_shift($errLog);
        $this->assertEquals(
            $errLog,
            array(
                0 => array ('errno' => 1054, 'error' => 'Unknown column \'xk\' in \'where clause\'', 'Sql' => 'SELECT * FROM test_IaMysqli_a WHERE id=xk', ),
                1 => array ('errno' => 0, 'error' => '', 'Sql' => 'previous Sql, no mysqli error, no retries', ),
                2 => array ('errno' => 1054, 'error' => 'Unknown column \'xk\' in \'where clause\'', 'Sql' => 'previous Sql, retries -- retries: 1', ),
                3 => array ('errno' => 0, 'error' => '', 'Sql' => 'previous Sql, no mysqli error -- retries: 1', ),
                4 => array ('errno' => 0, 'error' => '', 'Sql' => 'Sql retried, no mysqli error, no retries', ),
                5 => array ('errno' => 0, 'error' => '', 'Sql' => 'Sql retried, no mysqli error, retries -- retries: 1', ),
            ),
            "Error log entries"
        );
        */
        $db->close();

        unset($db);
    }

    /**
     * test_throwSqlException_set
     *
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     */
    public function test_throwSqlException_set() {
        $db = $this->dbCreateInstance();
        $driver = new mysqli_driver();

        $db->throwSqlException_set(false);
        $this->assertEquals(MYSQLI_REPORT_OFF,$driver->report_mode,"Set to no mysqli Excpetions");

        $db->throwSqlException_set(true);
        $this->assertEquals(MYSQLI_REPORT_STRICT | MYSQLI_REPORT_ERROR,$driver->report_mode,"Set to default mysqli Exceptions");

        $db->throwSqlException_set(MYSQLI_REPORT_STRICT);
        $this->assertEquals(MYSQLI_REPORT_STRICT,$driver->report_mode,"Set to Strict mysqli Exceptions");
    }

    /**
     * test_throwSqlException_get
     *
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_get
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     */
    public function test_throwSqlException_get() {
        $db = $this->dbCreateInstance();
        //$driver = new mysqli_driver();

        $db->throwSqlException_set(false);
        $this->assertEquals(MYSQLI_REPORT_OFF,$db->throwSqlException_get(),"Set to no mysqli Excpetions");

        $db->throwSqlException_set(true);
        $this->assertEquals(MYSQLI_REPORT_STRICT | MYSQLI_REPORT_ERROR,$db->throwSqlException_get(),"Set to default mysqli Exceptions");

        $db->throwSqlException_set(MYSQLI_REPORT_STRICT);
        $this->assertEquals(MYSQLI_REPORT_STRICT,$db->throwSqlException_get(),"Set to Strict mysqli Exceptions");
    }

    /**
     * execute_select_with_exception
     *
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set

     *
     * @covers Iac\inc\sql\IacMysqli::single_read
     */
    public function test_execute_select_with_exception() {
        $db = $this->dbCreateInstance();
        $driver = new mysqli_driver();
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");

        $this->assertEquals($driver->report_mode,MYSQLI_REPORT_STRICT | MYSQLI_REPORT_ERROR,"Unable to set to default mysqli Exceptions, to test this test");
        $this->assertTrue($db->connect(), "DB Connection failed");
         $db->single_read("SELECT nonExistantCol FROM nonExistantTable");
        $this->fail('Sql error exception not thrown');
    }

    /**
     * execute_query_with_exception
     *
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set

     *
     * @covers Iac\inc\sql\IacMysqli::query
     */
    public function test_execute_query_with_exception() {
        $db = $this->dbCreateInstance();
        $driver = new mysqli_driver();
        $db->throwSqlException_set(true);
        $this->expectException("Iac\inc\sql\IacSqlException");

        $this->assertEquals($driver->report_mode,MYSQLI_REPORT_STRICT | MYSQLI_REPORT_ERROR,"Unable to set to default mysqli Exceptions, to test this test");
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->query("UPDATE   name='xxxxxxxxxx' WHERE id=1");
        $this->fail('Sql error exception not thrown');
    }

    /**
     * @covers Iac\inc\sql\IacMysqli::selectArrayMultiKey
     * @covers Iac\inc\sql\IacMysqli::selectArrayMultiKeyDo
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     *
     * @throws IacSqlException
     */
    public function testSelectMultiKeyStringException() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->throwSqlException_set(true);
        $this->expectException("mysqli_sql_exception");
        $db->selectArrayMultiKey("SELECT title, profesion, name, last_name FROM test_iamysqli_a ORDER BY 1,2,gato", 2) ;
    }

    /**
     * @covers Iac\inc\sql\IacMysqli::selectArrayMultiKey
     * @covers Iac\inc\sql\IacMysqli::selectArrayMultiKeyDo
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::throwSqlException_set
     *
     * @throws IacSqlException
     */
    public function testSelectMultiKeyArrayException() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $db->throwSqlException_set(true);
        $this->expectException("mysqli_sql_exception");
        $db->selectArrayMultiKey(["SELECT title, profesion, name, last_name FROM test_iamysqli_a ORDER BY 1,2,gato"], 2) ;
    }

    /**
     * @covers Iac\inc\sql\IacMysqli::selectArrayMultiKey
     * @covers Iac\inc\sql\IacMysqli::selectArrayMultiKeyDo
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::prepare
     *
     * @throws IacSqlException
     */
    public function test_SelectMultiKey() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");

        $this->assertNotTrue($db->selectArrayMultiKey("SELECT title, profesion, name, last_name FROM test_iamysqli_a ORDER BY 1,2,gato", 3), "sql error" );
        $this->assertNotTrue($db->selectArrayMultiKey("[SELECT title, profesion, name, last_name FROM test_iamysqli_a ORDER BY 1,2,gato]", 3), "sql error" );

        $sql = "SELECT title, profesion, name, last_name FROM test_iamysqli_a WHERE title <> 'Esq' ORDER BY 1,2, 3";
        $actual = $db->selectArrayMultiKey($sql, 2) ;
        $expected = [
            'Mr' =>
                ['Web Tester'=>['name' => 'Paul', 'last_name' => 'Jomes']],
            'Ms' =>
                ['Web Designer' => ['name' => 'Dana', 'last_name' => 'Smith'] ],
            'Mss' =>
                [
                    'Test transaction' => [ 'name' => 'Mary', 'last_name' => 'Picard'],
                    'Web User' => ['name' => 'Rachel', 'last_name' => 'James']
                ],
        ];
        $this->assertEquals($expected, $actual);

        $stmt = $db->prepare($sql);
        $this->assertEquals($expected, $db->selectArrayMultiKey($stmt, 2), "prepared statement" );


        $actual = $db->selectArrayMultiKey($sql, 2) ;
        $expected = [
            'Mr' =>
                ['Web Tester'=>['name' => 'Paul', 'last_name' => 'Jomes']],
            'Ms' =>
                ['Web Designer' => ['name' => 'Dana', 'last_name' => 'Smith'] ],
            'Mss' =>
                [
                    'Test transaction' => [ 'name' => 'Mary', 'last_name' => 'Picard'],
                    'Web User' => ['name' => 'Rachel', 'last_name' => 'James']
                ]
        ];

        $this->assertEquals($expected,$actual , "selectArrayMultiKey");
        $actual = $db->selectArrayMultiKey([$sql, $sql], 2) ;
        $this->assertEquals($expected,$actual , "selectArrayMultiKey duplicated query ");




    }


    /**
     * @covers Iac\inc\sql\IacMysqli::selectValuePath
     * @covers Iac\inc\sql\IacMysqli::selectArrayIndex
     * @covers Iac\inc\sql\IacMysqli::runSql
     * @covers Iac\inc\sql\IacMysqli::prepare
     *
     * @throws IacSqlException
     */
    public function test_SelectValuePath() {
        $db = $this->dbCreateInstance();
        $this->assertTrue($db->connect(), "DB Connection failed");
        $sql = "SELECT title, profesion, name, last_name FROM test_iamysqli_a WHERE title<> 'Esq' ORDER BY 1,2, 3";
        $expectedPath = [
            'Mr' => ['Web Tester' => ['Paul' => 'Jomes']],
            'Ms' => ['Web Designer' => ['Dana' => 'Smith']],
            'Mss' =>[
                'Test transaction' => ['Mary' => 'Picard'],
                'Web User' => ['Rachel' => 'James']
            ]
        ];
        $this->assertEquals($expectedPath,$db->selectValuePath($sql) , "selectValuePath");
        $stmt = $db->prepare($sql);
        $this->assertEquals($expectedPath,$db->selectValuePath($stmt) , "selectValuePath prepared statement");
        //$this->assertEquals($expectedPath,$db->selectValuePath($sql, 0) , "selectValuePath");

        $expectedFlat2 = [
            'Mr' => ['Web Tester' => ['name' => 'Paul', 'last_name' =>  'Jomes']],
            'Ms' => ['Web Designer' => ['name' =>'Dana' , 'last_name'=> 'Smith']],
            'Mss' => [
                'Test transaction' =>['name' =>'Mary' , 'last_name'=> 'Picard'],
                'Web User' => [ 'name' =>'Rachel' , 'last_name'=> 'James']
            ]
        ];
        $this->assertEquals($expectedFlat2,$db->selectValuePath($sql, 2) , "selectValuePath flat=2");
        $expectedNegative = [
            'Mr' => [
                'Web Tester' => [
                    'Paul' => ['Jomes' => []]
                ]
            ],
            'Ms' => [
                    'Web Designer' => [
                        'Dana' => ['Smith' => []]
                    ],
                ],
            'Mss' => [
                    'Test transaction' => [
                        'Mary' => ['Picard' => []]
                    ],
                'Web User' => [
                    'Rachel' => ['James' => []]
                ]
            ]
        ];
        $this->assertEquals($expectedNegative,$db->selectValuePath($sql, 0) , "selectValuePath flat=2");
        $this->assertEquals(false,$db->selectValuePath($sql . ",gato") , "selectValuePath con error");
    }
}
