<?php
/**
 * Hoja para hacer más fácil las pruebas: correrlas, ver sus reportes, tips, como instalar phpUnit, ...
 *
 * Para las pruebas a) lee testsuites de vitex/phpunit.xml y todos los archivos *Test.php dentro de vitex/tests
 *
 * @version 1.0.3 2021-09-29
 *
 */
use JetBrains\PhpStorm\Pure;

error_reporting(E_ALL  );
ini_set('ignore_repeated_errors', "1");
ini_set('display_errors',"1");
ignore_user_abort(true);
ini_set("date.timezone", "America/Mexico_City");

?><!DOCTYPE html>
<html lang="es-MX es">
<head>
    <meta charset="UTF-8">
    <title>Tests</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>

    <style>
        BODY {margin:2em;line-height: 2em;}
        PRE {line-height: 1.2em;}
        CODE {line-height: 1.6em;}
        H1 {text-align: center;font-size:1.6em;color:darkblue}
        FIELDSET {border-color:darkblue;display:inline-block;padding-right:1em;
            box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2);transition: 0.3s;
        }
        LEGEND {color:darkblue;font-size:1.4em}
        SUMMARY {color:green;cursor:pointer;text-decoration: underline}
        DETAILS > DIV {margin:0.5em 1em;padding:1em; border:green solid 1px;width: fit-content; }
        A:visited {color:blue}

        .izq {text-align:left}
        .gde {font-size:1.3em; color:darkblue}
        .code {line-height: 1.4em;}

        H1.corriendo {margin-bottom:0;padding-bottom: 0}
        DIV.command {margin: 0 auto;width:95%;text-align:center; border: 1px blue solid;display:table-cell;min-height:5em}
        DIV.corriendo { margin-top:0;padding: 0.5em 1em;text-align: left;line-height: 1.4em;}
    </style>
    <script src="../js2/jquery-3.6.0.min.js"></script>
</head>
<body>

<div id="command" class="command">&nbsp;</div>

<div id="msgrunning" hidden><h1>mensaje de espera estoy corriendo</h1></div>

<?php /** run here */
runTestSuite($_REQUEST['testsuite'] ?? '');
?>

<?php
/** code */

/**
 * @param $testsuite
 */
function runTestSuite($testsuite) {
    $testsuite = trim($testsuite);
    if(empty($testsuite))
        return;
    try {
        $testSuiteParam = array_key_exists($testsuite, getTestSuiteOptions()) ?
            '--testsuite ' : '';
        $pathCoverage = $_REQUEST['pathCoverage'] ?? '';
        $split = explode('/', $testsuite);
        if(empty($testSuiteParam) && count($split) >1) {
            $last = count($split) - 1;
            $split[$last] = str_replace('Test', '', $split[$last]) . '.html';
            unset($split[0]);
            $coveragePath = '/' . implode('/', $split);
        } else {
            $coveragePath = '';
        }
        $o = htmlentities($testsuite ?? '', ENT_QUOTES + ENT_HTML401 + ENT_DISALLOWED + ENT_SUBSTITUTE);

        echo "<div id='resultados'>
        <h1>Resultado de pruebas: $o:<br>
           <span style='font-weight: normal;font-size:0.8em'> <a target='_blank' href='reports/testDetails.html'>Pruebas realizadas</a>
           <span style='padding-left:12em;font-weight: normal;font-size:0.8em'> 
                <a target='_blank' href='reports/testdox.html'>TestDox</a>
                <a style='padding-left:12em' target='_blank'  href='reports/html-coverage$coveragePath'>Coverage</a> 
                <input style='margin-left:12em;padding-left:1em;padding-right:1em' type='submit' value='Re - Run' form='runPhpUnit'>
                <a style='padding-left:6em'  href='javascript:scrollToTests()'>Seleccionar Test</a>
            </span> 
        </h1> 
        ";
        if(!empty($testsuite) && !empty($testSuiteParam))
            echo "<div style='margin:1em;padding:1em;border:1px silver solid;font-size:0.9em;width:fit-content'>Files for $testsuite: <i>" .
                implode(", ", (array)getTestSuiteFiles()[$testsuite]->file ) .
                "</i></div>";
        elseif(!empty($testsuite))
            echo "<div style='margin:1em;padding:1em;border:1px silver solid;font-size:0.9em;width:fit-content'>Files: $testsuite<i>" .
                "</i></div>";

        $result = shell_exec("tester.bat $pathCoverage $testSuiteParam$testsuite 2>&1"); // 2>&1 redirecciona stderr a stdout
        $result = str_replace(["\r\n\r\n\r\n\r\n", "\r\n\r\n\r\n", "\r\n\r\n"], "\r", $result);
        $result = str_replace(["\r\r\r\r", "\r\r\r", "\r\r"], "\r", $result);
        $result = str_replace(["\n\n\n\n", "\n\n\n", "\n\n"], "\r", $result);
        echo "<pre>$result</pre></div>";
    } catch (Throwable $e) {
        echo "<div style='color:red;margin:auto;text-align: center' >Error detectado:<br>" . $e->getMessage() . "</div>";
    }
}

/**
 * @param string $default
 * @return array
 */
function getTestSuiteOptions(string $default = ''):array {
    $options = [];
    try {
        $phpUnit = new SimpleXMLElement(file_get_contents(__DIR__ . "/../phpunit.xml"));
        foreach ($phpUnit->children()->testsuites->children() as $t) {
            $name = trim($t->attributes()->name);
            $o = htmlentities($name ?? '', ENT_QUOTES + ENT_HTML401 + ENT_DISALLOWED + ENT_SUBSTITUTE);
            $selected = $default === $name ? " SELECTED='SELECTED' " : '';
            $options[$name] = "<option value='$name' $selected>$o</option>";
        }
        return $options;
    } catch(Throwable)  {return [];}
}
/**
 * @param string $default
 * @return array
 */
function getTestSuiteFiles():array {
    $files = [];
    try {
        $phpUnit = new SimpleXMLElement(file_get_contents(__DIR__ . "/../phpunit.xml"));
        foreach ($phpUnit->children()->testsuites->children() as $t) {
            $files[trim($t->attributes()->name)] = $t->children();
        }
        return $files;
    } catch(Throwable)  {return [];}
}

/**
 * @param string $default
 * @return string
 */
function testFileOptions(string $default = ''):string {
    $options = '';
    //$testsDir = '.';
    $testFiles = new TestFileReader();
    /**@var FileIs $file */
    foreach($testFiles->listFiles('.') as $file) {
        if($file->isDir())
            continue;
        $reBased = FileIs::fromDirToBaseDir($file, '.', 'tests');
        $selected = $default === $reBased->fullPath() ? " SELECTED='SELECTED' " : '';
        $options .= "<option value='" . $reBased->fullPath() ."' $selected>" .
            substr( $reBased->fullPath(),6) . "</option>";
    }
    return $options;
}

class TestFileReader
{
    /** @var string */
    protected string $initialPath;

    /**
     * @param string $path
     * @param int $sortingOrder , SCANDIR_SORT_* default:SCANDIR_SORT_ASCENDING
     * @return Generator
     */
    public function listFiles(string $path, int $sortingOrder = SCANDIR_SORT_ASCENDING): Generator
    {
        $this->initialPath = $path;
        yield from $this->filesRead($path, $sortingOrder);
    }

    /**
     * @param string $path
     * @param int $sortingOrder , SCANDIR_SORT_* default:SCANDIR_SORT_ASCENDING
     * @return Generator
     */
    protected function filesRead(string $path, int $sortingOrder = SCANDIR_SORT_ASCENDING): Generator
    {
        foreach (scandir($path, $sortingOrder) as $file) {
            if (empty($file) || $file[0] === '.')
                continue;
            $path = rtrim($path, "/\\") . '/';
            $fullPath = $path . $file;
            if (is_dir($fullPath)) {
                yield new FileIs(true, $fullPath);
                yield from $this->filesRead($fullPath . '/', $sortingOrder);
            } elseif(fnmatch('*Test.php', $file, FNM_CASEFOLD))
                yield new FileIs(false, $fullPath);
        }
    }
}

class FileIs {
    protected bool $isDir;
    protected string $fullPath;

    /**
     * @param bool $isDir
     * @param string $fullPath
     */
    public function __construct(bool $isDir, string $fullPath) {
        $this->isDir = $isDir;
        $this->fullPath = $fullPath;
    }

    /**
     * @return bool
     */
    public function isDir(): bool { return $this->isDir; }

    /**
     * @return string
     */
    public function fullPath(): string { return $this->fullPath; }

    /**
     * @return string
     */
    public function fileName(): string { return basename($this->fullPath); }

    /**
     * @return string
     */
    #[Pure]
    public function extension(): string{ return strstr($this->fileName(), '.'); }

    /**
     * @return string
     */
    #[Pure]
    public function path(): string {
        return rtrim(
                self::replaceOnce($this->fullPath, $this->fileName(), ''),
                "/\\"
            ) . '/';
    }

    /**
     * Cambia la información del file de un (sub)directorio a otro
     *
     * @param FileIs $fileIs
     * @param $fromDir
     * @param $toDir
     * @return FileIs
     */
    #[Pure]
    public static function fromDirToBaseDir(FileIs $fileIs, $fromDir, $toDir):FileIs {
        return new FileIs(
            $fileIs->isDir(),
            self::replaceOnce($fileIs->fullPath(), $fromDir, $toDir)
        );
    }

    /**
     * @param string $haystack
     * @param string $needle
     * @param $replace
     * @return string
     */
    protected static function replaceOnce(string $haystack, string $needle, $replace):string {
        $pos = strpos($haystack, $needle);
        if ($pos !== false) {
            return substr_replace($haystack, $replace, $pos, strlen($needle));
        }
        return $replace;
    }

}

?>

<fieldset id="phpUnitFieldSet" class="ficha card">
    <legend>Tests</legend>
    <div class="izq">
        <ul>
            <li><a target="_blank" href="jsTestsQunit.html">javascript tests</a></li>
            <li><form method="POST" id="runPhpUnit">
                <label >Run testsuite:
                    <select required name="testsuite" id="testsuite" class="notSelectize">
                        <option></option>
                        <optgroup label="Test suites">
                            <?php echo implode('', getTestSuiteOptions($_REQUEST['testsuite'] ?? '') ); ?>
                        </optgroup>
                        <optgroup label="Test Files">
                            <?php echo testFileOptions($_REQUEST['testsuite'] ?? ''); ?>
                        </optgroup>
                    </select>   </label> <input type="submit" value="Run">
<!--
                    <details><summary>Avanzados</summary><div>
                            <input type="checkbox" name="pathCoverage" id="pathCoverage" value="--path-coverage"> Path Coverage <i>¡muy lento!</i>
                        </div>
                    </details>
-->
                </form>
            </li>
            <li><b class="gde">Última corrida</b>:
                <ul>
                    <li><a href="reports/testDetails.html">Pruebas realizadas</a></li>
                    <li><a href="reports/testdox.html">TestDox</a></li>
                    <li><a href="reports/html-coverage">Cobertura</a>, última sin el --no-coverage</li>
                    <li><a href="reports">Reportes generados</a></li>
                </ul>
            </li>
        </ul>
        <div class="code">
                <b>Instrucciones para correr las pruebas de phpUnit</b>
                <ol>
                    <li>Abrir command prompt</li>
                    <li>Correr:<ol>
                    <li>cd \wamp\www\vitex</li>
                    <li>
                        <ul>
                            <li>tests\tester.bat --testsuite testSuiteName
                            <li>tests\tester.bat tests\testFileName.php
                            <li>tests\tester.bat --no-coverage
                                [--testsuite testSuiteName|tests\testFileName.php]
                                <br><i>Rápido, al no generar coverage</i></li>
                            <li>tests\tester.bat --no-coverage --stop-on-failure --stop-on-error
                                [--testsuite testSuiteName|tests\testFileName.php]
                                <br><i>Termina al primer error y es rápido, al no generar coverage</i></li>
                        </ul>
                    </li>
                        </ol>
                    <li>Nota: En vitex/phpunit.xml en &lt;testsuites&gt; agregar la prueba en el testsuite correspondiente
                        o agregar un testsuite adecuado.
                </ol>

                <b>Sobre el PhpUnit</b>
                <ul>
                    <li>Usamos 9.5, instalada: <?php echo strstr( shell_exec("php " . __DIR__ . '/../tools/phpunit.phar --version'), "PHPUnit"); ?></li>
                    <li>PhpUnit, documentación
                        <ul>
                            <li><a href="https://phpunit.readthedocs.io/en/9.5/">
                                    https://phpunit.readthedocs.io/en/9.5/</a></li>
                            <li>En español, ¡checar que la versión sea 9.5!<br>
                                <a href="https://phpunit.readthedocs.io/es/latest/">
                                    https://phpunit.readthedocs.io/es/latest/</a>
                            </li>
                        </ul>
                    </li>
                </ul>
                    </blockquote>
        </div>
    </div>
    <details>
        <summary>On metrics</summary>
        <DIV>
            <ul>
                <li>valores CRAP<ul>
                        <li>Por convención method o function normal (sencilla a mediana):
                            Con crap > 12, se considera CRAPpy.
                        <li>Por convención method o function mediana a complicada (sencilla a mediana):
                            Con crap 24, se considera CRAPpy.
                        <li>Method o function muy complicada: Con crap > 30, se considera CRAPpy.
                            <br><i>https://testing.googleblog.com/2011/02/this-code-is-crap.html</i></li>
                        <li>Por convención method o function de validación no es para esta medida.
                    </ul>
                </li>
                <li>% Coverage, es con criterio<ul>
                        <li>Considerar 100% coverage vs esfuerzo para lograrlo</li>
                        <li>Ojo con ciertas protecciones/validaciones que son difíciles de lograr el coverage</li>
                    </ul></li>
            </ul>
        </DIV>

    </details>
</fieldset>

<div id="patterns" style="border:1px silver solid;padding:1em;white-space: pre">
    <h2>Patrones</h2>
<h3>A)Datos de entrada</h3>
    0.- require_once('../../inc/config.php'); // hace los includes, paths y revisa login realizado

    1.- Obten únicamente los datos necesarios, limpialos y protegelos
        // solo los que necistamos, con su default en su caso y numeros sin comas, fechas en y-m-d fecha y hora y-m-d H:i (24 horas) y sin strim solo textbox sin tinymce
        $values = ParamsHelper::get(
            ['keyQuiero'=>'Su Default', ...],
            numberKeys:['campoNumerico1', ... ]
            noTrimKeys:[]
        );


    2.- Checar permisos
        if(!usuarioPuede())
            die("SIN PERMISO");

    3.-  Valida los datos:
        $errores = validateHelper($values);
        if(!empty($errores))
            die("ERRORES TRATA OTRA VEZ ": . dipslayErrores($errores);

<h3>Ajax responder basado en Ajax Helper</h3>
        Clase que la extiende debe:

            class NombreClase extends AjaxHelper {
                function __construct() { parent::__construct(); }
                implementar puedeHacerAccion checando permisos para cada acción
                implementar cada acción, obteniendo únicamente los datos necesarios, limpiando y validando datos
            }
            new NombreClase(); // Corre, y muere no continua

        en ajax helper debe tener
            abstract protected function puedeHacerAccion():bool;
            private function response() {...

</div>

<script>

    jQuery(function($){
        $("#testsuite").on('change', setCommand).trigger('change');
        $("#pathCoverage").on('change', setCommand).trigger('change');
    });
    function setCommand() {
        const prueba = document.getElementsByName("testsuite")[0].value;
        const element = document.getElementById("command");
        if(prueba.length===0) {
            $(element).css({visibility:"hidden"});
            return;
        }
        const pathCoverage = $("#pathCoverage").is(":checked") ? ' --path-coverage ' : '';
        const command = prueba.search('\/') > -1 ? "" : " --testsuite ";
        $(element).css({visibility:"visible"});
        element.innerHTML =
            "<div class='corriendo'>cd \\wamp\\www\\vitex<br>\ttests\\tester.bat " + pathCoverage + command + prueba +
            "</div>";
    }
    function running() {
        if(form !== null)
            form.setAttribute('hidden', '');
        const prueba = document.getElementsByName("testsuite")[0].value;
        const message = document.getElementById("msgrunning");
        message.innerHTML = `<h1 class='corriendo'>Probando: ${prueba}, ¡Paciencia!</h1>`;

        message.removeAttribute('hidden');
        $("#phpUnitFieldSet").hide();
        $("#resultados").hide();
        $("#patterns").hide();
    }
    const form = document.getElementById("runPhpUnit");
    if(form !== null)
        form.onsubmit = running;

    function scrollToTests() {document.getElementById('phpUnitFieldSet').scrollIntoView();}
    try {history.replaceState({content: document.title}, document.title, document.location.href);} catch(e) {}


</script>



</body>
</html>
