<?php

function component_solicitar_carta_porte($es_alta = true, $solicitud = [])
{
    $hayInconsistencias = false;
    if (isset($solicitud['iconsistencias']) and !empty($solicitud['iconsistencias'])) {
        // $solicitud['iconsistencias'] = json_decode($solicitud['iconsistencias'], true);
        $hayInconsistencias = true;
    }


    $shapeInconsistencias = [
        'cp_figuratransporte_id' => ['label' => 'Chofer', 'campo' => 'chofer_label', 'helper' => 'help_chofer'],
        'cp_autotransporte_id' => ['label' => 'Transporte', 'campo' => 'vehiculo_label', 'helper' => 'help_vehiculo'],
        'origen_id' => ['label' => 'Origen', 'campo' => 'origen_id', 'helper' => 'origen_help'],
    ];

    // dd_($solicitud);

    global $gAppRelate;
    // $bodegaIdSqlProtected = strit($bodega_id);

    $comment = basename( __FUNCTION__);
    // ia_singleread("SELECT /*$comment*/ IFNULL(MAX(numero)+1, 1) numero_solicitud FROM solicitud_carta_porte WHERE bodega_id = $bodegaIdSqlProtected")
    $current_numero_nota = ($es_alta) ? ia_singleread("SELECT /*$comment*/ IFNULL(MAX(numero)+1, 1) numero_solicitud FROM solicitud_carta_porte"): $solicitud['numero'];

    // $origen = json_decode(obtenCatalogo('origen_bodega', true), true);
    $sql_origen = "SELECT /*origenes*/
                        ob.origen_bodega_id, ob.clave, ob.origen_bodega_id as real_data,
                        IF( ob.es = 'Cliente' OR ob.es = 'IMPORTACION', ob.clave, IF (e.empresa IS NULL, ob.clave, CONCAT(ob.clave, ' (', e.empresa, ')' )) ) as label,
                        ob.origen_bodega_id as value,
                        ob.clave as origen,
                        ob.origen_bodega_id as origen_id,
                        IF(ob.extra_clave = 'grupo_bodega', 'GRUPO', ob.es) es,
                        ob.empresa_id,
                        ob.cp_cliente_direccion_id,
                        cp_cd.calle, cp_cd.numero_exterior, cp_cd.codigo_postal, cp_cd.colonia, cp_cd.municipio, cp_cd.estado,
                        CONCAT(
                            IF(cp_cd.calle IS NULL, '', cp_cd.calle), ' ', 
                            IF(cp_cd.numero_exterior IS NULL, '',cp_cd.numero_exterior), ', ', 
                            IF(cp_cd.codigo_postal IS NULL, '', cp_cd.codigo_postal), ' - ', 
                            IF(cp_cd.colonia IS NULL, '', cp_cd.colonia), ', ', 
                            IF(cp_cd.municipio IS NULL, '', cp_cd.municipio), ', ', 
                            IF(cp_cd.estado IS NULL, '', cp_cd.estado)
                        ) as direccion_fiscal,
                        cp_cd.cp_cliente_direccion_id as cp_cliente_direccion_id_real,
                        cp_cd.estado
                    FROM origen_bodega ob
                    LEFT JOIN cp_cliente_direccion cp_cd USING (cp_cliente_direccion_id)
                    LEFT JOIN empresa e ON ob.empresa_id=e.empresa_id
                    WHERE ob.activo = 'Si' AND ob.es <> 'CLIENTE'
                    ORDER BY ob.es, ob.clave";
    $origen = ia_sqlArrayIndx($sql_origen);
    // dd_($origen, $sql_origen);

    $documentos = $gAppRelate->enums['solicitud_carta_porte.documento'];
    unset($documentos['nada']);

    $tipo_generacion_cfdi = $gAppRelate->enums['solicitud_carta_porte.tipo_generacion_cfdi'];

    $productos_generales = json_decode(obtenCatalogo('producto_general_cp', true), true);

    // $colores_todos = ia_sqlArrayIndx(
    //     "SELECT /*$comment*/ color_id, color, color_valor, color_id as real_value, color as label, color as value FROM color WHERE activo = 'Si' ORDER BY orden,color");
    $colores =  json_decode(obtenCatalogo('color', true), true);
        // json_decode(obtenCatalogo('color', true), true);

    $conductores = json_decode(obtenCatalogo('cp_figuratransporte_scp', true), true);
    $conductor = ($es_alta) ? []: searchValueInArrayByColumn($solicitud['cp_figuratransporte_id'] ?? '', $conductores, 'figuratransporte_id');
    $conductores_por_empresa = objetivisa_($conductores, 'empresa_id');

    $vehiculos = json_decode(obtenCatalogo('cp_autotransporte_scp', true), true);
    $transporte = ($es_alta) ? []: searchValueInArrayByColumn($solicitud['cp_autotransporte_id'] ?? '', $vehiculos, 'autotransporte_id');

    $vehiculos_por_empresa = objetivisa_($vehiculos, 'empresa_id');

    $json_file_attachments = null;

    $tipo_movimiento = 'Salida';

    $pk_solicitud = 'solicitud_carta_porte_id';
    $pk_id = $solicitud[$pk_solicitud] ?? '';

    $solicitud_items = [];
    $destino = [];

    $notas = [];
    $items_por_nota = [];
    if (!$es_alta) {
        $solicitudDocumento = new SolicitudCartaPorte();
        $solicitud_items = $solicitudDocumento->getItems($pk_id);
//        $solicitud_enDB = $solicitudDocumento->getByID($pk_id);
        $json_file_attachments = $solicitud['json_file_attachments'];
        $solicitud['path4File'] = "../uploads/scp/$solicitud[solicitud_carta_porte_id]/";

        $query_destino="SELECT ob.*,
	                         ( SELECT
                                CONCAT(
                                    IF(cp_cd.calle IS NULL, '', cp_cd.calle), ' ', 
                                    IF(cp_cd.numero_exterior IS NULL, '',cp_cd.numero_exterior), ', ', 
                                    IF(cp_cd.codigo_postal IS NULL, '', cp_cd.codigo_postal), ' - ', 
                                    IF(cp_cd.colonia IS NULL, '', cp_cd.colonia), ', ', 
                                    IF(cp_cd.municipio IS NULL, '', cp_cd.municipio), ', ', 
                                    IF(cp_cd.estado IS NULL, '', cp_cd.estado)
                                ) FROM cp_cliente_direccion AS cp_cd WHERE cp_cd.cp_cliente_id = ob.cliente_id ORDER BY cp_cd. ultimo_cambio DESC  LIMIT 1
                            ) as direccion_fiscal,
                            (SELECT cp_cliente_direccion_id FROM cp_cliente_direccion AS cp_cd WHERE cp_cd.cp_cliente_id = ob.cliente_id ORDER BY cp_cd.ultimo_cambio DESC  LIMIT 1) AS cp_cliente_direccion_id_real,
                            (SELECT cp_cd.estado FROM cp_cliente_direccion AS cp_cd WHERE cp_cd.cp_cliente_id = ob.cliente_id ORDER BY cp_cd.ultimo_cambio DESC  LIMIT 1) as estado
                            FROM origen_bodega ob
                            -- left join cp_cliente_direccion ccd on ob.cp_cliente_direccion_id = ccd.cp_cliente_direccion_id 
                            where ob.origen_bodega_id = '$solicitud[destino_id]'";
        $destino = ia_singleton($query_destino);

        if ($destino['es'] === 'BODEGA' || $destino['es'] === 'TIENDA')
            $destino = searchValueInArrayByColumn($solicitud['destino_id'] ?? '', $origen, 'origen_bodega_id');

        $query_notas = "SELECT
                            nb.*,
                            pg.producto,
                            b.bodega as bodega,
                            ob.clave as destino,
                            CONCAT(cf.NombreFigura, ' - ', cf.RFCFigura) as conductor,
                            CONCAT(ca.PlacaVM, ', ', ca.descripcion, ' - ', ca.AnioModeloVM) as transporte,
                            u.unidad
                        FROM nota_bodega nb
                        JOIN producto_general pg USING (producto_general_id)
                        JOIN bodega b USING (bodega_id)
                        JOIN origen_bodega ob ON (ob.origen_bodega_id = nb.origen_id)
                        LEFT JOIN cp_autotransporte ca ON ca.autotransporte_id = nb.cp_autotransporte_id
                        LEFT JOIN cp_figuratransporte cf ON cf.figuratransporte_id = nb.cp_figuratransporte_id
                        LEFT JOIN unidades u USING(unidades_id)
                        WHERE nb.solicitud_carta_porte_id = '$pk_id'";
        $notas = ia_sqlArrayIndx($query_notas);

        if (!(empty($notas))) {
            $notas_id = array_column($notas, 'nota_bodega_id');
            $notas_id_string = parseClauseIn($notas_id);

             $query = "SELECT 
                    nbi.*,
                    pg.producto, c.color
                FROM nota_bodega_items nbi
                JOIN producto_bodega pb On nbi.producto_bodega_id = pb.producto_bodega_id
                JOIN producto_general pg On pg.producto_general_id = pb.producto_general_id
                JOIN color c ON pb.color_id = c.color_id
                WHERE nbi.nota_bodega_id IN ($notas_id_string)";
            // $items_por_nota = json_encode(objetivisa_(ia_sqlArrayIndx($query), 'nota_bodega_id'), JSON_HEX_TAG);
            $items_por_nota = objetivisa_(ia_sqlArrayIndx($query), 'nota_bodega_id');
        }
    }

    $empresas = json_decode(obtenCatalogo('empresa'), true);
    $forma_etiquetado = $gAppRelate->enums['forma_etiquetado'];

    $tipos_factura = $gAppRelate->enums['solicitud_carta_porte.tipo_factura'];

    $cuetas_bancarias = json_decode(obtenCatalogo('banco_cuenta'), true);

    $inconsistencias = $solicitud['iconsistencias'] ?? '{}';

?>
<style>
    #div_generado label, #div_generado input{
        cursor: pointer;
    }
    .input_con_inconsistencia {
        animation: infinite parpadeoBorder 1s;
    }
    @keyframes parpadeoBorder {
        0% {
            border: 1px solid #000000;
            box-shadow: none;
        }
        100% {
            border: 1px solid red;
            outline: 0;
            outline: thin dotted \9;
            box-shadow: inset 0 1px 1px rgb(0 0 0 / 8%), 0 0 8px rgb(140 18 36 / 60%);
        }
    }
    .input_con_inconsistencia_selectize {
        animation: infinite parpadeoBorderSelectize 1s;
    }
    @keyframes parpadeoBorderSelectize {
        0% {
            box-shadow: none;
        }
        100% {
            border: 1px solid red;
            outline: 0;
            outline: thin dotted \9;
            box-shadow: inset 0 1px 1px rgb(0 0 0 / 8%), 0 0 8px rgb(140 18 36 / 60%);
        }
    }
</style>
<div style="margin-top: 0.5em;">
    <input type="hidden" name="entrada_salida" id="entrada_salida" value="<?=ucfirst($tipo_movimiento)?>">
    <input type="hidden" name="tipo" id="tipo" value="Movimiento">
    <input type="hidden" name="bodega_id" id="bodega_id" value="">
    <input type="hidden" name="<?=$pk_solicitud?>" id="<?=$pk_solicitud?>" value="<?=$pk_id ?? ''?>">
    <fieldset class="flexRow lblgrp" id="main_cotent">
        <legend class="bold"><?=$es_alta ? 'Nueva solicitud': 'Edita solicitud'?></legend>
        <div class="flexItem content_description_nota">
                <fieldset>
                    <legend class="bold">Datos Origen/Destino</legend>
                    <div class="flexRow">
                        <div class="flexItem" id="div_origen">
                            <label for="origen_id" title="Origen" class="bold lbl">* Origen</label>
                            <br>
                            <select class="selectize input inputEntrada" name="origen_id" id="origen_id" style="width: 220px;">
                                <option value="">Seleccione</option>
                                <?=array2Select($origen, 'origen_bodega_id', 'label', onlyOptions: true, addNull: false, group:'es', extra_data:['empresa_id', 'estado', 'direccion_fiscal', 'cp_cliente_direccion_id'], set_val:($solicitud['origen_id']??''))?>
                            </select>
                            <br>
                            <div id="origen_help" style="width: 190px;font-size: 9px; height: 65px"></div>
                        </div>
                        <div class="flexItem" id="div_destino">
                            <label for="destino_label" title="Origen de entrada" class="bold lbl">* Destino</label>
                            <label for="show_clientes" style="float: right" class="bold lbl"><input tabindex="-1" type="checkbox"  id="show_clientes"  class="noTab"><small>Clientes</small></label>
                            <br>
                            <input name="destino_label" id="destino_label" type="text" autocomplete="off" class="input inputEntrada" data-campo="destino_label" value=""/>
                            <span style="cursor:pointer;" title="Ir A Google maps" onclick="goto_google_maps();">&#127760;</span>
                            <br><i><small><a href="<?=getUrlTo('backoffice/cp_cliente.php?iah=a')?>" target="_blank" tabindex="-1">Agregar Cliente</a></small></i>
                            <input type="hidden" id="destino_id" name="destino_id">
                            <br>
                            <div id="destino_help" style="width: 130px;font-size: 9px; height: 65px"></div>
                            <!--<select class="selectize input inputEntrada" name="destino_id" id="destino_id">
                                <option value="">Seleccione</option>
                            </select>-->
                        </div>
                        <div class="flexItem" id="div_documento">
                            <label for="documento" title="Documento a Solicitar" class="bold lbl">* Documento</label>
                            <br>
                            <select class="selectize input inputEntrada" name="documento" id="documento" style="width: 220px;">
                                <option value="">Seleccione</option>
                                <?=ia_Options_array($documentos, $solicitud['documento'] ?? '')?>
                            </select>
                        </div>
                        <div class="flexItem" id="div_tipo_generacion_cfdi">
                            <label for="tipo_generacion_cfdi" title="Tipo de Timbrado" class="bold lblnotice">* Tipo de Timbrado</label>
                            <br>
                            <select class="selectize input inputEntrada" name="tipo_generacion_cfdi" id="tipo_generacion_cfdi" style="width: 250px;">
                                <option value="">Seleccione</option>
                                <?=ia_Options_array($tipo_generacion_cfdi, $solicitud['tipo_generacion_cfdi'] ?? 'inmediato')?>
                            </select>
                        </div>
                        <div class="flexItem hidden">
                            <label for="fecha_hora_salida_llegada" class="bold lblnotice">* Hora de salida</label>
                            <br>
                            <input type="text" name="fecha_hora_salida_llegada" id="fecha_hora_salida_llegada" class="input inputEntrada" value="<?=$solicitud['fecha_hora_salida_llegada']??''?>">
                        </div>
                        <div class="flexItem hidden">
                            <label for="duracion_viaje" class="bold lblnotice">* Tiempo de Viaje(HH:mm)</label>
                            <br>
                            <input type="text" name="duracion_viaje" id="duracion_viaje" class="input inputEntrada" value="<?=$solicitud['duracion_viaje']??''?>">
                        </div>
                        <div class="flexItem hidden">
                            <label for="distancia_recorrida" class="bold lblnotice">* Distancia (Km)</label>
                            <br>
                            <input type="text" name="distancia_recorrida" id="distancia_recorrida" class="input inputEntrada" value="<?=$solicitud['distancia_recorrida']??''?>">
                        </div>
                    </div>
                </fieldset>
                <fieldset style="margin-top: 10px;">
                    <details <?=$es_alta? 'open': ''?>>
                        <summary style="color: black;WIDTH: fit-content;margin-top: -5px;">
                            <legend class="bold">Producto <i class="vx_icon vx_icon_caret_down" style="margin-left: 2em;"></i></legend>
                        </summary>
                        <div class="flexRow">
                            <div class="flexItem" id="div_producto">
                                <label for="producto_general_label" title="Categoría de producto" class="bold lbl" id="label_for_producto">* <i>P</i>roduct</label>
                                <br>
                                <input name="producto_general_label" id="producto_general_label" type="text" autocomplete="off" class="input inputEntrada" data-campo="producto_general_label" value="" accesskey="P"/>
                                <input name="producto_general_id" id="producto_general_id" type="hidden" data-campo="producto_general_id" value=""/>
                                <br><span style="color:red;display:none" id="notaBodegaAvisos_nuevoProducto">¡Nuevo en Bodega!</span>
                            </div>
                            <div class="flexItem" id="div_color">
                                <label for="color_label" title="Color del producto" class="bold lbl" id="label_for_color">* <i><u>C</u></i>olores</label>
                                <br>
                                <input name="color_label" id="color_label" type="text" autocomplete="off" class="input inputEntrada" data-campo="color_label" value="" accesskey="C"/>
                                <input type="hidden" id="color_id_selected" name="color_id_selected">
                                <br><span style="color:red;display:none" id="notaBodegaAvisos_nuevoColor">¡Nuevo Color!</span>
                            </div>
                        </div>
                        <div class="flexRow">
                            <div class="flexItem" id="div_rollos">
                                <label for="rollos" title="Número de rollos" class="bold lbl">* <i><u>R</u></i>ollos</label>
                                <br>
                                <input name="rollos" id="rollos" class="auto ignore-val input inputEntrada" style="width:6em" data-autonumeric="{mNum:10,mDec:0,aSep:',',vMax:9999999999.99}" type="text" size="14" autocomplete="off" value="" accesskey="R">
                                <br><span style="color:red;display:none" id="notaBodegaAvisos_negativo_rollos">¡Falta!</span>
                            </div>
                            <div class="flexItem" id="div_quantity">
                                <label for="quantity" title="Monto" class="bold lbl">* <i><u>Q</u></i>uantity <span id="unidad_label"></span></label>
                                <br>
                                <input name="quantity" id="quantity" class="auto ignore-val input inputEntrada" style="width:6em" data-autonumeric="{mNum:10,mDec:2,aSep:',',vMax:9999999999.99}" type="text" size="14" autocomplete="off" value="" accesskey="Q">
                                <br><span style="color:red;display:none" id="notaBodegaAvisos_negativo_quantity">¡Falta!</span>
                            </div>
                            <div class="flexItem" id="div_button" style="float:right">
                                <button id="btn_add" type="button" class="btn btnGenerar-comodin" onclick="carta_porte.agregaColor()" style="float:right">Agregar Color</button>
                            </div>
                        </div>
                    <!--<div class="flewRow" style="float:right">
                        <div class="flexItem" id="div_button">
                            <button id="btn_add" type="button" class="btn btn_add_color_solicitud" onclick="carta_porte.agregaColor()">Agregar Color</button>
                        </div>
                    </div>-->
                    </details>
                </fieldset>
                <fieldset>
                    <legend class="bold">Datos Generales</legend>
                    <div class="flexRow">
                        <div class="flexItem" id="div_numnota">
                            <label for="numero" title="Número de Nota" class="bold lbl">* # Solicitud</label>
                            <br>
                            <input name="numero" id="numero" class="auto ignore-val input inputEntrada" data-autonumeric="{mNum:10,mDec:0,aSep:'',vMax:9999999999.99}" type="text" style="width:5em" autocomplete="off" value="<?=$current_numero_nota?>" accesskey="N" <?=!$es_alta ? 'disabled':''?>>
                        </div>
                        <div class="flexItem" id="div_fecha">
                            <label for="fecha" title="Fecha de la Nota" class="bold lbl" >* Fecha</label>
                            <br>
                            <input type="text" id="fecha" name="fecha" required="required" class="input inputEntrada" style="width:7em" value="<?=date('d-m-Y')?>">
                        </div>
                        <div class="flexItem" id="div_paid">
                            <label for="paid" title="Paid" class="bold lbl"> Paid</label>
                            <br>
                            <input name="paid" id="paid" type="checkbox" autocomplete="off" value="1">
                        </div>
<!--                        <div style="width: 100%;"></div>-->
                        <div class="flexItem" id="div_contra_nota" style="">
                            <label for="contra_nota_bodega_id" title="Contra Nota" class="bold lbl"> Contra Nota</label>
                            <br>
                            <input name="contra_nota_bodega_id" id="contra_nota_bodega_id" class="ignore-val input inputEntrada" type="text" style="width:5em" autocomplete="off" value="" accesskey="">
                        </div>
                        <div class="flexItem" id="div_para_quien" style="">
                            <label for="para_quien" title="Para Quién" class="bold lbl"> Para Quién</label>
                            <br>
                            <input name="para_quien" id="para_quien" class="ignore-val input inputEntrada" type="text" style="width:10em" autocomplete="off" value="">
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend class="bold">Datos Carta Porte</legend>
                    <div class="flexRow">
                        <div class="flexItem" id="div_chofer">
                            <label for="chofer_label" title="Conductor" class="bold lbl">* Chofer</label>
                            <br>
                            <input name="chofer_label" id="chofer_label" class="ignore-val input inputEntrada" type="text" autocomplete="off" value="">
                            <input name="cp_figuratransporte_id" id="cp_figuratransporte_id" class="ignore-val input inputEntrada" type="hidden" autocomplete="off" value="">
                            <br><div id="help_chofer" style="width: 250px; font-size: 11px; height: 20px; margin-top: 3px;"></div>
                        </div>
                        <div class="flexItem" id="div_vehiculo">
                            <label for="vehiculo_label" title="Transporte" class="bold lbl">* <i><u>T</u></i>ransporte</label>
                            <br>
                            <input name="vehiculo_label" id="vehiculo_label" class="ignore-val input inputEntrada" type="text" autocomplete="off" value="" accesskey="T">
                            <input name="cp_autotransporte_id" id="cp_autotransporte_id" class="ignore-val input inputEntrada" type="hidden" autocomplete="off" value="">
                            <br><div id="help_vehiculo" style="width: 250px; font-size: 11px; height: 20px; margin-top: 3px;"></div>
                        </div>
                        <div style="width: 100%;"></div>
                        <div class="flexItem" id="div_json_file_attachments" style="">
                            <label for="json_file_attachments" title="Archivos adjuntos" class="bold lbl"> Archivos adjuntos</label>
                            <br>
                            <!--<input name="json_file_attachments" id="json_file_attachments" class="ignore-val input inputEntrada" type="file" multiple="multiple">-->
                            <div class="custom_file">
                                <!--<input class="custom_file_input" name="icon" id="icon" type="file" class="multi max-2" accept=".jpg,.png,.gif,.jpeg,.ico" autocomplete="off">-->
                                <input name="json_file_attachments" id="json_file_attachments" class="custom_file_input" type="file" multiple="multiple">
                                <label class="custom_file_label_icon" for="icon" id="label_for_icon">Elige archivos</label>
                            </div>
                        </div>

                        <div class="flexItem" id="div_numero_cfdi" style="">
                            <label for="numero_cfdi" title="Número de CFDI" class="bold lbl"> No. CFDI</label>
                            <br>
                            <input name="numero_cfdi" id="numero_cfdi" class="ignore-val input inputEntrada" type="text" style="width:10em" autocomplete="off" value="<?=$solicitud['numero_cfdi'] ?? ''?>">
                        </div>

                        <div class="flexItem" id="div_generado">
                            <label for="generado" title="Generado" class="bold lbl"> Generado</label>
                            <br>
                            <input name="generado" id="generado" type="checkbox" <?=($solicitud['generado'] ?? 'No') == 'Si' ? 'checked': ''?>>
                        </div>

                        <div class="flexItem" id="div_file_attachments" style="">
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend class="bold">Datos Etiquetado</legend>
                    <div class="flexRow">
                        <div class="flexItem" id="div_confirmacion_etiquetado">
                            <label for="confirmacion_etiquetado" title="Confirmación de Etiquetado" class="bold lbl"> Etiquetado</label>
                            <br>
                            <input name="confirmacion_etiquetado" id="confirmacion_etiquetado" type="checkbox" autocomplete="off" <?=(($solicitud['confirmacion_etiquetado'] ?? 'No') == 'Si')?'checked':''?>>
                        </div>
                        <div class="flexItem" id="div_empresa_id_etiquetado">
                            <label for="empresa_id_etiquetado" title="Empresa de Etiquetado" class="bold lbl"> Empresa</label>
                            <br>
                            <select class="selectize input inputEntrada" name="empresa_id_etiquetado" id="empresa_id_etiquetado">
                                <option value="">Seleccione</option>
                                <?=ia_Options_array($empresas, $solicitud['empresa_id_etiquetado'] ?? '')?>
                            </select>
                        </div>
                        <div class="flexItem" id="div_forma_etiquetado">
                            <label for="forma_etiquetado" title="Empresa de Etiquetado" class="bold lbl"> Tipo</label>
                            <br>
                            <select class="selectize input inputEntrada" name="forma_etiquetado" id="forma_etiquetado">
                                <option value="">Seleccione</option>
                                <?=ia_Options_array($forma_etiquetado, $solicitud['forma_etiquetado'] ?? '')?>
                            </select>
                        </div>
                        <div class="flexItem" id="div_responsable_etiquetado" style="">
                            <label for="responsable_etiquetado" title="Para Quién" class="bold lbl"> Responsable</label>
                            <br>
                            <input name="responsable_etiquetado" id="responsable_etiquetado" class="ignore-val input inputEntrada" type="text" style="width:10em" autocomplete="off" value="<?=$solicitud['responsable_etiquetado'] ?? ''?>">
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend class="bold">Datos Facturación</legend>
                    <div class="flexRow">
                        <div class="flexItem" id="div_tipo_factura">
                            <label for="tipo_factura" title="Tipo de Factura" class="bold lbl">* Tipo de Factura</label>
                            <br>
                            <select class="selectize input inputEntrada" name="tipo_factura" id="tipo_factura">
                                <option value="">Seleccione</option>
                                <?=ia_Options_array($tipos_factura, $solicitud['tipo_factura'] ?? '')?>
                            </select>
                        </div>
                        <div class="flexItem" id="div_numero_factura">
                            <label for="numero_factura" title="Número de Factura" class="bold lbl"> # Factura</label>
                            <br>
                            <input name="numero_factura" id="numero_factura" class="auto ignore-val input inputEntrada" style="width:6em" data-autonumeric="{mNum:10,mDec:0,aSep:'',vMax:9999999999.99}" type="text" size="14" autocomplete="off" value="<?=$solicitud['numero_factura'] ?? ''?>">
                        </div>
                        <div class="flexItem" id="div_cuenta_bancaria">
                            <label for="banco_cuenta_id" title="Cuenta Bancaria" class="bold lbl"> Cuenta Bancaria</label>
                            <br>
                            <select class="selectize input inputEntrada" name="banco_cuenta_id" id="banco_cuenta_id">
                                <option value="">Seleccione</option>
                                <?=ia_Options_array($cuetas_bancarias, $solicitud['banco_cuenta_id'] ?? '')?>
                            </select>
                        </div>

                        <div class="flexItem" id="div_monto_deposito">
                            <label for="monto_deposito" title="Monto" class="bold lbl"> Monto</label>
                            <br>
                            <input name="monto_deposito" id="monto_deposito" class="auto ignore-val input inputEntrada" style="width:8em" data-autonumeric="{mNum:10,mDec:2,aSep:',',vMax:9999999999.99}" type="text" size="14" autocomplete="off" value="" accesskey="Q">
                        </div>


                    </div>
                </fieldset>
                <div class="flexRow">
                    <div class="flexItem" id="div_remarks">
                        <label for="remarks" title="Remarks" class="bold lbl"> Remarks</label>
                        <br>
                        <textarea name="remarks" id="remarks" class="iafck"></textarea>
                    </div>
                </div>
                <div class="flexRow">
                    <div class="flexItem hide" id="div_remarks_paid">
                        <label for="remarks_paid" title="Remarks Paid" class="bold lbl"> Remarks Paid</label>
                        <br>
                        <textarea name="remarks_paid" id="remarks_paid" class="iafck"></textarea>
                    </div>
                </div>
        </div>

        <div class="flexItem">
            <div class="flexRow">
                <div style="margin:auto;width:100%;">
                    <table id="table_entrada_productos"></table>
                    <div id="pager_entrada_productos"></div>
                </div>
            </div>
            <div class="flexRow">
                <div class="flexItem" id="div_guardarnota">
                    <button id="btn_save_entry" type="submit" class="btn  btnGenerar-comodin btnGenerar-comodin-change "><?=($es_alta) ? 'Guardar Solicitud': 'Guardar Cambios'?></button>
                </div>
                <div class="flexItem" id="div_cancelarnota">
                    <button id="btn_cancel_entry" type="button" class="btn btnGenerar-comodin" " onclick="<?=($es_alta) ? 'carta_porte.cancelar()': 'carta_porte.restoreSolicitud()'?>"><?=($es_alta) ? 'Cancelar Solicitud': 'Cancelar Cambios'?></button>
                </div>
            </div>
            <?php if (!empty($notas)):?>
                <div class="flexRow" style="margin-top: 2em;">
                    <br><br>
                    <a href="#div_notas">NOTAS</a>
                </div>
            <?php endif;?>
            <?php if ($hayInconsistencias):?>
                <div class="flexRow" style="margin-top: 2em;">
                    <br><br>
                    <ul><?=$solicitud['iconsistencias_text']?></ul>
                </div>
            <?php endif;?>
        </div>
        <?php if (!empty($notas)):?>
        <div class="flexRow" id="div_notas">
            <div style="margin:auto;width:100%;">
                <table id="table_notas"></table>
                <div id="pager_notas"></div>
            </div>
        </div>
        <?php endif;?>

    </fieldset>
</div>

<script>
    var gridhandlerProductosEntrada, gridhandler, gridhandlerNotas,
        es_alta = <?=$es_alta ? 'true' : 'false'?>,
        solicitud_items = [],
        solicitud = null,
        productos_generales = null,
        colores = null,
        conductores = null,
        conductor = null,
        conductores_por_empresa = null,
        vehiculos = null,
        trasnporte = null,
        vehiculos_por_empresa = null,
        json_file_attachments = null,
        pathApp = "../backoffice/",
        origen_destinos = [],
        cp_cliente_direccion_id_origen = null,
        cp_cliente_direccion_id_destino = null,
        destino = [],

        notas = [],
        items_por_nota = [],
        prefixContainerNotas = 'table_notas_',

        responsable_etiquetado_me = "<?=$_SESSION['usuario']?>",
        estado_origen = '',
        estado_destino = '',

        empresa_origen = '',
        empresa_chofer = '',
        empresa_transporte = '',
        empresa_etiquetado = '',

        hayInconsistencias = <?=var_export($hayInconsistencias)?>;
        shapeInconsistencias = <?=json_encode($shapeInconsistencias)?>;
        inconsistencias = <?=empty($inconsistencias) ? '{}': $inconsistencias?>,
        is_onload = true;

    $(function () {

        solicitud = (es_alta) ? null: <?=json_encode($solicitud)?>;
        conductor = (!es_alta) ? <?=json_encode($conductor)?> : null;
        trasnporte = (!es_alta) ? <?=json_encode($transporte)?> : null;

        productos_generales = <?=json_encode($productos_generales)?>;
        colores = <?=json_encode($colores)?>;
        conductores = <?=json_encode($conductores)?>;

        conductores_por_empresa = <?=json_encode($conductores_por_empresa)?>;
        vehiculos = <?=json_encode($vehiculos)?>;
        vehiculos_por_empresa = <?=json_encode($vehiculos_por_empresa)?>;

        origen_destinos = origen_destinos = <?=json_encode($origen)?>;

        destino = <?=json_encode($destino)?>;

        solicitud_items = <?=json_encode($solicitud_items)?>;
        json_file_attachments = <?=json_encode($json_file_attachments)?>;
        if(typeof json_file_attachments === "string" && json_file_attachments.length)
            json_file_attachments = JSON.parse(json_file_attachments);


        carta_porte.initControlles();
        carta_porte.initjqGRidProductosNota();

        if (!es_alta) {
            notas = <?=json_encode($notas, JSON_HEX_TAG)?>;
            items_por_nota = <?=json_encode($items_por_nota, JSON_HEX_TAG)?>;

            if (notas.length > 0)
                carta_porte.initJqGridNotas();

            setTimeout(function () {
                $.each(inconsistencias, function (key, value) {
                    let shape = shapeInconsistencias[key],
                        field = $('#'+shape.campo);
                    if (field.hasClass('selectize')) {
                        field.next().find('.selectize-input').addClass('input_con_inconsistencia_selectize');
                    } else {
                        field.addClass('input_con_inconsistencia');
                    }

                    if (shape.helper)
                    {
                        if (shape.helper === 'origen_help') {
                            $('#'+shape.helper).append('<p id="inconsistencia_origen">'+value+'</p>');
                        } else {
                            $('#'+shape.helper).html(value);
                        }
                    }
                });
                if (!hayInconsistencias) {
                    console.log('revisa');
                    carta_porte.inconsistenciaEmpresas();
                }

            }, 0);
        }

        $('#div_json_file_attachments').on({
            dragenter: function(e) {
                $(this).css('background-color', 'lightBlue');
            },
            dragleave: function(e) {
                $(this).css('background-color', 'white');
            },
            drop: function(e) {
                e.stopPropagation();
                e.preventDefault();
                //console.log(e.originalEvent.dataTransfer.files);
                doAdjuntarAchivos(e);
            }
        });
        is_onload= false;

    });

    function goto_google_maps(){
        var direccion = $('#destino_help i').text();

        var gm_url = encodeURIComponent(direccion);
        console.log(gm_url);
        window.open('https://www.google.com/maps/place/' + gm_url +'/');
    }

    const carta_porte = {

        rules_items: {
            'producto_general_id': {
                'required': true,
                'label': 'Product',
                'focusAfter': 'producto_general_label'
            },
            'color_id': {
                'required': true,
                'label': 'Color',
                'focusAfter': 'color_label'
            },
            'rollos': {
                'required': true,
                'label': 'Rollos',
                'numeric': true,
                'min': 1
            },
            'quantity': {
                'required': true,
                'label': 'Quantity',
                'numeric': true,
                'min': 1
            },
        },

        rules_solicitud: {
            'origen_id': {
                'required': true,
                'label': 'Origen',
                'focusAfter': 'origen_id'
            },
            'destino_id': {
                'required': true,
                'label': 'Destino',
                'focusAfter': 'destino_label'
            },
            'documento': {
                'required': true,
                'label': 'Documento',
            },
            'tipo_generacion_cfdi': {
                'required': true,
                'label': 'Tipo de Timbrado',
            },
            'numero': {
                'required': true,
                'label': 'Número de solicitud'
            },
            'fecha': {
                'required': true,
                'label': 'Fecha'
            },
            'cp_figuratransporte_id': {
                'required': true,
                'label': 'Chofer',
                'focusAfter': 'chofer_label'
            },
            'cp_autotransporte_id': {
                'required': true,
                'label': 'Transporte',
                'focusAfter': 'vehiculo_label'
            },
            /*'empresa_id_etiquetado': {
                'required': true,
                'label': 'Empresa de Etiquetado',
            },
            'forma_etiquetado': {
                'required': true,
                'label': 'Tipo de Etiquetado',
            },
            'responsable_etiquetado': {
                'required': true,
                'label': 'Responsable de Etiquetado',
            }*/
        },

        initControlles: function () {
            var _me = this;
            //$('#origen_id')[0].selectize.open();
            $('#origen_id').change(function () {
                // carta_porte.setDestinos(this.value);
                if (empty(this.value)) {
                    $('#origen_help').html('');
                    cp_cliente_direccion_id_origen = '';
                    estado_origen = '';
                    empresa_origen = '';
                } else {
                    let optionSelected = $(this).find(':selected');
                    let optionData = optionSelected.data();

                    estado_origen = optionData.estado;
                    empresa_origen = optionData.empresa_id;

                    $('#origen_help').html(`<i>${optionData.direccion_fiscal||''}</i>`);
                    cp_cliente_direccion_id_origen = optionData.cp_cliente_direccion_id || '';
                }
                _me.setTypeDocument();

                _me.inconsistenciaEmpresas();

                /*let empresa_id = optionSelected.data('empresa_id');
                $("#chofer_label").autocomplete('option', 'source', conductores_por_empresa[empresa_id] || []);
                $("#vehiculo_label").autocomplete('option', 'source', vehiculos_por_empresa[empresa_id] || []);*/
            });

            $d.initAutoComplete('#destino_label', origen_destinos, '#destino_id', function (item) {
                if (item != null) {
                    destino = item;
                    estado_destino = destino.estado;

                    $('#destino_help').html(`<i>${item.direccion_fiscal||''}</i>`);
                    cp_cliente_direccion_id_destino = item.cp_cliente_direccion_id || '';
                } else {
                    cp_cliente_direccion_id_destino = '';
                    estado_destino = '';
                }

                _me.setTypeDocument();
            });
            $('#show_clientes').click(function () {
                if (this.checked) {
                    $("#destino_label").autocomplete('option', 'source', []);
                    $("#destino_label").autocomplete("destroy");
                    $("#destino_label").removeData('autocomplete');
                    var configAutoComplete = {
                        url: getUrlForAjax('movimientos_bodega_acciones.php'),
                        accion: 'busca_cliente_cp',
                        campos: ['clave', 'extra_clave']
                    };
                    $d.initAutoCompleteAjax('#destino_label', configAutoComplete, '#destino_id', function (item) {
                        // console.log(item)
                        if (item != null) {
                            destino = item;
                            estado_destino = destino.estado;
                            let url= getUrlBase(`/backoffice/cp_cliente.php?id=${item.cliente_id}&iagridvar=iajqgridcp_cliente_var&iah=e`);
                            $('#destino_help').html(`<b>RFC: ${item.rfc}</b><br><i>${item.direccion_fiscal||''}</i><a href="${url}" target="_blank" type='button' class="btn"><span class='ui-icon ui-icon-pencil'></span></a>`);
                            cp_cliente_direccion_id_destino = item.cp_cliente_direccion_id || '';
                        } else {
                            cp_cliente_direccion_id_destino = '';
                            estado_destino = '';
                        }
                        _me.setTypeDocument();
                    });
                } else {
                    $("#destino_label").autocomplete("destroy");
                    $("#destino_label").removeData('autocomplete');
                    $d.initAutoComplete('#destino_label', origen_destinos, '#destino_id', function (item) {
                        if (item != null) {
                            destino = item;
                            estado_destino = destino.estado;

                            $('#destino_help').html(`<i>${item.direccion_fiscal||''}</i>`);
                            cp_cliente_direccion_id_destino = item.cp_cliente_direccion_id || '';
                        } else {
                            cp_cliente_direccion_id_destino = '';
                            estado_destino = '';
                        }

                        _me.setTypeDocument();
                    });
                }
                $('#destino_label').focus().select();
            });

            let inputs_hidden_viaje = ['fecha_hora_salida_llegada', 'duracion_viaje', 'distancia_recorrida'];
            $('#documento').change(function () {
                if (this.value === 'carta_porte') {
                    inputs_hidden_viaje.forEach(function (_this, i) {
                        $('#'+ _this).parent().show();
                    });
                }
                else {
                    inputs_hidden_viaje.forEach(function (_this, i) {
                        $('#'+ _this).val('');
                        $('#'+ _this).parent().hide();
                    });
                }
            });

            $('#div_tipo_generacion_cfdi').width('200');
            setTimeout(function () {
                $('#div_tipo_generacion_cfdi').find('.selectize-control.single').width('200');
            }, 10);


            $('#generado').click(function () {
                if (this.checked) {
                    $('label[for=numero_cfdi]').prepend('*');
                } else {
                    $('label[for=numero_cfdi]').text($('label[for=numero_cfdi]').text().replaceAll('*', ''));
                }
            });




            $d.initAutoComplete('#producto_general_label', productos_generales, '#producto_general_id', function (item) {
                if (item!= null) {
                    $('#unidad_label').text('').text("("+item.unidad+")");
                    $('#unidades-table').text('').text(item.unidad);
                    setTimeout(() => {$('#color_label').focus().select();}, 10);
                }

                // productoCambio(item);
                // $('#producto_label').val(item.label);
            });

            $d.initAutoComplete('#color_label', colores, '#color_id_selected', function (item) {
                setTimeout(() => {$('#rollos').focus().select();}, 10);
                // notaBodegaAvisos.cambiaColorRollosQuantity();
                // $('#color_label').val(item.label);
            });

            $('#rollos').val('');
            $('#quantity').val('');

            $d.initDatePicker('#fecha', null, (es_alta ? null: solicitud.fecha));

            $('#paid').click(function (){
                $('#div_remarks_paid').toggleClass('hide');
            });


            // Para set nuevo source
            // $( "#chofer_label" ).autocomplete('option', 'source', conductores_por_empresa[17]);
            $('#chofer_label').blur(function () {
                if (empty(this.value)) {
                    $('[for=chofer_label]').text("* Chofer");
                    empresa_chofer = '';
                    _me.inconsistenciaEmpresas();
                }
            });
            $d.initAutoComplete('#chofer_label', conductores, '#cp_figuratransporte_id', function (chofer) {
                let label_chofer = $('[for=chofer_label]');
                if (!empty(chofer)) {
                    // $('#help_chofer').html('').html(chofer.empresa ?? '').show();
                    label_chofer.text("* Chofer de "+(chofer.empresa || ''));
                    empresa_chofer = chofer.empresa_id;
                } else {
                    label_chofer.text('* Chofer');
                    empresa_chofer = '';
                    // $('#help_chofer').html('').hide();
                }
                _me.inconsistenciaEmpresas();
                setTimeout(() => {$('#vehiculo_label').focus().select();}, 10);
            }, 350, 'value');
            // $("#chofer_label").autocomplete('option', 'source', []);

            $('#vehiculo_label').blur(function () {
                if (empty(this.value)) {
                    $('[for=vehiculo_label]').text("* Transporte");
                    empresa_transporte = '';
                    _me.inconsistenciaEmpresas();
                }
            });
            $d.initAutoComplete('#vehiculo_label', vehiculos, '#cp_autotransporte_id', function (vehiculo) {
                let label_vehiculo = $('[for=vehiculo_label]');
                if (!empty(vehiculo)) {
                    label_vehiculo.text("* Transporte "+vehiculo.descripcion + " - " + (vehiculo.empresa || ''));
                    empresa_transporte = vehiculo.empresa_id;
                    // $('#help_vehiculo').html('').html(vehiculo.descripcion + " - " + vehiculo.empresa ?? '').show();
                } else {
                    label_vehiculo.text("* Transporte");
                    empresa_transporte = '';
                    // $('#help_vehiculo').html('').hide();
                }
                _me.inconsistenciaEmpresas();
            }, 200, 'value');
            // $("#vehiculo_label").autocomplete('option', 'source', []);

            $('#confirmacion_etiquetado').click(function () {
                if (this.checked) {
                    $('#responsable_etiquetado').val(responsable_etiquetado_me);
                } else {
                    $('#responsable_etiquetado').val('');
                }
            });
            $('#empresa_id_etiquetado').change(function () {
                empresa_etiquetado = this.value;
                _me.inconsistenciaEmpresas();
            });


            if (!es_alta) {
                estado_destino = destino.estado || '';
                $('#origen_id').change();
                $('#destino_label').val(destino.clave);
                $('#destino_id').val(solicitud.destino_id);
                let url= getUrlBase(`/backoffice/cp_cliente.php?id=${destino.cliente_id || ''}&iagridvar=iajqgridcp_cliente_var&iah=e`);

                $('#destino_help').html(`<b>RFC: ${destino.extra_clave}</b><br><i>${destino.direccion_fiscal||''}</i><a href="${url}" target="_blank" type='button' class="btn"><span class='ui-icon ui-icon-pencil'></span></a>`);
                if (destino.es == 'CLIENTE') {
                    $('#show_clientes').click();
                    $('#destino_label').blur();
                }
                // cp_cliente_direccion_id_destino = item.cp_cliente_direccion_id || '';

                cp_cliente_direccion_id_destino = destino.cp_cliente_direccion_id;

                if (solicitud.paid != '0' || solicitud.paid != 0) {
                    $('#paid').prop('checked', true);
                    $('#div_remarks_paid').removeClass('hide').show();
                }

                $('#contra_nota_bodega_id').val(solicitud.contra_nota_bodega_id);
                $("#para_quien").val(solicitud.para_quien);

                $('#chofer_label').val(conductor.NombreFigura);
                $('#cp_figuratransporte_id').val(conductor.figuratransporte_id);
                $('[for=chofer_label]').text("* Chofer de "+ conductor.empresa || '');
                empresa_chofer = conductor.empresa_id||'';
                // $('#help_chofer').html('').html(conductor.empresa ?? '').show();

                $('#vehiculo_label').val(trasnporte.PlacaVM);
                $('#cp_autotransporte_id').val(trasnporte.autotransporte_id);
                $('[for=vehiculo_label]').text("* Transporte "+ (trasnporte.descripcion + " - " + trasnporte.empresa || ''));
                empresa_transporte = trasnporte.empresa_id||'';
                // $('#help_vehiculo').html('').html(trasnporte.descripcion + " - " + trasnporte.empresa ?? '').show();

                $('#remarks').val(solicitud.remarks);
                $('#remarks_paid').val(solicitud.remarks_paid);

                $("#json_file_attachments").off('change').on('change', doAdjuntarAchivos);
                carga_json_file_attachments(solicitud, "div_file_attachments");


                setTimeout(() => {
                    tinymce.get('remarks').setContent(solicitud.remarks);
                    tinymce.get('remarks_paid').setContent(solicitud.remarks_paid);

                    tinymce.triggerSave();
                }, 500);

                if (solicitud.documento === 'carta_porte') {
                    inputs_hidden_viaje.forEach(function (_this, i) {
                        $('#'+ _this).parent().show();
                    });
                }

            }

            $('input, select, textarea, text').change(function () {
                $('#btn_save_entry').css('background', '#20cd98')
            });

        },

        setTypeDocument: function ()
        {
            console.log(is_onload);
            if (!is_onload) {
                console.log('entre');
                let $documento = $('#documento');
                if (empty(estado_origen) || empty(estado_destino)) {
                    setTimeout(function () {
                        $documento[0].selectize.setValue('');
                    }, 0)
                    return;
                }

                if (estado_origen.strcasecmp(estado_destino) === 0) {
                    setTimeout(function () {
                        $documento[0].selectize.setValue('cfdi_traslado');
                    },0);
                } else {
                    setTimeout(function () {
                        $documento[0].selectize.setValue('carta_porte');
                        $documento.trigger('change');
                    },0);
                }
            }
        },

        setDestinos: function (origen_id)
        {
            if (empty(origen_id))
                return;

            let request = {
                url: getUrlForAjax('bodega_acciones.php'),
                data: {
                    accion: 'obtenDestinos',
                    origen_id: origen_id
                }
            };
            jqAjax(request,
                (response) => {
                    let optionsSelect = getSelect(response.origen_destino, 'origen_bodega_id', 'clave', null, '', '', true, [], 'es');
                    $('#destino_id')[0].selectize.destroy();
                    $('#destino_id').html(optionsSelect).selectize();
                    if (!es_alta) {
                        $('#destino_id')[0].selectize.setValue(solicitud.destino_id);
                    }
                },
                (fail, thrownError) => {
                    ia.alertError(
                        ((fail.responseJSON) ? fail.responseJSON.message : undefined) ?? fail.responseText ?? thrownError,
                        "Error: " + (((fail.responseJSON) ? fail.responseJSON.code : undefined) ?? fail.status ?? ''),
                        true
                    );
                }
            );
        },

        initjqGRidProductosNota: function ()
        {
            gridhandlerProductosEntrada = gridhandler = $('#table_entrada_productos');
            gridhandlerProductosEntrada.jqGrid({
                'regional': 'es',
                datatype: "local",
                data: solicitud_items,
                colModel: [
                    {
                        label:"&nbsp;", name:'actions',index:'actions',formatter: 'actions',
                        fixed:true,search:false,editable:false, sortable:false,resize:false,width:80,
                        formatoptions: {editbutton:false,editformbutton:false,delbutton:false},
                        classes:'grid_ctat_gasto_blank'
                    },

                    {label:"ProductoColorID", name:'producto_color_id',index:'producto_color_id', width:135, hidden:true, key:true},

                    {label:"Producto", name:'producto_label',index:'producto_label', width:135},
                    {label:"ProductoID", name:'producto_general_id',index:'producto_general_id', hidden:true},
                    {label:"Color", name:'color_label',index:'color_label', width:135},
                    {label:"ColorID", name:'color_id',index:'color_id', hidden:true},
                    {
                        label:"Rollos", name:'rollos',index:'rollos',
                        template: colFmt.decimalSeparatorPoint,
                        summaryTpl: "<div>{0}</div>",
                        summaryType: "sum"
                    },
                    {
                        label:"Quantity", name:'quantity',index:'quantity',
                        template: colFmt.decimalSeparatorPoint,
                        summaryTpl: "<div>{0}</div>",
                        summaryType: "sum"
                    },
                    {label:"Unidad", name:'unidad',index:'unidad', width:60},
                ],
                gridview: true,
                viewable : true,

                height: ($(window).height() - 500) < 200 ? 200 : $(window).height() - 700,
                width:"auto", // gridhandlerProductosEntrada.parent().width()-15,
                hidegrid: false,
                pager: "#pager_entrada_productos",
                search: true,
                autoencode : true,
                ignoreCase : true,
                shrinkToFit : false,
                scrollrows : true,
                rownumbers : true,

                rowNum: 10000000,
                rowList: [],        // disable page size dropdown
                pgbuttons: false,     // disable page control like next, back button
                pgtext: null,         // disable pager text like 'Page 0 of 10'
                viewrecords: false,    // disable current view record text like 'View 1-10 of 100'

                hoverrows : false,
                footerrow : true,
                resizable: true,
                rowattr: function(rd, rowData) {
                    // console.log(rd);
                },
                grouping: true,
                groupingView: {
                    groupField : ['producto_label'],
                    groupColumnShow: [false],
                    groupText: ["<b>{0}: <small>{1} Color(es)</small></b>"],
                },
                loadComplete: function (data){
                    gridhandlerProductosEntrada.jqGrid("hideCol", "rn");

                    vx_asyncFunction(function() {
                    var iCol=getColumnIndexByName(gridhandlerProductosEntrada,'actions');
                    gridhandlerProductosEntrada.children("tbody").children("tr.jqgrow").children("td:nth-child("+(iCol+1)+")").each(function() {
                        var $div = $(this).children('div'),
                            $id = $(this).closest("tr.jqgrow").attr("id");

                        $div.html('');

                        $('<a>',{
                            rel:'opener refferer',
                            href:"javascript:carta_porte.editProductoSolicitud('"+$id+"')",
                            title: 'Editar',
                            mouseover: function() { $(this).addClass('ui-state-hover');},
                            mouseout: function() {  $(this).removeClass('ui-state-hover');}
                        }).css({'margin-left':'5px',float:'left'})
                            .addClass('ui-pg-div ui-inline-custom')
                            .append('<span class="ui-icon ui-icon-pencil"></span>')
                            .appendTo($div);

                        $('<a>',{
                            rel:'opener refferer',
                            href:"javascript:carta_porte.removeColor('"+$id+"')",
                            title: 'Editar',
                            mouseover: function() { $(this).addClass('ui-state-hover');},
                            mouseout: function() {  $(this).removeClass('ui-state-hover');}
                        }).css({'margin-left':'5px',float:'left'})
                            .addClass('ui-pg-div ui-inline-custom')
                            .append('<span class="ui-icon ui-icon-trash"></span>')
                            .appendTo($div);
                    });
                    },0, this);

                    vx_asyncFunction(function() {
                    notaBodegaPonFooter();
                    },0, this);
                },

            }).jqGrid('gridResize',{
                minWidth:150,
                maxWidth:3000,
                minHeight:80,
                maxHeight:3000,
                stop: function(event, ui) {
                    if(typeof gridhandlerProductosEntrada_iscolstate != 'undefined')
                        iaJqGridSaveColState(gridhandlerProductosEntrada, gridhandlerProductosEntrada[0].p.remapColumns,gridhandlerProductosEntrada.data('saveStateName'));
                }
            });
            $('#gview_'+ gridhandlerProductosEntrada[0].id + ' .ui-jqgrid-ftable').css('height', '56px');

            $(window).bind('resize', function() {
                if ($( window ).width() < 1210 && $( window ).width() > 1055) {
                    gridhandlerProductosEntrada.setGridWidth($('#main_cotent').width()- $('.content_description_nota').width() - 80);
                }
            }).trigger('resize');
        },

        initJqGridNotas: function ()
        {
            gridhandlerNotas = $('#table_notas');
            gridhandlerNotas.jqGrid({
                'regional': 'es',
                datatype: "local",
                caption: "NOTAS",
                data: notas,
                colModel: [
                    {label:"nota_bodega_id", name:'nota_bodega_id',index:'nota_bodega_id', width:135, hidden:true, key:true},

                    {label:"Número", name:'numero',index:'numero', width:50},
                    {label:"Origen", name:'bodega',index:'bodega', width:135},
                    {label:"Destino", name:'destino',index:'destino', width:135},

                    {label:"Producto", name:'producto',index:'producto', width:135},
                    {label:"Total Rolls", name:'total_rolls',index:'total_rolls', width:135, template: colFmt.decimalSeparatorPoint,},
                    {label:"Total Quantity", name:'total_quantity',index:'total_quantity', width:135, template: colFmt.decimalSeparatorPoint,},

                    {label:"Unidad", name:'unidad',index:'unidad', width:60},

                    {label:"Conductor", name:'conductor',index:'conductor', width:135},
                    {label:"Transporte", name:'transporte',index:'transporte', width:135},

                    {label:"Fecha", name:'fecha',index:'fecha', width:135},
                ],
                gridview: true,
                viewable : true,

                height: ($(window).height() - 500) < 200 ? 200 : $(window).height() - 700,
                width:"auto",
                hidegrid: false,
                pager: "#pager_notas",
                search: true,
                autoencode : true,
                ignoreCase : true,
                shrinkToFit : false,
                scrollrows : true,
                rownumbers : true,

                rowNum: 10000000,
                rowList: [],        // disable page size dropdown
                pgbuttons: false,     // disable page control like next, back button
                pgtext: null,         // disable pager text like 'Page 0 of 10'
                viewrecords: false,    // disable current view record text like 'View 1-10 of 100'

                hoverrows : false,
                footerrow : false,
                resizable: true,
                rowattr: function(rd, rowData) {
                    // console.log(rd);
                },
                subGrid: true,
                subGridOptions: {
                    selectOnExpand : true
                },
                subGridRowExpanded: function (subgrid_id, row_id){SubGridItemsNota(subgrid_id, row_id)},
                loadComplete: function (data){
                    /*gridhandlerProductosEntrada.jqGrid("hideCol", "rn");
                    notaBodegaPonFooter();
                    var iCol=getColumnIndexByName(gridhandlerProductosEntrada,'actions');
                    gridhandlerProductosEntrada.children("tbody").children("tr.jqgrow").children("td:nth-child("+(iCol+1)+")").each(function() {
                        var $div = $(this).children('div'),
                            $id = $(this).closest("tr.jqgrow").attr("id");

                        $div.html('');

                        $('<a>',{
                            rel:'opener refferer',
                            href:"javascript:carta_porte.editProductoSolicitud('"+$id+"')",
                            title: 'Editar',
                            mouseover: function() { $(this).addClass('ui-state-hover');},
                            mouseout: function() {  $(this).removeClass('ui-state-hover');}
                        }).css({'margin-left':'5px',float:'left'})
                            .addClass('ui-pg-div ui-inline-custom')
                            .append('<span class="ui-icon ui-icon-pencil"></span>')
                            .appendTo($div);

                        $('<a>',{
                            rel:'opener refferer',
                            href:"javascript:carta_porte.removeColor('"+$id+"')",
                            title: 'Editar',
                            mouseover: function() { $(this).addClass('ui-state-hover');},
                            mouseout: function() {  $(this).removeClass('ui-state-hover');}
                        }).css({'margin-left':'5px',float:'left'})
                            .addClass('ui-pg-div ui-inline-custom')
                            .append('<span class="ui-icon ui-icon-trash"></span>')
                            .appendTo($div);
                    });*/
                },

            }).jqGrid('gridResize',{
                minWidth:150,
                maxWidth:3000,
                minHeight:80,
                maxHeight:3000,
                stop: function(event, ui) {
                    if(typeof gridhandlerProductosEntrada_iscolstate != 'undefined')
                        iaJqGridSaveColState(gridhandlerProductosEntrada, gridhandlerProductosEntrada[0].p.remapColumns,gridhandlerProductosEntrada.data('saveStateName'));
                }
            });
            $('#gview_'+ gridhandlerProductosEntrada[0].id + ' .ui-jqgrid-ftable').css('height', '56px');

            $(window).bind('resize', function() {
                if ($( window ).width() < 1210 && $( window ).width() > 1055) {
                    gridhandlerProductosEntrada.setGridWidth($('#main_cotent').width()- $('.content_description_nota').width() - 80);
                }
            }).trigger('resize');
        },

        agregaColor: function ()
        {
            gridhandlerProductosEntrada.jqGrid('resetSelection');
            let item = {
                producto_color_id: $('#producto_general_id').val() + "_" + $('#color_id_selected').val(),
                producto_label: $('#producto_general_label').val(),
                producto_general_id: $('#producto_general_id').val(),
                color_label: $('#color_label').val(),
                color_id: $('#color_id_selected').val(),
                rollos: normalizaQuantity($('#rollos').val()),
                quantity: normalizaQuantity($('#quantity').val()),
                unidad: $('#unidad_label').text()
            };

            var row = validaDatos(item, carta_porte.rules_items);
            if (row === false)
                return;
            
            if (carta_porte.existeProductoColor(item.producto_color_id)) {
                // ia.alertWarn(`La solicitud ya tiene el producto <b>${item.producto_label}</b> con el color <b>${item.color_label}</b>`, 'Alerta!', true);
                vx_alert(divIDError, `La solicitud ya tiene el producto <b>${item.producto_label}</b> con el color <b>${item.color_label}</b>`, 'Alerta!', 'color_label')
                gridhandlerProductosEntrada.setSelection(item.producto_color_id);
                // $('#color_label').focus();
                return;
            }


            gridhandlerProductosEntrada.jqGrid('addRowData', item.producto_color_id, item);
            gridhandlerProductosEntrada.trigger('reloadGrid');

            $('#color_label').val('');
            $('#color_id_selected').val('');
            $('#rollos').val('');
            $('#quantity').val('');

            $('#color_label').focus();
        },

        editProductoSolicitud: function (rowId)
        {
            let data = gridhandlerProductosEntrada.getRowData(rowId);
            $('#producto_general_label').val(data.producto_label);
            $('#producto_general_id').val(data.producto_general_id);

            $('#color_label').val(data.color_label);
            $('#color_id_selected').val(data.color_id);

            $('#rollos').val($.fmatter.util.NumberFormat(data.rollos, $.jgrid.formatter.number));
            $('#quantity').val($.fmatter.util.NumberFormat(data.quantity, $.jgrid.formatter.number));

            $('#producto_general_label').focus();

            gridhandlerProductosEntrada.jqGrid('delRowData', rowId);

        },

        existeProductoColor: function (_id)
        {
            let row = gridhandlerProductosEntrada.getRowData(_id);
            return Object.entries(row).length !== 0;
        },

        removeColor: function (rowId)
        {
            // var index_color = colores_selecionados.indexOf(rowId);
            // if (index_color > -1) {
            //     colores_selecionados.splice(index_color, 1);
            // }
            // delete productos_entrada[rowId];
            gridhandlerProductosEntrada.jqGrid('delRowData', rowId);
            gridhandlerProductosEntrada.trigger('reloadGrid');
        },

        guardar: function()
        {
            var autoCompleteIsOpen = false, autoCompleteOpen = null;
            $('.content_description_nota .ui-autocomplete-input').each(function () {
                if ($(this).autocomplete("widget").is(':visible')) {
                    autoCompleteIsOpen = true;
                    autoCompleteOpen = this;
                }
            });
            if (autoCompleteIsOpen) {
                $(autoCompleteOpen).focus().select();
                return;
            }

            var solicitud = {
                origen_id: $('#origen_id').val(),
                destino_id: $('#destino_id').val(),
                documento: $('#documento').val(),

                numero: $('#numero').val(),
                fecha: stringToDate($('#fecha').val(), 'yyyy-MM-dd'),
                paid: ($('#paid').is(':checked')) ? 1:0,
                contra_nota_bodega_id: $('#contra_nota_bodega_id').val(),
                para_quien: $('#para_quien').val(),

                cp_figuratransporte_id: $('#cp_figuratransporte_id').val(),
                cp_autotransporte_id: $('#cp_autotransporte_id').val(),

                remarks: tinymce.get('remarks').getContent() ?? $('#remarks').val(),
                remarks_paid: tinymce.get('remarks_paid').getContent() ?? $('#remarks_paid').val(),

                cp_cliente_direccion_id_destino: cp_cliente_direccion_id_destino,
                cp_cliente_direccion_id_origen: cp_cliente_direccion_id_origen,

                confirmacion_etiquetado: ($('#confirmacion_etiquetado').is(':checked')) ? 'Si':'No',
                empresa_id_etiquetado: $('#empresa_id_etiquetado').val() ?? '',
                forma_etiquetado: $('#forma_etiquetado').val() ?? '',
                responsable_etiquetado: $('#responsable_etiquetado').val() ?? '',

                tipo_factura: $('#tipo_factura').val(),
                numero_factura: $('#numero_factura').val(),
                banco_cuenta_id: $('#banco_cuenta_id').val(),
                monto_deposito: $('#monto_deposito').val(),

                numero_cfdi: $('#numero_cfdi').val(),
                generado:  ($('#generado').is(':checked')) ? 'Si':'No',

                tipo_generacion_cfdi: $('#tipo_generacion_cfdi').val(),

                fecha_hora_salida_llegada: $('#fecha_hora_salida_llegada').val(),
                duracion_viaje: $('#duracion_viaje').val(),
                distancia_recorrida: $('#distancia_recorrida').val()

            };

            if ($('#generado').is(':checked')) {
                carta_porte.rules_solicitud.numero_cfdi = {'required': true,'label': 'No. CFDI','focusAfter': 'numero_cfdi'};
            }else {
                delete carta_porte.rules_solicitud.numero_cfdi;
            }
            carta_porte.rules_solicitud.tipo_factura = {'required': true};
            if (solicitud.tipo_factura == 'FACTURA') {
                carta_porte.rules_solicitud.numero_factura = {'required': true, label: 'Número de Factura'};
                carta_porte.rules_solicitud.banco_cuenta_id = {'required': true, label: 'Cuenta Bancaria'};
                carta_porte.rules_solicitud.monto_deposito = {'required': true, label: 'Monto de la factura'};
            } else {
                delete carta_porte.rules_solicitud.numero_factura;
                delete carta_porte.rules_solicitud.banco_cuenta_id;
                delete carta_porte.rules_solicitud.monto_deposito;
            }

            /* if (destino.es == 'CLIENTE') {
                carta_porte.rules_solicitud.contra_nota_bodega_id = {'required': true,'label': 'Contra Nota'};
                carta_porte.rules_solicitud.para_quien = {'required': true};
                carta_porte.rules_solicitud.tipo_factura = {'required': true};
                carta_porte.rules_solicitud.numero_factura = {'required': true, label: 'Número de Factura'};
                carta_porte.rules_solicitud.banco_cuenta_id = {'required': true, label: 'Cuenta Bancaria'};
                carta_porte.rules_solicitud.monto_deposito = {'required': true, label: 'Monto de la factura'};
            } */

            if (solicitud.documento === 'carta_porte') {
                carta_porte.rules_solicitud.fecha_hora_salida_llegada = {'required': true, label: 'Hora de salida'};
                carta_porte.rules_solicitud.duracion_viaje = {'required': true, label: 'Tiempo de viaje'};
                carta_porte.rules_solicitud.distancia_recorrida = {'required': true, label: 'Distancia'};
            }
            
            var validacion = validaDatos(solicitud, carta_porte.rules_solicitud);
            if (validacion === false)
                return;

            var items = gridhandlerProductosEntrada.getRowData();
            if (items.length === 0) {
                var promiseNotProducts = ia.alertError('La solicitud no tiene productos para guardar', 'ALERTA!')
                promiseNotProducts.done(function () {$('#producto_general_label').focus();});
                promiseNotProducts.fail(function () {$('#producto_general_label').focus();});
                return;
            }

            if (!es_alta) {
                solicitud.solicitud_carta_porte_id = $('#solicitud_carta_porte_id').val();
            }

            var request = {
                url: getUrlForAjax('solicitud_cp_acciones.php'),
                data: {
                    accion: (es_alta) ? 'nuevaSolicitud' : 'actualizaSolicitud',
                    solicitud, items
                }
            };

            jqAjax(request,
                (response) => {
                    if (response.code == 200 && response.status == true) {
                        var promiseInfo = ia.alertInfo(response.message, "Nueva Solicitud", true);
                        if (es_alta) {
                            carta_porte.resetForm();
                            $('#origen_id')[0].selectize.open();
                        } else {
                            promiseInfo.done(function () {
                                if (es_alta) {
                                    carta_porte.resetForm();
                                    $('#origen_id')[0].selectize.open();
                                } else {
                                    location.reload();
                                }
                            });
                            promiseInfo.fail(function () {
                                if (es_alta) {
                                    carta_porte.resetForm();
                                    $('#origen_id')[0].selectize.open();
                                } else {
                                    location.reload();
                                }
                            });
                        }

                    } else {
                        ia.alertError(response.message, "Nueva Solicitud");
                    }
                },
                (fail, thrownError) => {
                    ia.alertError(
                        ((fail.responseJSON) ? fail.responseJSON.message : undefined) ?? fail.responseText ?? thrownError,
                        "Error: " + (((fail.responseJSON) ? fail.responseJSON.code : undefined) ?? fail.status ?? ''),
                        true
                    );
                }
            )

        },

        cancelar: function ()
        {
            carta_porte.resetForm();
            $('#origen_id')[0].selectize.open();
        },

        resetForm: function ()
        {
            gridhandlerProductosEntrada.jqGrid('resetSelection');
            $('#form_solicitud')[0].reset();

            $('#origen_id')[0].selectize.clear();
            // $('#destino_id')[0].selectize.clear();
            $('#documento')[0].selectize.clear();

            $('#producto_general_id').val('');
            $('#color_id_selected').val('');

            $('#fecha').val('').datepicker('setDate', new Date());

            $('#cp_figuratransporte_id').val('');
            $('#cp_autotransporte_id').val('');

            gridhandlerProductosEntrada.jqGrid('clearGridData');
            gridhandlerProductosEntrada.trigger('reloadGrid');
        },

        resetItem: function()
        {
            solicitud = (es_alta) ? null: <?=json_encode($solicitud)?>;
            solicitud_items = <?=json_encode($solicitud_items)?>;
        },

        restoreSolicitud: function ()
        {
            solicitud = (es_alta) ? null: <?=json_encode($solicitud)?>;
            solicitud_items = <?=json_encode($solicitud_items)?>;


            $('#origen_id')[0].selectize.setValue(solicitud.origen_id);
            $('#origen_id').change();

            $('#documento')[0].selectize.setValue(solicitud.documento);


            if (solicitud.paid != '0' || solicitud.paid != 0) {
                $('#paid').prop('checked', true);
                $('#div_remarks_paid').removeClass('hide').show();
            } else {
                $('#paid').prop('checked', false);
                $('#div_remarks_paid').addClass('hide');
            }

            $('#contra_nota_bodega_id').val(solicitud.contra_nota_bodega_id);
            $("#para_quien").val(solicitud.para_quien);

            $('#chofer_label').val(conductor.NombreFigura);
            $('#cp_figuratransporte_id').val(conductor.figuratransporte_id);

            $('#vehiculo_label').val(trasnporte.PlacaVM);
            $('#cp_autotransporte_id').val(trasnporte.autotransporte_id);

            $('#remarks').val(solicitud.remarks);
            $('#remarks_paid').val(solicitud.remarks_paid);

            tinymce.get('remarks').setContent(solicitud.remarks);
            tinymce.get('remarks_paid').setContent(solicitud.remarks_paid);
            tinymce.triggerSave();

            gridhandlerProductosEntrada.jqGrid('clearGridData');
            gridhandlerProductosEntrada.jqGrid('setGridParam', {data: solicitud_items}).trigger('reloadGrid');


        },

        inconsistenciaEmpresas: function () {
            empresa_origen = empresa_origen.toString();
            empresa_chofer = empresa_chofer.toString();
            empresa_transporte = empresa_transporte.toString();
            empresa_etiquetado = empresa_etiquetado.toString();

            let empresa_id = empresa_etiquetado || empresa_origen;

            var input_chofer = $('#chofer_label'),
                help_chofer = $('#help_chofer');
            input_chofer.removeClass('input_con_inconsistencia');
            help_chofer.html('');
            if (!empty(empresa_chofer) && empresa_id !== empresa_chofer) {
                input_chofer.addClass('input_con_inconsistencia');
                help_chofer.html('<b class="text-danger">El chofer no es de la empresa de origen</b>');
            }

            var input_transporte = $('#vehiculo_label'),
                help_transporte = $('#help_vehiculo');
            input_transporte.removeClass('input_con_inconsistencia');
            help_transporte.html('');
            if (!empty(empresa_transporte) && empresa_id !== empresa_transporte) {
                input_transporte.addClass('input_con_inconsistencia');
                help_transporte.html('<b class="text-danger">El transporte no es de la empresa de origen</b>');
            }

            var input_origen = $('#origen_id'),
                help_origen = $('#origen_help');
            input_origen.next().find('.selectize-input').removeClass('input_con_inconsistencia_selectize');
            $('#inconsistencia_origen').remove();
            if (!empty(empresa_etiquetado) && !empty(empresa_origen) && empresa_etiquetado !== empresa_origen) {
                input_origen.next().find('.selectize-input').addClass('input_con_inconsistencia_selectize');
                help_origen.append('<p class="text-danger" id="inconsistencia_origen">La empresa no coincide con la de etiquetado</p>');
            }

        }


    };
    Object.freeze(carta_porte);

    function notaBodegaPonFooter() {
        let footer = $('#gview_'+ gridhandlerProductosEntrada[0].id + ' .ui-jqgrid-ftable');

        footer
            .find('td[aria-describedby=table_entrada_productos_actions]')
            .html('<div style="text-align: left">Productos: <br> <b style="float:right; font-size: 1.5em">'+gridhandlerProductosEntrada.find('tr.jqgroup').length+"</b><div>");

        footer
            .find('td[aria-describedby=table_entrada_productos_color_label]')
            .html('<div style="text-align: left">Colores: <br> <b style="float:right; font-size: 1.5em">'+gridhandlerProductosEntrada.getGridParam("reccount")+"</b><div>");

        let total_rolls = 0, total_quantity = 0;
        gridhandlerProductosEntrada.getRowData().forEach(function (row, index) {
            total_rolls = total_rolls + Number(normalizaQuantity(row.rollos));
            total_quantity = total_quantity + Number(normalizaQuantity(row.quantity));
        });

        footer
            .find('td[aria-describedby=table_entrada_productos_rollos]')
            .html('<div style="text-align: left">Rollos: <br> <b style="float:right; font-size: 1.5em">'+$.fmatter.util.NumberFormat(total_rolls, $.jgrid.formatter.number)+"</b><div>");

        footer
            .find('td[aria-describedby=table_entrada_productos_quantity]')
            .html('<div style="text-align: left">Quantity: <br><b style="float:right; font-size: 1.5em">'+$.fmatter.util.NumberFormat(total_quantity, $.jgrid.formatter.number)+"</b><div>");
        footer
            .find('td[aria-describedby=table_entrada_productos_unidad]')
            .html('<div style="text-align: left">Unidad: <br><b id="unidades-table" style="float:right; font-size: 1.5em"></b><div>');

    }

    function processContinueAddColor(row, edit = false, rowIdOrigen = null, averageIncorrect = false)
    {

    }

    function doAdjuntarAchivos(event = null){
        if (!window.FormData && event == null)
            return;

        let formdata = new FormData(),
            $json_file_attachments = $('#json_file_attachments'),
            files = $json_file_attachments[0].files.length ? $json_file_attachments[0].files : event.originalEvent.dataTransfer.files,
            solicitud_carta_porte_id = $("#solicitud_carta_porte_id").val(),
            fileExtension = ['jpeg', 'jpg', 'png', 'pdf', 'xml', 'doc', 'xls', 'docx', 'xlsx'], cuantos_archivos_validos = 0;


        $.each(files, function(i, file){
            if (typeof file != "undefined" && $.inArray(file.name.split('.').pop().toLowerCase(), fileExtension) >= 0) {
                cuantos_archivos_validos++;
                formdata.append(i, file);
            }
        });

        if(!cuantos_archivos_validos)
            return;

        formdata.append('accion','adjuntarArchivos');
        formdata.append('solicitud_carta_porte_id',solicitud_carta_porte_id);

        $.ajax({
            url: pathApp + "ajax/solicitud_cp_acciones.php",
            cache: false,
            type: "post",
            async: true,
            processData: false,
            contentType: false,
            data: formdata,

            beforeSend: function(jqXHR, settings)
            {
                $.blockUI();
                return true;
            }
        }).done(function(response, textStatus, jqXHR){
            try {
                // console.log(response);
                carga_json_file_attachments(response.solicitud, "div_file_attachments");
                // actualizaLineajqGrid(res.solicitud.solicitud_carta_porte_id,res.solicitud);
                // closeItem();

            }catch(err){alert(err.message);console.log(response) }
        }).fail(function (xhr, ajaxOptions, thrownError){
            try {
                // var res = JSON.parse(xhr);
                // actualizaLineajqGrid(res.bcmenDB.banco_cuenta_mov_id,res.bcmenDB);
                // closeItem();

            }catch(err){alert(err.message);console.log(xhr) }
        }).always(function(res){ $.unblockUI(); });
        return true;
    }

    function carga_json_file_attachments(solicitud, campo_id){
        //@todo VCA hacer funcion inicializadora
        campo_id = typeof campo_id === "undefined" ? "div_file_attachments" : campo_id;
        let $div_file_att = $("#" + campo_id),
            $nf = "",
            jfa = solicitud.json_file_attachments;

        if(typeof jfa === "string" && jfa.length)
            jfa = JSON.parse(jfa);

        $div_file_att.html('');
        if (jfa != null && jfa.length) {
            $.each(jfa, function (i, file) {
                $nf = '<li id="' + file.id + '"><a href="javascript:void(0);" onclick="confirmaBorraAdjunto(\'' + file.nombre + '\',\'' + file.id + '\',\'' + solicitud.solicitud_carta_porte_id + '\');"><img src="../img/delete.png" alt="Borrar Archivo" class="noborders" /></a>&nbsp;';
                $nf += '<a href="' + pathApp + 'descargaarchivo.php?NA=' + file.nombre + '&P2F=' + solicitud.path4File + '"><strong>' + file.nombre + '</strong></a>&nbsp;&nbsp;&nbsp;';
                $nf += '<a href="' + pathApp + 'descargaarchivo.php?NA=' + file.nombre + '&P2F=' + solicitud.path4File + '"><img src="../img/20-attach.png" alt="' + file.nombre + '" title="' + file.nombre + '" class="noborders" /></a>&nbsp;&nbsp;&nbsp;';
                $nf += '<a target="_blank" href="' + solicitud.path4File + file.nombre + '"><img src="../img/20-preview.png" alt="' + file.nombre + '" title="' + file.nombre + '" class="noborders" /></a>';
                $div_file_att.append($nf);
            });
            $div_file_att.html('<ol>' + $div_file_att.html());
        }
    }

    function confirmaBorraAdjunto(nombre,file_id,scp_id){
        if(!nombre || !file_id || !scp_id)
            return;

        let dDescripcion = '<br/>¿Confirmas borrar el Archivo Adjunto?<br /><br />Nombre: <strong>'+nombre+'</strong>';

        $("#" + divIDInfo).html(dDescripcion).dialog({
            resizable: false,
            modal: true,
            width: 450,
            title: 'Borrar Archivo Adjunto.',

            open: function(event,ui){},
            buttons: {
                'Borrar Archivo': function() {
                    doBorraAdjunto(file_id,scp_id);
                    $(this).dialog( "close" );
                },
                'Cerrar': function() {
                    $(this).dialog( "close" );
                }
            }
        });
    }

    function doBorraAdjunto(file_id,scp_id){
        $.ajax({
            url: pathApp + "ajax/solicitud_cp_acciones.php",
            cache: false,
            type: "post",
            async: true,
            data: {'accion':'borraAdjunto', 'solicitud_carta_porte_id':scp_id, 'file_id':file_id, '_app':_app}
        }).done(function(res){ try {
            if(res.status === true){
                $('#'+file_id).remove();
            }
            else
                vx_alert(divIDInfo, res.Error, "Borrar Archivo Adjunto.");
        }catch(err){alert(err.message); console.log(res); }
        }).fail(function (xhr, ajaxOptions, thrownError){ try {
            if(xhr.status === true){
                $('#'+file_id).remove();
            }
            else
                vx_alert(divIDInfo, res.Error, "Borrar Archivo Adjunto.");
        }catch(err){alert(err.message); console.log(xhr); }
        });
    }

    function SubGridItemsNota(subgrid_id, row_id)
    {
        // $('.ui-sgcollapsed.sgexpanded').click();
        var subgrid_table_id = subgrid_id + '_table';
        setGridSelectedRow(row_id);
        // doSumasGrid = doSumasGridItems;

        $('#' + subgrid_id).html('<table id =\"' + subgrid_table_id + '\"></table>');

        var gridhandlerItems = $('#' + subgrid_table_id);

        gridhandlerItems.jqGrid({
            data: items_por_nota[row_id],
            datatype: 'local',
            colModel: [
                { name: 'nota_bodega_item_id', index: 'nota_bodega_item_id', label: 'NOTABODEGAITEMID', key:true, hidden: true},
                { name: 'nota_bodega_id', index: 'nota_bodega_id', label: 'NOTABODEGAID', hidden: true, classes: 'bold'},
                { name: 'producto_bodega_id', index: 'producto_bodega_id', label: 'PORDUCTOBODEGAID', hidden: true, /*cellattr: _cellAttrSubMonedaid*/},
                { name: 'producto', index: 'producto', label: 'Producto', width: 330, classes: 'bold'},
                { name: 'color', index: 'color', label: 'Color', width: 250, classes: 'bold'},
                { name: 'rollos', index: 'rollos', label: 'Rollos', width: 100, classes: 'bold', template:colFmt.decimal},
                { name: 'quantity', index: 'quantity', label: 'Quantity', width: 100, classes: 'bold', template:colFmt.decimal},
                { name: 'es_saldo', index: 'en_remate', label: 'Dead Stock', width: 100,  template:colFmt.SiNoSN},
                { name: 'en_remate', index: 'en_remate', label: 'Saldo', width: 100,  template:colFmt.SiNoSN},
                { name: 'lento', index: 'en_remate', label: 'Lento', width: 100,  template:colFmt.SiNoSN},
                { name: 'super_lento', index: 'en_remate', label: 'Super Lento', width: 100,  template:colFmt.SiNoSN},
            ],
            width: 817,
            autowidth: false,
            rowNum: 100,
            rowList: [50, 100, 200, 300],
            viewrecords: true,
            rownumbers: true,
            caption: 'Productos de la nota',
            height: 'auto',
            autoencode: false,
            gridview: true,
            ignoreCase: true,
            footerrow: false,
            userDataOnFooter: true,
            loadComplete: function() {
                printNextPrevButton(row_id);
                // setTimeout(function(){
                //     doSumasGrid(row_id);
                //     printNextPrevButton(row_id);
                //     var row_coor = $('#' + row_id)[0].getBoundingClientRect(), //revisar para que no de error javascript.
                //         row_footer_coor = $('#' + row_id).siblings('.ui-subgrid').find('.footrow')[0].getBoundingClientRect(); //revisar para que no de error javascript.
                //     if(row_coor.top > 100){
                //         var offset = (row_footer_coor.bottom > \$gridParams.coordenadas.height) ? Math.abs(row_footer_coor.bottom - \$gridParams.coordenadas.height) / 2 : 0;
                //         gridhandler.parent().parent()[0].scrollTop = gridhandler.parent().parent()[0].scrollTop + offset;
                //     }
                // },100);
                // return true;
            },
        });
    }

    const printNextPrevButton = function (rowID) {
        var divContainer = $('#'+prefixContainerNotas+rowID);
        var buttonPrevItem = `<img
                                        src="../img/next-item.png" width="30" height="30"
                                        onclick='nextPrevItem("`+rowID+`", false);' style="cursor:pointer; margin-left: 15px; transform: rotate(180deg);"
                                        title='Anterior'/>`;
        var buttonNextItem = `<img
                                        src="../img/next-item.png" width="30" height="30"
                                        onclick='nextPrevItem("`+rowID+`");' style="cursor:pointer; margin-left: 15px"
                                        title='Siguiente'/>`;
        divContainer.css('display', 'flex')
        divContainer.css('align-items', 'flex-end');
        divContainer.append(buttonPrevItem + buttonNextItem);
    }
    const nextPrevItem = function(row_id, next = true) {
        let prevNext = $('#' + row_id);
        prevNext.find('.ui-sgcollapsed').click(); // cierra grid actual

        if (next) {
            if(!prevNext.nextAll('tr:visible:first').find('.ui-sgcollapsed').hasClass('sgexpanded')) {
                prevNext.nextAll('tr:visible:first').find('.ui-sgcollapsed').click();
            }
        } else {
            prevNext.prevAll('tr:visible:first').find('.ui-sgcollapsed').click();
        }
    }

</script>
<?php
}?>