<?php
require_once('inc/config.php');

use Workerman\Worker;
use Workerman\Connection\TcpConnection;
require_once __DIR__ . '/vendor/autoload.php';
$global_uid = 0;

// Assign a uid to the connection when a client connects, save the connection, and notify all clients
function handle_connection(TcpConnection $connection): void
{
    $client = $connection->getRemoteAddress();
    echo "New connection from: $client\n";

    $connection->send(json_encode([
        'status' => 'success',
        'message' => "Welcome to Vitex websocket server, $client."
    ]));
}

function handle_message($connection, $data): void
{
    global $ws_worker;

    $payload = json_decode($data, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $connection->send(json_encode([
            'status' => 'error',
            'message' => 'Invalid JSON received.',
        ]));
        return;
    }

    echo "Received data: " . print_r($payload, true) . "\n";

    $accion = $payload['accion'] ?? null;
    $usuario_id = $payload['usuario_id'] ?? null;
    $usuario = $payload['usuario'] ?? null;

    $connection->usuario_id = $usuario_id;
    $connection->usuario = $usuario;

    $response_msg = "Received accion: $accion, usuario_id: $usuario_id, usuario: $usuario\n";

    if ($accion === 'run_async') {
        $func = $payload['func'] ?? null;
        $func = str_replace('async_', 'ws_', $func);
        $func_params = $payload['func_params'] ?? [];

        if (!is_array($func_params)) {
            $func_params = [];
        }

        if ($func && function_exists($func)) {
            call_user_func($func, $func_params);
            $response_msg .= "Processed func: $func with params: " . print_r($func_params, true) . "\n";
        } else {
            $response_msg .= "Function $func does not exist.\n";
        }
    }

    $connection->send(json_encode([
        'status' => 'success',
        'message' => $response_msg
    ]));
}

function handle_close($connection): void
{
    global $ws_worker;
    $usuario_id = $connection->usuario_id ?? null;
    $usuario = $connection->usuario ?? null;
    echo "Connection closed for usuario_id: $usuario_id ($usuario)\n";

    foreach ($ws_worker->connections as $conn) {
        $conn->send("usuario: $usuario_id ($usuario) has disconnected.");
    }
}


// Create a Worker instance
$ws_worker = new Worker("websocket://0.0.0.0:2000");

// Enable `SO_KEEPALIVE` and optionally disable Nagle's algorithm
$ws_worker->transport = 'tcp';
$ws_worker->context = stream_context_create([
    'socket' => [
        'so_keepalive' => true,  // Enable keep-alive
        'tcp_nodelay' => true,  // Disable Nagle's algorithm (optional)
    ],
]);

// Start 4 processes to handle incoming connections
$ws_worker->count = 10;

// Assign event handlers
$ws_worker->onMessage = 'handle_message';
$ws_worker->onConnect = 'handle_connection';
$ws_worker->onClose = 'handle_close';

// Run the worker
Worker::runAll();
file_debug_reporte();
ia_errores_a_dime();